var HostVulnerabilityController = {

    filter: {
        hostNameSearchText: '',
        altxId: '',
        vulnerabilityTitle: '',
        referenceSearchText: '',

        showNewVulnerabilities: true,
        showRemainingVulnerabilities: true,
        showRemediatedVulnerabilities: true
    },

    statistics: {
        totalHostsCount: 0,
        totalUniqueVulnerabilitiesCount: 0
    },

    reloadHostVulnerabilityGrid: function () {
        HostVulnerabilityController.cleanAdditionalInfoOnPage();
        const table = document.getElementById('hostVulnerabilityGrid');
        if ($.fn.DataTable.isDataTable(table)) {
            $(table).dataTable().api().ajax.reload();
        }
    },

    onHostNameFilterChanged: debounce(function (input) {
        HostVulnerabilityController.filter.hostNameSearchText = input.value;
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    }, 500),

    onAltxIdFilterChanged: debounce(function (input) {
        HostVulnerabilityController.filter.altxId = input.value;
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    }, 500),

    onVulnerabilityTitleFilterChanged: debounce(function (input) {
        HostVulnerabilityController.filter.vulnerabilityTitle = input.value;
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    }, 500),

    onReferenceFilterChanged: debounce(function (input) {
        HostVulnerabilityController.filter.referenceSearchText = input.value;
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    }, 500),

    onShowNewVulnsFilterChanged: debounce(function (value) {
        HostVulnerabilityController.filter.showNewVulnerabilities = value;
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    }, 500),

    onShowRemainingVulnsFilterChanged: debounce(function (value) {
        HostVulnerabilityController.filter.showRemainingVulnerabilities = value;
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    }, 500),

    onShowRemediatedVulnsFilterChanged: debounce(function (value) {
        HostVulnerabilityController.filter.showRemediatedVulnerabilities = value;
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    }, 500),

    createSeverityBlocks: function (data) {
        let html = '';
        const sortData = data.sort((a,b) => { 
           if(a.Value.SeverityLevel > b.Value.SeverityLevel)
               return -1;
            return 1;
        });
        const severities = sortData.filter(function (item) { return item.Value.Value > 0 });
        
        severities.forEach(function (item) {
            let name = '';
            switch (item.Value.SeverityLevel) {
                case 1:
                    name = 'NotAvailable';
                    nameTitle = 'Недоступно';
                    break;
                case 2:
                    name = 'Information';
                    nameTitle = 'Информация';
                    break;
                case 3:
                    name = 'Low';
                    nameTitle = 'Низкий';
                    break;
                case 4:
                    name = 'Medium';
                    nameTitle = 'Средний';
                    break;
                case 5:
                    name = 'High';
                    nameTitle = 'Высокий';
                    break;
                case 6:
                    name = 'Critical';
                    nameTitle = 'Критический';
                    break;
            }

            let title = nameTitle + ': ' + item.Value.Value;
            html += '<span class="label_severity ' + name + '" title="' + title + '" data-toggle="tooltip" data-placement="bottom">' + item.Value.Value + '</span> ';
        });
        return html;
    },

    updateStatistics: function (json) {
        HostVulnerabilityController.statistics.totalHostsCount = json.data.TotalHostsCount;
        HostVulnerabilityController.statistics.totalUniqueVulnerabilitiesCount = json.data.TotalUniqueVulnerabilitiesCount;
        $('#uniqueHostsCount').html(json.data.TotalHostsCount);
        $('#uniqueVulnerabilitiesCount').html(json.data.TotalUniqueVulnerabilitiesCount);

        if (HostVulnerabilityController.statistics.totalHostsCount === 1) {
            document.getElementById('newVulnStatistics').classList.remove('hide');
            document.getElementById('remainingVulnStatistics').classList.remove('hide');
            document.getElementById('remediatedVulnStatistics').classList.remove('hide');

            let htmlNewVulns = HostVulnerabilityController.createSeverityBlocks(json.data.NewVulnSeverities);
            if (htmlNewVulns) {
                $('#newVulnStatisticsSpan').html(htmlNewVulns);
            }

            let htmlRemainingVulns = HostVulnerabilityController.createSeverityBlocks(json.data.RemainingVulnSeverities);
            if (htmlRemainingVulns) {
                $('#remainingVulnStatisticsSpan').html(htmlRemainingVulns);
            }

            let htmlRemediatedVulns = HostVulnerabilityController.createSeverityBlocks(json.data.RemediatedVulnSeverities);
            if (htmlRemediatedVulns) {
                $('#remediatedVulnStatisticsSpan').html(htmlRemediatedVulns);
            }
        }
        else {
            if (HostVulnerabilityController.statistics.totalUniqueVulnerabilitiesCount === 1) {
                document.getElementById('newVulnStatistics').classList.remove('hide');
                document.getElementById('remainingVulnStatistics').classList.remove('hide');
                document.getElementById('remediatedVulnStatistics').classList.remove('hide');

                let textNewVulns = 'Хостов: ' + json.data.HostWithNewVulnerabilitiesCount;
                let textRemainingVulns = 'Хостов: ' + json.data.HostWithRemainingVulnerabilitiesCount;
                let textRemediatedVulns = 'Хостов: ' + json.data.HostWithRemediatedVulnerabilitiesCount;

                $('#newVulnStatisticsSpan').html(textNewVulns);
                $('#remainingVulnStatisticsSpan').html(textRemainingVulns);
                $('#remediatedVulnStatisticsSpan').html(textRemediatedVulns);
            }
            else {
                HostVulnerabilityController.cleanStatistics();
            }
        }
    },

    cleanAdditionalInfoOnPage: function () {
        $('#uniqueHostsCount').html(null);
        $('#uniqueVulnerabilitiesCount').html(null);
        HostVulnerabilityController.cleanStatistics();
    },

    cleanStatistics: function () {
        document.getElementById('newVulnStatistics').classList.add('hide');
        document.getElementById('remainingVulnStatistics').classList.add('hide');
        document.getElementById('remediatedVulnStatistics').classList.add('hide');

        $('#newVulnStatisticsSpan').html(null);
        $('#remainingVulnStatisticsSpan').html(null);
        $('#remediatedVulnStatisticsSpan').html(null);
    },

    exportDataToCsv: function () {
        let query = '';

        if (VulnerabilityRemediationControlController.filter.newJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать задание, сканирования и применить фильтр');
            return;
        }

        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId === true && jobExecutionPicker.oldJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать задание, сканирования и применить фильтр');
            return;
        }

        if (VulnerabilityRemediationControlController.filter.newJobExecutionId)
            query+='&NewJobExecutionId='+VulnerabilityRemediationControlController.filter.newJobExecutionId;
        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId)
            query+='&ChooseExactOldExecutionId='+VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId;
        if (VulnerabilityRemediationControlController.filter.oldJobExecutionId)
            query+='&OldJobExecutionId='+VulnerabilityRemediationControlController.filter.oldJobExecutionId;
        if (VulnerabilityRemediationControlController.filter.useOnlyLastDaysCount)
            query+='&UseOnlyLastDaysCount='+VulnerabilityRemediationControlController.filter.useOnlyLastDaysCount;
        if (VulnerabilityRemediationControlController.filter.hostIds)
            VulnerabilityRemediationControlController.filter.hostIds.forEach((hostId)=>
                query+='&HostIds='+hostId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.groupIds)
            VulnerabilityRemediationControlController.filter.groupIds.forEach((groupId)=>
                query+='&GroupIds='+groupId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.severityTypeIds)
            VulnerabilityRemediationControlController.filter.severityTypeIds.forEach((severityTypeId)=>
                query+='&Severities='+severityTypeId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.cvssScoreMin)
            query+='&CvssScoreMin='+VulnerabilityRemediationControlController.filter.cvssScoreMin;
        if (VulnerabilityRemediationControlController.filter.cvssScoreMax)
            query+='&CvssScoreMax='+VulnerabilityRemediationControlController.filter.cvssScoreMax;
        if (VulnerabilityRemediationControlController.filter.hasExploit)
            query+='&HasExploit='+VulnerabilityRemediationControlController.filter.hasExploit;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInCveDb)
            query+='&IsInCveDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInCveDb;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInBduDb)
            query+='&IsInBduDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInBduDb;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInNkckiDb)
            query+='&IsInNkckiDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInNkckiDb;

        if (VulnerabilityRemediationControlController.filter.dateFrom)
            query+='&PublishedFrom='+VulnerabilityRemediationControlController.filter.dateFrom;
        if (VulnerabilityRemediationControlController.filter.dateTo)
            query+='&PublishedTo='+VulnerabilityRemediationControlController.filter.dateTo;

        if (HostVulnerabilityController.filter.hostNameSearchText)
            query+='&HostName='+HostVulnerabilityController.filter.hostNameSearchText;
        if (HostVulnerabilityController.filter.altxId)
            query+='&AltxId='+HostVulnerabilityController.filter.altxId;
        if (HostVulnerabilityController.filter.vulnerabilityTitle)
            query+='&VulnerabilityTitle='+HostVulnerabilityController.filter.vulnerabilityTitle;
        if (HostVulnerabilityController.filter.referenceSearchText)
            query+='&ReferenceSearchText='+HostVulnerabilityController.filter.referenceSearchText;


        if (HostVulnerabilityController.filter.showNewVulnerabilities)
            query+='&ShowNewVulnerabilities='+HostVulnerabilityController.filter.showNewVulnerabilities;
        if (HostVulnerabilityController.filter.showRemainingVulnerabilities)
            query+='&ShowRemainingVulnerabilities='+HostVulnerabilityController.filter.showRemainingVulnerabilities;
        if (HostVulnerabilityController.filter.showRemediatedVulnerabilities)
            query+='&ShowRemediatedVulnerabilities='+HostVulnerabilityController.filter.showRemediatedVulnerabilities;

        if (query)
        {
            query = query.substring(1);
            query = '?' + query;
        }
        window.location = VulnerabilityRemediationControlController.urlForHostVulnerabilityForCsv + query;
    }
};