var VulnerabilityRemediationControlController = {
    filter: {
        newJobExecutionId: 0,
        chooseExactOldExecutionId: false,
        oldJobExecutionId: 0,
        useOnlyLastDaysCount: 30,
        hostIds: [],
        groupIds: [],
        severityTypeIds: [],
        cvssScoreMin: 0,
        cvssScoreMax: 10,
        hasExploit: false,
        referenceDatabases: {
            isInCveDb: false,
            isInBduDb: false,
            isInNkckiDb: false,
        },
        dateFrom: '',
        dateTo: ''
    },
    urlForVulnerabilitiesForCsv: null,
    urlForHostsForCsv: null,
    urlForHostVulnerabilityForCsv: null,
    
    
    oldScanChoosingTypeOnChange: function () {
        document.getElementById('oldJobExecutionPicker').classList.remove('hide');
    },

    handleFormSubmit: function (event) {
        event.preventDefault();

        if (entityPicker.jobId === 0) {
            notifyWarning('Необходимо выбрать задание и сканирования');
            return;
        }
        
        if (jobExecutionPicker.newJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать актуальное сканирование');
            return;
        }

        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId === true && jobExecutionPicker.oldJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать определённое старое сканирование или сменить способ выбора старого сканирования');
            return;
        }

        const inputDaysElement = document.getElementById('useOnlyLastDaysCount');
        if (inputDaysElement.value === '') {
            notifyWarning('Необходимо указать корректное число дней');
            return;
        }

        VulnerabilityRemediationControlController.updateFilters();
        VulnerabilityRemediationControlController.reloadTabs();

        document.getElementById('filterResetBlock').classList.remove('hide');
    },

    handleFilterResetClick: function () {
        SelectedHostsGridController.reset();
        SelectedGroupsGridController.reset();

        document.getElementById('searchFormVulnRemrdiationControl').reset();

        entityPicker.clearData();
        jobExecutionPicker.clearData();

        document.getElementById("ChooseExactOldExecutionId_No").setAttribute("checked","");
        document.getElementById('oldJobExecutionPicker').classList.add('hide');
        document.getElementById('useOnlyLastDaysCountBlock').classList.remove('hide');
        document.getElementById('useOnlyLastDaysCount').value = 30;

        $("#sliderRange").slider( 'values', [ 0, 10 ] );
        document.getElementById('cvssScoreMin').value = 0;
        document.getElementById('cvssScoreMax').value = 10;
        $("#cvssScore").text("(0 - 10)");

        document.getElementById("currentScanInput").disabled = true;
        document.getElementById('btnNewJobExecution').disabled = true;
        document.getElementById("oldScanInput").disabled = true;
        document.getElementById('btnOldJobExecution').disabled = true;

        document.getElementById('dateFromPicker').disabled = false;
        document.getElementById('dateToPicker').disabled = false;

        document.getElementById('filterResetBlock').classList.add('hide');
        VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId = false;

        VulnerabilityRemediationControlController.updateFilters();
        VulnerabilityRemediationControlController.reloadTabs();
    },

    updateFilters: function () {
        const form = document.getElementById('searchFormVulnRemrdiationControl');

        // Shallow copy
        const hostIds = Array.from(SelectedHostsGridController.cpData);
        const groupIds = Array.from(SelectedGroupsGridController.cpData);

        const severityTypeIds = Array.from(form.querySelectorAll('input[name="SeverityType"]:checked'))
            .map(x => x.value);
        const referenceDatabases = {
            isInCveDb: document.getElementById('isInCveDb').checked,
            isInBduDb: document.getElementById('isInBduDb').checked,
            isInNkckiDb: document.getElementById('isInNkckiDb').checked,
        };

        const dateFromPicker = document.getElementById('dateFromPicker');
        const dateFrom = moment.utc(dateFromPicker.value, 'DD.MM.YYYY').startOf('day');

        const dateToPicker = document.getElementById('dateToPicker');
        const dateTo = moment.utc(dateToPicker.value, 'DD.MM.YYYY').endOf('day');

        VulnerabilityRemediationControlController.filter.newJobExecutionId = jobExecutionPicker.newJobExecutionId;
        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId === true) {
            VulnerabilityRemediationControlController.filter.oldJobExecutionId = jobExecutionPicker.oldJobExecutionId;
        } else {
            VulnerabilityRemediationControlController.filter.oldJobExecutionId = 0;
        }
        
        VulnerabilityRemediationControlController.filter.UseOnlyLastDaysCount=document.getElementById('useOnlyLastDaysCount').value;

        VulnerabilityRemediationControlController.filter.hostIds = hostIds;
        VulnerabilityRemediationControlController.filter.groupIds = groupIds;

        VulnerabilityRemediationControlController.filter.severityTypeIds = severityTypeIds;
        VulnerabilityRemediationControlController.filter.cvssScoreMin = document.getElementById('cvssScoreMin').value;
        VulnerabilityRemediationControlController.filter.cvssScoreMax = document.getElementById('cvssScoreMax').value;
        VulnerabilityRemediationControlController.filter.hasExploit = document.getElementById('hasExploit').checked;
        VulnerabilityRemediationControlController.filter.referenceDatabases = referenceDatabases;
        VulnerabilityRemediationControlController.filter.dateFrom = dateFrom.toISOString();
        VulnerabilityRemediationControlController.filter.dateTo = dateTo.toISOString();
    },

    reloadTabs: function () {
        VulnerabilitiesController.reloadVulnerabilitiesGrid();
        HostsRemediationController.reloadHostsGrid();
        HostVulnerabilityController.reloadHostVulnerabilityGrid();
    },
};