﻿$(document).ready(function () {
    $(function () {
        if ($("#IsEdit").val() === "True") {
            $("#credentialType").addClass("disableContent");

            $('#credentialType').change();
        }
    });
});

function loadBlockIfSuccess(html) {
    $('#loading').hide();
    $('#block').show();
    $('#block').html(html);
}

function loadSpinnerForBlock() {
    $('#block').hide();
    $('#loading').show();
    $('#loading').html("<img src='/img/preloader/spinner.svg' />");
}

function loadCredentialBlock(credentialType) {
    switch (credentialType) {
        case "Windows":
            loadWindowsBlock();
            break;

        case "Ssh":
        case "Solaris":
        case "FreeBsd":
        case "CiscoIOS":
        case "CiscoNXOS":
        case "Huawei":
        case "CheckPoint":
        case "FortiOs":
        case "Eltex":
            loadSshBlock();
            break;

        case "Sql":
            loadSqlBlock();
            break;

        case "VMwareESXi":
        case "VMwareNSX":
        case "VMwarevCenter":
        case "UserGate":
        case "OpenShift":
            loadHttpBlock();
            break;
    }
}

function loadWindowsBlock() {
    setWinRmPortChecked();
    setWinRmOverHttps();
    setAgentPortChecked();
}

function loadSshBlock() {
    setAuthType();
    isPrivilegesBlockAvailable();
    isTerminalPagerSeparatorSetupAvailable();
    setPrivilegePassword();
    privilegePasswordStateChanged();
    let privilegeLevelInput = $('#PrivilegesLevel');
    if ($('#PrivilegesLevel').val() === "")
        privilegeLevelInput.val(privilegeLevelInput.attr('defaultvalue'));
    isUserRoot();
    isUseSeparator();
}

function loadHttpBlock() {
    let checkCertAvailable = document.getElementById('IsCheckCertOptionAvailable').value.toLowerCase() === "true";
    checkCertAvailable ? $('#checkCertBlock').removeClass('hide') : $('#checkCertBlock').addClass('hide');
}

function loadSqlBlock() {
    selectSqlType();
    isDefaultPortClick();
    if (document.getElementById('Id').value != 0)
        document.getElementById('dbTypeSelector').classList.add('disableContent');
}

function setAuthType() {
    $('input:radio[name=SelectedAuthType]').change(function () {
        if (this.value === 'Password') {
            $('#sshPassBlock').removeClass('hide');
            $('#sshKeyBlock').addClass('hide');
            $('#sshPassPhraseBlock').addClass('hide');
        }
        else if (this.value === 'PrivateKey') {
            $('#sshKeyBlock').removeClass('hide');
            $('#sshPassBlock').addClass('hide');
            $('#sshPassPhraseBlock').addClass('hide');
        }
        else if (this.value === 'PrivateKeyAndPassPhrase') {
            $('#sshPassPhraseBlock').removeClass('hide');
            $('#sshKeyBlock').removeClass('hide');
            $('#sshPassBlock').addClass('hide');
        }
    });

    $('input:radio[name=SelectedAuthType]:checked').trigger('change');
}

function isUseSeparator() {
    if ($('#UseTerminalPagerSeparator').prop('checked') === true)
        document.getElementById('useSeparator').classList.remove('disableContent');
    else {
        document.getElementById('useSeparator').classList.add('disableContent');
        var str = $('#TerminalPagerSeparator');
        str.val(str.attr('defaultvalue'));
        str.attr('value', str.attr('defaultvalue'));
    }
}

function privilegePasswordStateChanged() {
    if ($('#IsPrivilegePasswordChecked').prop('checked') === false) {
        $('#sshPrivilegePasswordBlock').addClass('disableContent');

        let privilegePasswordInput = $('#PrivilegePassword');
        privilegePasswordInput.val('');

        let confirmPrivilegePasswordInput = $('#ConfirmPrivilegePassword');
        confirmPrivilegePasswordInput.val('');

        $('#okEn').addClass('hide');
        $('#errEn').addClass('hide');
    }
    else
        $('#sshPrivilegePasswordBlock').removeClass('disableContent');
}

function isPrivilegesBlockAvailable() {
    let privAvailable = document.getElementById('IsPrivilegeSetupAvailable').value.toLowerCase() === "true";
    privAvailable ? $('#privilegesBlock').removeClass('hide') : $('#privilegesBlock').addClass('hide');
}

function isTerminalPagerSeparatorSetupAvailable() {
    let terminalSepAvailable = document.getElementById('IsTerminalPagerSeparatorSetupAvailable').value.toLowerCase() === "true";
    terminalSepAvailable ? $('#terminalPagerSeparatorBlock').removeClass('hide') : $('#terminalPagerSeparatorBlock').addClass('hide');
}

function setPrivilegePassword() {
    $('select[name=Privileges]').change(function () {

        let selectedPrivelege = this.value.toLowerCase();

        if (selectedPrivelege === 'none') {
            $('#sshPrivilegeBlock').addClass('hide');
            $('#enablePrivilegePasswordBlock').addClass('hide');
            $('#sshPivilegeLevelBlock').addClass('hide');
        }
        else {
            $('#sshPrivilegeBlock').removeClass('hide');
            $('#enablePrivilegePasswordBlock').removeClass('hide');

            if (selectedPrivelege === "enable" || selectedPrivelege === "super") {
                $('#sshPivilegeLevelBlock').removeClass('hide');
            } else {
                $('#sshPivilegeLevelBlock').addClass('hide');
            }
        }
    });

    $('select[name=Privileges]').trigger('change');
}

function isUserRoot() {

    let userNameStruct = { "oldVal": null, "newVal": null };

    $('#UserName').change(function () {

        let currentVal = this.value;
        
        if (!userNameStruct.oldVal && !userNameStruct.newVal) {
            //init
            userNameStruct.oldVal = currentVal;
            userNameStruct.newVal = currentVal;
        }
        else {
            userNameStruct.oldVal = userNameStruct.newVal;
            userNameStruct.newVal = currentVal;
        }

        if (userNameStruct.newVal === 'root') {
            $('select[name=Privileges]').val('None').trigger("change");
        }
        else if (userNameStruct.oldVal === 'root'){
            let defaultPriv = document.getElementById('defaultPrivilege').value;
            $('select[name=Privileges]').val(defaultPriv).trigger("change");
        }
    });
}

function setWinRmPortChecked() {
    if (document.getElementById('WinrmPort') !== null && document.getElementById('IsSpecifyWinrmPort') !== null) {
        if ($('#IsSpecifyWinrmPort').prop('checked') === true)
            document.getElementById('winRmPortBlock').classList.remove('disableContent');
        else {
            document.getElementById('winRmPortBlock').classList.add('disableContent');
            var port = $('#WinrmPort');
            port.val(port.attr('defaultvalue'));
            port.attr('value', port.attr('defaultvalue'));
        }
    }
}

function setAgentPortChecked() {
    if (document.getElementById('AgentPort') !== null && document.getElementById('IsSpecifyAgentPort') !== null) {
        if ($('#IsSpecifyAgentPort').prop('checked') === true)
            document.getElementById('agentPortBlock').classList.remove('disableContent');
        else {
            document.getElementById('agentPortBlock').classList.add('disableContent');
            var port = $('#AgentPort');
            port.val(port.attr('defaultvalue'));
            port.attr('value', port.attr('defaultvalue'));
        }
    }
}

function setWinRmOverHttps() {
    if ($('#WinrmOverHttps').prop('checked') === true)
        document.getElementById('winOverHttpBlock').classList.remove('hide');
    else {
        document.getElementById('winOverHttpBlock').classList.add('hide');
    }
}

function checkPass() {
    checkPasswordBlock('Password', 'ConfirmPassword', 'err', 'ok');
}

function checkSshPass() {
    checkPasswordBlock('SshKeyPassword', 'ConfirmSshPassPhrase', 'errSsh', 'okSsh');
}

function checkPrivilegePass() {
    checkPasswordBlock('PrivilegePassword', 'ConfirmPrivilegePassword', 'errEn', 'okEn');
}

function selectSqlType() {
    $('input:radio[name=DbType]').change(function () {
        $('#sqlPortBlock').removeClass('hide');

        if (this.value === 'MsSql') {
            $('#instance').removeClass('hide');
            $('#useWindowsAuthentication').removeClass('hide');
            $('#priviligiDBA').addClass('hide');
            $('#loginDb').removeClass('hide');
            $("#postgreEmptyDbNameHint").addClass('hide');
            $('#checkAccessDbBlock').removeClass('hide');
            $('#bd').addClass('hide');
            $('#timeout').addClass('hide');
            $('#optionsDb').addClass('hide');
        }
        else if (this.value === 'Oracle') {
            $('#useWindowsAuthentication').addClass('hide');
            $('#priviligiDBA').removeClass('hide');
            $('#loginDb').removeClass('hide');
            $("#postgreEmptyDbNameHint").addClass('hide');
            $('#instance').addClass('hide');
            $('#checkAccessDbBlock').removeClass('hide');
            $('#bd').removeClass('hide');
            $('#timeout').addClass('hide');
            $('#optionsDb').addClass('hide');
        }
        else if (this.value === 'PostgreSQL') {
            $('#useWindowsAuthentication').addClass('hide');
            $('#bd').removeClass('hide');
            $('#instance').addClass('hide');
            $('#timeout').removeClass('hide');
            $('#checkAccessDbBlock').removeClass('hide');
            $('#loginDb').removeClass('hide');
            $("#postgreEmptyDbNameHint").removeClass('hide');
            $('#priviligiDBA').addClass('hide');
            $('#optionsDb').addClass('hide');
        }
        else if (this.value === 'MySql') {
            $('#useWindowsAuthentication').addClass('hide');
            $('#priviligiDBA').addClass('hide');
            $('#loginDb').removeClass('hide');
            $("#postgreEmptyDbNameHint").addClass('hide');
            $('#bd').removeClass('hide');
            $('#instance').addClass('hide');
            $('#timeout').addClass('hide');
            $('#checkAccessDbBlock').removeClass('hide');
            $('#optionsDb').addClass('hide');
        }
        else if (this.value === 'IbmDb2') {
            $('#useWindowsAuthentication').addClass('hide');
            $('#priviligiDBA').addClass('hide');
            $('#loginDb').removeClass('hide');
            $("#postgreEmptyDbNameHint").addClass('hide');
            $('#bd').removeClass('hide');
            $('#instance').addClass('hide');
            $('#timeout').addClass('hide');
            $('#checkAccessDbBlock').removeClass('hide');
            $('#optionsDb').addClass('hide');
        }
        else if (this.value === 'SapHana') {
            $('#useWindowsAuthentication').addClass('hide');
            $('#priviligiDBA').addClass('hide');
            $('#loginDb').removeClass('hide');
            $("#postgreEmptyDbNameHint").addClass('hide');
            $('#bd').removeClass('hide');
            $('#instance').addClass('hide');
            $('#timeout').addClass('hide');
            $('#checkAccessDbBlock').removeClass('hide');
            $('#optionsDb').addClass('hide');
        }
        else if (this.value === 'MongoDB') {
            $('#useWindowsAuthentication').addClass('hide');
            $('#bd').removeClass('hide');
            $('#instance').addClass('hide');
            $('#timeout').addClass('hide');
            $('#checkAccessDbBlock').removeClass('hide');
            $('#loginDb').removeClass('hide');
            $("#postgreEmptyDbNameHint").addClass('hide');
            $('#priviligiDBA').addClass('hide');
            $('#optionsDb').removeClass('hide');
        }

        selectDefaultValueForSql();
    });

    // Fire event on init to show credential settings for selected DB type
    $('input:radio[name=DbType]:checked').trigger('change');
}

function isDefaultPortClick() {
    if (document.getElementById('DbPort') !== null && document.getElementById('IsDefaultPort') !== null) {
        if ($('#IsDefaultPort').prop('checked') === false)
            document.getElementById('defaultPortBlock').classList.remove('disableContent');
        else {
            document.getElementById('defaultPortBlock').classList.add('disableContent');
            selectDefaultValueForSql();
        }
    }
}

function selectDefaultValueForSql() {
    var isDefaultPort = document.getElementById('IsDefaultPort').checked;
    if (isDefaultPort === true) {
        var selectedType = $('input[name=DbType]:checked').val();
        if (selectedType === 'MsSql') {
            $('#DbPort').val(1433);
            $('#DbPort').attr('value', 1433);
        }
        else if (selectedType === 'Oracle') {
            $('#DbPort').val(1521);
            $('#DbPort').attr('value', 1521);
        }
        else if (selectedType === 'PostgreSQL') {
            $('#DbPort').val(5432);
            $('#DbPort').attr('value', 5432);
        }
        else if (selectedType === 'MySql') {
            $('#DbPort').val(3306);
            $('#DbPort').attr('value', 3306);
        }
        else if (selectedType === 'IbmDb2') {
            $('#DbPort').val(50000);
            $('#DbPort').attr('value', 50000);
        }
        else if (selectedType === 'SapHana') {
            $('#DbPort').val(39015);
            $('#DbPort').attr('value', 39015);
        }
        else if (selectedType === 'MongoDB') {
            $('#DbPort').val(27017);
            $('#DbPort').attr('value', 27017);
        }
    }
}

function executeFileDialog() {
    document.getElementById('loadSSH').click();
}

function loadSSHKey(e) {

    let file = document.getElementById('loadSSH').files[0];

    if (file) {
        if (file.size > 1048576) {
            notify(fileMessage.LoadingSshKeyError + '<br/>' + fileMessage.RestrictFileSize);
            return;
        }

        let fr = new FileReader();
        fr.readAsDataURL(file);
        fr.onload = function (e) {
            document.getElementById('SshPrivateKey').value = e.target.result.split(',')[1];
            document.getElementById('buttonFileDialog').value = fileMessage.FileLoaded;
            document.getElementById('buttonFileDialog').classList.add('disableContent');
            document.getElementById('clearSSH').classList.remove('disableContent');
        };
    }
}

function clearSSHKey() {
    document.getElementById('SshPrivateKey').value = '';
    document.getElementById('loadSSH').value = '';
    document.getElementById('buttonFileDialog').value = fileMessage.FileLoad;
    document.getElementById('buttonFileDialog').classList.remove('disableContent');
    document.getElementById('clearSSH').classList.add('disableContent');
}

function checkCredential() {
    const credentialType = $('select#credentialType').val();

    if (!$("form").valid()) {
        notify('Необходимо заполнить все данные');
        return;
    }

    if (credentialType === 'Sql') { // validation for sql
        if (document.getElementById('DbLogin').value == '') {
            notify('Необходимо задать логин');
            return;
        }
    }

    if (credentialType !== 'Sql' && credentialType !== 'OpenShift') { // validation for all credentials except sql and OpenShift
        if (document.getElementById('UserName').value == '') {
            notify('Необходимо задать имя пользователя');
            return;
        }
    }

    if ($('input[name=DbType]:checked').val() === 'MsSql') {
        const dbServer = document.querySelector('input[name=DbServer]').value;
        const isDefaultPort = document.getElementById('IsDefaultPort').checked;
        
        if (dbServer !== undefined && dbServer.length > 0 && isDefaultPort === true) {
            notify('При заданном экземпляре нельзя задать порт по умолчанию, порт должен быть задан явно');
            return;
        }
    }

    /************************ Authentication block validation ************************/

    let radioPassChecked = document.getElementById('radioPass') != null && document.getElementById('radioPass').checked;
    let radioPrivateKeyChecked = document.getElementById('radioPrivateKey') != null && document.getElementById('radioPrivateKey').checked;
    let radioPrivateKeyAndPassChecked = document.getElementById('radioPrivateKeyAndPass') != null && document.getElementById('radioPrivateKeyAndPass').checked;

    let passwordElement = document.getElementById('Password');
    let confirmPasswordElement = document.getElementById('ConfirmPassword');
    let sshKeyPasswordElement = document.getElementById('SshKeyPassword');
    let confirmSshPassPhraseElement = document.getElementById('ConfirmSshPassPhrase');
    let sshPrivateKeyElement = document.getElementById('SshPrivateKey');

    const sshPrivateKeyNotValidMsg = 'Необходимо загрузить SSH ключ';

    //User choosed Password authentication for nix (Default behaviour for the rest)
    if (radioPassChecked || (!radioPassChecked && !radioPrivateKeyChecked && !radioPrivateKeyAndPassChecked)) {

        //Validate Password
        if (passwordElement.value === '' && (confirmPasswordElement === null || confirmPasswordElement.value === '')) {
            notify('Необходимо задать пароль');
            return;
        }
        if (confirmPasswordElement !== null && passwordElement.value !== confirmPasswordElement.value) {
            notify('Пароли не совпадают');
            return;
        }
    }

    //User choosed SshPrivateKey authentication. Validate SshPrivateKey
    if (radioPrivateKeyChecked && sshPrivateKeyElement.value == '') {
        notify(sshPrivateKeyNotValidMsg);
        return;
    }

    //User choosed SshPrivateKey and SSH Passphrase authentication
    if (radioPrivateKeyAndPassChecked) {

        //Validate SshPrivateKey
        if (sshPrivateKeyElement.value == '') {
            notify(sshPrivateKeyNotValidMsg);
            return;
        }

        //Validate SSH Passphrase
        if (sshKeyPasswordElement.value == '' && confirmSshPassPhraseElement.value == '') {
            notify('Необходимо задать SSH проверочную фразу');
            return;
        }
        if (sshKeyPasswordElement.value !== confirmSshPassPhraseElement.value) {
            notify('Проверочные фразы не совпадают');
            return;
        }
    }

    /************************ Privilege block validation ************************/

    let privilegePasswordElement = document.getElementById('PrivilegePassword');
    let confirmPrivilegePasswordElement = document.getElementById('ConfirmPrivilegePassword');
    let privilegesElement = document.getElementById('Privileges');

    if (privilegesElement != null
        && privilegesElement.value !== 'None'
        && $('#IsPrivilegePasswordChecked').prop('checked') === true) {

        //Validate PrivilegePassword
        if (privilegePasswordElement.value == '' && confirmPrivilegePasswordElement.value == '') {
            notify('Необходимо задать пароль привилегий');
            return;
        }
        if (privilegePasswordElement.value !== confirmPrivilegePasswordElement.value) {
            notify('Пароли привилегий не совпадают');
            return;
        }
    }

    /************************ Separator validation ************************/
    let terminalSeparator = document.getElementById('TerminalPagerSeparator');

    if (terminalSeparator != null && $('#UseTerminalPagerSeparator').prop('checked') === true) {
        if (terminalSeparator.value.trim().length === 0) {
            notify('Необходимо задать разделитель терминального пейджера');
            return;
        }
    }
}

function notify(message) {
    notifyWarning(message)
    event.preventDefault();
}