﻿const DB_TYPE_MsSql = "MsSql";
const DB_TYPE_Oracle = "Oracle";
const DB_TYPE_MySql = "MySql";
const DB_TYPE_PostgreSQL = "PostgreSQL";
const DB_TYPE_IbmDb2 = "IbmDb2";
const DB_TYPE_SapHana = "SapHana";

const COMPLIANCE_TYPE_Default = "Default";

const FIXATION_SEARCH_PATTERN_CISCO = "*.so, *.conf";
const FIXATION_SEARCH_PATTERN_WIN = "*.exe, *.dll";

const NMAP_SCAN_PROFILE_STANDARD = "ScanProfileStandard";
const NMAP_SCAN_PROFILE_TOP50 = "ScanProfileTOP50";
const NMAP_SCAN_PROFILE_FULL = "ScanProfileFull";
const NMAP_SCAN_PROFILE_STANDARD_UDP = "ScanProfileStandardUDP";
const NMAP_SCAN_PROFILE_FULL_UDP = "ScanProfileFullUDP";
const NMAP_SCAN_PROFILE_CUSTOM = "ScanProfileCustom";

const NMAP_TIME_PROFILE_PARANOID = "Paranoid";
const NMAP_TIME_PROFILE_SNEAKY = "Sneaky";
const NMAP_TIME_PROFILE_POLITE = "Polite";
const NMAP_TIME_PROFILE_NORMAL = "Normal";
const NMAP_TIME_PROFILE_AGGRESSIVE = "Aggressive";
const NMAP_TIME_PROFILE_INSANE = "Insane";

const NMAP_DATA_DIR = "C:\\\\ProgramData\\\\ALTEX-SOFT\\\\RedCheck\\\\ALTXmap";

$(document).ready(function () {
    $(window).keydown(function (event) {
        if (event.keyCode === 13) {
            event.preventDefault();
            return false;
        }
    });
});

function JobMasterTab(id) {
    //create tab element
    if (document.getElementById(id) === null) {
        switch (id) {
            case "TabHostsAndGroup":
                createTabHostsAndGroups();
                break;
            case "TabCredentials":
                var types = GetCredentialTypesByJobScanType(currentJobProperties.currentJobScanType);
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Vulnerability || currentJobProperties.currentJobScanType === SCAN_TYPE_Patch || currentJobProperties.currentJobScanType === SCAN_TYPE_Compliance || currentJobProperties.currentJobScanType === SCAN_TYPE_Inventory || currentJobProperties.currentJobScanType === SCAN_TYPE_Fixation || isDocker(currentJobProperties.currentJobScanType) || currentJobProperties.currentJobScanType === SCAN_TYPE_Yara) {
                    var params = new CredentialParams(types, GetCiscoOsTypesByJobScanType(currentJobProperties.currentJobScanType));
                    createTabCredentials(params);
                    break;
                }

                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Remediation) {
                    var winParams = new CredentialParams(types, null);
                    createTabCredentials(winParams);
                    break;
                }
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Ping) {
                    setCredentialTypeToPing();
                    break;
                }
                break;
            case "TabScanProfiles":
                let scanProfileParams = new ScanProfileParams(currentJobProperties.currentJobScanType, currentJobProperties.currentCredentialTypes);
                createTabScanProfile(scanProfileParams);
                break;
            case "TabCompliance":
                let complianceParams = new ComplianceParams(currentJobProperties.currentJobScanType, currentJobProperties.currentCredentialTypes);
                createTabCompliance(complianceParams);
                break;
            case "TabXccdfProfile":
                let complianceSelectedList = CreateJobsComplianceController.getSelectedIds();
                createTabXccdfProfile(complianceSelectedList);
                break;
            case "TabScheduler":
                createTabScheduler();
                break;
            case "TabPing":
                createTabPing();
                break;
            case "TabFileFixation":
                createTabFileFixation(currentJobProperties);
                break;
            case "TabRegFixation":
                createTabRegFixation();
                break;
            case "TabCiscoFixation":
                createTabCiscoFixation();
                break;
            case "TabNmap":
                createTabNmap();
                break;
            case "TabHostDiscovery":
                createTabHostDiscovery();
                break;
            case "TabBruteforce":
                createTabBruteforce();
                break;
            case "TabInventory":
                let inventoryParams = new InventoryParams(currentJobProperties.currentJobScanType, currentJobProperties.currentCredentialTypes);
                createTabInventory(inventoryParams);
                break;
            case "TabScadaModules":
                createTabScadaModules();
                break;
            case "TabYara":
                createTabYara();
                break;
            case "TabReport":
                createTabReport(new ReportTemplateParams(currentJobProperties.currentJobScanType));
                break;
        }
    }

    this.getId = function () {
        return id;
    };

    this.getNextTab = function () {
        switch (id) {
            case "TabSettings":
                if (isHostDiscovery(currentJobProperties.currentJobScanType)) {
                    return new JobMasterTab("TabHostDiscovery");
                }
                return new JobMasterTab("TabHostsAndGroup");
            case "TabHostsAndGroup":
                if (isNmap(currentJobProperties.currentJobScanType)) {
                    return new JobMasterTab("TabNmap");
                }
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Scada) {
                    return new JobMasterTab("TabScadaModules");
                }
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Ping) {
                    return new JobMasterTab("TabPing");
                }
                return new JobMasterTab("TabCredentials");
            case "TabCredentials":
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Vulnerability || currentJobProperties.currentJobScanType === SCAN_TYPE_Patch
                    || currentJobProperties.currentJobScanType === SCAN_TYPE_Docker_Vulnerabilities)
                    return new JobMasterTab("TabScanProfiles");
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Compliance)
                    return new JobMasterTab("TabCompliance");
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Ping)
                    return this.setSchedulerOrReportNextTab();
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Inventory)
                    return new JobMasterTab("TabInventory");
                if (isFixation(currentJobProperties.currentJobScanType, currentJobProperties.currentCredentialTypes.getByIndex(0).type)) {
                    return new JobMasterTab("TabFileFixation");
                }
                if (isCiscoFixation(currentJobProperties.currentJobScanType, currentJobProperties.currentCredentialTypes.getByIndex(0).type)) {
                    return new JobMasterTab("TabCiscoFixation");
                }
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Yara) {
                    return new JobMasterTab("TabYara");
                }
                break;
            case "TabPing":
                return new JobMasterTab("TabCredentials");
            case "TabCompliance":
                return new JobMasterTab("TabXccdfProfile");
            case "TabXccdfProfile":
                FillProfileTreeViewValue();
                return this.setSchedulerOrReportNextTab();
            case "TabFileFixation":
                if (currentJobProperties.currentCredentialTypes.getByIndex(0).type === CREDENTIAL_TYPE_Windows)
                    return new JobMasterTab("TabRegFixation");
                else return this.setSchedulerOrReportNextTab();
            case "TabNmap":
                if (document.getElementById("Nmap_ScanTypes_Bruteforce").checked)
                    return new JobMasterTab("TabBruteforce");
                else return this.setSchedulerOrReportNextTab();
            case "TabHostDiscovery":
                return this.setSchedulerOrReportNextTab();
            case "TabInventory":
            case "TabScanProfiles":
            case "TabCiscoFixation":
            case "TabRegFixation":
            case "TabBruteforce":
            case "TabScadaModules":
                return this.setSchedulerOrReportNextTab();
            case "TabScheduler":
                return new JobMasterTab("TabReport");
            case "TabReport":
            case "TabYara":
                return new JobMasterTab("TabSummary");
            default:
        }
    };

    this.isValid = async function () {
        let isValid = $("form").valid();

        switch (id) {
            case "TabSettings":
                if ($('#Params_IsNotifyByEmail').prop('checked') && $.fn.DataTable.isDataTable('#NetworkResourcesGrid')) {
                    let rowsCount = $('#NetworkResourcesGrid').DataTable().rows().count();
                    if (rowsCount === 0) {
                        notifyWarning('Требуется выбрать хотя бы один адрес электронной почты');
                        return false;
                    }
                }

                if (document.querySelector('#Params_ScanningServiceId').value == 0) {
                    notifyWarning('Требуется выбрать службу сканирования');
                    isValid = false;
                } else {
                    if (!isJobScanTypeForNixServiceAllowed(
                        $('#Params_ScanningServiceHostOsType').val(),
                        $('#Params_SelectedJobScanType').val(),
                        nixScanServiceForbiddenJobs
                    )) {
                        notifyWarning(nixScanServiceInvalidScanType);
                        return false;
                    }
                }
                break;
            case "TabHostsAndGroup":
                if (currentJobProperties.currentJobScanType === SCAN_TYPE_Nmap || currentJobProperties.currentJobScanType === SCAN_TYPE_HostDiscovery) {
                    if (currentJobProperties.currentJobScanType === SCAN_TYPE_Nmap && (currentJobProperties.currentCountHostsSelected === 0 || currentJobProperties.currentCountHostsSelected === undefined)
                        && (currentJobProperties.currentCountGroupsSelected === 0 || currentJobProperties.currentCountGroupsSelected === undefined)) {
                        notifyWarning('Требуется выбрать группы или хосты');
                        isValid = false;
                    }
                }
                else if ((currentJobProperties.currentCountHostsSelected === 0 || currentJobProperties.currentCountHostsSelected === undefined) && (currentJobProperties.currentCountGroupsSelected === 0 || currentJobProperties.currentCountGroupsSelected === undefined)) {
                    notifyWarning('Требуется выбрать группы или хосты');
                    isValid = false;
                }
                break;
            case "TabCredentials":
                if (JobCredentialsGridComponent.Data.length === 0) {
                    notifyWarning(noCredentialsSelected);
                    return false;
                }

                let isCredentialsForNixServiceAllowedCheck = isCredentialsForNixServiceAllowed(
                    $('#Params_ScanningServiceHostOsType').val(),
                    currentJobProperties.currentJobScanType,
                    currentJobProperties.currentPingType,
                    JobCredentialsGridComponent.Data,
                    nixScanServiceForbiddenJobs
                );
                if (isCredentialsForNixServiceAllowedCheck.result === false) {
                    notifyWarning(isCredentialsForNixServiceAllowedCheck.message);
                    return false;
                }

                try {
                    let result = await $.ajax({
                        url: getSameCredentialsWithDifferentTypesUrl + '?credentialIdsStr=' + JobCredentialsGridComponent.Data.map((c) => c.Id).join(','),
                        type: 'GET',
                        contentType: "application/json; charset=utf-8",
                    });

                    if (result.length > 0)
                        notifyWarning("Нельзя задать несколько одинаковых УЗ разных типов:\n"
                            + result.map((c) => c.Name + " (" + (c.SubType !== null && c.SubType !== undefined ? (c.Type + ' ' + c.SubType) : c.Type) + ")").join("\n"));

                    return result.length === 0;
                }
                catch (error) {
                    notifyWarning(error);
                }
                break;
            case "TabPing":
                if (!isCredentialTypeWithTransportTypeForNixServiceAllowed(
                    $('#Params_ScanningServiceHostOsType').val(),
                    null,
                    currentJobProperties.currentPingType,
                    nixScanServiceForbiddenJobs
                )) {
                    notifyWarning(nixScanServiceInvalidTransport + ": " + currentJobProperties.currentPingType);
                    return false;
                }
                break;
            case "TabFileFixation":
                let selectedHash = document.getElementById('FileFixation_SelectedFixationHashType').value;

                // TODO: Remove localhost check?
                let hasLocalhost = document.querySelectorAll("input[type='hidden'][id*='Hosts_HostsList_'][value='1']").length > 0;
                if (selectedHash === 'Level3' && hasLocalhost) {
                    notifyWarning('УРОВЕНЬ 3 не может использоваться для localhost. Необходимо удалить localhost из набора хостов задания или задать другой алгоритм КС');
                    isValid = false;
                }
                if (currentJobProperties.currentCredentialTypes.getByIndex(0).type != CREDENTIAL_TYPE_Windows) {
                    let rowsCount = $('#FileFixation_Catalogs').DataTable().rows().count();
                    if (rowsCount === 0) {
                        notifyWarning('Требуется выбрать каталоги для фиксации');
                        isValid = false;
                    }
                    if (Array.from(document.querySelectorAll("input[type='checkbox'][name^='FileFixation.FixationEntries']")).filter(i => i.name.endsWith('IsExclusion')).every(x => x.checked) === true) {
                        notifyWarning('Добавьте хотя бы один не исключающий каталог');
                        isValid = false;
                    }
                }
                break;
            case "TabRegFixation":
                let fileRowsCount = $('#FileFixation_Catalogs').DataTable().rows().count();
                let regRowsCount = $('#RegFixation_Keys').DataTable().rows().count();
                if (fileRowsCount === 0 && regRowsCount === 0) {
                    notifyWarning('Требуется выбрать ключи реестра или каталоги для фиксации');
                    isValid = false;
                }

                let allFileExclusions = Array.from(document.querySelectorAll("input[type='checkbox'][name^='FileFixation.FixationEntries']")).filter(i => i.name.endsWith('IsExclusion'));
                let allRegExclusions = Array.from(document.querySelectorAll("input[type='checkbox'][name^='RegFixation.FixationEntries']")).filter(i => i.name.endsWith('IsExclusion'));

                if (allFileExclusions.length > 0 && allFileExclusions.every(x => x.checked) || allRegExclusions.length > 0 && allRegExclusions.every(x => x.checked)) {
                    notifyWarning('Добавьте хотя бы один не исключающий каталог');
                    isValid = false;
                }
                break;
            case "TabCompliance":
                if (currentJobProperties.currentCountCompliance === null || currentJobProperties.currentCountCompliance === undefined || currentJobProperties.currentCountCompliance === 0) {
                    document.getElementById('complianceValid').classList.remove('hide');
                    isValid = false;
                }
                break;
            case "TabInventory":
                const nodes = inventoryTreeView.getTopNodes();
                let countOfUnchecked = 0;
                for (let i = 0; i < nodes.length; i++) {
                    if (nodes[i].getCheckState() === 'Unchecked')
                        countOfUnchecked++;

                    if (countOfUnchecked === nodes.length) {
                        notifyWarning('Требуется выбрать параметры профиля инвентаризации');
                        isValid = false;
                    }
                }
                break;
            case "TabNmap":
                if ($('[id*="Nmap_ScanTypes_"]:checked').length === 0) {
                    notifyWarning('Требуется выбрать хотя бы один тип сканирования');
                    isValid = false;
                }

                // If only Bruteforce is checked - no validation is needed at this step
                if ($('[id*="Nmap_ScanTypes_"]:checked').length === 1 &&
                    $('#Nmap_ScanTypes_' + SCAN_TYPE_Bruteforce).prop('checked') === true)
                    isValid = true;

                let selectedScanProfile = document.getElementById('Nmap_SelectedScanProfile').value;
                if (selectedScanProfile === NMAP_SCAN_PROFILE_CUSTOM && $("form").valid() &&
                    (!$('#Nmap_Tcp_Ports').val() && !$('#Nmap_Udp_Ports').val() ||
                        $('#Nmap_Tcp_Ports').val() && ($('#Nmap_Tcp_Ports').val().match(/^\d+(?:-\d+)?(?:,\d+(?:-\d+)?)*$/) === null || !ValidatePortRanges($('#Nmap_Tcp_Ports').val())) ||
                        $('#Nmap_Udp_Ports').val() && ($('#Nmap_Udp_Ports').val().match(/^\d+(?:-\d+)?(?:,\d+(?:-\d+)?)*$/) === null || !ValidatePortRanges($('#Nmap_Udp_Ports').val())))) {
                    notifyWarning('Требуется корректно указать диапазоны сканируемых портов');
                    isValid = false;
                }
                break;
            case "TabHostDiscovery":
                if (!$('#HostDiscoveryRange').val()) {
                    notifyWarning('Требуется указать диапазон хостов для сканирования');
                    isValid = false;
                }
                if (!$('#HostDiscoveryTCPPorts').val()) {
                    notifyWarning('Требуется выбрать порты для сканирования');
                    isValid = false;
                }
                if (!ValidatePortRanges($('#HostDiscoveryTCPPorts').val())) {
                    notifyWarning('Требуется корректно указать диапазоны сканируемых портов');
                    isValid = false;
                }
                break;
            case "TabBruteforce":
                if ($('#bruteforceAllInstances').prop('checked') !== true && $('#bruteforceInstance').val().length === 0 && $('#bruteforcePort').val().length === 0) {
                    notifyWarning('Требуется указать экземпляр или порт');
                    isValid = false;
                } else if ($('#bruteforcePort').val().length > 0 && ($('#bruteforcePort').val().match(/^\d{1,5}$/) === null || $('#bruteforcePort').val() < 1 || $('#bruteforcePort').val() > 65535)) {
                    notifyWarning('Требуется указать корректный номер порта');
                    isValid = false;
                }

                if ($('#Bruteforce_BruteTimeout').val() && $('#Bruteforce_BruteTimeout').val().match(/^\d+[h,m,s]?$/) === null) {
                    notifyWarning('Требуется корректно указать значение таймаута для хоста');
                    isValid = false;
                }
                break;
            case "TabScanProfiles":
                if (!ifScanProfileValid()) {
                    notifyWarning('Требуется выбрать профили сканирования');
                    isValid = false;
                }

                if (!ifJarSearchPathValid()) {
                    isValid = false;
                }

                break;
            case "TabScadaModules":
                if ($('input[id*="Scada_ScadaModules_"]:checked').length === 0) {
                    $('#scadaModulesValid').removeClass('hide');
                    isValid = false;
                }
                break;
            case "TabScheduler":
                if (validateSchedule() === false) {
                    isValid = false;
                }
                break;
            case "TabYara":
                let catalogsRowsCount = $('#Yara_Catalogs').DataTable().rows().count();
                if (catalogsRowsCount === 0) {
                    notifyWarning('Требуется указать каталоги для сканирования YARA-правилами');
                    isValid = false;
                }
                break;
        }

        return isValid;
    };

    this.open = function () {
        if (id === "TabSummary") {
            if (currentJobProperties.currentJobScanType === SCAN_TYPE_Inventory)
                FillInventoryTreeView();
            // if (currentJobProperties.currentJobScanType === SCAN_TYPE_Fixation)
            //     FillFixationData();
            $('#submitCreateSummary').click();
        }
        else {
            var count = $('.tablinks').length;
            for (var i = 0; i < count; i++) {
                if (document.getElementsByClassName('tablinks')[i].id === id && i + 1 < count) {
                    document.getElementsByClassName('tablinks')[i].classList.remove('active');
                    document.getElementsByClassName('tablinks')[i + 1].classList.add('active');
                }
            }

            document.getElementById(id).click();
        }
    };

    this.setSchedulerOrSummaryNextTab = function () {
        if (currentJobProperties.currentIsScheduler === true)
            return new JobMasterTab("TabScheduler");
        else
            return new JobMasterTab("TabSummary");
    };

    this.setSchedulerOrReportNextTab = function () {
        if (currentJobProperties.currentIsScheduler === true)
            return new JobMasterTab("TabScheduler");
        else
            return new JobMasterTab("TabReport");
    };
}

function ValidatePortRanges(ports) {
    var portParts = ports.split(",");
    return portParts.every(function (value) {
        if (value.indexOf("-") > -1) {
            var parts = value.split("-");
            if (parts.length !== 2) return false;

            var startPort = parseInt(parts[0]);
            var endPort = parseInt(parts[1]);
            if (isNaN(startPort) || isNaN(endPort)) return false;

            if (startPort >= endPort || startPort < 1 || endPort > 65535) return false;
        } else {
            var port = parseInt(value);
            if (isNaN(port) || port < 1 || port > 65535) return false;
        }

        return true;
    });
}

var isCanNextFromNmap = true;
var isCanNextFromMail = true;
var isCanCreateJob = true;
var isCanUseFromScada = true;
var isCanUseFromYara = true;
var JobProperties = function (oldProperties) {
    this.currentJobScanType;
    this.currentCountHostsSelected;
    this.currentCountGroupsSelected;
    this.currentCredential;
    this.additionalCredential;
    this.currentCountCompliance;
    this.selectedComplianceIds;
    this.currentIsScheduler;
    this.currentCredentialTypes;
    this.currentPingType;
    this.currentJobAgentType;
    this.runAfterCreation;

    this.init = function () {
        if (oldProperties) {
            this.currentIsScheduler = oldProperties.currentIsScheduler;
            this.currentCountHostsSelected = oldProperties.currentCountHostsSelected;
            this.currentCountGroupsSelected = oldProperties.currentCountGroupsSelected;
            this.currentCredential = oldProperties.currentCredential;
            this.additionalCredential = oldProperties.additionalCredential;
            this.currentCountCompliance = oldProperties.currentCountCompliance;
            this.selectedComplianceIds = oldProperties.selectedComplianceIds;
            this.currentJobScanType = oldProperties.currentJobScanType;
            this.currentCredentialTypes = oldProperties.currentCredentialTypes;
            this.currentReportTemplatesSelected = oldProperties.currentReportTemplatesSelected;
            this.currentPingType = oldProperties.currentPingType;
            this.currentJobAgentType = oldProperties.currentJobAgentType;
            this.runAfterCreation = oldProperties.runAfterCreation;
        }
        else {
            this.currentCountHostsSelected = 0;
            this.currentCountGroupsSelected = 0;
            this.currentCredential = null;
            this.additionalCredential = null;
            this.currentCountCompliance = 0;
            this.currentComplianceIds = null;
            this.currentJobScanType = null;
            this.currentCredentialTypes = new CredentialTypes();
            this.currentReportTemplatesSelected = 0;
            this.currentIsScheduler = false;
            this.currentPingType = 'Agent';
            this.currentJobAgentType = JOB_AGENT_TYPE_Agent;
            this.runAfterCreation = true;
        }
    };
};

function isFixation(jobScanType, credentialType) {
    if (jobScanType === SCAN_TYPE_Fixation && (credentialType === CREDENTIAL_TYPE_Windows || credentialType === CREDENTIAL_TYPE_Ssh))
        return true;
    else return false;
}

function isCiscoFixation(jobScanType, credentialType) {
    if (jobScanType === SCAN_TYPE_Fixation && credentialType === CREDENTIAL_TYPE_Cisco)
        return true;
    else return false;
}

function isNmap(jobScanType) {
    if (jobScanType === SCAN_TYPE_Nmap)
        return true;
    else return false;
}

function isHostDiscovery(jobScanType) {
    if (jobScanType === SCAN_TYPE_HostDiscovery)
        return true;
    else return false;
}

function CredentialParams(credentialParams, credentialCiscoOsType) {

    this.getCredentialParams = function () {
        return credentialParams;
    };

    this.getCredentialCiscoOsType = function () {
        return credentialCiscoOsType;
    };
}

function ScanProfileParams(jobScanType, credentialTypes) {
    this.getJobScanType = function () {
        return jobScanType;
    };

    this.getCredentialTypes = function () {
        return credentialTypes.map(t => t.subType ? t.type + '-' + t.subType : t.type).join(',');
    };
}

function ComplianceParams(jobScanType, credentialTypes) {
    this.getJobScanType = function () {
        return jobScanType;
    };

    this.getCredentialTypes = function () {
        return credentialTypes.map(t => t.subType ? t.type + '-' + t.subType : t.type).join(',');
    };
}

function InventoryParams(jobScanType, familyTypes) {
    this.getJobScanType = function () {
        return jobScanType;
    };

    this.getFamilyTypes = function () {
        return familyTypes.map(t => t.subType ? t.type + '-' + t.subType : t.type).join(',');
    };
}

function ReportTemplateParams(jobType) {
    this.getJobType = function () {
        return jobType;
    };
}

function getActiveTab() {
    return $('.tablinks.active')[0];
}

function selectedJobScanType_OnSelectedIndexChanged(element) {
    currentJobProperties = new JobProperties();
    currentJobProperties.init();
    currentJobProperties.currentIsScheduler = isScheduledStartType();
    document.getElementById('useExtendIdentificationBlock').classList.remove('hide');
    document.getElementById('failedHostsRetryBlock').classList.remove('hide');
    setSaveExtendedLogBlock(element.value);

    //JobScanType_Vulnerability
    if (element.value === SCAN_TYPE_Vulnerability) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Vulnerability;
        resetAllTabs();
    }
    //JobScanType_Patch
    if (element.value === SCAN_TYPE_Patch) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Patch;
        resetAllTabs();
    }
    //JobScanType_Compliance
    if (element.value === SCAN_TYPE_Compliance) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Compliance;
        resetAllTabs();
    }
    //JobScanType_Inventory
    if (element.value === SCAN_TYPE_Inventory) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Inventory;
        resetAllTabs();
    }
    //JobScanType_Fixation
    if (element.value === SCAN_TYPE_Fixation) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Fixation;
        resetAllTabs();
    }
    //JobScanType_Nmap
    if (element.value === SCAN_TYPE_Nmap) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Nmap;
        resetAllTabs();
        document.getElementById('failedHostsRetryBlock').classList.add('hide');
        document.getElementById('enableFailedHostsRetry').checked = false;
    }
    //JobScanType_HostDiscovery
    if (element.value === SCAN_TYPE_HostDiscovery) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_HostDiscovery;
        resetAllTabs();
        document.getElementById('useExtendIdentificationBlock').classList.add('hide');
        document.getElementById('Params_UseExtendIdentification').checked = false;

        document.getElementById('failedHostsRetryBlock').classList.add('hide');
        document.getElementById('enableFailedHostsRetry').checked = false;
    }
    // JobScanType_Scada
    if (element.value === SCAN_TYPE_Scada) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Scada;
        resetAllTabs();
        document.getElementById('failedHostsRetryBlock').classList.add('hide');
        document.getElementById('enableFailedHostsRetry').checked = false;
    }
    // JobScanType_Ping
    if (element.value === SCAN_TYPE_Ping) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Ping;
        resetAllTabs();
        document.getElementById('useExtendIdentificationBlock').classList.add('hide');
        document.getElementById('Params_UseExtendIdentification').checked = false;

        document.getElementById('failedHostsRetryBlock').classList.add('hide');
        document.getElementById('enableFailedHostsRetry').checked = false;
    }
    // JobScanType_DockerVulnerabilities
    if (element.value === SCAN_TYPE_Docker_Vulnerabilities) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Docker_Vulnerabilities;
        resetAllTabs();
    }
    //JobScanType_Yara
    if (element.value === SCAN_TYPE_Yara) {
        currentJobProperties.currentJobScanType = SCAN_TYPE_Yara;
        resetAllTabs();
    }

    isCanUsePortScan(currentJobProperties.currentJobScanType);
    onIsNotifyByEmailChanged();
    canCreateJob();
    isCanUseScada(currentJobProperties.currentJobScanType);
    isCanUseYara(currentJobProperties.currentJobScanType);
    isCanNextForMainTab();
    isCanTimeoutPerObject(currentJobProperties.currentJobScanType);
}

function canCreateJob() {
    isCanCreateJob = true;
    canCreateDockerVulnerabilityJob();
}

function canCreateDockerVulnerabilityJob() {
    if (currentJobProperties.currentJobScanType == SCAN_TYPE_Docker_Vulnerabilities) {
        let dockerVersion = checkContentForDocker().responseText;
        if (!dockerVersion || dockerVersion == '"0.0.0.0"') {
            document.getElementById('noContentForDockerVulnerability').classList.remove('hide');
            isCanCreateJob = false;
        }
        else
            document.getElementById('noContentForDockerVulnerability').classList.add('hide');
    }
    else
        document.getElementById('noContentForDockerVulnerability').classList.add('hide');

    isCanNextForMainTab();
}

function selectedJobStartType_OnSelectedIndexChanged(element) {
    if (element.selectedIndex === 0) {
        document.getElementById('Params_RunAfterCreation').checked = currentJobProperties.runAfterCreation;
        document.getElementById('schedulerType').classList.remove('disableContent');
        currentJobProperties.currentIsScheduler = false;
    }
    if (element.selectedIndex === 1) {
        document.getElementById('Params_RunAfterCreation').checked = false;
        document.getElementById('schedulerType').classList.add('disableContent');
        currentJobProperties.currentIsScheduler = true;
    }
}

function resetAllTabs() {
    hideInstallType();
    hideAllTabs();
}

function hideInstallType() {
    var elem = document.getElementById('installType');
    elem.classList.add('hide');
}

function resetSaveExtendedLogValues() {
    document.getElementById('Params_SaveResultXml').checked = false;
    document.getElementById('Params_SaveSystemCharacteristicXml').checked = false;
    document.getElementById('Params_SaveNotTrueOvalResults').checked = false;
    document.getElementById('Params_SaveXccdfCollectedItems').checked = false;
    document.getElementById('Params_SaveXccdfNotTrueCollectedItems').checked = false;
}

function setSaveExtendedLogBlock(jobScanType) {
    hideSaveExtendedLogBlock();
    if (jobScanType === SCAN_TYPE_Inventory) {
        showSaveExtendedLogBlockForInventory();
    }
    if (jobScanType === SCAN_TYPE_Scada) {
        showSaveExtendedLogBlockForScada();
    }
    if (jobScanType === SCAN_TYPE_Patch || jobScanType === SCAN_TYPE_Vulnerability || jobScanType === SCAN_TYPE_Docker_Vulnerabilities) {
        showSaveExtendedLogBlockForOvalAudit();
    }
    if (jobScanType === SCAN_TYPE_Compliance) {
        showSaveExtendedLogBlockForCompliance();
    }
    if (jobScanType === SCAN_TYPE_HostDiscovery || jobScanType === SCAN_TYPE_Nmap) {
        showSaveExtendedLogBlockPentestAndHostDiscovery();
    }
}

function hideSaveExtendedLogBlock() {
    document.getElementById('saveExtendedLogBlock').classList.add('hide');

    document.getElementById('saveResultXmlBlock').classList.add('hide');
    document.getElementById('saveSystemCharacteristicXmlBlock').classList.add('hide');
    document.getElementById('saveNotTrueOvalResultsBlock').classList.add('hide');
    document.getElementById('saveExtendedLogBlockForPentestAndHostDiscovery').classList.add('hide');

    document.getElementById('saveXccdfCollectedItemsBlock').classList.add('hide');
    document.getElementById('saveXccdfNotTrueCollectedItemsBlock').classList.add('hide');

    resetSaveExtendedLogValues();
}

function showSaveExtendedLogBlockPentestAndHostDiscovery() {

    document.getElementById('saveExtendedLogBlockForPentestAndHostDiscovery').classList.remove('hide');
    resetSaveExtendedLogValues();
}


function showSaveExtendedLogBlockForOvalAudit() {
    document.getElementById('saveExtendedLogBlock').classList.remove('hide');

    document.getElementById('saveResultXmlBlock').classList.remove('hide');
    document.getElementById('saveSystemCharacteristicXmlBlock').classList.remove('hide');
    document.getElementById('saveNotTrueOvalResultsBlock').classList.remove('hide');

    resetSaveExtendedLogValues();
}

function showSaveExtendedLogBlockForScada() {
    document.getElementById('saveExtendedLogBlock').classList.remove('hide');

    document.getElementById('saveResultXmlBlock').classList.remove('hide');
    document.getElementById('saveSystemCharacteristicXmlBlock').classList.add('hide');
    document.getElementById('saveNotTrueOvalResultsBlock').classList.add('hide');

    resetSaveExtendedLogValues();
}

function showSaveExtendedLogBlockForInventory() {
    document.getElementById('saveExtendedLogBlock').classList.remove('hide');

    document.getElementById('saveResultXmlBlock').classList.remove('hide');
    document.getElementById('saveSystemCharacteristicXmlBlock').classList.add('hide');
    document.getElementById('saveNotTrueOvalResultsBlock').classList.add('hide');

    resetSaveExtendedLogValues();
}

function showSaveExtendedLogBlockForCompliance() {
    document.getElementById('saveExtendedLogBlock').classList.remove('hide');

    document.getElementById('saveResultXmlBlock').classList.remove('hide');
    document.getElementById('saveSystemCharacteristicXmlBlock').classList.remove('hide');
    document.getElementById('saveXccdfCollectedItemsBlock').classList.remove('hide');
    document.getElementById('saveXccdfNotTrueCollectedItemsBlock').classList.remove('hide');

    resetSaveExtendedLogValues();
}

function viewInstallType() {
    var elem = document.getElementById('installType');
    elem.classList.remove('hide');
}

function isScheduledStartType() {
    let startTypeSelectElement = document.getElementById('Params_SelectedJobStartType');
    return startTypeSelectElement.value === "Scheduled";
}

function hideAllTabs() {
    hideHostsAndGroupTab();
    hideCredentialsTab();

    hideScanProfilesTab();
    hideComplianceTab();
    hideXccdfProfileTab();
    hideSummaryTab();
    hideSchedulerTab();
    hideFileFixationTab();
    hideRegFixationTab();
    hideCiscoFixationTab();
    hideNmapTab();
    hideHostDiscoveryTab();
    hideBruteforceTab();
    hideScadaModulesTab();
    hideReportTab();
    hideInventoryTab();
    hidePingTab();
    hideYaraTab();
}

function hideReportTab() {
    if (document.getElementById('TabReport') !== null) {
        $('#Report').html(null);
        $('#TabReport').remove();
    }
}

function hideScadaModulesTab() {
    if (document.getElementById('TabScadaModules') !== null) {
        $('#ScadaModules').html(null);
        $('#TabScadaModules').remove();
    }
}

function hideBruteforceTab() {
    if (document.getElementById('TabBruteforce') !== null) {
        $('#Bruteforce').html(null);
        $('#TabBruteforce').remove();
    }
}

function hideNmapTab() {
    if (document.getElementById('TabNmap') !== null) {
        $('#Nmap').html(null);
        $('#TabNmap').remove();
    }
}

function hideHostDiscoveryTab() {
    if (document.getElementById('TabHostDiscovery') !== null) {
        $('#HostDiscovery').html(null);
        $('#TabHostDiscovery').remove();
    }
}

function hideCiscoFixationTab() {
    if (document.getElementById('TabCiscoFixation') !== null) {
        $('#CiscoFixation').html(null);
        $('#TabCiscoFixation').remove();
    }
}

function hideRegFixationTab() {
    if (document.getElementById('TabRegFixation') !== null) {
        $('#RegFixation').html(null);
        $('#TabRegFixation').remove();
    }
}

function hideFileFixationTab() {
    if (document.getElementById('TabFileFixation') !== null) {
        $('#FileFixation').html(null);
        $('#TabFileFixation').remove();
    }
}

function hideSchedulerTab() {
    if (document.getElementById('TabScheduler') !== null) {
        $('#Scheduler').html(null);
        $('#TabScheduler').remove();
    }
}

function hideXccdfProfileTab() {
    if (document.getElementById('TabXccdfProfile') !== null) {
        $('#XccdfProfile').html(null);
        $('#TabXccdfProfile').remove();
    }
}

function hideCredentialsTab() {
    if (document.getElementById('TabCredentials') !== null) {
        $('#Credentials').html(null);
        $('#TabCredentials').remove();
    }
}

function hideHostsAndGroupTab() {
    if (document.getElementById('TabHostsAndGroup') !== null) {
        updateCountOfHosts(0);
        updateCountOfGroups(0);
        SelectedHostsGridController.cpData = [];
        SelectedGroupsGridController.cpData = [];
        $('#HostsAndGroup').html(null);
        $('#TabHostsAndGroup').remove();
    }
}

function hideScanProfilesTab() {
    if (document.getElementById('TabScanProfiles') !== null) {
        $('#ScanProfile').html(null);
        $('#TabScanProfiles').remove();
    }
}

function hideComplianceTab() {
    if (document.getElementById('TabCompliance') !== null) {
        $('#Compliance').html(null);
        $('#TabCompliance').remove();

        currentJobProperties.selectedCompliances = undefined;
        currentJobProperties.currentCountCompliance = 0;
    }
}

function hideInventoryTab() {
    if (document.getElementById('TabInventory') !== null) {
        $('#Inventory').html(null);
        $('#TabInventory').remove();
    }
}

function hidePingTab() {
    if (document.getElementById('TabPing') !== null) {
        $('#Ping').html(null);
        $('#TabPing').remove();
    }
}

function hideYaraTab() {
    if (document.getElementById('TabYara') !== null) {
        $('#Yara').html(null);
        $('#TabYara').remove();
    }
}

function hideReportTab() {
    if (document.getElementById('TabReport') !== null) {
        $('#Report').html(null);
        $('#TabReport').remove();
    }
}

function hideSchedulerTab() {
    if (document.getElementById('TabScheduler') !== null) {
        $('#Scheduler').html(null);
        $('#TabScheduler').remove();
    }
}

function hideSummaryTab() {
    if (document.getElementById('TabSummary') !== null) {
        $('#Summary').html(null);
        $('#TabSummary').remove();
        $('#submitSaveJob').addClass('hide');
    }
}

function createTabHostsAndGroups() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabHostsAndGroup;
    newTab.id = "TabHostsAndGroup";
    newTab.name = "HostsAndGroup";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('HostsAndGroup'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabScanProfile(params) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabScanProfiles;
    newTab.id = "TabScanProfiles";
    newTab.name = "ScanProfile";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('ScanProfile', params); };

    $('.tablinks:last-child').after(newTab);
}

function createTabCompliance(params) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabCompliance;
    newTab.id = "TabCompliance";
    newTab.name = "Compliance";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Compliance', params); };

    $('.tablinks:last-child').after(newTab);
}

function createTabCredentials(params) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabCredentials;
    newTab.id = "TabCredentials";
    newTab.name = "Credentials";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Credentials', params); };

    $('.tablinks:last-child').after(newTab);
}

function createTabXccdfProfile(params) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabXccdfProfile;
    newTab.id = "TabXccdfProfile";
    newTab.name = "XccdfProfile";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('XccdfProfile', params); };

    $('.tablinks:last-child').after(newTab);
}

function createTabScheduler() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabScheduler;
    newTab.id = "TabScheduler";
    newTab.name = "Scheduler";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Scheduler'); };

    var reportsTab = $('#TabReport');
    if (reportsTab.length === 0)
        $('.tablinks:last-child').after(newTab);
    else
        reportsTab.before(newTab);
}

function createTabPing() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabPing;
    newTab.id = "TabPing";
    newTab.name = "Ping";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Ping'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabFileFixation(params) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabFileFixation;
    newTab.id = "TabFileFixation";
    newTab.name = "FileFixation";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('FileFixation', params); };

    $('.tablinks:last-child').after(newTab);
}

function createTabRegFixation() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabRegFixation;
    newTab.id = "TabRegFixation";
    newTab.name = "RegFixation";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('RegFixation'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabCiscoFixation() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabCiscoFixation;
    newTab.id = "TabCiscoFixation";
    newTab.name = "CiscoFixation";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('CiscoFixation'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabNmap() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabNmap;
    newTab.id = "TabNmap";
    newTab.name = "Nmap";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Nmap'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabHostDiscovery() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabHostDiscovery;
    newTab.id = "TabHostDiscovery";
    newTab.name = "HostDiscovery";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('HostDiscovery'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabBruteforce() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabBruteforce;
    newTab.id = "TabBruteforce";
    newTab.name = "Bruteforce";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Bruteforce'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabInventory(param) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabInventory;
    newTab.id = "TabInventory";
    newTab.name = "Inventory";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Inventory', param); };

    $('.tablinks:last-child').after(newTab);
}

function createTabScadaModules() {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabScadaModules;
    newTab.id = "TabScadaModules";
    newTab.name = "ScadaModules";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('ScadaModules'); };

    $('.tablinks:last-child').after(newTab);
}

function createTabYara(params) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabYara;
    newTab.id = "TabYara";
    newTab.name = "Yara";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Yara', params); };

    $('.tablinks:last-child').after(newTab);
}

function createTabReport(param) {
    var newTab = document.createElement("button");
    newTab.innerText = jobMasterTabName.TabReport;
    newTab.id = "TabReport";
    newTab.name = "Report";
    newTab.classList.add("tablinks");
    newTab.onclick = function () { openTab('Report', param); };

    $('.tablinks:last-child').after(newTab);
}

function createTabSummary() {
    if (document.getElementById('TabSummary') === null) {
        var newTab = document.createElement("button");
        newTab.innerText = jobMasterTabName.TabSummary;
        newTab.id = "TabSummary";
        newTab.name = "Summary";
        newTab.classList.add("tablinks");
        newTab.onclick = function () { openTab('Summary'); };

        $('.tablinks:last-child').after(newTab);

        newTab.click();
    }
    else {
        $('#Summary').html(null);
        $('#TabSummary').click();
    }

    $('#submitSaveJob').removeClass('hide');
    document.getElementById('preloader').classList.remove('hide');
    $('#Summary').append('<div id="summaryContent"></div>');
}

function openTab(tabName, params) {
    var i, tabcontent, tablinks;

    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        if (tabcontent[i].id !== tabName)
            tabcontent[i].classList.add("hide");
        else {
            $('#' + tabName).removeClass('hide');

            $('#cmdPrevious').removeClass('hide');
            $('#cmdNext').removeClass('hide');

            $('#submitSaveJob').addClass('hide');

            if (tabName === 'HostsAndGroup')
                hostTabInit();
            if (tabName === 'Scheduler')
                schedulerTabInit();
            if (tabName === 'FileFixation')
                fileFixationTabInit(params.currentCredentialTypes.getByIndex(0).type, params.currentJobAgentType);
            if (tabName === 'RegFixation')
                regFixationTabInit();
            if (tabName === 'CiscoFixation')
                ciscoFixationTabInit();
            if (tabName === 'Credentials')
                credentialsTabInit(params);
            if (tabName === 'ScanProfile')
                scanProfileTabInit(params);
            if (tabName === 'Nmap')
                nmapTabInit();
            if (tabName === 'HostDiscovery')
                hostDiscoveryTabInit();
            if (tabName === 'Bruteforce')
                bruteforceTabInit();
            if (tabName === 'Settings') {
                const isInit = typeof currentJobProperties === 'undefined';

                $('#cmdPrevious').addClass('hide');
                if (document.querySelector("select[id='Params_SelectedJobScanType'][name='Params.SelectedJobScanType']") !== null) {
                    currentJobProperties = new JobProperties(typeof currentJobProperties !== 'undefined' ? currentJobProperties : null);
                    currentJobProperties.init();
                    currentJobProperties.currentJobScanType = document.querySelector("select[id='Params_SelectedJobScanType'][name='Params.SelectedJobScanType']").value;
                    isCanUsePortScan(currentJobProperties.currentJobScanType);
                    isCanUseScada(currentJobProperties.currentJobScanType);
                    isCanUseYara(currentJobProperties.currentJobScanType);
                    isCanUseExtendIdentification(currentJobProperties.currentJobScanType);
                    isCanUseFailedHostsRetry(currentJobProperties.currentJobScanType);
                    isCanTimeoutPerObject(currentJobProperties.currentJobScanType);

                    if (isInit) {
                        setSaveExtendedLogBlock(currentJobProperties.currentJobScanType);
                    }
                    canCreateJob();
                }
                if (document.getElementById('Params_SelectedJobStartType') !== null) {
                    selectedJobStartType_OnSelectedIndexChanged(document.getElementById('Params_SelectedJobStartType'));
                }
            }
            if (tabName === 'Summary') {
                initSummaryTab();
                $('#submitCreateSummary').click();
            }
            if (tabName === 'Inventory')
                initTabInventory(params);
            if (tabName === 'Compliance')
                initTabCompliance(params);
            if (tabName === 'XccdfProfile')
                initTabXccdfProfile(params);
            if (tabName === 'Report')
                initTabReport(params);
            if (tabName === 'ScadaModules')
                initTabScadaModules(params);
            if (tabName === 'Ping')
                initTabPing();
            if (tabName === 'Yara')
                initTabYara();
        }
    }

    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        if (tablinks[i].name !== tabName)
            tablinks[i].classList.remove('active');
        else tablinks[i].classList.add('active');
    }
}

function isCanUsePortScan(scanType) {
    if (scanType === SCAN_TYPE_Nmap || scanType === SCAN_TYPE_HostDiscovery) {
        var flag = document.getElementById('Params_IsUseNMap').value;
        if (flag === 'False') {
            document.getElementById('nmapNotUse').classList.remove('hide');
            isCanNextFromNmap = false;
        }
        else {
            document.getElementById('nmapNotUse').classList.add('hide');
            isCanNextFromNmap = true;
        }
    }
    else {
        document.getElementById('nmapNotUse').classList.add('hide');
        isCanNextFromNmap = true;
    }

    isCanNextForMainTab();
}

function isCanUseYara(scanType) {
    if (scanType === SCAN_TYPE_Yara) {
        var flag = document.getElementById('Params_IsUseYara').value;
        if (flag === 'False') {
            document.getElementById('yaraNotUse').classList.remove('hide')
            isCanUseFromYara = false;
        }
        else {
            document.getElementById('yaraNotUse').classList.add('hide')
            isCanUseFromYara = true;
        }
    }
    else {
        document.getElementById('yaraNotUse').classList.add('hide');
        isCanUseFromYara = true;
    }

    isCanNextForMainTab();
}

function isCanUseScada(scanType) {
    if (scanType === SCAN_TYPE_Scada) {
        var flag = document.getElementById('Params_IsUseScada').value;
        if (flag === 'False') {
            document.getElementById('scadaNotUse').classList.remove('hide')
            isCanUseFromScada = false;
        }
        else {
            document.getElementById('scadaNotUse').classList.add('hide')
            isCanUseFromScada = true;
        }
    }
    else {
        document.getElementById('scadaNotUse').classList.add('hide');
        isCanUseFromScada = true;
    }

    isCanNextForMainTab();
}

function isCanUseExtendIdentification(scanType) {
    if (scanType === SCAN_TYPE_Ping || scanType === SCAN_TYPE_HostDiscovery) {
        document.getElementById('useExtendIdentificationBlock').classList.add('hide');
    }
    else {
        document.getElementById('useExtendIdentificationBlock').classList.remove('hide');
    }
}

function isCanUseFailedHostsRetry(scanType) {
    if (scanType === SCAN_TYPE_Nmap || scanType === SCAN_TYPE_HostDiscovery || scanType === SCAN_TYPE_Scada || scanType === SCAN_TYPE_Ping) {
        document.getElementById('failedHostsRetryBlock').classList.add('hide');
    }
    else {
        document.getElementById('failedHostsRetryBlock').classList.remove('hide');
    }
}

function isCanTimeoutPerObject(scanType) {
    if (scanType === SCAN_TYPE_Vulnerability || scanType === SCAN_TYPE_Compliance || scanType === SCAN_TYPE_Patch
        || scanType === SCAN_TYPE_Docker_Vulnerabilities) {
        document.getElementById('timeoutPerObjectBlock').classList.remove('hide');
    } else {
        document.getElementById('timeoutPerObjectBlock').classList.add('hide');
    }
}

function hostTabInit() {
    if ($('#HostsAndGroup').children().length === 0) {
        loadHostsAndGroups();
    }
}

function credentialsTabInit(params) {
    if ($('#Credentials').children().length === 0) {
        loadCredentials(params);
    }
}

function scanProfileTabInit(params) {
    if ($('#ScanProfile').children().length === 0) {
        loadScanProfile(params);
    }
}

function nmapTabInit() {
    if ($('#Nmap').children().length === 0) {
        loadNmap();
    }
}

function hostDiscoveryTabInit() {
    if ($('#HostDiscovery').children().length === 0) {
        loadHostDiscovery();
    }
}

function bruteforceTabInit() {
    if ($('#Bruteforce').children().length === 0) {
        loadBruteforce();
    }
}

function initTabXccdfProfile(params) {
    params = CreateJobsComplianceController.getSelectedIds();

    if ($('#XccdfProfile').children().length === 0) {
        loadXccdfProfile(params);
    }
}

function schedulerTabInit() {
    if ($('#Scheduler').children().length === 0) {
        loadScheduler();
    }
}

function fileFixationTabInit(credentialFamilyType, jobAgentType) {
    if ($('#FileFixation').children().length === 0) {
        loadFileFixation(credentialFamilyType, jobAgentType);
    }
}

function regFixationTabInit() {
    if ($('#RegFixation').children().length === 0) {
        loadRegFixation();
    }
}

function ciscoFixationTabInit() {
    if ($('#CiscoFixation').children().length === 0) {
        loadCiscoFixation();
    }
}

function initSummaryTab() {
    $('#cmdNext').addClass('hide');
    $('#submitSaveJob').removeClass('hide');
}

function initTabCompliance(params) {
    $('#Compliance').trigger('visible');
    if ($('#Compliance').children().length === 0) {
        loadCompliance(params);
    }
}

function initTabInventory(params) {
    if ($('#Inventory').children().length === 0) {
        loadInventory(params);
    }
}

function initTabReport(params) {
    if ($('#ReportSettings').length === 0) {
        loadReportTemplates(params);
    }
}

function initTabScadaModules(params) {
    if ($('#ScadaModules').children().length === 0) {
        loadScadaModules(params);
    }
}

function initTabPing() {
    if ($('#Ping').children().length === 0) {
        loadPing();
    }
}

function initTabYara() {
    if ($('#Yara').children().length === 0) {
        loadYara();
    }
}

function setCurrentCredentialTypes(newCredentialTypes, jobScanType) {
    if (!currentJobProperties.currentCredentialTypes.isEqualTo(newCredentialTypes)) {
        currentJobProperties.currentCredentialTypes = newCredentialTypes;
        hideScanProfilesTab();
        hideComplianceTab();
        hideXccdfProfileTab();
        hideSummaryTab();
        hideSchedulerTab();
        hideFileFixationTab();
        hideRegFixationTab();
        hideCiscoFixationTab();
        hideNmapTab();
        hideHostDiscoveryTab();
        hideBruteforceTab();
        hideScadaModulesTab();
        hideReportTab();
        hideInventoryTab();
    }

    if (jobScanType === SCAN_TYPE_Ping)
        setJobAgentTypeByPingType();
}

function setJobAgentTypeByPingType() {
    switch (currentJobProperties.currentPingType) {
        case 'Agent':
            setJobAgentTypeVariable(JOB_AGENT_TYPE_Agent);
            break;
        case 'Winrm':
            setJobAgentTypeVariable(JOB_AGENT_TYPE_TempAgent);
            break;
        default:
            setJobAgentTypeVariable(JOB_AGENT_TYPE_Agentless);
            break;
    }
}

function setAgentless() {
    $('#agentlessBlock').removeClass('disableContent');
    $('[id*=JobAgentType][value="Agentless"]').prop('checked', 'checked');
    $('#radiobBlockCredentialsJM').addClass('disableContent');
    setJobAgentTypeVariable(JOB_AGENT_TYPE_Agentless);
}

function manualRadioClick() {
    $('#scanTypeRadio').addClass('disableContent');
    $('.scanProfilePanel').removeClass('disableContent');
    $('[id*=ScanType][value="Fill"]').prop('checked', 'checked');

    ScanProfileStripClick();
}

function ScanProfileStripClick() {

    var checkedArray = $('input[id*="ScanProfile_Strips_"]:checked')

    var jarExist = false;
    for (var i = 0; i < checkedArray.length; i++) {
        if (document.getElementById(checkedArray[i].id.replace("IsSelected", "ContainsJar")).value === 'True')
            jarExist = true;
    }

    if (jarExist) {
        document.querySelector('#jarCatalogs').classList.remove('hidden');
    }
    else {
        document.querySelector('#jarCatalogs').classList.add('hidden');
    }
}

function ScanSpeedTypeClick() {
    const scanSpeedType = document.querySelector("input[name='ScanProfile.ScanSpeedType']:checked").value;

    if (scanSpeedType === 'FullWithJar')
        document.querySelector('#jarCatalogs').classList.remove('hidden');
    else
        document.querySelector('#jarCatalogs').classList.add('hidden');
}

function autoRadioClick() {
    $('#scanTypeRadio').removeClass('disableContent');
    $('.scanProfilePanel').addClass('disableContent');
    $('#scanProfileValid').addClass('hide');

    ScanSpeedTypeClick();
}

function toggleScadaModules(isChecked) {
    const checkboxes = document.querySelectorAll('input[type="checkbox"][id^="Scada_ScadaModules_"]');
    for (let i = 0; i < checkboxes.length; i++) {
        checkboxes[i].checked = isChecked;
    }
}

function jobMasterComplete() {
    document.getElementById('preloader').classList.add('hide');
}

async function jobMasterNext() {
    var activeTab = getActiveTab();
    var currentTab = new JobMasterTab(activeTab.id);

    // Async check for Nmap job
    //if (activeTab.id === "TabHostsAndGroup" && (currentJobProperties.currentJobScanType === SCAN_TYPE_Nmap || currentJobProperties.currentJobScanType === SCAN_TYPE_HostDiscovery)) {
    //    currentTab.isValidAsync();
    //    return;
    //}

    currentTab.isValid().then(function (result) {
        if (result === true)
            currentTab.getNextTab().open();
    });
}

function jobMasterPrevious() {
    var activeTab = $('.tablinks.active').text();

    var count = $('.tablinks').length;
    for (var i = 0; i < count; i++) {
        if (document.getElementsByClassName('tablinks')[i].innerText === activeTab) {
            document.getElementsByClassName('tablinks')[i].classList.remove('active');
            document.getElementsByClassName('tablinks')[i - 1].classList.add('active');
        }
    }
    document.querySelectorAll('.tablinks.active')[0].click();
}

function ifScanProfileValid() {
    if (document.getElementById('ScanProfile_ScanProfileExists') !== null) {
        if (document.querySelectorAll("input[type='radio'][name='ScanProfile.ScanProfileExists']:checked")[0].value === 'NoProfile')
            return true;
        if (document.querySelectorAll("input[type='radio'][name='ScanProfile.ScanProfileExists']:checked")[0].value === 'Manual') {
            if (document.querySelectorAll("input[type='checkbox'][name*='ScanProfile.Strips[']:checked").length === 0) {
                return false;
            }
        }
    }

    return true;
}

function ifJarSearchPathValid() {
    const regExWin = new RegExp(/^[a-zA-Z]:.+$/gmi);
    const regExLinux = new RegExp(/^\/.*$/igm);

    if (document.getElementById('ScanProfile_ScanProfileExists') != null) {

        var profileType =  document.querySelector('input[name="ScanProfile.ScanProfileExists"]:checked').value;
       

        const scanSpeedType = document.querySelector("input[name='ScanProfile.ScanSpeedType']:checked").value;
        

        var checkedArray = $('input[id*="ScanProfile_Strips_"]:checked')

        var jarExistInNixProfile = false;
        var jarExistInWinProfile = false;


        for (var i = 0; i < checkedArray.length; i++) {
            if (document.getElementById(checkedArray[i].id.replace("IsSelected", "ContainsJar")).value === 'True') {
                if (document.getElementById(checkedArray[i].id.replace("IsSelected", "Family")).value === 'unix')
                    jarExistInNixProfile = true;
                else if (document.getElementById(checkedArray[i].id.replace("IsSelected", "Family")).value === 'windows')
                    jarExistInWinProfile = true;
            }
                
        }

        if (scanSpeedType === 'FullWithJar' || jarExistInNixProfile || jarExistInWinProfile) {
            const jarSearchPathInputs = document.querySelectorAll("input[type='text'][name*='ScanProfile.JarSearchPaths[']");
            const jarSearchPathInputsLength = jarSearchPathInputs.length;

            if (jarSearchPathInputsLength === 0) {
                notifyWarning('Требуется задать пути поиска jar файлов для каждого типа учётной записи [Windows, Ssh]');
                return false;
            }

            let linuxPathExist = false;

            if ((profileType == 'NoProfile' && scanSpeedType === 'FullWithJar' || profileType == 'Manual' && jarExistInNixProfile) && currentJobProperties.currentCredentialTypes.map(x => x.type).indexOf('Ssh') >= 0) {
                for (let i = 0; i < jarSearchPathInputsLength; ++i) {

                    if (regExLinux.test(jarSearchPathInputs[i].value)) {
                        linuxPathExist = true;
                    }
                }

                if (linuxPathExist === false) {
                    notifyWarning('Не найдено ни одного пути поиска jar файлов для учётной записи "Ssh"');
                    return false;
                }
            }

            let windowsPathExist = false;

            if ((profileType == 'NoProfile' && scanSpeedType === 'FullWithJar' || profileType == 'Manual' && jarExistInWinProfile) && currentJobProperties.currentCredentialTypes.map(x => x.type).indexOf('Windows') >= 0) {
                for (let i = 0; i < jarSearchPathInputsLength; ++i) {
                    if (regExWin.test(jarSearchPathInputs[i].value)) {
                        windowsPathExist = true;
                    }
                }

                if (windowsPathExist === false) {
                    notifyWarning('Не найдено ни одного пути поиска jar файлов для учётной записи "Windows"');
                    return false;
                }
            }
        }

        return true;
    }
}

    function selectAllInventoryJM() {
        if (typeof inventoryTreeView === "undefined")
            return;

        inventoryTreeView.getTopNodes()
            .forEach(function (node) {
                node.setChecked(true);
            });
    }

    function unSelectAllInventoryJM() {
        if (typeof inventoryTreeView === "undefined")
            return;

        inventoryTreeView.getTopNodes()
            .forEach(function (node) {
                node.setChecked(false);
            });
    }

    function changeCountCompliance() {
        currentJobProperties.currentCountCompliance = CreateJobsComplianceController.getSelectedIds().length;
        hideXccdfProfileTab();
        hideSchedulerTab();
        hideReportTab();
        hideSummaryTab();
    }

    function updateCountOfGroups(count) {
        currentJobProperties.currentCountGroupsSelected = count;
    }

    function updateCountOfHosts(count) {
        currentJobProperties.currentCountHostsSelected = count;
    }

    function FillInventoryTreeView() {
        var version = 0;
        if (document.getElementById('Inventory_Version') !== null)
            version = document.getElementById('Inventory_Version').value;

        var result = '<inventory_profiles is_leaf="false" version="' + version + '">';
        const nodes = inventoryTreeView.getTopNodes();
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].getCheckState() === 'Checked' || nodes[i].getCheckState() === 'Indeterminate') {
                const name = nodes[i].getName();
                result += '<' + name + getLeafValue(nodes[i]) + '>'
                    + recursiveInventory(nodes[i])
                    + '</' + name + '>';
            }
        }
        result += '</inventory_profiles>';

        var xml = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'Inventory.InventoryProfileXml').attr('id', 'Inventory_InventoryProfileXml').val(result);
        $('#Inventory').append(xml);
    }

    function recursiveInventory(node) {
        const nodes = inventoryTreeView.getNodesByParent(node);
        var result = '';

        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].getCheckState() === 'Checked' || nodes[i].getCheckState() === 'Indeterminate') {
                const name = nodes[i].getName();
                result += '<' + name + getLeafValue(nodes[i]);

                if (nodes[i]._isParent) {
                    result += '>' + recursiveInventory(nodes[i]) + '</' + name + '>';
                }
                else result += '/>';
            }
        }

        return result;
    }

    function getLeafValue(node) {
        var leaf = '';
        if (node.getCheckState() === 'Indeterminate')
            leaf = ' is_leaf="false"';
        if (node.getCheckState() === 'Checked')
            leaf = ' is_leaf="true"';
        return leaf;
    }

    function loadFileFixationCsvFile(e) {
        let input = document.getElementById('fileFixationCsvInput');
        let file = input.files[0];
        input.value = '';

        if (file.size > 512000) { // 500 KB max
            notifyInfo("Превышен допустимый размер файла. Максимальный размер - 500 КБ");
            return;
        }

        const reader = new FileReader();
        reader.readAsText(file);

        reader.onload = function (e) {
            parseFileFixationCsv(e.target.result);
        };

        reader.onerror = function () {
            notifyInfo("Не удалось загрузить список путей для фиксации из файла");
        };
    }

    function loadJarSearchPathesCsvFile(e) {
        let input = document.getElementById('jarSearchPathesCsvInput');
        let file = input.files[0];
        input.value = '';

        if (file.size > 512000) { // 500 KB max
            notifyInfo("Превышен допустимый размер файла. Максимальный размер - 500 КБ");
            return;
        }

        const reader = new FileReader();
        reader.readAsText(file);

        reader.onload = function (e) {
            parseJarSearchPathesCsv(e.target.result);
        };

        reader.onerror = function () {
            notifyInfo("Не удалось загрузить список путей для поиска jar файлов из файла");
        };
    }

    function loadYaraScanPathsCsvFile(e) {
        let input = document.getElementById('fileYaraScanPathsCsvInput');
        let file = input.files[0];
        input.value = '';
    
        if (file.size > 512000) { // 500 KB max
            notifyInfo("Превышен допустимый размер файла. Максимальный размер - 500 КБ");
            return;
        }
    
        const reader = new FileReader();
        reader.readAsText(file);
    
        reader.onload = function (e) {
            parseFileYaraCsv(e.target.result);
        };
    
        reader.onerror = function () {
            notifyInfo("Не удалось загрузить список путей для сканирования YARA из файла");
        };
    }

    function loadRegFixationCsvFile(e) {
        let input = document.getElementById('regFixationCsvInput');
        let file = input.files[0];
        input.value = '';

        if (file.size > 512000) { // 500 KB max
            notifyInfo("Превышен допустимый размер файла. Максимальный размер - 500 КБ");
            return;
        }

        const reader = new FileReader();
        reader.readAsText(file);

        reader.onload = function (e) {
            parseRegFixationCsv(e.target.result);
        };

        reader.onerror = function () {
            notifyInfo("Не удалось загрузить список ключей для фиксации из файла");
        };
    }

    function parseFileFixationCsv(csvText) {
        const csvTextLines = csvText.split(/\r\n|\n/);
        const headers = csvTextLines[0].split(',');

        for (let i = 1; i < csvTextLines.length; i++) {
            let data = csvTextLines[i].split(',');
            let path = data[0];
            let fileName = data[1];
            let includeSubs = data.length >= 3 ? (data[2] === '#' ? 'true' : 'false') : 'false';
            let isExclusion = data.length >= 4 ? (data[3] === '!' ? 'true' : 'false') : 'false';

            addFixationFilePath(path, fileName, includeSubs, isExclusion, false)
        }
    }

    function parseJarSearchPathesCsv(csvText) {
        const csvTextLines = csvText.split(/\r\n|\n/);
        const headers = csvTextLines[0].split(',');

        const table = $('#jarCatalogsGrid').DataTable();

        for (let i = 0; i < csvTextLines.length; i++) {
            let data = csvTextLines[i].split(',');
            let path = data[0];

            if (checkJobPath(path, table, false)) {
                table.row.add({ 0: path }).draw();
            }
        }
    }

    function parseFileYaraCsv(csvText) {
        const csvTextLines = csvText.split(/\r\n|\n/);
    
        for (let i = 0; i < csvTextLines.length; i++) {
            addYaraScanPath(csvTextLines[i], false)
        }
    }

    function parseRegFixationCsv(csvText, addFunctionName) {
        const csvTextLines = csvText.split(/\r\n|\n/);
        const headers = csvTextLines[0].split(',');

        for (let i = 1; i < csvTextLines.length; i++) {
            let data = csvTextLines[i].split(',');
            let path = data[0];
            let includeSubs = data.length >= 2 ? (data[1] === '#' ? 'true' : 'false') : 'false';
            let isExclusion = data.length >= 3 ? (data[2] === '!' ? 'true' : 'false') : 'false';

            addFixationRegistryKey(path, includeSubs, isExclusion, false)
        }
    }

    function checkJobPath(path, table, notify = true) {
        const msgSpecifyCat = 'Укажите путь к каталогу';
        const msgExistingCat = 'Такой каталог уже добавлен';
        const msgIncorrectCat = 'Некорректный каталог для выбранной учётной записи';

        const regExWin = new RegExp(/^[a-zA-Z]:.+$/gmi);
        const regExLinux = new RegExp(/^\/.*$/igm);

        if (path === null || path.trim() === '') {
            if (notify) {
                notifyWarning(msgSpecifyCat);
            }
            return false;
        }

        if (currentJobProperties.currentCredentialTypes.values.length == 1) {
            if (currentJobProperties.currentCredentialTypes.getByIndex(0).type === CREDENTIAL_TYPE_Windows) {
                if (!regExWin.test(path)) {
                    if (notify) {
                        notifyWarning(msgIncorrectCat);
                    }
                    return false;
                }
            }
            if (currentJobProperties.currentCredentialTypes.getByIndex(0).type === CREDENTIAL_TYPE_Ssh) {
                if (!regExLinux.test(path)) {
                    if (notify) {
                        notifyWarning(msgIncorrectCat);
                    }
                    return false;
                }
            }
        }
        else {
            if (!regExLinux.test(path) && !regExWin.test(path)) {
                if (notify) {
                    notifyWarning(msgIncorrectCat);
                }
                return false;
            }
        }

        const rows = Array.from(table.rows().data().flatten().map(x => x[0]));

        const index = rows.findIndex(row => {return row === path;});

        if (index >= 0) {
            if (notify) {
                notifyWarning(msgExistingCat);
            }
            return false;
        }

        return true;
    }

    function checkFileFixationPath(path, fileName, table, notify = true) {
        const msgSpecifyCat = 'Укажите путь к каталогу';
        const msgExistingCat = 'Такой каталог уже добавлен';
        const msgIncorrectCat = 'Некорректный каталог';

        const regExWin = new RegExp(/^[a-zA-Z]:.+$/gmi);
        const regExLinux = new RegExp(/^\/.*$/igm);

        if (path === null || path.trim() === '') {
            if (notify) {
                notifyWarning(msgSpecifyCat);
            }
            return false;
        }

        if (currentJobProperties.currentCredentialTypes.getByIndex(0).type === CREDENTIAL_TYPE_Windows) {
            if (!regExWin.test(path)) {
                if (notify) {
                    notifyWarning(msgIncorrectCat);
                }
                return false;
            }
        }
        if (currentJobProperties.currentCredentialTypes.getByIndex(0).type === CREDENTIAL_TYPE_Ssh) {
            if (!regExLinux.test(path)) {
                if (notify) {
                    notifyWarning(msgIncorrectCat);
                }
                return false;
            }
        }

        const fullPath = path + fileName;
        const rows = Array.from(table.rows().data().flatten().map(x => ''.concat(x[0], x[1])));

        const index = rows.findIndex(row => {
            if (currentJobProperties.currentCredentialTypes.getByIndex(0).type === CREDENTIAL_TYPE_Windows) {
                return row.toLowerCase() === fullPath.toLowerCase();
            }
            return row === fullPath;
        });

        if (index >= 0) {
            if (notify) {
                notifyWarning(msgExistingCat);
            }
            return false;
        }

        return true;
    }

    function checkRegFixationPath(key, table, optionValues, notify = true) {
        const msgSpecifyCat = 'Укажите ключ';
        const msgExistingCat = 'Такой ключ уже добавлен';
        const msgIncorrectCat = 'Некорректный ключ';

        if (key === null || key.trim() === '') {
            if (notify) {
                notifyWarning(msgSpecifyCat);
            }
            return false;
        }

        if (!optionValues.some(substr => key.toUpperCase().startsWith(substr.toUpperCase()))) {
            if (notify) {
                notifyWarning(msgIncorrectCat);
            }
            return false;
        }

        const f = table.column(0).data().filter(function (value, index) {
            return value === key;
        });

        if (f.any()) {
            if (notify) {
                notifyWarning(msgExistingCat);
            }
            return false;
        }

        return true;
    }

    function addFixationFilePath(path, fileName, includeSubdirectories, isExclusion, notify = true) {
        const inputPath = document.getElementById("FileFixation_FilePathForInclusion");
        path = path == null ? inputPath.value : path;

        const inputFileName = document.getElementById("FileFixation_FileNameForInclusion");
        fileName = fileName == null ? inputFileName.value : fileName;

        const table = $('#FileFixation_Catalogs').DataTable();

        if (checkFileFixationPath(path, fileName, table, notify)) {
            table.row.add({ 0: path, 1: fileName, 2: includeSubdirectories == null ? 'false' : includeSubdirectories.toString(), 3: isExclusion == null ? 'false' : isExclusion.toString() }).draw();
            inputPath.value = null;
            inputFileName.value = null;
        }
    }

    function addJarFilePath(path, notify = true) {
        const inputPath = document.getElementById("JarFilePathForInclusion");
        path = path == null ? inputPath.value : path;


        const table = $('#jarCatalogsGrid').DataTable();

        if (checkJobPath(path, table, notify)) {
            table.row.add({ 0: path }).draw();
            inputPath.value = null;
        }
    }

    function addYaraScanPath(path, notify = true) {
        const inputPath = document.getElementById("Yara_PathForInclusion");
        path = path == null ? inputPath.value : path;
    
        const table = $('#Yara_Catalogs').DataTable();
        if (checkJobPath(path, table, notify)) {
            table.row.add({ 0: path }).draw();
            inputPath.value = null;
        }
    }

    function addFixationRegistryKey(key, includeSubkeys, isExclusion, notify = true) {
        const input = document.getElementById("RegFixation_IncRegKey");
        const selectBlock = document.getElementById("RegFixation_InclRegHive");
        const selectNode = selectBlock.options[selectBlock.selectedIndex].text;

        const dirValue = selectNode + '\\' + input.value;
        key = key == null ? dirValue : key;

        const table = $('#RegFixation_Keys').DataTable();

        if (checkRegFixationPath(key, table, [...selectBlock.options].map(o => o.text), notify)) {
            table.row.add({ 0: key, 1: includeSubkeys == null ? 'false' : includeSubkeys.toString(), 2: isExclusion == null ? 'false' : isExclusion.toString() }).draw();
            input.value = null;
        }
    }

    function createLi(ul, id, name, value, deleteFunctionName) {
        var count = ul.getElementsByTagName("li").length;

        var li = document.createElement("li");
        li.classList.add("col-sm-12", "padding-left-0", "fixation-listbox-item");
        var innerDiv = document.createElement("div");
        innerDiv.classList.add("col-sm-11", "padding-left-0");
        var input = document.createElement("input");
        input.id = id + "_" + count;
        input.setAttribute("name", name + "[" + count + "]");
        input.setAttribute("readonly", true);
        input.value = value;
        input.classList.add("readonlyInputForModel");
        innerDiv.appendChild(input);
        var innerDiv2 = document.createElement("div");
        innerDiv2.classList.add("col-sm-1", "padding-left-0");
        var img = document.createElement("img");
        img.classList.add("float-right");
        img.src = "/Content/rc_icons/basket.png";
        img.setAttribute("onclick", deleteFunctionName + "(" + count + ")");
        innerDiv2.appendChild(img);

        li.appendChild(innerDiv);
        li.appendChild(innerDiv2);

        ul.appendChild(li);
    }

    function addCiscoFilePahToList() {
        var dir = document.getElementById("CiscoFixation_CiscoFileToAdd");
        var ul = document.getElementById("CiscoFixation_Files");
        if (dir.value !== '') {
            createLi(ul, "CiscoFixation_Files", "CiscoFixation.Files", dir.value, "deleteItemFromCiscoList");
            dir.value = null;
        }
    }

    function deleteItemFromCiscoList(index) {
        var ul = document.getElementById("CiscoFixation_Files");
        ul.removeChild(ul.getElementsByTagName('li')[index]);

        var items = document.querySelectorAll('[id*=CiscoFixation_Files_]');
        for (var i = 0; i < items.length; i++) {
            items[i].id = "CiscoFixation_Files_" + i;
            items[i].setAttribute("name", "CiscoFixation.Files[" + i + "]");
            ul.getElementsByTagName('img')[i].setAttribute("onclick", "deleteItemFromCiscoList(" + i + ")");
        }
    }

    function isUseCiscoCsm() {
        if ($('input:checkbox[name*=FixContentUsingCsm]').prop('checked') === false)
            $('#csmBlock').addClass('disableContent');
        else
            $('#csmBlock').removeClass('disableContent');
    }

    function pingTypeSelect(type) {
        currentJobProperties.currentPingType = type;
        hideCredentialsTab();
        hideSummaryTab();
    }

    function setCredentialTypeToPing() {
        var types = getCredentialTypesByPingType(currentJobProperties.currentPingType);
        var params = new CredentialParams(types, null);
        createTabCredentials(params);
    }

    function setJobAgentTypeVariable(agentType) {
        if (currentJobProperties.currentJobScanType == SCAN_TYPE_Fixation) {
            if (agentType == JOB_AGENT_TYPE_TempAgent)
                document.getElementById('fixationInfo').classList.remove('hide');
            else document.getElementById('fixationInfo').classList.add('hide');
        }
        hideFileFixationTab();
        currentJobProperties.currentJobAgentType = agentType;
    }

    // #region Job Wizard Scada Modules

    function scadaModulesViewModelSelectionChanged(s, e) {
        if ($('input[id*="Scada_ScadaModules_"]:checked').length === 0) {
            $('#scadaModulesValid').removeClass('hide');
        } else {
            $('#scadaModulesValid').addClass('hide');
        }
    }

    // #endregion

    function checkJobName() {
        var currentName = document.getElementById('Params_Name').value;
        restRequestWithParams(new createJobUrlList().getCheckJobUrl(currentName), viewNewJobName);
    }

    function viewNewJobName(data) {
        var newJobName = JSON.parse(data);
        var oldName = document.getElementById('Params_Name').value.replace(/\s+$/g, '');
        if (newJobName != oldName) {
            document.getElementById('jobNewNameInfoBlock').classList.remove('hide');
            document.getElementById('jobNewNameMessage').innerText = new createJobMessage().newJobNameMessage(oldName, newJobName);
            document.getElementById('Params_Name').value = newJobName;
        } else{
            document.getElementById('jobNewNameInfoBlock').classList.add('hide');
            document.getElementById('Params_Name').value = oldName;
        } 
    }// #endregion

    // #region Nmap

    Array.prototype.unique = function () {
        return this.filter(function (el, index, arr) {
            return index === arr.indexOf(el);
        });
    }

    function onPortScanSelectionChanged(s, e) {
        if ($('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").prop('checked') === true) {
            $('#Nmap_Settings').show();
        } else {
            $('#Nmap_Settings').hide();
        }

        $('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan).val($('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").prop('checked'));

        // Show/hide extended params block
        if ($('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").prop('checked') !== true &&
            $('#Nmap_ScanTypes_' + SCAN_TYPE_Pentest + "_Checkbox").prop('checked') !== true) {
            $('#extendedParams').hide();
        } else {
            $('#extendedParams').show();
        }
    }

    var nmapSelectedScanProfile;
    var nmapSelectedjobProfile;
    var nmapScanProfilesParams = {};
    nmapScanProfilesParams[NMAP_SCAN_PROFILE_STANDARD] = " -sT";
    nmapScanProfilesParams[NMAP_SCAN_PROFILE_TOP50] = " -p21,22,23,25,53,80,81,88,110,111,135,139,143,389,443,445,465,587,631,636,902,912,993,995,1025,1026,1027,1028,1080,1433,1521,1723,2000,3128,3268,3306,3389,5357,5432,5900,5901,8080,8081,8086,8443,9999,10000,10243,49154,50000 -sT";
    nmapScanProfilesParams[NMAP_SCAN_PROFILE_FULL] = " -p1-65535 -sT";
    nmapScanProfilesParams[NMAP_SCAN_PROFILE_STANDARD_UDP] = " -sT -sU";
    nmapScanProfilesParams[NMAP_SCAN_PROFILE_FULL_UDP] = " -p1-65535 -sT -sU";
    nmapScanProfilesParams[NMAP_SCAN_PROFILE_CUSTOM] = "";
    var nmapSelectedTimeProfile;
    var nmapTimeProfilesParams = {};
    nmapTimeProfilesParams[NMAP_TIME_PROFILE_PARANOID] = " -T0";
    nmapTimeProfilesParams[NMAP_TIME_PROFILE_SNEAKY] = " -T1";
    nmapTimeProfilesParams[NMAP_TIME_PROFILE_POLITE] = " -T2";
    nmapTimeProfilesParams[NMAP_TIME_PROFILE_NORMAL] = " -T3";
    nmapTimeProfilesParams[NMAP_TIME_PROFILE_AGGRESSIVE] = " -T4";
    nmapTimeProfilesParams[NMAP_TIME_PROFILE_INSANE] = " -T5";

    function onNmapScanProfileInit(scanProfileList) {
        nmapSelectedScanProfile = scanProfileList.value;
        scanProfileList.value = NMAP_SCAN_PROFILE_TOP50;
        scanProfileList.dispatchEvent(new Event('change', { 'bubbles': true }));
    }

    function onNmapScanProfileChanged(scanProfileList) {

        //Temporary set -sT for properly work, onNmapUseTCPSYNScanChanged() will return -sS

        $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(' -sS', ' -sT'));

        var newSelectedProfile = scanProfileList.value;

        if (newSelectedProfile === NMAP_SCAN_PROFILE_FULL ||
            newSelectedProfile === NMAP_SCAN_PROFILE_FULL_UDP) {
            $('#Pentest_Long_Time_Warning').show();
        } else {
            $('#Pentest_Long_Time_Warning').hide();
        }

        if (newSelectedProfile === NMAP_SCAN_PROFILE_CUSTOM) {
            $('#Nmap_Tcp_Ports_Row').show();
            $('#Nmap_Udp_Ports_Row').show();
        } else {
            $('#Nmap_Tcp_Ports_Row').hide();
            $('#Nmap_Udp_Ports_Row').hide();
            $('#Nmap_Tcp_Ports').val("");
            $('#Nmap_Udp_Ports').val("");
            tcpPortsValue = "";
            udpPortsValue = "";
        }

        switch (newSelectedProfile) {
            case NMAP_SCAN_PROFILE_STANDARD:
            case NMAP_SCAN_PROFILE_CUSTOM:
                $('#Nmap_Host_Timeout').val("5h");
                break;
            case NMAP_SCAN_PROFILE_TOP50:
                $('#Nmap_Host_Timeout').val("1h");
                break;
            case NMAP_SCAN_PROFILE_STANDARD_UDP:
            case NMAP_SCAN_PROFILE_FULL:
                $('#Nmap_Host_Timeout').val("24h");
                break;
            case NMAP_SCAN_PROFILE_FULL_UDP:
                $('#Nmap_Host_Timeout').val("48h");
                break;
        }
        document.getElementById('Nmap_Host_Timeout').onchange();

        switch (nmapSelectedScanProfile) {
            case newSelectedProfile:
                break;
            case NMAP_SCAN_PROFILE_CUSTOM:
                var regex = /-p [TU]:(.+-s(T|U)|.+?(\s|$))/i;
                if ($('#Nmap_Command_Line').val().match(regex)) {
                    $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val()
                        .replace(regex, nmapScanProfilesParams[newSelectedProfile]));
                } else {
                    $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + nmapScanProfilesParams[newSelectedProfile]);
                }

                break;
            default:
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(nmapScanProfilesParams[nmapSelectedScanProfile], nmapScanProfilesParams[newSelectedProfile]));
        }

        nmapSelectedScanProfile = newSelectedProfile;

        onNmapUseTCPSYNScanChanged();
    }

    function onNmapJobProfileInit(jobProfileList) {
        nmapSelectedjobProfile = jobProfileList.options[jobProfileList.selectedIndex];
        jobProfileList.value = 0;
        jobProfileList.dispatchEvent(new Event('change', { 'bubbles': true }));
    }

    function onNmapJobProfileChanged(jobProfileList) {
        nmapSelectedjobProfile = jobProfileList.options[jobProfileList.selectedIndex];
        if (nmapSelectedjobProfile.value != "0") {
            var profile = pentestProfilesList.filter(p => p.Id === nmapSelectedjobProfile.value)[0];

            $('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").prop('checked', profile.PortsScanChecked);
            onPortScanSelectionChanged();
            $("#Nmap_ScanTypes_" + SCAN_TYPE_Bruteforce).prop("checked", profile.BruteforceChecked);
            $("#Nmap_ScanTypes_" + SCAN_TYPE_Pentest).prop("checked", profile.PentestChecked);
            $('#Pentest_Detect_OS_And_Services').prop("checked", profile.DetectOSAndServices);
            $('#Pentest_Web_Scripts_Checked').prop("checked", profile.PentestWebScriptsChecked);
            $('#Extend_Service_Detection').prop("checked", profile.ExtendServiceDetection);
            $('#Ping_Before_Scan').prop("checked", profile.PingBeforeScan);
            $('#Nmap_Use_TCP_SYN_Scan').prop("checked", profile.UseTCPSynScan);

            document.getElementById('Nmap_SelectedScanProfile').value = profile.SelectedNmapProfile;
            document.getElementById('Nmap_SelectedTimeProfile').value = profile.SelectedNmapTimeProfile;

            onNmapTimeProfileChanged(document.getElementById('Nmap_SelectedTimeProfile'));
            onNmapScanProfileChanged(document.getElementById('Nmap_SelectedScanProfile'));

            $('#Nmap_Tcp_Ports').val(profile.NmapTCPPorts);
            tcpPortsValue = profile.NmapTCPPorts;
            $('#Nmap_Udp_Ports').val(profile.NmapUDPPorts);
            udpPortsValue = profile.NmapUDPPorts;
            $('#Nmap_Excluded_Tcp_Ports').val(profile.ExcludedNmapTCPPorts);
            tcpExcludedPortsValue = profile.ExcludedNmapTCPPorts;
            $('#Nmap_Excluded_Udp_Ports').val(profile.ExcludedNmapUDPPorts);
            udpExcludedPortsValue = profile.ExcludedNmapUDPPorts;
            $('#Nmap_Host_Timeout').val(profile.NmapHostTimeout);
            $('#Nmap_Interface_Name').val(profile.SelectedNmapInterface);
            $('#Nmap_Max_Page_Count').val(profile.HttpMaxPageCount);
            $('#Nmap_Max_Page_Depth').val(profile.HttpMaxDepth);
            $('#Nmap_Max_Parallelism').val(profile.MaxParallelism);
            $('#Nmap_Max_Rtt_Timeout').val(profile.MaxRttTimeout);
            $('#Nmap_Max_Retries').val(profile.MaxRetries);
            $('#Pentest_SaveLogFiles').prop("checked", profile.NmapSaveLogFiles);
            $('#LogLevel').val(profile.NmapLogLevel);
            $('#Nmap_Cert_Expire_Timeout').val(profile.CertExpireTimeout);
            onNmapTcpPortsChanged();
            onNmapUdpPortsChanged();
            onNmapExcludedTcpPortsChanged();
            onNmapExcludedUdpPortsChanged();
            document.getElementById("deletePentestProfile").classList.remove('disableContent');
            document.getElementById("savePentestProfile").classList.remove('disableContent');

            $('#Nmap_Command_Line').val(profile.NmapCommandLine);
        }
        else {
            setPentestSettingsToDefault();
            document.getElementById("deletePentestProfile").classList.add('disableContent');
            document.getElementById("savePentestProfile").classList.add('disableContent');
        }
    }

    function setPentestSettingsToDefault() {
        $('#Nmap_Command_Line').val("-Pn --disable-arp-ping -sT -vvv -d -T4 --host-timeout=3h --min-rtt-timeout=10ms");
        $('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").prop('checked', true);
        $("#Nmap_ScanTypes_" + SCAN_TYPE_Bruteforce).prop("checked", false);
        $("#Nmap_ScanTypes_" + SCAN_TYPE_Pentest).prop("checked", true);
        pentestDetectOsAndServicesValue = false;
        $('#Pentest_Detect_OS_And_Services').prop("checked", true);
        $('#Pentest_Web_Scripts_Checked').prop("checked", false);
        $('#Nmap_Use_TCP_SYN_Scan').prop("checked", false);
        $('#Extend_Service_Detection').prop("checked", false);
        $('#Ping_Before_Scan').prop("checked", false);
        onPentestSelectionChanged();
        document.getElementById('Nmap_SelectedScanProfile').value = NMAP_SCAN_PROFILE_STANDARD;
        onNmapScanProfileChanged(document.getElementById('Nmap_SelectedScanProfile'));

        document.getElementById('Nmap_SelectedTimeProfile').value = NMAP_TIME_PROFILE_AGGRESSIVE;
        onNmapTimeProfileChanged(document.getElementById('Nmap_SelectedTimeProfile'));

        $('#Nmap_Tcp_Ports').val("");
        $('#Nmap_Udp_Ports').val("");
        $('#Nmap_Excluded_Tcp_Ports').val("");
        $('#Nmap_Excluded_Udp_Ports').val("");
        tcpPortsValue = "";
        tcpExcludedPortsValue = "";
        udpExcludedPortsValue = "";
        udpPortsValue = "";
        /*    $('#Nmap_Host_Timeout').val("");*/
        $('#Nmap_Interface_Name').val("");
        $('#Nmap_Max_Page_Count').val("20");
        $('#Nmap_Max_Page_Depth').val("3");
        $('#Pentest_SaveLogFiles').prop("checked", false);
        $('#LogLevel').val("1");
        $('#Nmap_Cert_Expire_Timeout').val("30");
    }

    function onNmapTimeProfileInit(timeProfileList) {
        nmapSelectedTimeProfile = timeProfileList.value;
        timeProfileList.value = NMAP_TIME_PROFILE_AGGRESSIVE;
        timeProfileList.dispatchEvent(new Event('change', { 'bubbles': true }));
    }

    function onNmapTimeProfileChanged(timeProfileList) {
        var newSelectedProfile = timeProfileList.value;

        switch (newSelectedProfile) {
            case NMAP_TIME_PROFILE_PARANOID:
                $('#Nmap_Max_Parallelism').val("1");
                $('#Nmap_Max_Rtt_Timeout').val("300000");
                $('#Nmap_Max_Retries').val("10");
                break;
            case NMAP_TIME_PROFILE_SNEAKY:
                $('#Nmap_Max_Parallelism').val("1");
                $('#Nmap_Max_Rtt_Timeout').val("15000");
                $('#Nmap_Max_Retries').val("10");
                break;
            case NMAP_TIME_PROFILE_POLITE:
                $('#Nmap_Max_Parallelism').val("1");
                $('#Nmap_Max_Rtt_Timeout').val("10000");
                $('#Nmap_Max_Retries').val("10");
                break;
            case NMAP_TIME_PROFILE_NORMAL:
                $('#Nmap_Max_Parallelism').val("900");
                $('#Nmap_Max_Rtt_Timeout').val("10000");
                $('#Nmap_Max_Retries').val("10");
                break;
            case NMAP_TIME_PROFILE_AGGRESSIVE:
                $('#Nmap_Max_Parallelism').val("900");
                $('#Nmap_Max_Rtt_Timeout').val("1250");
                $('#Nmap_Max_Retries').val("6");
                break;
            case NMAP_TIME_PROFILE_INSANE:
                $('#Nmap_Max_Parallelism').val("900");
                $('#Nmap_Max_Rtt_Timeout').val("300");
                $('#Nmap_Max_Retries').val("2");
                break;
        }

        $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(nmapTimeProfilesParams[nmapSelectedTimeProfile], nmapTimeProfilesParams[newSelectedProfile]));
        nmapSelectedTimeProfile = newSelectedProfile;
        $('#Bruteforce_SelectedTimeProfile').val(timeProfileList.value);

        setNmapMaxParallelism('');
        setNmapMaxRttTimeout('');
        setNmapMaxRetries('');
    }

    var pentestDetectOsAndServicesValue = false;
    function onPentestDetectOsAndServicesChanged() {
        if ($('#Pentest_Detect_OS_And_Services').prop('checked') === pentestDetectOsAndServicesValue) return;

        if ($("#Nmap_ScanTypes_" + SCAN_TYPE_Pentest).prop('checked') === true || $('#Pentest_Detect_OS_And_Services').prop('checked') === true) {
            $('#Pentest_Web_Scripts_Checked').prop("checked", false);
            pentestWebScriptsCheckedValue = false;
        }

        pentestDetectOsAndServicesValue = $('#Pentest_Detect_OS_And_Services').prop('checked');
    }

    var pentestWebScriptsCheckedValue = false;
    function onPentestWebScriptsChanged() {
        if ($('#Pentest_Web_Scripts_Checked').prop('checked') === pentestWebScriptsCheckedValue) return;

        pentestWebScriptsCheckedValue = $('#Pentest_Web_Scripts_Checked').prop('checked');
    }

    function onPentestSelectionChanged(s, e) {
        if ($("#Nmap_ScanTypes_" + SCAN_TYPE_Pentest).is(":checked")) {
            $('#Pentest_Confidence_Types').removeClass("hidden");
            document.getElementById('Pentest_Detect_OS_And_Services').parentElement.classList.add('disableContent');
            document.getElementById('Pentest_Web_Scripts_Checked').parentElement.classList.remove('disableContent');
            $('#Pentest_Detect_OS_And_Services').prop("checked", true);
            document.getElementById('Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").parentElement.classList.add('disableContent');
            $('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").prop('checked', true);
            onPortScanSelectionChanged();
            onPentestDetectOsAndServicesChanged();

        } else {
            $('#Pentest_Confidence_Types').addClass("hidden");
            document.getElementById('Pentest_Detect_OS_And_Services').parentElement.classList.remove('disableContent');
            document.getElementById('Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").parentElement.classList.remove('disableContent');
            document.getElementById('Pentest_Web_Scripts_Checked').parentElement.classList.add('disableContent');
            $('#Pentest_Web_Scripts_Checked').prop("checked", false);
        }

        // Show/hide extended params block
        if ($('#Nmap_ScanTypes_' + SCAN_TYPE_PortScan + "_Checkbox").prop('checked') !== true &&
            $('#Nmap_ScanTypes_' + SCAN_TYPE_Pentest + "_Checkbox").prop('checked') !== true) {
            $('#extendedParams').hide();
        } else {
            $('#extendedParams').show();
        }
    }

    var tcpPortsValue = "";
    var tcpExcludedPortsValue = "";
    var udpExcludedPortsValue = "";
    var udpPortsValue = "";
    function onNmapTcpPortsChanged() {

        //Temporary set -sT for properly work, onNmapUseTCPSYNScanChanged() will return -sS
        $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(' -sS', ' -sT'));

        var trimmedValue = $('#Nmap_Tcp_Ports').val().replace(/ /g, '')

        if (trimmedValue === tcpPortsValue) return;

        if (!tcpPortsValue && !udpPortsValue) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + " -p T:" + trimmedValue + " -sT");
        } else {
            var valueToReplace = (!trimmedValue && !udpPortsValue)
                ? ""
                : "-p " +
                (trimmedValue ? "T:" + trimmedValue : "") +
                (trimmedValue && udpPortsValue.length > 0 ? "," : "") +
                (udpPortsValue.length > 0 ? "U:" + udpPortsValue + " -sU" : "") +
                (trimmedValue.length > 0 ? " -sT" : "");

            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/-p [TU]:(.+-s(U|T)|.+?(\s|$))/i, valueToReplace));
        }

        tcpPortsValue = trimmedValue;
        $('#Nmap_Tcp_Ports').val(trimmedValue)

        onNmapUseTCPSYNScanChanged();
    }

    function onNmapExcludedTcpPortsChanged() {

        var trimmedValue = $('#Nmap_Excluded_Tcp_Ports').val().replace(/ /g, '')

        if (trimmedValue === tcpExcludedPortsValue) return;

        if (!tcpExcludedPortsValue && !udpExcludedPortsValue) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + " --exclude-ports T:" + trimmedValue);
        } else {
            var valueToReplace = (!trimmedValue && !udpExcludedPortsValue)
                ? ""
                : "--exclude-ports " +
                (trimmedValue ? "T:" + trimmedValue : "") +
                (trimmedValue && udpExcludedPortsValue.length > 0 ? "," : "") +
                (udpExcludedPortsValue.length > 0 ? "U:" + udpExcludedPortsValue : "");

            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/--exclude-ports [TU]:.+?(\s|$)/i, valueToReplace));
        }

        tcpExcludedPortsValue = trimmedValue;
        $('#Nmap_Excluded_Tcp_Ports').val(trimmedValue);
    }

    function onNmapUdpPortsChanged() {

        //Temporary set -sT for properly work, onNmapUseTCPSYNScanChanged() will return -sS
        $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(' -sS', ' -sT'));

        var trimmedValue = $('#Nmap_Udp_Ports').val().replace(/ /g, '')

        if (trimmedValue === udpPortsValue) return;

        if (!tcpPortsValue && !udpPortsValue) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + " -p U:" + trimmedValue + " -sU");
        } else {
            var valueToReplace = (!trimmedValue && !tcpPortsValue)
                ? ""
                : "-p " +
                (tcpPortsValue.length > 0 ? "T:" + tcpPortsValue : "") +
                (tcpPortsValue.length > 0 && trimmedValue ? "," : "") +
                (trimmedValue ? "U:" + trimmedValue + " -sU" : "") +
                (tcpPortsValue.length > 0 ? " -sT" : "");

            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/-p [TU]:(.+-s(U|T)|.+?(\s|$))/i, valueToReplace));
        }

        udpPortsValue = trimmedValue;
        $('#Nmap_Udp_Ports').val(trimmedValue)

        onNmapUseTCPSYNScanChanged();
    }

    function onNmapExcludedUdpPortsChanged() {

        var trimmedValue = $('#Nmap_Excluded_Udp_Ports').val().replace(/ /g, '')

        if (trimmedValue === udpExcludedPortsValue) return;

        if (!udpExcludedPortsValue && !tcpExcludedPortsValue) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + " --exclude-ports U:" + trimmedValue);
        } else {
            var valueToReplace = (!trimmedValue && !tcpExcludedPortsValue)
                ? ""
                : "--exclude-ports " +
                (trimmedValue ? "U:" + trimmedValue : "") +
                (trimmedValue && tcpExcludedPortsValue.length > 0 ? "," : "") +
                (tcpExcludedPortsValue.length > 0 ? "T:" + tcpExcludedPortsValue : "");

            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/--exclude-ports [TU]:.+?(\s|$)/i, valueToReplace));
        }

        udpExcludedPortsValue = trimmedValue;
        $('#Nmap_Excluded_Udp_Ports').val(trimmedValue)
    }

    function onNmapHostTimeoutChanged() {
        $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/--host-timeout=.+? /i, "--host-timeout=" + $('#Nmap_Host_Timeout').val() + " "));
    }

    function onNmapInterfaceNameChanged() {
        var newValue = "";
        if ($('#Nmap_Interface_Name').val().match(/eth\d+/i) !== null) {
            newValue = " -e " + $('#Nmap_Interface_Name').val();
        } else if ($('#Nmap_Interface_Name').val()) {
            newValue = " -e eth" + $('#Nmap_Interface_Name').val();
        }

        if ($('#Nmap_Command_Line').val().match(/ -e eth\d+/i) === null) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + newValue);
        } else {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/ -e eth\d+/i, newValue));
        }

        $('#Bruteforce_Interface_Name').val($('#Nmap_Interface_Name').val());
    }

    function onNmapMaxPageCountChanged() {
        var trimmedValue = $('#Nmap_Max_Page_Count').val().replace(/ /g, '');

        var argsRegex = /--script-args\s+\'(.+?)\'/i

        if ($('#Nmap_Command_Line').val().indexOf('httpspider.maxpagecount') >= 0) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(new RegExp((trimmedValue === '' ? ',?' : '') + 'httpspider.maxpagecount=-?\\d*' + (trimmedValue === '' ? ',?' : ''), '\i'), trimmedValue === '' ? '' : 'httpspider.maxpagecount=' + trimmedValue));

            var argsMatch = argsRegex.exec($('#Nmap_Command_Line').val());

            if (argsMatch === null) {
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/--script-args\s+'(.*?)'/i, ""));
            }
        }
        else {
            var argsMatch = argsRegex.exec($('#Nmap_Command_Line').val());

            if (argsMatch !== null) {
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(argsRegex, '--script-args \'' + argsMatch[1] + ',httpspider.maxpagecount=' + trimmedValue + '\''));
            }
            else {
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + ' --script-args \'httpspider.maxpagecount=' + trimmedValue + '\'')
            }
        }
    }


    function onNmapMaxPageDepthChanged() {
        var trimmedValue = $('#Nmap_Max_Page_Depth').val().replace(/ /g, '');

        var argsRegex = /--script-args\s+\'(.+?)\'/i

        if ($('#Nmap_Command_Line').val().indexOf('httpspider.maxdepth') >= 0) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(new RegExp((trimmedValue === '' ? ',?' : '') + 'httpspider.maxdepth=-?\\d*' + (trimmedValue === '' ? ',?' : ''), '\i'), trimmedValue === '' ? '' : 'httpspider.maxdepth=' + trimmedValue));

            var argsMatch = argsRegex.exec($('#Nmap_Command_Line').val());

            if (argsMatch === null) {
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/--script-args\s+'(.*?)'/i, ""));
            }
        }
        else {
            var argsMatch = argsRegex.exec($('#Nmap_Command_Line').val());

            if (argsMatch !== null) {
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(argsRegex, '--script-args \'' + argsMatch[1] + ',httpspider.maxdepth=' + trimmedValue + '\''));
            }
            else {
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + ' --script-args \'httpspider.maxdepth=' + trimmedValue + '\'')
            }
        }
    }

    function onNmapMaxParallelismChanged() {
        var trimmedValue = $('#Nmap_Max_Parallelism').val().replace(/ /g, '');
        setNmapMaxParallelism(trimmedValue);
    }

    function setNmapMaxParallelism(value) {
        if ($('#Nmap_Command_Line').val().indexOf(' --max-parallelism') > -1) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(new RegExp(' --max-parallelism=\\d+'), value === '' ? '' : ' --max-parallelism=' + value));
        }
        else if (value.length > 0) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + ' --max-parallelism=' + value);
        }
    }

    function onNmapMaxRttTimeoutChanged() {
        var trimmedValue = $('#Nmap_Max_Rtt_Timeout').val().replace(/ /g, '');
        setNmapMaxRttTimeout(trimmedValue);
    }

    function setNmapMaxRttTimeout(value) {
        if ($('#Nmap_Command_Line').val().indexOf(' --max-rtt-timeout') > -1) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(new RegExp(' --max-rtt-timeout=\\d+ms'), value === '' ? '' : ' --max-rtt-timeout=' + value + 'ms'));
        }
        else if (value.length > 0) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + ' --max-rtt-timeout=' + value + 'ms');
        }
    }

    function onNmapMaxRetriesChanged() {
        var trimmedValue = $('#Nmap_Max_Retries').val().replace(/ /g, '');
        setNmapMaxRetries(trimmedValue);
    }

    function onNmapUseTCPSYNScanChanged() {
        var useTcpSynValue = $('#Nmap_Use_TCP_SYN_Scan').prop('checked') === true;

        $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(useTcpSynValue ? ' -sT' : ' -sS', useTcpSynValue ? ' -sS' : ' -sT'));
    }

    function onNmapExtendServiceDetectionChanged() {
        if ($('#Extend_Service_Detection').prop('checked') === true) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + ' --version-all');
        }
        else {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(' --version-all', ''));
        }
    }

    function onNmapPingBeforeScanChanged() {
        if (document.getElementById('Ping_Before_Scan').checked === true) {
            NmapCommandLineHelper.removeFlag('-Pn');
        } else {
            NmapCommandLineHelper.addFlag('-Pn');
        }
    }

    function setNmapMaxRetries(value) {
        if ($('#Nmap_Command_Line').val().indexOf(' --max-retries') > -1) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(new RegExp(' --max-retries=\\d+'), value === '' ? '' : ' --max-retries=' + value));
        }
        else if (value.length > 0) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + ' --max-retries=' + value);
        }
    }

    function onBruteforceInterfaceNameChanged() {
        var newValue = "";
        if ($('#Bruteforce_Interface_Name').val().match(/eth\d+/i) !== null) {
            newValue = " -e " + $('#Bruteforce_Interface_Name').val();
        } else if ($('#Bruteforce_Interface_Name').val()) {
            newValue = " -e eth" + $('#Bruteforce_Interface_Name').val();
        }

        if ($('#Nmap_Command_Line').val().match(/ -e eth\d+/i) === null) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + newValue);
        } else {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(/ -e eth\d+/i, newValue));
        }

        $('#Nmap_Interface_Name').val($('#Bruteforce_Interface_Name').val());
    }

    function onBruteforceTimeProfileChanged() {
        const nmapTimeProfileCombo = document.getElementById('Nmap_SelectedTimeProfile');
        nmapTimeProfileCombo.value = $('#Bruteforce_SelectedTimeProfile').val();
        nmapTimeProfileCombo.dispatchEvent(new Event('change', { 'bubbles': true }));
    }

    function onUseExtendIdentificationChanged() {
        if ($('#Params_UseExtendIdentification').prop('checked') === true) {
            $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val() + " -R");
        } else {
            if ($('#Nmap_Command_Line').val() != undefined)
                $('#Nmap_Command_Line').val($('#Nmap_Command_Line').val().replace(" -R", ""));
        }
    }

    var NmapCommandLineHelper = {
        addFlag: function (flag) {
            const commandLine = document.getElementById('Nmap_Command_Line');
            commandLine.value = `${commandLine.value} ${flag}`;
        },
    
        removeFlag: function (flag) {
            const commandLine = document.getElementById('Nmap_Command_Line');
            const commandLineValue = ' ' + commandLine.value;
    
            if (commandLineValue.indexOf(` ${flag}`) > -1) {
                commandLine.value = commandLineValue.replace(` ${flag}`, '').trimStart();
            }
        },
    };

    function onIsNotifyByEmailChanged() {
        if ($('#Params_IsNotifyByEmail').prop('checked') == true) {
            if (document.getElementById('Params_UseEmailDelivery').value == "False") {
                document.getElementById('deliveryNotUse').classList.remove('hide');
                isCanNextFromMail = false;
            } else {
                document.getElementById('deliveryNotUse').classList.add('hide');
                isCanNextFromMail = true;

                if ($('#NetworkResourcesGrid').length === 0)
                    ajaxRequest(networkResourcesViewPartialUrl, 'POST', null, function () {
                        $('#Params_IsNotifyByEmail').prop('disabled', true);
                    }, function (html) {
                        $('#networkResourcesContainer').append(html);
                        $('#Params_IsNotifyByEmail').prop('disabled', false);
                    });

                document.getElementById('networkResourcesContainer').classList.remove('hide');
            }
        } else {
            document.getElementById('deliveryNotUse').classList.add('hide');
            document.getElementById('networkResourcesContainer').classList.add('hide');
            isCanNextFromMail = true;
        }

        isCanNextForMainTab();
    }

    function isCanNextForMainTab() {
        if (isCanNextFromMail && isCanNextFromNmap && isCanCreateJob && isCanUseFromScada && isCanUseFromYara)
            document.getElementById('cmdNext').classList.remove('disableContent');
        else
            document.getElementById('cmdNext').classList.add('disableContent');
    }

    function checkContentForDocker() {
        return $.ajax({
            type: "GET",
            url: new createJobUrlList().checkContentForDocker(),
            dataType: "json",
            async: !1
        });
    }

// #endregion