﻿/*const SCAN_TYPE_AuditMsSql = "AuditMsSql";
const SCAN_TYPE_AuditOracle = "AuditOracle";
const SCAN_TYPE_AuditMySql = "AuditMySql";
const SCAN_TYPE_AuditPostgreSQL = "AuditPostgreSQL";
const SCAN_TYPE_AuditIbmDb2 = "AuditIbmDb2";
const SCAN_TYPE_AuditSapHana = "AuditSapHana";*/
const SCAN_TYPE_Vulnerability = "Vulnerability";
const SCAN_TYPE_Patch = "Patch";
const SCAN_TYPE_Inventory = "Inventory";
const SCAN_TYPE_Compliance = "Compliance";
const SCAN_TYPE_Fixation = "Fixation";
const SCAN_TYPE_Remediation = "Remediation";
const SCAN_TYPE_Nmap = "Nmap";
const SCAN_TYPE_HostDiscovery = "HostDiscovery";
const SCAN_TYPE_PortScan = "PortScanNmap";
const SCAN_TYPE_Bruteforce = "Bruteforce";
const SCAN_TYPE_Pentest = "Pentest";
const SCAN_TYPE_Scada = "Scada";
const SCAN_TYPE_Ping = "Ping";
const SCAN_TYPE_Docker_Vulnerabilities = "DockerVulnerabilities"
const SCAN_TYPE_Yara = "Yara";

const CREDENTIAL_TYPE_Windows = "Windows";
const CREDENTIAL_TYPE_VMware = "VMware";
const CREDENTIAL_TYPE_Ssh = "Ssh";
const CREDENTIAL_TYPE_Cisco = "Cisco";
const CREDENTIAL_TYPE_Huawei = "Huawei";
const CREDENTIAL_TYPE_Solaris = "Solaris";
const CREDENTIAL_TYPE_FreeBsd = "FreeBsd";
const CREDENTIAL_TYPE_CheckPoint = "CheckPoint";
const CREDENTIAL_TYPE_FortiOs = "FortiOs";
const CREDENTIAL_TYPE_UserGate = "UserGate";
const CREDENTIAL_TYPE_Sql = "Sql";
const CREDENTIAL_TYPE_Eltex = "Eltex";
const CREDENTIAL_TYPE_OpenShift = "OpenShift";

const CREDENTIAL_SUBTYPE_CiscoIos = "Ios";
const CREDENTIAL_SUBTYPE_CiscoNxos = "Nxos";
const CREDENTIAL_SUBTYPE_CiscoNone = "None";

const CREDENTIAL_SUBTYPE_VmwarePlatformNone = "None";

const CREDENTIAL_SUBTYPE_SqlMsSql = "MsSql";
const CREDENTIAL_SUBTYPE_SqlOracle = "Oracle";
const CREDENTIAL_SUBTYPE_SqlMySql = "MySql";
const CREDENTIAL_SUBTYPE_SqlPostgreSQL = "PostgreSQL";
const CREDENTIAL_SUBTYPE_SqlIbmDb2 = "IbmDb2";
const CREDENTIAL_SUBTYPE_SqlSapHana = "SapHana";

const SCHEDULE_TYPE_Minutely = "Minutely";
const SCHEDULE_TYPE_Hourly = "Hourly";
const SCHEDULE_TYPE_Daily = "Daily";
const SCHEDULE_TYPE_Weekly = "Weekly";
const SCHEDULE_TYPE_Monthly = "Monthly";
const SCHEDULE_TYPE_OneTime = "OneTime";

const OS_TYPE_WINDOWS = "Windows";
const OS_TYPE_LINUX = "Linux";

const GLOBAL_DATE_TIME_FORMAT = "DD.MM.YYYY HH:mm:ss";

const Severity = {
    UNKNOWN: 1,
    INFO: 2,
    LOW: 3,
    MEDIUM: 4,
    HIGH: 5,
    CRITICAL: 6,
};

$(document).ready(function () {
    $.ajaxSetup({ cache: false });

    $("[data-toggle=popover]").popover({
        container: 'body',
        html: true,
        content: function () {
            var clone = $($(this).data('popover-content')).clone(true).removeClass('hidden');
            return clone;
        }
    });

    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });

    jQuery.fn.center = function () {
        this.css("position", "absolute");
        this.css("top", Math.max(0, ($(window).height() - $(this).outerHeight()) / 2 +
            $(window).scrollTop()) + "px");
        this.css("left", Math.max(0, ($(window).width() - $(this).outerWidth()) / 2 +
            $(window).scrollLeft()) + "px");
        return this;
    };

    $(".patch-panel, .notupd-hosts-panel").hide();
    $("#chartsToggle").on("click",
        function () {
            $(".vuln-panel, .patch-panel").toggle();
            ChartsController.drawForDashboard();
        }
    );
    $("#hostsToggle").on("click",
        function () {
            $(".vuln-hosts-panel, .notupd-hosts-panel").toggle();
        }
    );

    commandBlock = {
        id: '',
        isOpen: false
    };

    document.addEventListener('click', function () {
        if (event.srcElement.parentElement !== undefined && commandBlock.isOpen && event.srcElement.parentElement.id.indexOf('cmd-link-id-') === -1 && event.srcElement.id.indexOf('cmd-link-id-') === -1) {
            clearStyle(commandBlock.id);
        }
    });
});

$(document).ajaxError(function (e, xhr) {
    if (xhr.status === 401) {
        setCookie("is401Redirect", "true");
        window.location = "/account/loginview";
    }
    
    if (xhr.status === 403) {
        notifyWarning("У вас недостаточно прав для выполнения этого действия");
    }
    
    if (xhr.status === 419) {
        notifyWarning("Истекло время клиентской сессии. Требуется повторная авторизация");
    }
});

function isRedirectToAuth(response) {
    if ($(response).filter('#login').get(0)) {
        return true;
    }
    return false;
}

function openCommands(id, position) {
    if (commandBlock.isOpen) {
        clearStyle(commandBlock.id);
    }

    var element = document.getElementById('cmd-link-id-' + id);
    var xy = element.getBoundingClientRect();
    var block = document.getElementById('command-id-' + id);

    block.setAttribute('style', 'visibility:hidden;display:block');

    if (position === undefined || position == 'left') {
        block.setAttribute('style', 'left:' + Math.round(xy.left - block.clientWidth + 5) + 'px' + ';top:' + Math.round(xy.top - block.clientHeight / 2) + 'px;display:block');
    }
    if (position != undefined && position == 'top') {
        block.setAttribute('style', 'left:' + Math.round(xy.left - block.clientWidth / 2 + 10) + 'px' + ';top:' + Math.round(xy.top - block.clientHeight - 5) + 'px;display:block');
    }
    if (position !== undefined && position === 'top left') {
        block.setAttribute('style', 'left:' + Math.round(xy.left + 8) + 'px' + ';top:' + Math.round(xy.top - block.clientHeight - 10) + 'px;display:block');
    }

    commandBlock = {
        id: 'command-id-' + id,
        isOpen: true
    };
}

function isEmptyObj(obj) {
    return !(typeof obj !== "undefined" && (typeof obj !== "object" || !obj));
}

function isEmptyString(string) {
    return !string;
}

function getDateFromAspNetFormat(date) {
    const re = /-?\d+/;
    const m = re.exec(date);
    return parseInt(m[0], 10);
}

function clearStyle(id) {
    document.getElementById(id).setAttribute('style', '');
    commandBlock = {
        id: '',
        isOpen: false
    };
}

function bindToolTip() {
    $('[data-toggle="tooltip"]').tooltip();
}

function debounce(callee, timeout) {
    return function perform(...args) {
        let previousCall = this.lastCall;
        this.lastCall = Date.now();

        if (previousCall && this.lastCall - previousCall <= timeout) {
            clearTimeout(this.lastTimer);
        }

        this.lastTimer = setTimeout(() => callee(...args), timeout);
    };
}

function escapeHtml(source) {
    var tagsToReplace = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;'
    };

    return source.replace(/[&<>]/g, function (tag) {
        return tagsToReplace[tag] || tag;
    });;
}

function setInputFilter(textbox, inputFilter) {
    ["input", "keydown", "keyup", "mousedown", "mouseup", "select", "contextmenu", "drop"].forEach(function (event) {
        textbox.addEventListener(event, function () {
            if (inputFilter(this.value)) {
                this.oldValue = this.value;
                this.oldSelectionStart = this.selectionStart;
                this.oldSelectionEnd = this.selectionEnd;
            } else if (this.hasOwnProperty("oldValue")) {
                this.value = this.oldValue;
                this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
            } else {
                this.value = "";
            }
        });
    });
}

// #region Compliances

function dropPlatformsChange() {
    $("#SelectedProduct").val('');
    if ($("#SelectedPlatform :selected").text() !== '') {
        ComplianceController.PlatformFilter = $("#SelectedPlatform :selected").text();
    }
    else {
        $("#SelectedPlatform").val('');
        ComplianceController.PlatformFilter = '';
    }
    $('#CompliancesGrid').DataTable().ajax.reload()
}

function dropProductsChange() {
    $("#SelectedPlatform").val('');
    if ($("#SelectedProduct :selected").text() !== '') {
        ComplianceController.PlatformFilter = $("#SelectedProduct :selected").text();
    }
    else {
        $("#SelectedProduct").val('');
        ComplianceController.PlatformFilter = '';
    }
    $('#CompliancesGrid').DataTable().ajax.reload()
}

// Job master & job properties
var ComplianceParamsForJobMaster = {
    changePlatform: function () {
        $("#Compliance_Params_SelectedProduct").val('');
        if ($("#Compliance_Params_SelectedPlatform :selected").text() !== '') {
            platformName = $("#Compliance_Params_SelectedPlatform :selected").text();
        }
        else {
            $("#Compliance_Params_SelectedPlatform").val('');
            platformName = '';
        }

        $('#CreateJobsComplianceGrid').DataTable().ajax.reload();
    },

    changeProduct: function () {
        $("#Compliance_Params_SelectedPlatform").val('');
        if ($("#Compliance_Params_SelectedProduct :selected").text() !== '') {
            platformName = $("#Compliance_Params_SelectedProduct :selected").text();
        }
        else {
            $("#Compliance_Params_SelectedProduct").val('');
            platformName = '';
        }

        $('#CreateJobsComplianceGrid').DataTable().ajax.reload();
    }
};

var ComplianceParamsForJobProperties = {
    credentialTypesString: '',
    errorText: 'Произошла ошибка: не удалось получить список платформ',

    changePlatform: function () {
        $("#ComplianceParams_SelectedProduct").val('');
        if ($("#ComplianceParams_SelectedPlatform :selected").text() !== '') {
            platformName = $("#ComplianceParams_SelectedPlatform :selected").text();
        }
        else {
            $("#ComplianceParams_SelectedPlatform").val('');
            platformName = '';
        }

        $('#CreateJobsComplianceGrid').DataTable().ajax.reload();
    },

    changeProduct: function () {
        $("#ComplianceParams_SelectedPlatform").val('');
        if ($("#ComplianceParams_SelectedProduct :selected").text() !== '') {
            platformName = $("#ComplianceParams_SelectedProduct :selected").text();
        }
        else {
            $("#ComplianceParams_SelectedProduct").val('');
            platformName = '';
        }

        $('#CreateJobsComplianceGrid').DataTable().ajax.reload();
    },

    setPlaceholders: function () {
        $('#ComplianceParams_SelectedPlatform option:first-child').attr({ selected: 'selected', disabled: 'disabled', hidden: 'hidden' });
        $('#ComplianceParams_SelectedProduct option:first-child').attr({ selected: 'selected', disabled: 'disabled', hidden: 'hidden' });
    },

    updateFilters: async function () {
        const credentialTypesString = new CredentialTypes(JobCredentialsGridComponent.Data)
            .map(t => t.subType ? t.type + '-' + t.subType : t.type).join(',');

        if (credentialTypesString === ComplianceParamsForJobProperties.credentialTypesString) {
            return;
        }

        platformName = '';
        ComplianceParamsForJobProperties.credentialTypesString = credentialTypesString;

        const selectPlatform = document.getElementById('ComplianceParams_SelectedPlatform');
        const selectProduct = document.getElementById('ComplianceParams_SelectedProduct');

        selectPlatform.disabled = true;
        selectProduct.disabled = true;

        const data = await ComplianceParamsForJobProperties.getFilterOptions(credentialTypesString);
        if (data !== null) {
            ComplianceParamsForJobProperties.setSelectOptions(selectPlatform, data.Filters.XccdfPlatforms);
            ComplianceParamsForJobProperties.setSelectOptions(selectProduct, data.Filters.XccdfProducts);
            ComplianceParamsForJobProperties.setPlaceholders();
        }
        
        selectPlatform.disabled = false;
        selectProduct.disabled = false;
    },

    setSelectOptions: function (select, data) {
        select.innerHTML = '';

        data.forEach(item => {
            const option = document.createElement('option');
            option.value = item.Value;
            option.textContent = item.Text;
            select.appendChild(option);
        });
    },

    getFilterOptions: async function (credentialTypesString) {
        try {
            const response = await fetch('/Jobs/GetFiltersForComplianceGrid', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(credentialTypesString)
            });

            if (!response.ok) {
                notifyWarning(ComplianceParamsForJobProperties.errorText);
                return null;
            }

            return await response.json();
        } catch (e) {
            console.error(e);
            notifyWarning(ComplianceParamsForJobProperties.errorText);
            return null;
        }
    }
};

function resetRowFocusForGrid(table) {
    if (table.pageRowCount > 0) {
        table.SetFocusedRowIndex(-1);
        table.SetFocusedRowIndex(0);
    }
}

function OnSelectedRowJM(nodes, selected) {
    // TODO: separate logic for independent pages
    if (typeof createReportTabs !== "undefined") {
        clearNextSteps(benchmarksTab.data('step-name'));
    } else if (typeof currentJobProperties !== 'undefined') {
        // TODO: think of replacing by getSelectedBenchmarks()
        if (typeof currentJobProperties.selectedCompliances === "undefined")
            currentJobProperties.selectedCompliances = [];
        const selectionIds = nodes.cells(nodes).data().toArray();
        for (let i = 0; i < selectionIds.length; i++) {
            if (selected === true && currentJobProperties.selectedCompliances.filter(x => x.id === selectionIds[i]).length === 0) {
                currentJobProperties.selectedCompliances.push({ id: selectionIds[i], profiles: [0] })
            } else if (selected === false && currentJobProperties.selectedCompliances.filter(x => x.id === selectionIds[i]).length > 0) {
                currentJobProperties.selectedCompliances = currentJobProperties.selectedCompliances.filter(x => x.id !== selectionIds[i]);
            }
        }
        changeCountCompliance();
    } else {
        // Stop redundant profiles reloading while compliance grid is initialized and benchmarks are selected programmatically
        if (CreateJobsComplianceController.additionals.isComplianceGridInit === true)
            return;

        let jobXccdfFiles = getSelectedBenchmarks();
        selectedComplianceIds = jobXccdfFiles?.map(x => x.XccdfFileId).join() ?? '';

        loadXccdfProfile(jobXccdfFiles, function () {
            const selectionIds = nodes.cells(nodes).data().toArray();
            let newSelectionIds = [];

            if (selected) {
                // Exclude previously added
                newSelectionIds = selectionIds.filter(function (currentId) {
                    return jobXccdfFiles.some(x => x.XccdfFileId == currentId && x.XccdfProfileIds.length === 0);
                });
            }

            if (newSelectionIds.length > 0) {
                XccdfProfileTreeViewController.onAddNodes(newSelectionIds);
            }

            if (XccdfProfileTreeViewController.anyProfileSelected() && !$('#benchmarksValid').hasClass('hide')) {
                $('#benchmarksValid').addClass('hide');
            }
        });
    }
}

function getSelectedBenchmarks() {
    const api = $('#CreateJobsComplianceGrid').DataTable();

    let jobXccdfFiles = [];
    api.column('Id:name').checkboxes.selected()
        .each(function (value, index) {
            jobXccdfFiles[value] = { XccdfFileId: value, XccdfProfileIds: [] };
        });

    let profileTreeView = xssdfProfileTreeView2;

    if (jobXccdfFiles.length !== 0 && typeof profileTreeView !== "undefined") {
        const benchmarkNodes = profileTreeView.getTopNodes();
        benchmarkNodes.forEach(function (node) {
            const xccdfFileId = node.getKey();

            if (jobXccdfFiles[xccdfFileId] === undefined)
                return;

            jobXccdfFiles[xccdfFileId].XccdfProfileIds = [];

            profileTreeView.getNodesByParent(node)
                .forEach(function (profileNode) {
                    if (profileNode.getChecked())
                        jobXccdfFiles[xccdfFileId].XccdfProfileIds.push(profileNode.getKey());
                });
        });
    }

    return jobXccdfFiles.filter(function (e) { return e });
}

var XccdfProfileTreeViewController = {
    onInitComplete: function () {
        if ($('#ScanAllProfiles').prop('checked') === true) {
            $('#xssdfProfileTreeView2').parent().addClass('disableContent');
        } else {
            $('#xssdfProfileTreeView2').parent().removeClass('disableContent');
        }
    },

    onAddNodes: function (benchmarkIds) {
        const benchmarkNodes = XccdfProfileTreeViewController.getBenchmarkNodesbyIds(benchmarkIds);

        if ($('#ScanAllProfiles').prop('checked') === true) {
            XccdfProfileTreeViewController.selectAllProfiles(benchmarkNodes);
        } else {
            XccdfProfileTreeViewController.selectOnlyDefaultProfiles(benchmarkNodes);
        }
    },

    onScanAllProfilesClick: function () {
        const benchmarkNodes = xssdfProfileTreeView2.getTopNodes();

        if ($('#ScanAllProfiles').prop('checked') === true) {
            XccdfProfileTreeViewController.selectAllProfiles(benchmarkNodes);
            $('#xssdfProfileTreeView2').parent().addClass('disableContent');
        } else {
            XccdfProfileTreeViewController.selectOnlyDefaultProfiles(benchmarkNodes);
            $('#xssdfProfileTreeView2').parent().removeClass('disableContent');
        }
    },

    getBenchmarkNodesbyIds: function (ids) {
        let benchmarkNodes = xssdfProfileTreeView2.getTopNodes();

        benchmarkNodes = benchmarkNodes.filter(function (node) {
            const benchmarkId = node.getKey();
            return ids.some(function (id) { return id == benchmarkId; });
        });

        return benchmarkNodes;
    },

    anyProfileSelected: function () {
        let profileTreeView = xssdfProfileTreeView2;

        if (typeof profileTreeView === "undefined")
            return false;

        const benchmarkNodes = profileTreeView.getTopNodes();
        let anyProfileChecked = false;

        benchmarkNodes.forEach(function (node) {
            profileTreeView.getNodesByParent(node)
                .forEach(function (profileNode) {
                    if (profileNode.getChecked())
                        anyProfileChecked = true;
                });
        });

        return anyProfileChecked;
    },

    selectAllProfiles: function (benchmarkNodes) {
        benchmarkNodes.forEach(function (node) {
            xssdfProfileTreeView2.getNodesByParent(node)
                .forEach(function (profileNode) {
                    profileNode.setChecked(true);
                });
        });
    },

    selectOnlyDefaultProfiles: function (benchmarkNodes) {
        benchmarkNodes.forEach(function (node) {
            xssdfProfileTreeView2.getNodesByParent(node)
                .forEach(function (profileNode, index) {
                    profileNode.setChecked(false);

                    if (index === 0)
                        profileNode.setChecked(true);
                });
        });
    },
};

var InventoryTreeViewController = {
    onInitComplete: function () {
        this.collapseAll();
    },
};

function isDocker(jobScanType) {
    if (jobScanType === SCAN_TYPE_Docker_Vulnerabilities)
        return true;
    else return false;
}

// #endregion

function setXccdfFileInfo(data) {
    if (data !== '') {
        $('#title').text(data.Name);
        $('#name').text(data.Name);

        $('#version').text(data.Version);

        $('#file').text(data.FilePath);

        var desc = data.Description;
        desc = desc.replace(/•/g, '<br> •');
        $('#description').html(desc);

        var note = data.Notice;
        if (note !== undefined && note !== null) {
            $('#noteTitle').removeClass('hide');
            $('#note').removeClass('hide');
            $('#note').html(note);
        }
        else {
            $('#noteTitle').addClass('hide');
            $('#note').addClass('hide');
        }

        var platform = data.Platforms;
        if (platform != undefined) {
            var ovalLink = "";
            var lang = getCookie("lang");
            if (lang === "ru")
                ovalLink = "https://ovaldbru.altx-soft.ru/Definition.aspx?id=";
            else ovalLink = "https://ovaldbru.altx-soft.ru/en/Definition.aspx?id=";
            var result = "";

            let platformBlock = document.getElementById('platforms');
            document.getElementById('platformBlock').classList.add('hide');
            platformBlock.innerHTML = '';

            let productBlock = document.getElementById('products');
            document.getElementById('productBlock').classList.add('hide');
            productBlock.innerHTML = '';
            for (var i = 0; i < platform.length; i++) {
                function fillResult(platform) {
                    let result = '';
                    if (platform.Result != undefined) {
                        result += "<div class=\"oval-result-img-block " + getCssForOvalResult(platform.Result) + "\" ></div>"
                    }
                    result += "<a target=\"_blank\" href=\"" + ovalLink + platform.OvalId + "\">" + platform.Name + "</a> (" + platform.Cpe + ")<br/>";

                    return result;
                }

                if (platform[i].Cpe.indexOf("cpe:/o") == 0) {
                    document.getElementById('platformBlock').classList.remove('hide');
                    platformBlock.insertAdjacentHTML('beforeend', fillResult(platform[i]));
                }
                if (platform[i].Cpe.indexOf("cpe:/a") == 0) {
                    document.getElementById('productBlock').classList.remove('hide');
                    productBlock.insertAdjacentHTML('beforeend', fillResult(platform[i]));
                }
            }
        }
    }
}

function getCssForOvalResult(result) {
    switch (result) {
        case 1: //True
            return "oval-result-TRUE";
        case 2: //False
            return "oval-result-FALSE";
        case 3: //Unknown
            return "oval-result-ERROR";
        case 4: //Error
            return "oval-result-ERROR";
        case 5: //NotEvaluated
            return "oval-result-NOTEVALUATED";
        case 6: //NotApplicable
            return "oval-result-NOTAPPLICABLE";
    }
}

function getCookie(cname) {
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) === 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function setCookie(name, value) {
    document.cookie = encodeURIComponent(name) + '=' + encodeURIComponent(value);
}

function addClass(cell) {
    cell.classList.add("dxgv");
    cell.classList.add("cell");
}

function closeModal() {
    $(".dialog").dialog("close");
}

function severityChoiseHandler() {
    $('.checkboxSeverity').on('change', function () {
        if ($('.checkboxSeverity:checkbox:checked').length > 0)
            $('#checkAll').prop("checked", true);
        if ($('.checkboxSeverity:checkbox:checked').length == 0)
            $('#checkAll').prop("checked", false);
    });

    $('.checkboxResult').on('change', function () {
        if ($('.checkboxResult:checkbox:checked').length > 0)
            $('#checkResultAll').prop("checked", true);
        if ($('.checkboxResult:checkbox:checked').length == 0)
            $('#checkResultAll').prop("checked", false);
    });
}

function openPopup() {
    checkAll = $('#checkAll').prop("checked");
    checkHigh = $('#checkHigh').prop("checked");
    checkInfo = $('#checkInfo').prop("checked");
    checkUnknown = $('#checkUnknown').prop("checked");
    checkMedium = $('#checkMedium').prop("checked");
    checkLow = $('#checkLow').prop("checked");
    checkCritical = $('#checkCritical').prop("checked");
}

function openResultPopup() {
    checkResultAll = $('#checkResultAll').prop("checked");
    checkError = $('#checkError').prop("checked");
    checkFail = $('#checkFail').prop("checked");
    checkFixed = $('#checkFixed').prop("checked");
    checkInformational = $('#checkInformational').prop("checked");
    checkNotApplicable = $('#checkNotApplicable').prop("checked");
    checkNotChecked = $('#checkNotChecked').prop("checked");
    checkNotSelected = $('#checkNotSelected').prop("checked");
    checkPass = $('#checkPass').prop("checked");
    checkResultUnknown = $('#checkResultUnknown').prop("checked");
}

function severityInnerClick() {
    let data = {
        index: 0,
        itemArray: [],
        flags: ''
    }

    fillDataForFilter(data, 'checkHigh', 'severityHigh', 'block-high');
    fillDataForFilter(data, 'checkInfo', 'severityInfo', 'block-info');
    fillDataForFilter(data, 'checkMedium', 'severityMedium', 'block-medium');
    fillDataForFilter(data, 'checkUnknown', 'severityUnknown', 'block-unknown');
    fillDataForFilter(data, 'checkLow', 'severityLow', 'block-low');
    fillDataForFilter(data, 'checkCritical', 'severityCritical', 'block-critical');

    return data;
}

function severityFilterClickForStat(popoverId) {
    let severities = severityInnerClick();
    setResultFlagsForFilters('popupLabel', severities.flags, severities.index, 6);
    $('#' + popoverId).addClass("hidden");
    PentestResultGridController.reload();
}

function severityFilterClick(isScanResult) {
    let results = resultInnerClick();
    let severities = severityInnerClick();
    sortingCompliance(isScanResult, severities.itemArray, results.itemArray)
    $('#severityPopover').addClass("hidden");
    setResultFlagsForFilters('popupLabel', severities.flags, severities.index, 5);
}

function resultFilterClick() {
    let results = resultInnerClick();
    let severities = severityInnerClick();
    sortingCompliance(true, severities.itemArray, results.itemArray)
    $('#resultPopover').addClass("hidden");
    setResultFlagsForFilters('popupResultLabel', results.flags, results.index, 9);
}

function sortingCompliance(isScanResult, severityArray, resultArray) {
    let nodes = [];
    if (isScanResult)
        nodes = Array.from(document.querySelectorAll('li[class*=severity][class*=result]'));
    else nodes = Array.from(document.querySelectorAll('li[class*=severity]'));

    nodes.forEach(function (node) {
        if (complianceItemsCondition(node, severityArray, resultArray, isScanResult))
            node.classList.remove('hide');
        else node.classList.add('hide');
    });
}

function complianceItemsCondition(node, severityArray, resultArray, isScanResult) {
    if (isScanResult)
        return severityArray.some(function (className) { return node.classList.contains(className); })
            && resultArray.some(function (className) { return node.classList.contains(className); });
    else return severityArray.some(function (className) {
        return node.classList.contains(className)
    });
}

function setResultFlagsForFilters(componentName, flags, index, count) {
    if (index === 0)
        $('#' + componentName).text('Нет');
    if (index > 0 && index < count)
        $('#' + componentName).html(flags);

    if (index === count)
        $('#' + componentName).text('Все');
}

function fillDataForFilter(data, checkName, itemName, blockdName) {
    if ($('#' + checkName).prop("checked") === true) {
        data.itemArray.push(itemName);
        data.flags += "<div class=\"" + blockdName + " block-border\"></div>";
        data.index++;
    }
}

function resultInnerClick() {
    let data = {
        index: 0,
        itemArray: [],
        flags: ''
    }

    fillDataForFilter(data, 'checkError', 'resultError', 'legend-error');
    fillDataForFilter(data, 'checkFail', 'resultFail', 'legend-fail');
    fillDataForFilter(data, 'checkFixed', 'resultFixed', 'legend-fixed');
    fillDataForFilter(data, 'checkInformational', 'resultInformational', 'legend-informational');
    fillDataForFilter(data, 'checkNotApplicable', 'resultNotApplicable', 'legend-notapplicable');
    fillDataForFilter(data, 'checkNotChecked', 'resultNotChecked', 'legend-notchecked');
    fillDataForFilter(data, 'checkNotSelected', 'resultNotSelected', 'legend-notselected');
    fillDataForFilter(data, 'checkPass', 'resultPass', 'legend-pass');
    fillDataForFilter(data, 'checkResultUnknown', 'resultUnknown', 'legend-unknown');

    return data;
}

function complianceCheckSelect(itemsArray, flag) {
    itemsArray.forEach(function (x) {
        $('#' + x).prop('checked', flag);
    });
}

function checkAllSeverityClick(s, e) {
    if ($('#checkAll').prop('checked') === true)
        complianceCheckSelect(['checkCritical', 'checkHigh', 'checkInfo', 'checkMedium', 'checkUnknown', 'checkLow'], true);

    if ($('#checkAll').prop('checked') === false)
        complianceCheckSelect(['checkCritical', 'checkHigh', 'checkInfo', 'checkMedium', 'checkUnknown', 'checkLow'], false);
}

function checkAllResultClick(s, e) {
    if ($('#checkResultAll').prop('checked') === true)
        complianceCheckSelect(['checkError', 'checkFail', 'checkFixed', 'checkInformational', 'checkNotApplicable', 'checkNotChecked', 'checkNotSelected', 'checkPass', 'checkResultUnknown'], true);

    if ($('#checkResultAll').prop('checked') === false)
        complianceCheckSelect(['checkError', 'checkFail', 'checkFixed', 'checkInformational', 'checkNotApplicable', 'checkNotChecked', 'checkNotSelected', 'checkPass', 'checkResultUnknown'], false);
}

function closePopup() {
    $('#checkAll').prop("checked", checkAll);
    $('#checkHigh').prop("checked", checkHigh);
    $('#checkInfo').prop("checked", checkInfo);
    $('#checkUnknown').prop("checked", checkUnknown);
    $('#checkMedium').prop("checked", checkMedium);
    $('#checkLow').prop("checked", checkLow);
    $('#checkCritical').prop("checked", checkCritical);
}

function closeResultPopup() {
    $('#checkResultAll').prop("checked", checkResultAll);
    $('#checkError').prop("checked", checkError);
    $('#checkFail').prop("checked", checkFail);
    $('#checkFixed').prop("checked", checkFixed);
    $('#checkInformational').prop("checked", checkInformational);
    $('#checkNotApplicable').prop("checked", checkNotApplicable);
    $('#checkNotChecked').prop("checked", checkNotChecked);
    $('#checkNotSelected').prop("checked", checkNotSelected);
    $('#checkPass').prop("checked", checkPass);
    $('#checkResultUnknown').prop("checked", checkResultUnknown);

    $('#resultPopover').addClass("hidden");
}

function checkAccountPass() {
    checkPasswordBlock('OldPassword', 'NewPassword', 'errAccPass', 'okAccPass');
}

function checkPasswordBlock(passId, confirmPassId, imgIdErr, imgIdOk) {
    if (document.getElementById(confirmPassId) === null) {
        return;
    }
    
    if (document.getElementById(passId).value != '' && document.getElementById(confirmPassId).value != '') {
        if (document.getElementById(passId).value !== document.getElementById(confirmPassId).value) {
            document.getElementById(imgIdErr).classList.remove('hide');
            document.getElementById(imgIdOk).classList.add('hide');
        }
        if (document.getElementById(passId).value === document.getElementById(confirmPassId).value) {
            document.getElementById(imgIdOk).classList.remove('hide');
            document.getElementById(imgIdErr).classList.add('hide');
        }
    } else {
        if (document.getElementById(passId).value == '' && document.getElementById(confirmPassId).value == '') {
            document.getElementById(imgIdOk).classList.add('hide');
            document.getElementById(imgIdErr).classList.add('hide');
        } else if (document.getElementById(confirmPassId).value === '') {
            document.getElementById(imgIdOk).classList.add('hide');
            document.getElementById(imgIdErr).classList.add('hide');
        } else {
            document.getElementById(imgIdOk).classList.add('hide');
            document.getElementById(imgIdErr).classList.remove('hide');
        }
    }
}

function checkCredentialName() {
    if (document.getElementById('CredentialName').value.length === 0) {
        $('.ui-dialog-buttonset > button').attr('disabled', 'disabled');
    }
    else {
        $('.ui-dialog-buttonset > button').removeAttr('disabled');
    }
}

function dateRange_OnSelectedIndexChanged(select) {
    const dateFrom = document.getElementById('DateFrom');
    const dateFromPicker = document.getElementById('DateFromPicker');
    const dateTo = document.getElementById('DateTo');
    const dateToPicker = document.getElementById('DateToPicker');

    // Check ComboBox value
    var enabledState = select.value === "Other";

    // Enable/disable desired controls
    dateFrom.disabled = !enabledState;
    dateFromPicker.disabled = !enabledState;

    dateTo.disabled = !enabledState;
    dateToPicker.disabled = !enabledState;
}

function initDatePickerFields() {
    $('#DateFromPicker').datepicker({
        changeMonth: true,
        changeYear: true,
        showWeek: true,
        weekHeader: '',
        showButtonPanel: true,
        yearRange: '2000:+nn',
        minDate: new Date(2000, 0, 1),
        maxDate: '+0d',
        dateFormat: 'dd.mm.yy',
        altField: '#DateFrom',
        altFormat: 'dd.mm.yy 0:00:00'
    });

    $('#DateToPicker').datepicker({
        changeMonth: true,
        changeYear: true,
        showWeek: true,
        weekHeader: '',
        showButtonPanel: true,
        yearRange: '2000:+nn',
        minDate: new Date(2000, 0, 1),
        maxDate: '+0d',
        dateFormat: 'dd.mm.yy',
        altField: '#DateTo',
        altFormat: 'dd.mm.yy 23:59:59'
    });
}

function onPopupShow(s, e) {
    var popupControl = ASPxClientControl.GetControlCollection().GetByName(s.name);
    var windowElement = popupControl.GetWindowElement(-1);
    var y = Math.max(0, ($(window).height() - $(windowElement).outerHeight()) / 2 + $(window).scrollTop());
    var x = Math.max(0, ($(window).width() - $(windowElement).outerWidth()) / 2 + $(window).scrollLeft());

    popupControl.ShowAtPos(x, y);
}

// #region Hosts

function AdImportOnGetHostRowValues(value) {
    $('#Filter_HostName').val(value[1]);
    $('#Filter_HostId').val(value[0]);

    AdImportHostsController.CheckValidAdData();
}

function OnGetHostRowValues(value) {
    var hostNameTextbox = document.getElementById('HostName');
    if (hostNameTextbox !== null)
        hostNameTextbox.value = value[1];
    if ($('#HostId') !== null)
        $('#HostId').val(value[0]);

    if (document.getElementById('AdUsersGrid') !== null) {
        document.getElementById('HostName').value = value[1];
        AdUsersController.CheckValidAdData();
    }
}

// #endregion

// #region Credentials

function GetCredentialTypesByJobScanType(jobScanType) {
    if (jobScanType === SCAN_TYPE_Compliance) {
        return [
            CREDENTIAL_TYPE_Windows, 
            CREDENTIAL_TYPE_VMware, 
            CREDENTIAL_TYPE_Ssh,
            CREDENTIAL_TYPE_Solaris,
            CREDENTIAL_TYPE_Huawei,
            CREDENTIAL_TYPE_Cisco,
            CREDENTIAL_TYPE_CheckPoint,
            CREDENTIAL_TYPE_FortiOs,
            CREDENTIAL_TYPE_UserGate,
            CREDENTIAL_TYPE_Eltex,
            CREDENTIAL_TYPE_OpenShift,
            CREDENTIAL_TYPE_Sql
        ];
    }
    
    if (jobScanType === SCAN_TYPE_Vulnerability || jobScanType === SCAN_TYPE_Patch || jobScanType === SCAN_TYPE_Inventory) {
        var types = [CREDENTIAL_TYPE_Windows, CREDENTIAL_TYPE_VMware, CREDENTIAL_TYPE_Ssh];

        if (jobScanType === SCAN_TYPE_Vulnerability) {
            types.push(CREDENTIAL_TYPE_FreeBsd);
            types.push(CREDENTIAL_TYPE_Solaris);
            types.push(CREDENTIAL_TYPE_Cisco);
            types.push(CREDENTIAL_TYPE_CheckPoint);
            types.push(CREDENTIAL_TYPE_FortiOs);
            types.push(CREDENTIAL_TYPE_UserGate);
            types.push(CREDENTIAL_TYPE_Eltex);
        }

        if (jobScanType === SCAN_TYPE_Inventory) {
            types.push(CREDENTIAL_TYPE_Cisco);
            types.push(CREDENTIAL_TYPE_CheckPoint);
            types.push(CREDENTIAL_TYPE_FortiOs);
            types.push(CREDENTIAL_TYPE_UserGate);
            types.push(CREDENTIAL_TYPE_Eltex);
        }

        return types;
    }
    if (isDocker(jobScanType) || jobScanType === SCAN_TYPE_Yara) {
        return [CREDENTIAL_TYPE_Ssh];
    }
    if (jobScanType === SCAN_TYPE_Fixation) {
        return [CREDENTIAL_TYPE_Windows, CREDENTIAL_TYPE_Ssh]; //CREDENTIAL_TYPE_Cisco
    }
    if (jobScanType === SCAN_TYPE_Remediation) {
        return [CREDENTIAL_TYPE_Windows];
    }

    return null;
}

function getCredentialTypesByPingType(pingType) {
    switch (pingType) {
        case 'Agent':
        case 'UpdateAgent':
        case 'Wmi':
        case 'Winrm':
            return [CREDENTIAL_TYPE_Windows];
        case 'Ssh':
            return [CREDENTIAL_TYPE_Ssh, CREDENTIAL_TYPE_Solaris, CREDENTIAL_TYPE_FreeBsd, CREDENTIAL_TYPE_CheckPoint, CREDENTIAL_TYPE_Cisco, CREDENTIAL_TYPE_Huawei, CREDENTIAL_TYPE_FortiOs, CREDENTIAL_TYPE_Eltex];
        case 'Http':
            return [CREDENTIAL_TYPE_VMware, CREDENTIAL_TYPE_UserGate, CREDENTIAL_TYPE_OpenShift];
        case 'Sql':
            return [CREDENTIAL_TYPE_Sql];
    }
    return [];
}

function GetCiscoOsTypesByJobScanType(jobScanType) {
    var ciscoTypes = [];

    if (jobScanType === SCAN_TYPE_Vulnerability || jobScanType === SCAN_TYPE_Compliance || jobScanType === SCAN_TYPE_Inventory) {
        ciscoTypes.push(CREDENTIAL_SUBTYPE_CiscoIos);
        ciscoTypes.push(CREDENTIAL_SUBTYPE_CiscoNxos);
    }

    if (jobScanType === SCAN_TYPE_Fixation) {
        ciscoTypes.push(CREDENTIAL_SUBTYPE_CiscoIos);
    }

    return ciscoTypes;
}

const JOB_AGENT_TYPE_Agentless = "Agentless";
const JOB_AGENT_TYPE_Agent = "Agent";
const JOB_AGENT_TYPE_TempAgent = "TempAgent";

JobSourceCollection = {};
JobSourceCollection[SCAN_TYPE_Patch] = [JOB_AGENT_TYPE_Agent, JOB_AGENT_TYPE_Agentless, JOB_AGENT_TYPE_TempAgent];
JobSourceCollection[SCAN_TYPE_Vulnerability] = [JOB_AGENT_TYPE_Agent, JOB_AGENT_TYPE_Agentless, JOB_AGENT_TYPE_TempAgent];
JobSourceCollection[SCAN_TYPE_Scada] = [JOB_AGENT_TYPE_Agentless];
JobSourceCollection[SCAN_TYPE_Inventory] = [JOB_AGENT_TYPE_Agent, JOB_AGENT_TYPE_Agentless, JOB_AGENT_TYPE_TempAgent];
JobSourceCollection[SCAN_TYPE_Fixation] = [JOB_AGENT_TYPE_Agent, JOB_AGENT_TYPE_TempAgent];
JobSourceCollection[SCAN_TYPE_Remediation] = [JOB_AGENT_TYPE_Agent];
JobSourceCollection[SCAN_TYPE_Nmap] = [JOB_AGENT_TYPE_Agentless];
JobSourceCollection[SCAN_TYPE_HostDiscovery] = [JOB_AGENT_TYPE_Agentless];
JobSourceCollection[SCAN_TYPE_Compliance] = [JOB_AGENT_TYPE_Agent, JOB_AGENT_TYPE_TempAgent];

function GetAvailableJobAgentScTypes(jobScanType, credentialType) {
    var result = JobSourceCollection[jobScanType];

    if (credentialType === CREDENTIAL_TYPE_Ssh ||
        credentialType === CREDENTIAL_TYPE_Cisco ||
        credentialType === CREDENTIAL_TYPE_Huawei ||
        credentialType === CREDENTIAL_TYPE_VMware ||
        credentialType === CREDENTIAL_TYPE_Solaris ||
        credentialType === CREDENTIAL_TYPE_FreeBsd ||
        credentialType === CREDENTIAL_TYPE_CheckPoint ||
        credentialType === CREDENTIAL_TYPE_FortiOs ||
        credentialType === CREDENTIAL_TYPE_UserGate ||
        credentialType === CREDENTIAL_TYPE_Eltex ||
        credentialType === CREDENTIAL_TYPE_OpenShift
    ) {
        result = [JOB_AGENT_TYPE_Agentless];
    }
    
    if (result === undefined || result.length === 0) 
        return;
    
    // Removing Agentless transport for Windows creds since Agentless for Windows (WMI) is disabled
    let agentlessIdx = result.indexOf(JOB_AGENT_TYPE_Agentless);
    if(credentialType === CREDENTIAL_TYPE_Windows && agentlessIdx > -1) {
        result.splice(agentlessIdx, 1);
    }

    return result;
}

function AddAgentTypeTextBasedOnCred(value, credentialType) {
    if (value === JOB_AGENT_TYPE_Agentless && credentialType === CREDENTIAL_TYPE_Windows)
        return agentTypesTexts[value] + " WMI";
    else
        return agentTypesTexts[value];
}

var CredentialsPopupControler = {
    needSelectCredentialMessage: 'Выберите учётные данные',
    filterCredentialsGrid: null,
    currentPopupElement: null,
    isUseCheckBox: false,

    onShow: function (event) {
        const button = event.relatedTarget;
        CredentialsPopupControler.setCurrentPopupElement(button);

        if (button !== undefined && button.dataset.filter !== undefined) {
            const parsedFilter = JSON.parse(event.relatedTarget.dataset.filter);
            CredentialsPopupControler.filterCredentialsGrid.applyFilter(parsedFilter);
        }

        setTimeout(function () {
            $.fn.dataTable.util.columnsAjustSize();
        }, 200);
    },

    onShown: function (event) {
        if (CredentialsPopupControler.filterCredentialsGrid !== null) {
            CredentialsPopupControler.filterCredentialsGrid.deselectAll();
            CredentialsPopupControler.filterCredentialsGrid.reload();
        }
    },

    TableLoad: function (filter) {
        var parsedFilter = JSON.parse(filter);
        const checkbox = document.querySelector('[id*=credentialsModal] input[id*="IsUseCheckBox"]');
        CredentialsPopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;
        if (CredentialsPopupControler.filterCredentialsGrid == null || !CredentialsPopupControler.filterCredentialsGrid.isMount()) {
            CredentialsPopupControler.filterCredentialsGrid = new FilterCredentialsGridComponent({
                root: '#FilterCredentialsGrid',
                ajax: CredentialsPopupControler.createUrlFiltersCredentials(),
                style: CredentialsPopupControler.isUseCheckBox ? 'multi' : 'single',
                showCheckBox: CredentialsPopupControler.isUseCheckBox,
                filter: parsedFilter
            });

            CredentialsPopupControler.filterCredentialsGrid.mount();
        }
    },

    createUrlFiltersCredentials: function () {
        let links = {
            url: '/Credentials/FiltersCredentialsGrid',
            urlItemsId: '/Credentials/ListCredentialsIds',
        }
        return links;
    },

    setFilter: function (filter) {
        CredentialsPopupControler.filterCredentialsGrid.applyFilter(filter);
    },

    selectCredentialButtonClick: function () {
        // Function is overridden for Job Wizard and Job Properties in JobCredentialsGridComponent.selectCredentialButtonClick()

        const selectedRow = CredentialsPopupControler.filterCredentialsGrid.getLastSelectedItem();
        
        if (!selectedRow) {
            notifyWarning(CredentialsPopupControler.needSelectCredentialMessage);
            return;
        }

        const selectedCredential = [
            selectedRow['Id'],
            selectedRow['Name'],
            selectedRow['TypeText'],
            selectedRow['CreationDate'],
            selectedRow['SubType']
        ];

        CredentialsPopupControler.setCredentials(selectedCredential);
    },

    setCredentials: function (value) {
        const lang = getCookie('lang') || 'en';

        value[3] = value[3] ? new Date(value[3]).toLocaleString(lang) : '';

        // Job Properties and Job Wizard
        if ($('#JobProperties').length > 0 || $('#Credentials').length > 0) {
            return;
        }

        $('#credentialsModal').modal('hide');

        SetCredentialsToSettings(value);
        SetNetworkResourceCredential(value);
        checkPing(value);
        SetCredentialsToImportAdImport(value);
        SetCredentialsToEditHosts(value);
        SetCredentialsToAdUser(value);
    },

    setCurrentPopupElement: function (element) {
        CredentialsPopupControler.currentPopupElement = element;
    },

    getCurrentPopupElement: function () {
        return CredentialsPopupControler.currentPopupElement;
    }
};

var NetworkResourcesSettingsController = {
    filterNetworkResourcesGrid: null,

    TableLoad: function (filter, data) {
        if (NetworkResourcesSettingsController.filterNetworkResourcesGrid == null) {
            NetworkResourcesSettingsController.filterNetworkResourcesGrid = new FilterNetworkResourcesSettingsGridComponent({
                root: '#NetworkResourcesGridDelivery',
                ajax: { url: '/NetworkResources/NetworkResourcesGrid' },
                style: 'single',
                filter: filter,
                data: data,
                onResourceIsDefaultChangedFunctionName: "NetworkResourcesSettingsController.onResourceIsDefaultChanged()"
            });

            NetworkResourcesSettingsController.filterNetworkResourcesGrid.mount();
        }
    },
    onResourceIsDefaultChanged: function () {
        var isDefaultIds = [];
        $('input.is-default-checkbox:checked').each(function (i, elem) {
            isDefaultIds.push(parseInt($(elem).data('id')));
        });

        $('#Delivery_DefaultNetworkResourceIds_Value').val(isDefaultIds.sort(function (a, b) { return a - b; }).join());
    }
};

//#region ScanningService Controllers

const ScanningServiceBaseController = {
    selectServiceButtonClick: function (button, grid, needSelectMessage, modal) {
        const selectedRows = grid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(needSelectMessage);
            return;
        }

        ScanningServiceBaseController.setServiceDataToForm(selectedRows[0]);
        $(`#${modal}`).modal('hide');
    },
    setServiceDataToForm: function (value) {
        // id order: JobsFilter, JobMaster, JobProperties
        let serviceNameTextbox = document.querySelector(
            '#ScanningServiceName, #Params_ScanningServiceName, #ScanService_Name');
        let serviceIdHiddenInput = document.querySelector(
            '#ScanningServiceId, #Params_ScanningServiceId, #ScanService_Id');
        let serviceHostOsTypeHiddenInput = document.querySelector(
            '#ScanningServiceHostOsType, #Params_ScanningServiceHostOsType');
        
        if (serviceNameTextbox != null)
            serviceNameTextbox.value = value.name;
        if (serviceIdHiddenInput != null)
            serviceIdHiddenInput.value = value.id;
        if (serviceHostOsTypeHiddenInput != null)
            serviceHostOsTypeHiddenInput.value = value.hostOsType;
    }
}

const ScanningServiceJobsFilterPopupControler = {
    needSelectScanningServicesMessage: 'Выберите службу сканирования',
    grid: null,

    TableLoad: function () {
        if (ScanningServiceJobsFilterPopupControler.grid == null || !ScanningServiceJobsFilterPopupControler.grid.isMount()) {
            ScanningServiceJobsFilterPopupControler.grid = new ScanningServicesJobsFilterGridComponent({
                root: '#scanningServicesFilterGrid',
                ajax: { url: '/Components/ScanningServicesGrid' },
                style: 'single'
            });
        }
    },

    onShown: function () {
        if (ScanningServiceJobsFilterPopupControler.grid) {
            if (!ScanningServiceJobsFilterPopupControler.grid.isMount()) {
                ScanningServiceJobsFilterPopupControler.grid.mount();
            } else {
                ScanningServiceJobsFilterPopupControler.grid.$api.selectCustom().deselectAll().draw();
            }
        }
    },
    selectServiceButtonClick: function (button) {
        ScanningServiceBaseController.selectServiceButtonClick(
            button,
            ScanningServiceJobsFilterPopupControler.grid,
            ScanningServiceJobsFilterPopupControler.needSelectScanningServicesMessage,
            'scanningServicesFilterModal')
    }
};

const ScanningServiceSelectionPopupControler = {
    needSelectScanningServicesMessage: 'Выберите службу сканирования',
    grid: null,

    TableLoad: function () {
        if (ScanningServiceSelectionPopupControler.grid == null || !ScanningServiceSelectionPopupControler.grid.isMount()) {
            ScanningServiceSelectionPopupControler.grid = new ScanningServicesStatusGridComponent({
                root: '#scanningServicesSelectionGrid',
                ajax: { url: '/Components/ScanningServicesGrid' },
                style: 'single'
            });
        }
    },

    onShown: function () {
        if (ScanningServiceSelectionPopupControler.grid) {
            if (!ScanningServiceSelectionPopupControler.grid.isMount()) {
                ScanningServiceSelectionPopupControler.grid.mount();
            } else {
                ScanningServiceSelectionPopupControler.grid.$api.selectCustom().deselectAll().draw();
            }
        }
    },
    selectServiceButtonClick: function (button) {
        ScanningServiceBaseController.selectServiceButtonClick(
            button,
            ScanningServiceSelectionPopupControler.grid,
            ScanningServiceSelectionPopupControler.needSelectScanningServicesMessage,
            'scanningServicesSelectionModal')
    }
};

const ScanningServiceStatusPopupControler = {
    grid: null,

    TableLoad: function () {
        if (ScanningServiceStatusPopupControler.grid == null || !ScanningServiceStatusPopupControler.grid.isMount()) {
            ScanningServiceStatusPopupControler.grid = new ScanningServicesStatusGridComponent({
                root: '#filterScanningServicesStatusGrid',
                ajax: { url: '/Components/ScanningServicesGrid' },
                style: 'single'
            });
        }
    },

    onShown: function () {
        if (ScanningServiceStatusPopupControler.grid) {
            if (!ScanningServiceStatusPopupControler.grid.isMount()) {
                ScanningServiceStatusPopupControler.grid.mount();
            } else {
                ScanningServiceStatusPopupControler.grid.$api.selectCustom().deselectAll().draw();
            }
        }
        ScanStatusBarController.setStatus();
    },
    updateServiceButtonClick: function (button) {
        ScanningServiceStatusPopupControler.grid.$api.ajax.reload();
        ScanStatusBarController.setStatus();
    },
}
//#endregion


var NetworkResourcesController = {
    cpFilter: [],
    filterNetworkResourcesGrid: null,
    htmlFormParametersPrefix: null,

    LoadNotificationSettings: function (data) {
        var parsedData = JSON.parse(data);
        var idParameterPrefix = 'Params_';
        var nameParameterPrefix = 'Params.';

        for (let i = 0; i < parsedData.length; i++) {
            var networkResourceBaseId = 'NetworkResourceIds_' + parsedData[i].NetworkResourceId;
            var networkResourceBaseName = 'NetworkResourceIds[' + i + ']';
            var baseId = 'UserNotificationSettings_' + parsedData[i].NetworkResourceId;
            var baseName = 'UserNotificationSettings[' + i + ']';

            if ($('#' + baseId + '_NetworkResourceId').length === 0) {
                var inputNetworkResource = $('<input type="hidden">')
                    .attr('id', networkResourceBaseId)
                    .attr('name', networkResourceBaseName)
                    .val(parsedData[i].NetworkResourceId);

                var inputNotificationSettingsId = $('<input type="hidden">')
                    .attr('id', baseId + '_NetworkResourceId')
                    .attr('name', baseName + '.NetworkResourceId')
                    .val(parsedData[i].NetworkResourceId);

                var inputNotificationSettingsSubject = $('<input type="hidden">')
                    .attr('id', baseId + '_Subject')
                    .attr('name', baseName + '.Subject')
                    .val(parsedData[i].Subject);

                var inputNotificationSettingsTriggers = $('<input type="hidden">')
                    .attr('id', baseId + '_Triggers')
                    .attr('name', baseName + '.Triggers')
                    .val(parsedData[i].Triggers);

                $('#NetworkResourcesGrid').append(inputNetworkResource, inputNotificationSettingsId, inputNotificationSettingsSubject, inputNotificationSettingsTriggers);
            }
        }
    },

    TableLoad: function (filter) {
        var parsedFilter = JSON.parse(filter);
        if (parsedFilter.Resources === null || parsedFilter.Resources.length === 0) {
            parsedFilter.Resources = [0];
        }
        NetworkResourcesController.htmlFormParametersPrefix = parsedFilter.HtmlFormParametersPrefix;
        if (NetworkResourcesController.filterNetworkResourcesGrid == null) {
            NetworkResourcesController.filterNetworkResourcesGrid = new FilterNetworkResourcesGridComponent({
                root: '#NetworkResourcesGrid',
                ajax: { url: '/Jobs/CreateJobNetworkResourcesGrid' },
                style: 'single',
                filter: JSON.stringify(parsedFilter),
                needHideExtraColumns: parsedFilter.HtmlFormParametersPrefix === 'Sync',
                initComplete: function (settings, json) {
                    var networkResourcesFilter = JSON.parse(NetworkResourcesController.filterNetworkResourcesGrid.networkResourceFilter);
                    networkResourcesFilter.resources = json.data !== undefined && json.data.length > 0 ? json.data.map(function (item) { return { id: item.Id } }) : [{ id: 0 }];
                    NetworkResourcesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify(networkResourcesFilter));
                    NetworkResourcesController.ApplySelectedNetworkResources(networkResourcesFilter.resources);
                }
            });

            NetworkResourcesController.filterNetworkResourcesGrid.mount();
        }
    },

    ShowSelectedNetworkResources: function (newResources) {
        const currentResources = NetworkResourcesController.filterNetworkResourcesGrid.getAllItems().toArray().map(function (item) {
            return { id: parseInt(item['Id']) };
        });
        newResources = newResources.filter(function (newEl) { return currentResources.filter(function (curEl) { return newEl.id === curEl.id }).length === 0 });
        const unionResources = currentResources.concat(newResources);
        NetworkResourcesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify({ resources: unionResources }));
        NetworkResourcesController.filterNetworkResourcesGrid.reload();

        NetworkResourcesController.ApplySelectedNetworkResources(unionResources);
    },

    ApplySelectedNetworkResources: function (networkResources) {
        var idParameterPrefix = NetworkResourcesController.htmlFormParametersPrefix
            ? NetworkResourcesController.htmlFormParametersPrefix + '_'
            : '';
        var nameParameterPrefix = NetworkResourcesController.htmlFormParametersPrefix
            ? NetworkResourcesController.htmlFormParametersPrefix + '.'
            : '';

        var currentResourceIds = networkResources
            .filter(r => r.id > 0)
            .map(r => r.id);

        $('#Sync_SyncNetworkResourceIds_Value').val(currentResourceIds);

        var defaultSubjectFromSettings =
            (document.getElementById('Params_DefaultNotificationSubject')?.value || document.getElementById('DefaultNotificationSubject')?.value || 'Тема по умолчанию');
        var defaultTriggersFromSettings = [
            ['1', (document.getElementById('Params_JobCompletedNotification')?.value
                || document.getElementById('JobCompletedNotification')?.value) === "True"],

            ['2', (document.getElementById('Params_JobFailedNotification')?.value
                || document.getElementById('JobFailedNotification')?.value) === "True"],

            ['3', (document.getElementById('Params_ControlMismatchNotification')?.value
                || document.getElementById('ControlMismatchNotification')?.value) === "True"]
        ].filter(item => item[1]).map(item => item[0]).join(',');

        for (var i = 0; i < currentResourceIds.length; i++) {
            
            var networkResourceBaseId = idParameterPrefix + 'NetworkResourceIds_' + currentResourceIds[i];
            var networkResourceBaseName = nameParameterPrefix + 'NetworkResourceIds[' + i + ']';
            var baseId = idParameterPrefix + 'UserNotificationSettings_' + currentResourceIds[i];
            var baseName = nameParameterPrefix + 'UserNotificationSettings[' + i + ']';

            if ($('#' + baseId + '_NetworkResourceId').length === 0) {
                var inputNetworkResource = $('<input type="hidden">')
                    .attr('id', networkResourceBaseId)
                    .attr('name', networkResourceBaseName)
                    .val(currentResourceIds[i]);

                var inputNotificationSettingsId = $('<input type="hidden">')
                    .attr('id', baseId + '_NetworkResourceId')
                    .attr('name', baseName + '.NetworkResourceId')
                    .val(currentResourceIds[i]);

                var inputNotificationSettingsSubject = $('<input type="hidden">')
                    .attr('id', baseId + '_Subject')
                    .attr('name', baseName + '.Subject')
                    .val(defaultSubjectFromSettings);

                var inputNotificationSettingsTriggers = $('<input type="hidden">')
                    .attr('id', baseId + '_Triggers')
                    .attr('name', baseName + '.Triggers')
                    .val(defaultTriggersFromSettings);

                $('#NetworkResourcesGrid').append(inputNetworkResource, inputNotificationSettingsId, inputNotificationSettingsSubject, inputNotificationSettingsTriggers);
            }
        };

        $('#NetworkResourcesGrid input[type="hidden"][id*="NetworkResourceIds_"]').each(function() {
            var matches = $(this).attr('id').match(/NetworkResourceIds_(\d+)/);
            if (matches) {
                var resourceId = parseInt(matches[1]);
                if (!currentResourceIds.includes(resourceId)) {
                    $('#'+idParameterPrefix+'NetworkResourceIds_' + resourceId).remove();
                    $('#'+idParameterPrefix+'UserNotificationSettings_' + resourceId + '_NetworkResourceId').remove();
                    $('#'+idParameterPrefix+'UserNotificationSettings_' + resourceId + '_Subject').remove();
                    $('#'+idParameterPrefix+'UserNotificationSettings_' + resourceId + '_Triggers').remove();
                }
            }
        });
    },

    DeleteNetworkResource: function (sender, data) {
        var networkResourcesFilter = JSON.parse(NetworkResourcesController.filterNetworkResourcesGrid.networkResourceFilter);
        if (networkResourcesFilter.resources !== undefined) {
            networkResourcesFilter.resources = networkResourcesFilter.resources.filter(function (value, index, arr) {
                return value.id !== data["Id"];
            });

            if (networkResourcesFilter.resources.length == 0) {
                networkResourcesFilter.resources = [{ id: 0 }];
            }

            NetworkResourcesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify(networkResourcesFilter));
            NetworkResourcesController.filterNetworkResourcesGrid.reload();
            NetworkResourcesController.ApplySelectedNetworkResources(networkResourcesFilter.resources);
        }
    },

    EditNetworkResource: function (sender, data) {
        let id = data["Id"];
        let email = data["Path"];
        $('#userNotificationSettingsModal').attr('data-network-resource-id', id);
        $('#userNotificationSettingsModal').attr('data-network-resource-email', email);
        $('#userNotificationSettingsModal').modal('show');
    }
};

var NetworkResourcesPopupController = {
    needSelectNetworkResourceMessage: 'Выберите сетевые ресурсы',
    filterNetworkResourcesGrid: null,

    TableLoad: function (filter) {
        var parsedFilter = JSON.parse(filter);
        if (NetworkResourcesPopupController.filterNetworkResourcesGrid == null) {
            NetworkResourcesPopupController.filterNetworkResourcesGrid = new FilterNetworkResourcesPopupGridComponent({
                root: '#FilterNetworkResourcesGrid',
                ajax: NetworkResourcesPopupController.createUrlFiltersHosts(),
                style: 'multi',
                filter: JSON.stringify(parsedFilter)
            });

            NetworkResourcesPopupController.filterNetworkResourcesGrid.mount();
        }
    },

    onShown: function () {
        if (NetworkResourcesPopupController.filterNetworkResourcesGrid != null) {
            NetworkResourcesPopupController.filterNetworkResourcesGrid.$api.selectCustom().deselectAll().draw();
        }
    },

    selectNetworkResourcesButtonClick: function () {
        const selectedRows = NetworkResourcesPopupController.filterNetworkResourcesGrid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(NetworkResourcesPopupController.needSelectNetworkResourceMessage);
            return;
        }

        NetworkResourcesPopupController.ShowSelectedNetworkResources(selectedRows);
    },

    ShowSelectedNetworkResources: function (newResources) {
        const newResourceIds = newResources.map(function (resource) {
            return { id: resource.id };
        });

        NetworkResourcesController.ShowSelectedNetworkResources(newResourceIds);
    },

    createUrlFiltersHosts: function () {
        let links = {
            url: '/NetworkResources/NetworkResourcesGrid',
            urlItemsId: '/NetworkResources/ListNetworkResourceIds',
        }

        return links;
    }
};

var ReportTemplateNetworkResourcesPopupController = {
    needSelectNetworkResourceMessage: 'Выберите сетевые ресурсы',
    filterNetworkResourcesGrid: null,

    TableLoad: function (filter) {
        let networkResourceFilter = filter;
        if (initReportTEmplateNetworkResourcePopupFilter) {
            networkResourceFilter = initReportTEmplateNetworkResourcePopupFilter;
        }

        if (!ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid || !ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid.isMount()) {
            ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid = new FilterReportTemplateNetworkResourcesPopupGridComponent({
                root: '#FilterReportTemplateNetworkResourcesGrid',
                ajax: ReportTemplateNetworkResourcesPopupController.createUrlFiltersHosts(),
                style: 'multi',
                filter: networkResourceFilter
            });
        }
    },

    onShow: function () {
        if (ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid != null) {
            if (!ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid.isMount()) {
                ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid.mount();
            } else {
                ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid.$api.selectCustom().deselectAll().draw();
            }
        }
    },

    selectNetworkResourcesButtonClick: function () {
        const selectedRows = ReportTemplateNetworkResourcesPopupController.filterNetworkResourcesGrid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(ReportTemplateNetworkResourcesPopupController.needSelectNetworkResourceMessage);
            return;
        }

        ReportTemplateNetworkResourcesPopupController.ShowSelectedNetworkResources(selectedRows);
        $('#ReportTemplateNetworkResourcesModal').modal('hide');
    },

    ShowSelectedNetworkResources: function (newResourceRows) {
        const newResources = newResourceRows.map(function (resource) {
            return { id: resource.id };
        });

        ReportTemplatesController.ShowSelectedNetworkResources(newResources);
    },

    createUrlFiltersHosts: function () {
        let links = {
            url: '/NetworkResources/NetworkResourcesGrid',
            urlItemsId: '/NetworkResources/ListNetworkResourceIds',
        }

        return links;
    }
};

const ReportTemplatesStore = {
    urlForJobMaster: '/Jobs/CreateJobsReportTemplatesGrid',
    urlForJobProperties: '',
    
    setUrlForJobProperties(url) {
        ReportTemplatesStore.urlForJobProperties = url;
    },
    
    getAjaxSettings: function () {
        let url = ReportTemplatesStore.urlForJobProperties;
        
        if (typeof currentJobProperties !== 'undefined') {
            url = ReportTemplatesStore.urlForJobMaster;
        }

        return { url: url };
    },
};

var ReportTemplatesController = {
    reportsDeliverySettings: [],
    cpFilter: [],
    filterReportTemplatesGrid: null,
    filterNetworkResourcesGrid: null,
    htmlFormParametersPrefix: null,

    TableLoad: function (filter) {
        var parsedFilter = JSON.parse(filter);
        ReportTemplatesController.htmlFormParametersPrefix = parsedFilter.HtmlFormParametersPrefix;
        ReportTemplatesController.filterReportTemplatesGrid = new FilterReportTemplatesGridComponent({
            root: '#ReportTemplatesGrid',
            ajax: ReportTemplatesStore.getAjaxSettings(),
            style: 'single',
            filter: JSON.stringify({
                dataTypes: filter.DataTypes,
                templateIds: parsedFilter.Templates !== undefined
                    ? parsedFilter.Templates.map(function (t) { return t.IdReportTemplate; })
                    : [{ id: 0, networkResources: [] }]
            }),
            initComplete: function (settings, json) {
                $('#btnAddReportTemplateNetworkResource').attr('data-original-title', resourceClickReportTemplateFromAbove);
                bindToolTip();
            },
            showCheckBox: false,
            showCommands: true
        });

        ReportTemplatesController.filterReportTemplatesGrid.mount();
        ReportTemplatesController.filterReportTemplatesGrid.$api.on('select', ReportTemplatesController.OnReportTemplateSelectionChanged);

        if (parsedFilter.Templates !== undefined) {
            const templates = parsedFilter.Templates.map(function (t) {
                return {
                    id: t.IdReportTemplate,
                    networkResources: t.NetworkResources.map(function (r) {
                        return {
                            id: r.IdNetworkResource,
                            extension: reportExtensions.filter(function (e) { return e.ReportExtension === r.ReportExtension })[0].ReportExtensionString
                        }
                    })
                }
            });
            ReportTemplatesController.ApplySelectedReportTemplatesWithNetworkResources(templates);
        }
    },

    ShowSelectedReportTemplates: function (newTemplates) {
        const newTemplateIds = newTemplates.map(function (template) {
            return template.id;
        });

        const currentTemplateIds = ReportTemplatesController.filterReportTemplatesGrid.getAllItems().toArray().map(function (item) { return parseInt(item['Id']); });
        var unionTemplateIds = unionArray(currentTemplateIds, newTemplateIds);

        ReportTemplatesController.filterReportTemplatesGrid.reportTemplateFilter = JSON.stringify({ templateIds: unionTemplateIds });
        ReportTemplatesController.filterReportTemplatesGrid.reload();

        ReportTemplatesController.ApplySelectedReportTemplates(unionTemplateIds);
    },

    ApplySelectedReportTemplates: function (unionTemplateIds) {
        const unionTemplates = unionTemplateIds.map(function (id) {
            return { id: id, networkResources: [] };
        });
        ReportTemplatesController.ApplySelectedReportTemplatesWithNetworkResources(unionTemplates);
    },

    ApplySelectedReportTemplatesWithNetworkResources: function (unionTemplates) {
        var idParameterPrefix = ReportTemplatesController.htmlFormParametersPrefix !== undefined && ReportTemplatesController.htmlFormParametersPrefix.length > 0
            ? ReportTemplatesController.htmlFormParametersPrefix + '_'
            : '';
        var nameParameterPrefix = ReportTemplatesController.htmlFormParametersPrefix !== undefined && ReportTemplatesController.htmlFormParametersPrefix.length > 0
            ? ReportTemplatesController.htmlFormParametersPrefix + '.'
            : '';
        var oldReportTemplateElements = document.querySelectorAll('input[id*="' + idParameterPrefix + 'JobReportTemplates_"]');
        for (var i = 0; i < oldReportTemplateElements.length; i++) {
            oldReportTemplateElements[i].parentNode.removeChild(oldReportTemplateElements[i]);
        }

        unionTemplates = unionTemplates.filter(function (el) { return el.id > 0; });
        for (var i = 0; i < unionTemplates.length; i++) {
            var inputTemplateId = $(document.createElement('input'))
                .attr('type', 'hidden')
                .attr('name', nameParameterPrefix + 'JobReportTemplates[' + i + '].IdReportTemplate')
                .attr('id', idParameterPrefix + 'JobReportTemplates_' + unionTemplates[i].id + '_IdReportTemplate')
                .attr('data-order', i)
                .val(unionTemplates[i].id);
            $('#ReportTemplatesGrid').append(inputTemplateId);

            if (ReportTemplatesController.reportsDeliverySettings.filter(function (el) { return el.reportTemplateId == unionTemplates[i].id }).length === 0)
                ReportTemplatesController.reportsDeliverySettings.push({
                    reportTemplateId: unionTemplates[i].id,
                    networkResources: unionTemplates[i].networkResources
                });

            ReportTemplatesController.ApplySelectedNetworkResources(
                unionTemplates[i].id,
                ReportTemplatesController.reportsDeliverySettings.filter(function (el) { return el.reportTemplateId == unionTemplates[i].id })[0].networkResources
            );
        }

        if (typeof currentJobProperties !== 'undefined')
            currentJobProperties.currentReportTemplatesSelected = ReportTemplatesController.reportsDeliverySettings.length;
    },

    DeleteReportTemplate: function (sender, data) {
        var reportTemplateFilter = JSON.parse(ReportTemplatesController.filterReportTemplatesGrid.reportTemplateFilter);
        if (reportTemplateFilter.templateIds !== undefined) {
            reportTemplateFilter.templateIds = reportTemplateFilter.templateIds.filter(function (value, index, arr) {
                return value !== data["Id"];
            });

            if (reportTemplateFilter.templateIds.length == 0) {
                reportTemplateFilter.templateIds = [0];
            }

            ReportTemplatesController.filterReportTemplatesGrid.reportTemplateFilter = JSON.stringify(reportTemplateFilter);
            ReportTemplatesController.filterReportTemplatesGrid.reload();
        }

        ReportTemplatesController.ApplySelectedReportTemplates(reportTemplateFilter.templateIds);

        ReportTemplatesController.reportsDeliverySettings = ReportTemplatesController.reportsDeliverySettings.filter(function (value, index, arr) {
            return value.reportTemplateId !== data["Id"];
        });

        if (typeof currentJobProperties !== 'undefined')
            currentJobProperties.currentReportTemplatesSelected = ReportTemplatesController.reportsDeliverySettings.length;

        var networkResourceFilter = JSON.parse(ReportTemplatesController.filterNetworkResourcesGrid.networkResourceFilter);
        if (networkResourceFilter.reportTemplateId === data["Id"]) {
            ReportTemplatesController.NetworkResourcesTableReset();
        }
    },

    OnReportTemplateSelectionChanged: function (e, api, type, index) {
        let selectedTemplateId = api.row(index).data()["Id"];
        let selectedTemplateName = api.row(index).data()["ReportTemplateName"];

        let templateNetworkResources = [{ id: 0 }];
        if (ReportTemplatesController.reportsDeliverySettings !== undefined) {
            let templateDeliverySettigns = ReportTemplatesController.reportsDeliverySettings.filter(function (value, index, arr) { return value.reportTemplateId === selectedTemplateId });
            if (templateDeliverySettigns !== undefined
                && templateDeliverySettigns.length > 0
                && templateDeliverySettigns[0].networkResources !== undefined
                && templateDeliverySettigns[0].networkResources.length > 0)
                templateNetworkResources = templateDeliverySettigns[0].networkResources;
        }

        ReportTemplatesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify({
            reportTemplateId: selectedTemplateId,
            resources: templateNetworkResources
        }));
        ReportTemplatesController.filterNetworkResourcesGrid.reload();

        ReportTemplatesController.ApplySelectedNetworkResources(selectedTemplateId, templateNetworkResources);

        var reportTemplateFilter = JSON.parse(ReportTemplatesController.filterReportTemplatesGrid.reportTemplateFilter);
        if (reportTemplateFilter.templateIds === undefined ||
            reportTemplateFilter.templateIds.length === 1 && reportTemplateFilter.templateIds[0] == 0) {
            $('#btnAddReportTemplateNetworkResource').addClass('disabled');
            $('#btnAddReportTemplateNetworkResource').attr('data-original-title', resourceClickReportTemplateFromAbove);
        } else {
            $('#btnAddReportTemplateNetworkResource').removeClass('disabled');
            $('#btnAddReportTemplateNetworkResource').attr('data-original-title', '');
        }

        $('#selectedTemplateName').text('«' + selectedTemplateName + '»');
    },

    NetworkResourcesTableLoad: function () {
        ReportTemplatesController.filterNetworkResourcesGrid = new FilterReportTemplateNetworkResourcesGridComponent({
            root: '#ReportTemplates_NetworkResourcesGrid',
            ajax: { url: '/Jobs/CreateJobReportTemplateNetworkResourcesGrid' },
            style: 'single',
            filter: JSON.stringify({
                reportTemplateId: 0,
                resources: [{ id: 0 }]
            })
        });

        ReportTemplatesController.filterNetworkResourcesGrid.mount();
    },

    NetworkResourcesTableReset: function () {
        $('#selectedTemplateName').text('');

        ReportTemplatesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify({
            reportTemplateId: 0,
            resources: [{ id: 0 }]
        }));
        ReportTemplatesController.filterNetworkResourcesGrid.reload();

        $('#btnAddReportTemplateNetworkResource').addClass('disabled');
        $('#btnAddReportTemplateNetworkResource').attr('data-original-title', resourceClickReportTemplateFromAbove);
    },

    OnNetworkResourceExtensionChanged: function (networkResourceId, extension) {
        var idParameterPrefix = ReportTemplatesController.htmlFormParametersPrefix !== undefined && ReportTemplatesController.htmlFormParametersPrefix.length > 0
            ? ReportTemplatesController.htmlFormParametersPrefix + '_'
            : '';
        var networkResourceFilter = JSON.parse(ReportTemplatesController.filterNetworkResourcesGrid.networkResourceFilter);
        networkResourceFilter.resources.filter(function (value, index, arr) { return value.id === networkResourceId })[0].extension = extension;
        ReportTemplatesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify(networkResourceFilter));

        var selectedReportTemplateId = ReportTemplatesController.filterReportTemplatesGrid.$api.rows({ selected: true }).data()[0]["Id"];
        document.getElementById(idParameterPrefix + 'JobReportTemplates_' + selectedReportTemplateId + '_NetworkResources_' + networkResourceId + '_ReportExtension').value = extension;

        if (ReportTemplatesController.reportsDeliverySettings !== undefined) {
            for (var i = 0; i < ReportTemplatesController.reportsDeliverySettings.length; i++) {
                if (ReportTemplatesController.reportsDeliverySettings[i].reportTemplateId == selectedReportTemplateId) {
                    ReportTemplatesController.reportsDeliverySettings[i].networkResources
                        .filter(function (value, index, arr) { return value.id == networkResourceId })[0].extension = extension;
                    break;
                }
            }
        }
    },

    ShowSelectedNetworkResources: function (templateResources) {
        const currentResources = ReportTemplatesController.filterNetworkResourcesGrid.getAllItems().toArray().map(function (item) {
            var extension = document.querySelectorAll('select[data-id="' + item['Id'] + '"]')[0].value;
            return { id: parseInt(item['Id']), extension: extension };
        });
        // Filter new templateResources list to preserve settings for previously selected resources
        const newTemplateResources = templateResources.filter(function (newEl) {
            return currentResources.filter(function (curEl) {
                return newEl.id === curEl.id
            }).length === 0
        });
        const unionResources = currentResources.concat(newTemplateResources);
        ReportTemplatesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify({
            reportTemplateId: ReportTemplatesController.filterReportTemplatesGrid.getSelectedItems()[0]["id"],
            resources: unionResources
        }));
        ReportTemplatesController.filterNetworkResourcesGrid.reload();
        ReportTemplatesController.ApplySelectedNetworkResources(null, unionResources);
    },

    ApplySelectedNetworkResources: function (selectedTemplateId, templateNetworkResources) {
        var idParameterPrefix = ReportTemplatesController.htmlFormParametersPrefix !== undefined && ReportTemplatesController.htmlFormParametersPrefix.length > 0
            ? ReportTemplatesController.htmlFormParametersPrefix + '_'
            : '';
        var nameParameterPrefix = ReportTemplatesController.htmlFormParametersPrefix !== undefined && ReportTemplatesController.htmlFormParametersPrefix.length > 0
            ? ReportTemplatesController.htmlFormParametersPrefix + '.'
            : '';
        let selectedReportTemplateId;
        if (selectedTemplateId !== undefined && selectedTemplateId !== null)
            selectedReportTemplateId = selectedTemplateId;
        else
            selectedReportTemplateId = ReportTemplatesController.filterReportTemplatesGrid.$api.rows({ selected: true }).data()[0]["Id"];
        let selectedTemplateInputOrder = $('#' + idParameterPrefix + 'JobReportTemplates_' + selectedReportTemplateId + '_IdReportTemplate').data('order');

        var oldResourcesElements = document.querySelectorAll('input[id*="' + idParameterPrefix + 'JobReportTemplates_' + selectedReportTemplateId + '_NetworkResources_"]');
        for (var i = 0; i < oldResourcesElements.length; i++) {
            oldResourcesElements[i].parentNode.removeChild(oldResourcesElements[i]);
        }

        templateNetworkResources = templateNetworkResources !== undefined && templateNetworkResources.length > 0
            ? templateNetworkResources.filter(function (value, index, arr) { return value.id > 0 })
            : [];
        for (var i = 0; i < templateNetworkResources.length; i++) {
            var inputId = $(document.createElement('input'))
                .attr('type', 'hidden')
                .attr('name', nameParameterPrefix + 'JobReportTemplates[' + selectedTemplateInputOrder + '].NetworkResources[' + i + '].IdNetworkResource')
                .attr('id', idParameterPrefix + 'JobReportTemplates_' + selectedReportTemplateId + '_NetworkResources_' + templateNetworkResources[i].id + '_IdNetworkResource')
                .val(templateNetworkResources[i].id);
            var inputExtension = $(document.createElement('input'))
                .attr('type', 'hidden')
                .attr('name', nameParameterPrefix + 'JobReportTemplates[' + selectedTemplateInputOrder + '].NetworkResources[' + i + '].ReportExtension')
                .attr('id', idParameterPrefix + 'JobReportTemplates_' + selectedReportTemplateId + '_NetworkResources_' + templateNetworkResources[i].id + '_ReportExtension')
                .val(templateNetworkResources[i].extension);
            $('#ReportTemplates_NetworkResourcesGrid').append(inputId);
            $('#ReportTemplates_NetworkResourcesGrid').append(inputExtension);
        }

        if (ReportTemplatesController.reportsDeliverySettings !== undefined) {
            for (var i = 0; i < ReportTemplatesController.reportsDeliverySettings.length; i++) {
                if (ReportTemplatesController.reportsDeliverySettings[i].reportTemplateId == selectedReportTemplateId) {
                    ReportTemplatesController.reportsDeliverySettings[i].networkResources = templateNetworkResources;
                    break;
                }
            }
        }
    },

    DeleteNetworkResource: function (sender, data) {
        var networkResourceFilter = JSON.parse(ReportTemplatesController.filterNetworkResourcesGrid.networkResourceFilter);
        if (networkResourceFilter.resources !== undefined) {
            var resources = networkResourceFilter.resources.filter(function (value, index, arr) {
                return value.id !== data["Id"];
            });
            if (resources.length === 0) {
                resources = [{ id: 0 }];
            }
            networkResourceFilter.resources = resources;

            ReportTemplatesController.filterNetworkResourcesGrid.applyFilter(JSON.stringify(networkResourceFilter));
            ReportTemplatesController.filterNetworkResourcesGrid.reload();
        }

        var selectedTemplateId = ReportTemplatesController.filterReportTemplatesGrid.getSelectedItems()[0]["id"];
        ReportTemplatesController.ApplySelectedNetworkResources(selectedTemplateId, networkResourceFilter.resources);

        if (ReportTemplatesController.reportsDeliverySettings !== undefined) {
            for (var i = 0; i < ReportTemplatesController.reportsDeliverySettings.length; i++) {
                if (ReportTemplatesController.reportsDeliverySettings[i].reportTemplateId == selectedTemplateId) {
                    ReportTemplatesController.reportsDeliverySettings[i].networkResources = ReportTemplatesController.reportsDeliverySettings[i].networkResources.filter(function (value, index, arr) {
                        return value.id !== data["Id"];
                    });
                    break;
                }
            }
        }
    }
};

var ReportTemplatesPopupController = {
    needSelectReportTemplatesMessage: 'Выберите шаблоны отчетов',
    filterReportTemplatesGrid: null,

    TableLoad: function (reportTemplateFilter) {
        if (ReportTemplatesPopupController.filterReportTemplatesGrid == null) {
            ReportTemplatesPopupController.filterReportTemplatesGrid = new FilterReportTemplatesGridComponent({
                root: '#FilterReportTemplatesGrid',
                ajax: ReportTemplatesPopupController.createUrlFiltersHosts(),
                style: 'multi',
                filter: reportTemplateFilter,
                showCheckBox: true,
                showCommands: false
            });
        }
    },

    onShow: function () {
        if (ReportTemplatesPopupController.filterReportTemplatesGrid !== null) {
            if (!ReportTemplatesPopupController.filterReportTemplatesGrid.isMount()) {
                ReportTemplatesPopupController.filterReportTemplatesGrid.mount();
            } else {
                ReportTemplatesPopupController.filterReportTemplatesGrid.$api.selectCustom().deselectAll().draw();
            }
        }
    },

    createUrlFiltersHosts: function () {
        let links = {
            url: '/Jobs/CreateJobsReportTemplatesGrid',
            urlItemsId: '/Jobs/CreateJobsListReportTemplateIds',
        }

        return links;
    },

    selectReportTemplatesButtonClick: function () {
        const selectedRows = ReportTemplatesPopupController.filterReportTemplatesGrid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(ReportTemplatesPopupController.needSelectReportTemplatesMessage);
            return;
        }

        ReportTemplatesController.ShowSelectedReportTemplates(selectedRows);
        $('#reportTemplatesModal').modal('hide');
    }
};

function OnNetworkResourceCredentialChanged(value) {
    $('#UserCredentialId').val(value[0]);
    $('#UserCredentialName').val(value[1]);
    $('#credentialValid').addClass('hide');
}

function onNetworkResourceProviderTypeChanged(s, e) {
    $('#pathValid').addClass('hide');
    $('#credentialValid').addClass('hide');
    switch ($(s).val()) {
        case "Email":
            OnNetworkResourceCredentialChanged([null, '']);
            $('#btnCredential').prop('disabled', true);
            break;
        default:
            $('#btnCredential').prop('disabled', false);
            break;
    }
}

function SetCredentialsToSettings(value) {

    if (document.querySelector(".settings-tabs") != null) {
        if (document.getElementById('syncTab').classList.contains("active") &&
            document.getElementById('offlineSyncPath') != null) {
            document.getElementById('Sync_OfflineSyncPathCredentialName').value = value[1];
            document.getElementById('Sync_OfflineSyncPathCredentialId_Value').value = value[0];
        }
    }
}

function SetNetworkResourceCredential(value) {
    if ($("#networkResourceForm").length > 0)
        OnNetworkResourceCredentialChanged(value);
}

function checkPing(value) {
    var ping = document.getElementById('pingCredential');
    if (ping !== null)
        SetCredentialToPing(value[0], value[1], value[2], value[4]);
}

function SetCredentialsToImportAdImport(value) {
    var credentialNameTextbox = document.getElementById('Filter_CredentialName');
    var credentialId = document.getElementById('Filter_CredentialId');
    if (credentialNameTextbox !== null && credentialId !== null) {
        credentialNameTextbox.value = value[1];
        credentialId.value = value[0];
        AdImportHostsController.CheckValidAdData();
    }
}

function SetCredentialsToAdUser(value) {
    var credentialNameTextbox = document.getElementById('selectCredentialName');
    if (credentialNameTextbox !== null) {
        credentialNameTextbox.value = value[1];
        $('#CredentialId').val(value[0]);
        getDomainAdress(value[0]);
        AdUsersController.CheckValidAdData();
    }
}

function SetCredentialsToEditHosts(value) {
    var updateHost = document.getElementById('updateHost');
    var createHost = document.getElementById('createHost');
    if (updateHost !== null || createHost !== null) {
        var parentObj;
        if (updateHost !== null) parentObj = updateHost;
        if (createHost !== null) parentObj = createHost;

        var table = document.getElementById('credentialsForHostGrid');
        var emptyRow = document.getElementById('emptyRow');
        if (emptyRow !== null)
            table.deleteRow(1);
        var count = table.rows.length;
        var row = table.insertRow(count);
        row.classList.add("dxgvDataRow_Office2010Silver");
        var priorityCell = row.insertCell(0);
        var idCell = row.insertCell(1);
        var typeCell = row.insertCell(2);
        var nameCell = row.insertCell(3);
        var dateCell = row.insertCell(4);
        var jobAgentTypeCell = row.insertCell(5);
        var deleteCell = row.insertCell(6);
        priorityCell.innerHTML = count - 1;
        idCell.innerHTML = value[0];
        nameCell.innerHTML = value[1];
        typeCell.innerHTML = value[2];
        dateCell.innerHTML = value[3];
        deleteCell.innerHTML = "<a href=\"#\" onclick=\"deleteCredentialFromGridCustom(" + count + ")\"><img src=\"/img/rc_icons/basket.png\"></a>";

        var ind = count - 1;
        jobAgentTypeCell.innerHTML = FillJobAgentTypeComboBox(value[2], ind);
        parentObj.appendChild(createHiddenElementForCredentials(value[0], ind, "Id"));
        parentObj.appendChild(createHiddenElementForCredentials(ind, ind, "Priority"));
        parentObj.appendChild(createHiddenElementForCredentials(0, ind, "JobAgentType"));

        SetStyleForRow([priorityCell, idCell, nameCell, typeCell, dateCell, jobAgentTypeCell, deleteCell]);
    }
}

function credentialsJobAgentTypeChange(index) {
    var element = document.getElementById('Credentials_' + index + '__JobAgentType');
    var selectIndex = element.selectedIndex;
    var hiddenElementsAgentType = $('[type=hidden][id=Credentials_' + index + '__JobAgentType]');
    hiddenElementsAgentType.val(selectIndex);
}

function deleteCredentialFromGridCustom(index) {
    var targetGrid = document.getElementById('credentialsForHostGrid');
    targetGrid.deleteRow(index);

    var hiddenElementsPriority = targetGrid.querySelectorAll('[id*=__Priority]');
    for (var ind = 0; ind < hiddenElementsPriority.length; ind++) {
        hiddenElementsPriority[ind].remove();
    }

    var hiddenElementsId = targetGrid.querySelectorAll('[id*=__Id]');
    for (var indId = 0; indId < hiddenElementsId.length; indId++) {
        hiddenElementsId[indId].remove();
    }

    var hiddenElementsAgentType = targetGrid.querySelectorAll('[type=hidden][id*=__JobAgentType]');
    for (var indType = 0; indType < hiddenElementsAgentType.length; indType++) {
        hiddenElementsAgentType[indType].remove();
    }

    for (var i = 0; targetGrid.rows[i]; i++) {
        for (var j = 0; targetGrid.rows[i].cells[j]; j++) {
            if (i > 0) {
                if (j === 0) {
                    targetGrid.rows[i].cells[j].innerHTML = i - 1;
                }
                if (j === 6) {
                    var link = targetGrid.rows[i].cells[j].children[0];
                    link.setAttribute("onClick", "deleteCredentialFromGridCustom(" + i + ")");
                }
                if (j === 1) {
                    targetGrid.appendChild(createHiddenElementForCredentials(targetGrid.rows[i].cells[j].innerHTML, i - 1, "Id"));
                }
                if (j === 5) {
                    var combo = document.getElementById("credentialsForHostGrid").rows[2].cells[5].children[0];
                    var valueOfType = combo.options[combo.selectedIndex].value;
                    targetGrid.appendChild(createHiddenElementForCredentials(valueOfType, i - 1, "JobAgentType"));
                }
            }
        }
        if (i > 0)
            targetGrid.appendChild(createHiddenElementForCredentials(i - 1, i - 1, "Priority"));
    }
}

// #endregion

function SetStyleForRow(cells) {
    for (var i = 0; i < cells.length; i++) {
        cells[i].classList.add("dxgv");
        cells[i].classList.add("cell");
    }
}

function FillJobAgentTypeComboBox(type, index) {
    var obj = document.createElement("select");
    obj.classList.add("width-100-percent");
    obj.name = "Credentials[" + index + "].JobAgentType";
    obj.id = "Credentials_" + index + "__JobAgentType";
    obj.setAttribute("data-val", true);
    obj.setAttribute("onchange", "credentialsJobAgentTypeChange(" + index + ")");
    var lang = getCookie("lang");
    if (type === 'Windows') {
        var optionAgent = document.createElement("option");
        if (lang === "ru")
            optionAgent.text = "С использованием агента";
        else optionAgent.text = "Agent";
        optionAgent.value = "Agent";
        obj.add(optionAgent);

        var optionRE = document.createElement("option");
        optionRE.text = "Безагент WinRM";
        optionRE.value = "TempAgent";
        obj.add(optionRE);

        var optionNoneForWindows = document.createElement("option");
        if (lang === "ru")
            optionNoneForWindows.text = "Безагент WMI";
        else optionNoneForWindows.text = "Agentless WMI";
        optionNoneForWindows.value = "Agentless";
        obj.add(optionNoneForWindows);
    } else {
        var optionNone = document.createElement("option");
        if (lang === "ru")
            optionNone.text = "Безагент";
        else optionNone.text = "Agentless";
        optionNone.value = "Agentless";
        obj.add(optionNone);
    }

    return obj.outerHTML;
}


function createHiddenElementForCredentials(value, index, type) {
    var input = document.createElement("input");
    input.type = "hidden";
    input.value = value;
    input.id = "Credentials_" + index + "__" + type;
    input.name = "Credentials[" + index + "]." + type;
    input.setAttribute("data-val", true);
    return input;
}

function AdImportOnGetGroupRowValues(value) {
    var groupNameTextbox = document.getElementById("Filter_GroupName");
    if (groupNameTextbox !== null) {
        groupNameTextbox.value = value[1];
        $('#Filter_GroupId').val(value[0]);
    }
}

function OnGetGroupRowValues(value) {
    var groupNameTextbox = document.getElementById("GroupName");
    if (groupNameTextbox !== null) {
        groupNameTextbox.value = value[1];
        $('#GroupId').val(value[0]);
    }
}

// #endregion

var JobsPopupControler = {
    needSelectJobMessage: 'Выберите задание',
    filterJobsGrid: null,
    isUseCheckBox: false,
    resetSelectionAfterSearch: true,

    TableLoad: function (filter) {
        const parsedFilter = JSON.parse(filter);
        const checkbox = document.querySelector('[id*=jobsModal] input[id*="IsUseCheckBox"]');
        JobsPopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;
        JobsPopupControler.resetSelectionAfterSearch = JobsPopupControler.isUseCheckBox === false;

        if (JobsPopupControler.filterJobsGrid == null || !JobsPopupControler.filterJobsGrid.isMount()) {
            JobsPopupControler.filterJobsGrid = new FilterJobsGridComponent({
                root: '#FilterJobsGrid',
                ajax: JobsPopupControler.createUrlFiltersJobs(),
                style: JobsPopupControler.isUseCheckBox ? 'multi' : 'single',
                filter: parsedFilter,
                resetSelectionAfterSearch: JobsPopupControler.resetSelectionAfterSearch,
            });
        }
    },

    onShow: function () {
        if (JobsPopupControler.filterJobsGrid) {
            const form = document.getElementById('searchFormUnavailabilityReasons');
            if(form !== null) {
                const scanTypeIds = Array.from(form.querySelectorAll('input[name="JobScanType"]:checked'))
                    .map(x => x.value);
                if (scanTypeIds.length > 0) {
                    JobsPopupControler.filterJobsGrid.jobFilter.ScanTypes = scanTypeIds;
                    if (!JobsPopupControler.filterJobsGrid.isMount()) {
                        JobsPopupControler.filterJobsGrid.mount();
                    }
                    else {JobsPopupControler.filterJobsGrid.$api.selectCustom().deselectAll().draw();}
                }
            }
            else {
                if (!JobsPopupControler.filterJobsGrid.isMount()) {
                    JobsPopupControler.filterJobsGrid.mount();
                } else {
                    if (JobsPopupControler.resetSelectionAfterSearch) {
                        JobsPopupControler.filterJobsGrid.$api.selectCustom().deselectAll().draw();
                    }
                }
            }
            
        }
    },

    createUrlFiltersJobs: function () {
        let links = {
            url: '/Jobs/FiltersJobsGrid',
            urlItemsId: '/Jobs/ListJobsIds'
        };

        return links;
    },

    selectJobButtonClick: function (button) {

        var inputField = document.querySelector('input#currentScanInput');
        if(inputField && inputField.value) {
            jobExecutionPicker.newJobExecutionId = 0;
            inputField.value = '';
        }
        
        const selectedRows = JobsPopupControler.filterJobsGrid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(JobsPopupControler.needSelectJobMessage);
            return;
        }

        if (JobsPopupControler.isUseCheckBox === false) {
            let selectedJob = [selectedRows[0].id, selectedRows[0].name];
            JobsPopupControler.setJobDataToForm(selectedJob);
            $(button).trigger('select-entity.popup', [selectedRows[0].id, selectedRows[0].name]);
        } else {
            $(button).trigger('change-selected-jobs.popup', [selectedRows]);
        }

        $('#jobsModal').modal('hide');
    },

    cancelButtonClick: function (button) {
        $('#jobsModal').modal('hide');

        $(button).trigger('restore-selected-jobs.popup');
    },

    setJobDataToForm: function (value) {
        var jobNameTextbox = document.getElementById('JobName');
        const jobIdHiddenInput = document.getElementById('JobId');

        if (jobNameTextbox !== null) {
            jobNameTextbox.value = value[1];
        }

        if (jobIdHiddenInput !== null) {
            jobIdHiddenInput.value = value[0];
        }
    },

    update: function (selectedKeys) {
        if (JobsPopupControler.filterJobsGrid && JobsPopupControler.filterJobsGrid.isMount()) {
            JobsPopupControler.filterJobsGrid.$api.selectCustom().selectByKeys(selectedKeys).draw();
        }
    },
};

var BenchmarksPopupControler = {
    needSelectBenchmarkMessage: 'Выберите конфигурацию',
    filterBenchmarksGrid: null,
    isUseCheckBox: false,

    TableLoad: function (filter) {
        const parsedFilter = JSON.parse(filter);
        const checkbox = document.querySelector('[id*=benchmarksModal] input[id*="IsUseCheckBox"]');
        BenchmarksPopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;

        if (BenchmarksPopupControler.filterBenchmarksGrid == null || !BenchmarksPopupControler.filterBenchmarksGrid.isMount()) {
            BenchmarksPopupControler.filterBenchmarksGrid = new FilterBenchmarksGridComponent({
                root: '#FilterBenchmarksGrid',
                ajax: BenchmarksPopupControler.createUrlFiltersBenchmarks(),
                style: BenchmarksPopupControler.isUseCheckBox ? 'multi' : 'single',
                filter: parsedFilter,
                paging: false,
                resetSelectionAfterSearch: false,
            });
        }
    },

    onShow: function () {
        if (BenchmarksPopupControler.filterBenchmarksGrid) {
            if (!BenchmarksPopupControler.filterBenchmarksGrid.isMount()) {
                BenchmarksPopupControler.filterBenchmarksGrid.mount();
            } else {
                BenchmarksPopupControler.filterBenchmarksGrid.$api.draw();
            }
        }
    },

    createUrlFiltersBenchmarks: function () {
        let links = {
            url: '/Compliance/BenchmarksGrid',
        };

        return links;
    },

    selectBenchmarkButtonClick: function (button) {
        const selectedRows = BenchmarksPopupControler.filterBenchmarksGrid.getSelectedItemsForBenchmarks();

        if (!selectedRows.length) {
            notifyWarning(BenchmarksPopupControler.needSelectBenchmarkMessage);
            return;
        }

        if (BenchmarksPopupControler.isUseCheckBox === false) {
            $(button).trigger('select-entity.popup', 
                [
                    {
                        id: selectedRows[0].id,
                        benchmarkId: selectedRows[0].benchmarkId,
                        benchmarkName: selectedRows[0].benchmarkName,
                        profileId: selectedRows[0].profileId,
                        profileTextId: selectedRows[0].profileTextId,
                        isProfileDefault: selectedRows[0].isProfileDefault,
                        isProfileOutOfBox: selectedRows[0].isProfileOutOfBox,
                        isProfileSingle: selectedRows[0].isProfileSingle
                    }
                ]);
        } else {
            $(button).trigger('change-selected-benchmarks.popup', [selectedRows]);
        }

        $('#benchmarksModal').modal('hide');
    },

    cancelButtonClick: function (button) {
        $('#benchmarksModal').modal('hide');

        $(button).trigger('restore-selected-benchmarks.popup');
    },
    
    update: function (selectedKeys) {
        if (BenchmarksPopupControler.filterBenchmarksGrid && BenchmarksPopupControler.filterBenchmarksGrid.isMount()) {
            BenchmarksPopupControler.filterBenchmarksGrid.$api.selectCustom().selectByKeys(selectedKeys).draw();
        }
    },
};

var ComplianceRulesPopupControler = {
    OnShowComplianceRulesModal: function () {
        const table = document.getElementById('ComplianceRulesGrid');
        
        if (!$.fn.DataTable.isDataTable(table)) {
            createComplianceRulesGrid();
        }
        else {
            $(table).dataTable().api().ajax.reload();
        }

        setTimeout(function () {
            $.fn.dataTable.util.columnsAjustSize();
        }, 200);
    },

    cancelButtonClick: function (button) {
        $('#complianceRulesModal').modal('hide');
    },
};

var ComplianceRulesOnlyNamePopupControler = {
    needSelectRuleMessage: 'Выберите правило',
    filterRulesGrid: null,
    isUseCheckBox: false,

    TableLoad: function (filter) {
        const parsedFilter = JSON.parse(filter);
        const checkbox = document.querySelector('[id*=complianceRulesSelectedCheckedModal] input[id*="IsUseCheckBox"]');
        ComplianceRulesOnlyNamePopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;

        if (ComplianceRulesOnlyNamePopupControler.filterRulesGrid == null || !ComplianceRulesOnlyNamePopupControler.filterRulesGrid.isMount()) {
            ComplianceRulesOnlyNamePopupControler.filterRulesGrid = new FilterRulesGridComponent({
                root: '#ComplianceRulesOnlyNamesGrid',
                ajax: ComplianceRulesOnlyNamePopupControler.createUrlRulesGrid(),
                style: ComplianceRulesOnlyNamePopupControler.isUseCheckBox ? 'multi' : 'single',
                filter: parsedFilter,
                resetSelectionAfterSearch: false,
            });
        }
    },

    onShow: function () {
        const filter = ComplianceRulesOnlyNamePopupControler.getFilterForTable();
        if (!ComplianceRulesOnlyNamePopupControler.filterRulesGrid) {
            ComplianceRulesOnlyNamePopupControler.TableLoad(JSON.stringify(filter));
        }
        
        if (ComplianceRulesOnlyNamePopupControler.filterRulesGrid) {
            if (!ComplianceRulesOnlyNamePopupControler.filterRulesGrid.isMount()) {
                ComplianceRulesOnlyNamePopupControler.filterRulesGrid.filter = filter;
                ComplianceRulesOnlyNamePopupControler.filterRulesGrid.applyFilter(filter);
                ComplianceRulesOnlyNamePopupControler.filterRulesGrid.mount();
            } else {
                ComplianceRulesOnlyNamePopupControler.filterRulesGrid.filter = filter;
                ComplianceRulesOnlyNamePopupControler.filterRulesGrid.applyFilter(filter);
                ComplianceRulesOnlyNamePopupControler.filterRulesGrid.$api.draw();
            }
        }
    },

    createUrlRulesGrid: function () {
        let links = {
            url: '/AnalyticsForms/RulesSelectedCheckedGrid',
        };

        return links;
    },

    selectRuleButtonClick: function (button) {
        const selectedRows = ComplianceRulesOnlyNamePopupControler.filterRulesGrid.getSelectedItemsForRules();

        if (!selectedRows.length) {
            notifyWarning(ComplianceRulesOnlyNamePopupControler.needSelectRuleMessage);
            return;
        }

        if (ComplianceRulesOnlyNamePopupControler.isUseCheckBox === false) {
            let selectedRule = [selectedRows[0].ruleId, selectedRows[0].ruleTitle];
            $(button).trigger('select-entity.popup', [selectedRows[0].ruleId, selectedRows[0].ruleTitle]);
        } else {
            $(button).trigger('change-selected-rules.popup', [selectedRows]);
        }

        $('#complianceRulesSelectedCheckedModal').modal('hide');
    },

    cancelButtonClick: function (button) {
        $('#complianceRulesSelectedCheckedModal').modal('hide');

        $(button).trigger('restore-selected-rules.popup');
    },

    getFilterForTable: function() {
        let filter = {};
        filter.XccdfFileEnumerationId = ComplianceAnalysisController.filter.xccdfFileEnumerationId;
        filter.XccdfProfileId = ComplianceAnalysisController.filter.xccdfProfileId;
        filter.IsProfileDefault = ComplianceAnalysisController.filter.isProfileDefault;
        filter.IsProfileOutOfBox = ComplianceAnalysisController.filter.isProfileOutOfBox;
        filter.IsProfileSingle = ComplianceAnalysisController.filter.isProfileSingle;
        return filter;
    },

    update: function (selectedKeys) {
        if (ComplianceRulesOnlyNamePopupControler.filterRulesGrid && ComplianceRulesOnlyNamePopupControler.filterRulesGrid.isMount()) {
            ComplianceRulesOnlyNamePopupControler.filterRulesGrid.$api.selectCustom().selectByKeys(selectedKeys);
        }
    },
};

var HostsWithNoResultPopupControler = {
    filterHostsGrid: null,
    isUseCheckBox: false,
    showScanIds: false,

    TableLoad: function (filter) {
        const parsedFilter = JSON.parse(filter);
        const checkbox = document.querySelector('[id*=hostsWithNoResultModal] input[id*="IsUseCheckBox"]');
        HostsWithNoResultPopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;

        if (HostsWithNoResultPopupControler.filterHostsGrid == null || !HostsWithNoResultPopupControler.filterHostsGrid.isMount()) {
            HostsWithNoResultPopupControler.filterHostsGrid = new FilterHostsWithNoResultGridComponent({
                root: '#HostsWithNoResultGrid',
                ajax: HostsWithNoResultPopupControler.createUrlHostsWithNoResultGrid(),
                dataSrc: 'data',
                style: HostsWithNoResultPopupControler.isUseCheckBox ? 'multi' : 'single',
                filter: parsedFilter,
                resetSelectionAfterSearch: false,
            }, showScanIds);
        }
    },

    onShow: function () {
        if (VulnerabilityAnalysisController.filter.jobIds.length > 0) {
            showScanIds = true;
            $('#hostsWithNoResultModalTitle').html('Хосты, у которых все сканирования в рамках выбранного задания и периода времени неуспешные');
        }
        else {
            showScanIds = false;
            $('#hostsWithNoResultModalTitle').html('Хосты без данных о проведённых сканированиях');
        }
        const filter = HostsWithNoResultPopupControler.getFilterForTable();
        if (!HostsWithNoResultPopupControler.filterHostsGrid) {
            HostsWithNoResultPopupControler.TableLoad(JSON.stringify(filter));
        }

        if (HostsWithNoResultPopupControler.filterHostsGrid) {
            
            if (!HostsWithNoResultPopupControler.filterHostsGrid.isMount()) {
                HostsWithNoResultPopupControler.filterHostsGrid.filter = filter;
                HostsWithNoResultPopupControler.filterHostsGrid.applyFilter(filter);
                HostsWithNoResultPopupControler.filterHostsGrid.showScanIds = showScanIds;
                HostsWithNoResultPopupControler.filterHostsGrid.mount();
                HostsWithNoResultPopupControler.filterHostsGrid.$api.column(3).visible(showScanIds);
            } 
            else {
                HostsWithNoResultPopupControler.filterHostsGrid.filter = filter;
                HostsWithNoResultPopupControler.filterHostsGrid.applyFilter(filter);
                HostsWithNoResultPopupControler.filterHostsGrid.showScanIds = showScanIds;
                HostsWithNoResultPopupControler.filterHostsGrid.$api.column(3).visible(showScanIds);
                HostsWithNoResultPopupControler.filterHostsGrid.$api.draw();
            }
        }
    },

    updateFilter: function(filter) {
        
    },
    
    createUrlHostsWithNoResultGrid: function () {
        let links = {
            url: '/AnalyticsForms/HostsWithNoResultGrid',
        };

        return links;
    },

    cancelButtonClick: function (button) {
        $('#hostsWithNoResultModal').modal('hide');
    },

    getFilterForTable: function() {
        let filter = {};
        filter.groupIds = VulnerabilityAnalysisController.filter.groupIds;
        filter.hostIds = VulnerabilityAnalysisController.filter.hostIds;
        filter.jobIds = VulnerabilityAnalysisController.filter.jobIds;
        filter.UseOnlyLastDaysCount = VulnerabilityAnalysisController.filter.UseOnlyLastDaysCount;
        filter.hostSearchText = HostsController.filter.hostSearchText;
        return filter;
    },

    update: function (selectedKeys) {
        if (HostsWithNoResultPopupControler.filterHostsGrid && HostsWithNoResultPopupControler.filterHostsGrid.isMount()) {
            HostsWithNoResultPopupControler.filterHostsGrid.$api.selectCustom().selectByKeys(selectedKeys);
        }
    },
};

var JobExecutionsPopupControler = {
    needSelectJobExecution: 'Выберите сканирование',
    filterJobExecutionsGrid: null,
    isUseCheckBox: false,
    currentPopupElement: null,
    currentPopupElementType: 'new',

    TableLoad: function (parsedFilter) {
        const checkbox = document.querySelector('[id*=jobExecutionsModal] input[id*="IsUseCheckBox"]');
        JobExecutionsPopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;

        if (JobExecutionsPopupControler.filterJobExecutionsGrid == null || !JobExecutionsPopupControler.filterJobExecutionsGrid.isMount()) {
            JobExecutionsPopupControler.filterJobExecutionsGrid = new FilterJobExecutionsGridComponent({
                root: '#FilterJobExecutionsGrid',
                ajax: JobExecutionsPopupControler.createUrlFilterJobExecutions(),
                style: JobExecutionsPopupControler.isUseCheckBox ? 'multi' : 'single',
                filter: parsedFilter,
                paging: true,
                resetSelectionAfterSearch: false,
            });
        }
    },

    onShow: function (event) {
        const button = event.relatedTarget;
        JobExecutionsPopupControler.setCurrentPopupElement(button);

        if (button !== undefined && button.dataset.filter !== undefined) {
            const parsedFilter = JSON.parse(button.dataset.filter);

            if (!JobExecutionsPopupControler.filterJobExecutionsGrid) {
                JobExecutionsPopupControler.TableLoad(parsedFilter);
            }
            
            if (JobExecutionsPopupControler.filterJobExecutionsGrid) {

                if (!JobExecutionsPopupControler.filterJobExecutionsGrid.isMount()) {
                    JobExecutionsPopupControler.filterJobExecutionsGrid.filter = parsedFilter;
                    JobExecutionsPopupControler.filterJobExecutionsGrid.applyFilter(parsedFilter);
                    JobExecutionsPopupControler.filterJobExecutionsGrid.mount();
                } else {
                    JobExecutionsPopupControler.filterJobExecutionsGrid.filter = parsedFilter;
                    JobExecutionsPopupControler.filterJobExecutionsGrid.applyFilter(parsedFilter);
                    JobExecutionsPopupControler.filterJobExecutionsGrid.$api.draw();
                }
            }
        }

        setTimeout(function () {
            $.fn.dataTable.util.columnsAjustSize();
        }, 200);
    },

    createUrlFilterJobExecutions: function () {
        let links = {
            url: '/Jobs/FilterJobExecutionGrid',
        };

        return links;
    },

    selectJobExecutionButtonClick: function (button) {
        const selectedRows = JobExecutionsPopupControler.filterJobExecutionsGrid.getSelectedItemsForJobExecutions();

        if (!selectedRows.length) {
            notifyWarning(JobExecutionsPopupControler.needSelectJobExecution);
            return;
        }

        if (JobExecutionsPopupControler.isUseCheckBox === false) {
            const currentButton = JobExecutionsPopupControler.getCurrentPopupElement();
            $(currentButton).trigger('select-entity.popup',
            [
                {
                    id: selectedRows[0].id,
                    start: selectedRows[0].start,
                    stop: selectedRows[0].stop
                }
            ]);
        }

        $('#jobExecutionsModal').modal('hide');
    },

    cancelButtonClick: function (button) {
        $('#jobExecutionsModal').modal('hide');
    },

    update: function (selectedKeys) {
        if (JobExecutionsPopupControler.filterJobExecutionsGrid && JobExecutionsPopupControler.filterJobExecutionsGrid.isMount()) {
            JobExecutionsPopupControler.filterJobExecutionsGrid.$api.selectCustom().selectByKeys(selectedKeys).draw();
        }
    },

    setCurrentPopupElement: function (element) {
        JobExecutionsPopupControler.currentPopupElement = element;
        if (element !== undefined && element.dataset.type !== undefined) {
            JobExecutionsPopupControler.currentPopupElementType = element.dataset.type;
        }
    },

    getCurrentPopupElement: function () {
        return JobExecutionsPopupControler.currentPopupElement;
    },
};

function saveAccount() {
    if (document.getElementById('OldPassword').value !== document.getElementById('NewPassword').value) {
        document.getElementById('alertPassDoNotMatch').classList.remove('hidden');
        event.preventDefault();
        return;
    }
    document.getElementById('saveAccountClick').click();  //closeAccountBtn
    clearAccountVisualData();
}

function clearAccountVisualData() {
    if (document.getElementById('NewPassword') === null) {
        return;
    }
    
    document.getElementById('OldPassword').value = null;
    document.getElementById('NewPassword').value = null;

    document.getElementById('errAccPass').classList.add('hide');
    document.getElementById('okAccPass').classList.add('hide');

    document.getElementById('alertPassDoNotMatch').classList.add('hidden');
}

function accountSaveSuccess(data, successMessage, errorMessage) {
    if (data === true) {
        document.getElementById('accountViewModal').innerHTML = '';
        notifySuccess(successMessage);
        setTimeout(() => location.reload(), 1500);
        return;
    }

    notifyWarning(errorMessage);
}

var ScanResultPageControlController = {
    onActiveTabChanged: function () {
        $.fn.dataTable.util.columnsAjustSize();
    }
};

var ScanResultOvalInventoryController = {
    ovalInventoryGridView_SelectionChanged: function (s, e) {
        $('#ovalInventoryGridView .gridViewSummary .gridViewTotal .totalCount').text(s.GetSelectedRowCount());
    },

    OnInit: function (s, e) {
        ScanResultOvalInventoryController.AdjustSize();
        ASPxClientUtils.AttachEventToElement(window, "resize", function (evt) {
            ScanResultOvalInventoryController.AdjustSize();
        });
    },
    OnEndCallback: function (s, e) {
        ScanResultOvalInventoryController.AdjustSize();
    },
    AdjustSize: function () {
        var clientHeight = document.documentElement.clientHeight;
        var gridView = ASPxClientControl.GetControlCollection().GetByName('ovalInventoryGridView');
        gridView.SetHeight(clientHeight - 200);
    },
    RowDblClick: function (s, e) {
        s.ExpandDetailRow(e.visibleIndex);
    },
    OnContextMenuItemClick: function (s, e) {
        var actionParams = $("form#ovalInventoryForm").attr("action").split("?command=");
        actionParams[1] = e.item.name;
        $("form#ovalInventoryForm").attr("action", actionParams.join("?command="));
        $("form#ovalInventoryForm").submit();
    }
};

var EditProfileController = {
    cpData: {},
    SelectionChanged: function (s, e) {
        $('#auditForEditProfileGridView .gridViewSummary .gridViewTotal .totalCount').text(s.GetSelectedRowCount());
        s.GetSelectedFieldValues("OvalId", EditProfileController.GetSelectedFieldValuesCallback);
    },
    OnInit: function (s, e) {
        EditProfileController.AdjustSize();
        ASPxClientUtils.AttachEventToElement(window, "resize", function (evt) {
            EditProfileController.AdjustSize();
        });
        bindToolTip();
    },

    OnEndCallback: function (s, e) {
        EditProfileController.AdjustSize();
        bindToolTip();
    },

    AdjustSize: function () {
        var clientHeight = document.documentElement.clientHeight;
        var gridView = ASPxClientControl.GetControlCollection().GetByName('auditForEditProfileGridView');
        gridView.SetHeight(clientHeight - 200);
    },
    RowDblClick: function (s, e) {
        s.ExpandDetailRow(e.visibleIndex);
    },

    OnBeginCallback: function (s, e) {
        var controls = ASPxClientControl.GetControlCollection();
        e.customArgs["description"] = document.getElementById('Filter_Description').value;
        e.customArgs["reference"] = document.getElementById('Filter_Reference').value;
        e.customArgs["title"] = document.getElementById('Filter_Title').value;
        e.customArgs["family"] = controls.GetByName('Family').GetValue();
        e.customArgs["auditType"] = controls.GetByName('AuditType').GetValue();
    },
    OnRowClick: function (s, e) {
        if (e.htmlEvent.ctrlKey)
            return;

        e.cancel = true;
        var isSelected = s.IsRowSelectedOnPage(e.visibleIndex);
        s.SelectRows(e.visibleIndex, !isSelected);
    },

    GetSelectedFieldValuesCallback: function (values) {
        EditProfileController.cpData = values.join(',');
    },

    EditProfileFilterSubmit: function () {
        var auditGrid = ASPxClientControl.GetControlCollection().GetByName('auditForEditProfileGridView');
        auditGrid.PerformCallback();
    }
};

function fillTargetAuditForProfile() {
    var elemets = EditProfileController.cpData.split(',');
    for (var i = 0; i < elemets.length; i++) {
        var tag = $('<input />').attr('type', 'hidden')
            .attr('name', "Audits[" + i + "]")
            .attr('value', elemets[i]);
        if ($('#newProfileForm') !== null)
            $('#newProfileForm').append(tag);
        if ($('#editProfileForm') !== null)
            $('#editProfileForm').append(tag);
    }
}

var AuditManagerSplitterController = {
    onInit: function (s, e) {
        AuditManagerSplitterController.adjustSize();
        ASPxClientUtils.AttachEventToElement(window, "resize", function (evt) {
            AuditManagerSplitterController.adjustSize();
        });
    },

    onPaneResized: function (s, e) {
        $.fn.dataTable.util.columnsAjustSize();
        adjustGridSizeInSplitter('AuditForProfileGrid');
        adjustGridSizeInSplitter('ProfileGrid');
    },

    adjustSize: function () {
        var height = document.documentElement.clientHeight;
        splResizing.SetHeight(height - 158);
    },
};

var ProfileController = {
    selectedProfileId: 0,

    onDrawCallback: function (settings) {
        $(settings.nScrollBody).css('overflow-y', 'scroll');
        adjustGridSizeInSplitter(settings.sTableId);
        bindToolTip();
    },

    onSelectionChanged: function (e, itemsId) {
        ProfileController.setSelectedProfileId(itemsId[0]);
    },

    setSelectedProfileId: function (itemId) {
        ProfileController.selectedProfileId = itemId || 0;

        const table = document.getElementById('AuditForProfileGrid');
        if ($.fn.DataTable.isDataTable(table)) {
            $(table).dataTable().api().ajax.reload();
        }
    },

    handleDeleteClick: function (sender, row) {
        deleteProfile(row.Id);
    },

    reloadGrid: function () {
        const table = document.getElementById('ProfileGrid');
        if ($.fn.DataTable.isDataTable(table)) {
            const api = $(table).dataTable().api();

            api.selectCustom().deselectAll();
            api.ajax.reload();
            ProfileController.setSelectedProfileId(0);
        }
    }
};

var LogsController = {
    OnInit: function (s, e) {
        LogsController.AdjustSize(s.name);
        ASPxClientUtils.AttachEventToElement(window, "resize", function (evt) {
            LogsController.AdjustSize(s.name);
        });
    },
    OnEndCallback: function (s, e) {
        LogsController.AdjustSize(s.name);
    },
    AdjustSize: function (name) {
        var clientHeight = document.documentElement.clientHeight;
        var gridView = ASPxClientControl.GetControlCollection().GetByName(name);//(MVCxClientGridView)
        gridView.SetHeight(clientHeight - 154);
    }
};

var ScanResultInventoryAuditController = {
    errorText: 'Во время выполнения запроса что-то пошло не так',

    onInitCompleteForTreeView: function () {
        const treeView = this;
        ScanResultInventoryAuditController.loadTreeNodesByNodeId(null, function (response) {
            TreeViewClientSideHelper.addNodes(treeView, response.data);
        });
    },

    onSelectionChangedForTreeView: function (node) {
        ScanResultInventoryAuditController.loadInventoryAuditDetails(node.dataset.name);
    },

    onExpandNode: function (event, context, node) {
        const container = node.querySelector(':scope > .treeview__container');
        if (container !== null) return;

        ScanResultInventoryAuditController.loadTreeNodesByNodeId(node.dataset.name, function (response) {
            TreeViewClientSideHelper.addNodes(context, response.data, node);
        });
    },

    loadTreeNodesByNodeId: function (nodeId, callback) {
        const formData = new FormData();
        if (nodeId !== null && nodeId !== undefined) {
            formData.append('NodeId', escapeHtml(nodeId));
        }

        const xhr = new XMLHttpRequest();
        xhr.responseType = 'json';
        xhr.open('POST', inventoryAuditUrl.getInventoryAuditByScanIdUrl, true);
        xhr.send(formData);

        xhr.onload = function (event) {
            if (xhr.status === 200 && xhr.response !== null) {
                if (xhr.response.error !== undefined) {
                    notifyWarning(xhr.response.error);
                    return;
                }
                
                callback(xhr.response);
            } else {
                notifyWarning(ScanResultInventoryAuditController.errorText);
            }
        };

        xhr.onerror = function () {
            notifyWarning(ScanResultInventoryAuditController.errorText);
        };
    },

    loadInventoryAuditDetails: function (nodeId) {
        const formData = new FormData();
        if (nodeId !== null && nodeId !== undefined) {
            formData.append('NodeId', escapeHtml(nodeId));
        } else {
            formData.append('NodeId', '');
        }

        const xhr = new XMLHttpRequest();
        xhr.open('POST', inventoryAuditUrl.getDetailsByResultIdUrl, true);
        xhr.send(formData);

        xhr.onload = function (event) {
            if (xhr.status == 200 && xhr.response !== null && !isRedirectToAuth(xhr.response)) {
                const body = document.getElementById('inventoryAuditDetails');
                body.innerHTML = xhr.response;
            } else {
                notifyWarning(ScanResultInventoryAuditController.errorText);
            }
        };

        xhr.onerror = function () {
            notifyWarning(ScanResultInventoryAuditController.errorText);
        };
    }
};

var ScanResultRegFixationController = {
    onInitComplete: function (settings) {
        const api = this.api();

        api.on('page.dt', function () {
            const scrollBody = $(api.table().node()).parent();
            scrollBody.scrollTop(0);
        });
    },

    onDrawCallbackForScanResult: function (settings) {
        const scrollBody = $(this.api().table().node()).parent();
        scrollBody.css('overflow-y', 'scroll');
    },

    onContextMenuItemClick: function (node, name) {
        var actionParams = $("form#regFixationsForm").attr("action").split("?command=");
        actionParams[1] = name;
        $("form#regFixationsForm").attr("action", actionParams.join("?command="));
        $("form#regFixationsForm").submit();
        this.close();
    },
};

var ScanResultFsFixationController = {
    onDrawCallbackForScanResult: function (settings) {
        const scrollBody = $(this.api().table().node()).parent();
        scrollBody.css('overflow-y', 'scroll');
    },

    onContextMenuItemClick: function (node, name) {
        var actionParams = $("form#fsFixationsForm").attr("action").split("?command=");
        actionParams[1] = name;
        $("form#fsFixationsForm").attr("action", actionParams.join("?command="));
        $("form#fsFixationsForm").submit();
        this.close();
    }
};

var ControlsInfoController = {
    onDrawCallback: function (settings) {
        bindToolTip();
    },

    openControlDetails: function (sender, row) {
        $.extend(document.createElement('a'), { href: sender.href, target: '_blank', rel: 'noopener' }).click();
    },
};

var HostsController = {
    selectedGroupIds: '',
    _$HostsTable: null,
    _$GroupsTable: null,

    HostGrid_OnPreInit: function (settings) {
        HostsController._$HostsTable = $(settings.nTable);
        HostsController.HostsGrid_AdjustSize();
    },

    HostsGrid_OnInitComplete: function (settings, json) {
        if (document.getElementById('IsViewHostsWithoutGroups').checked)
            document.getElementById('GroupsGrid_wrapper').classList.add('disableContent');
        else document.getElementById('GroupsGrid_wrapper').classList.remove('disableContent');

        backgroundTasksMonitor.on('tasks-stopped', () => {
            this.api().draw(false);
        });
    },

    HostsGrid_OnDrawCallback: function (settings) {
        HostsController.HostsGrid_AdjustSize();
        bindToolTip();
    },

    HostsGrid_OnBeginCallback: function (data) {
        data.selectedGroupIds = HostsController.selectedGroupIds;
        data.viewHostsWithoutGroups = document.getElementById('IsViewHostsWithoutGroups').checked;
    },

    HostGrid_Reset: function () {
        const api = HostsController._$HostsTable.DataTable();

        api.rowFocus().reset();
        api.redcheck.deselectAll();
    },

    HostsGrid_AdjustSize: function () {
        adjustGridSizeInSplitter('HostsGrid');
    },

    HostsGrid_DeleteHosts: function (e, dt) {
        const successText = 'Операция массового удаления хостов успешно запущена';
        const errorText = 'Во время выполнения запроса что-то пошло не так';

        const selectedIds = dt.redcheck.selectedIds().length > 0
            ? dt.redcheck.selectedIds()
            : [dt.redcheck.focusedId()];
        
        async function deleteHosts() {
            try {
                const response = await fetch('/Host/DeleteHosts', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(selectedIds),
                });
        
                if (response.ok) {
                    notifySuccess(successText);
                    HostsController.HostGrid_Reset();
                    
                    const taskKey = await response.text();
                    backgroundTasksMonitor.startTrackingTask(taskKey)
                } else {
                    notifyWarning(errorText);
                }
            } catch (e) {
                console.error(e);
                notifyWarning(errorText);
            }
        }

        window.showDeleteHostsDialog(selectedIds, deleteHosts);
    },

    GroupsGrid_OnPreInit: function (settings) {
        HostsController._$GroupsTable = $(settings.nTable);
        HostsController.GroupsGrid_AdjustSize();
    },

    GroupsGrid_OnInitComplete: function (settings, json) {
        backgroundTasksMonitor.on('tasks-stopped', () => {
            this.api().draw(false);
        });
    },

    GroupsGrid_OnDrawCallback: function (settings) {
        HostsController.GroupsGrid_AdjustSize();
        bindToolTip();
    },

    GroupsGrid_Reset: function () {
        const api = HostsController._$GroupsTable.DataTable();

        api.rowFocus().reset();
        api.redcheck.deselectAll().draw(false);
    },

    GroupsGrid_AdjustSize: function () {
        adjustGridSizeInSplitter('GroupsGrid');
    },

    SetSelectedGroup: function (value) {
        const _this = HostsController;
        const checkbox = document.getElementById('IsViewHostsWithoutGroups');

        let viewHostsWithoutGroups = checkbox ? checkbox.checked : false;
        let selectedGroupIds = value.length ? value.join(',') : '';

        if (viewHostsWithoutGroups === _this.viewHostsWithoutGroups && selectedGroupIds === _this.selectedGroupIds) {
            return;
        }

        _this.viewHostsWithoutGroups = viewHostsWithoutGroups;
        _this.selectedGroupIds = selectedGroupIds;
        _this.reloadHostsGrid();
    },

    GroupsGrid_DeleteGroup: function (e, dt) {
        const selectedRow = dt.redcheck.selectedIds()[0] ?? dt.redcheck.focusedId();
        window.showDeleteGroupDialog(selectedRow);
    },

    reloadHostsGrid: function () {
        HostsController._$HostsTable.DataTable().ajax.reload();
    }
};

var ReportsGridController = {
    _$ReportsTable: null,
    _$ConfirmDeleteDlg: null,

    onInitComplete: function (settings) {
        ReportsGridController._$ReportsTable = $(settings.nTable);
        ReportsGridController._$ConfirmDeleteDlg = createDialog('#confirmDeleteDlg');
    },

    onDrawCallback: function (settings) {
        $('.open-report:not(.gray)').on('click', openReportClick);
        bindToolTip();
    },

    delete: function (sender, row) {
        ReportsGridController._$ConfirmDeleteDlg
            .data('action', sender.href)
            .dialog('open');
    }
};

var CredentialsGridController = {
    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
    },

    onDrawCallback: function (settings) {
        $(settings.nScrollBody).css('overflow-y', 'scroll');
        bindToolTip();
    },

    handleRenameClick: function (sender, row) {
        renameCredentials(row.Id, row.Name);
    },

    handleDeleteClick: function (sender, row) {
        checkUsageJobs(row.Id, sender.href, row.Name);
    }
};

var PingResultGridController = {
    additionals: {
        isForScanResult: false,
        isForExecution: false,
        textTimer: null,
        urlForOverallPingResult: null,
        urlForPingResultForCsv: null
    },
    api: {},
    filters: {
        executionId: 0,
        group: null, //all groups
        credential: null, //all credentials
        agent: '', //all agents,
        text: '', //without search text
        isAvailable: false,
        isUnavailable: false
    },

    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);

        if (PingResultGridController.additionals.isForExecution) {
            PingResultGridController.api = this.api();
            $.ajax({
                url: PingResultGridController.additionals.urlForOverallPingResult,
                type: 'GET',
                success: function (data) {
                    PingResultGridController.fillData(data);
                },
                error: function (error) {
                    notifyWarning("Во время выполнения произошла ошибка");
                }
            });
        }
    },

    onDrawCallbackForExecution: function (settings) {
        PingResultGridController.additionals.isForExecution = true;
        $(settings.nScrollBody).css('overflow-y', 'scroll');
        bindToolTip();
    },

    onDrawCallbackForScanResult: function (settings) {
        PingResultGridController.additionals.isForScanResult = true;
        $(settings.nScrollBody).css('overflow-y', 'scroll');
        bindToolTip();
    },

    selectGroups: function (e) {
        PingResultGridController.filters.group = e.target.value;
        PingResultGridController.api.ajax.reload();
    },

    selectCredentials: function (e) {
        PingResultGridController.filters.credential = e.target.value;
        PingResultGridController.api.ajax.reload();
    },

    selectAgents: function (e) {
        PingResultGridController.filters.agent = e.target.value;
        PingResultGridController.api.ajax.reload();
    },

    selectSearch: function (e) {
        if (PingResultGridController.additionals.textTimer !== null)
            clearTimeout(PingResultGridController.additionals.textTimer);
        PingResultGridController.additionals.textTimer = setTimeout(function () {
            PingResultGridController.filters.text = e.target.value;
            PingResultGridController.api.ajax.reload();
        }, 500);
    },

    availableClick: function (value) {
        PingResultGridController.filters.isAvailable = value;
        PingResultGridController.api.ajax.reload();
    },

    unavailableClick: function (value) {
        PingResultGridController.filters.isUnavailable = value;
        PingResultGridController.api.ajax.reload();
    },

    fillData: function (data) {
        if (data != null) {
            let countSuccessfully = data.CountOfAvailableHosts;
            let countUnsuccessfully = data.CountOfUnAvailableHosts;
            let groups = data.Groups;
            let credentials = data.Credentials;
            let agents = data.Agents;

            if (groups != null)
                for (var i = 0; i < groups.length; i++) {
                    let option = document.createElement('option');
                    option.innerText = groups[i].Name;
                    option.value = groups[i].Id;
                    document.getElementById('filterHosts').appendChild(option);
                }
            if (credentials != null)
                for (var i = 0; i < credentials.length; i++) {
                    let option = document.createElement('option');
                    option.innerText = credentials[i].Name;
                    option.value = credentials[i].Id;
                    document.getElementById('filterCredentials').appendChild(option);
                }
            if (agents != null)
                for (var i = 0; i < agents.length; i++) {
                    let option = document.createElement('option');
                    option.innerText = agents[i];
                    document.getElementById('filterAgents').appendChild(option);
                }
            document.getElementById('availableCount').innerText = countSuccessfully;
            document.getElementById('notAvailableCount').innerText = countUnsuccessfully;
        }
    },

    exportStatisticsToCsvForPing: function () {
        let query = '';
        if (PingResultGridController.filters.group)
            query += '&GroupId=' + PingResultGridController.filters.group;
        if (PingResultGridController.filters.credential)
            query += '&CredentialId=' + PingResultGridController.filters.credential;
        if (PingResultGridController.filters.agent)
            query += '&Agent=' + PingResultGridController.filters.agent;
        if (PingResultGridController.filters.isAvailable)
            query += '&IsAvailable=' + PingResultGridController.filters.isAvailable;
        if (PingResultGridController.filters.isUnavailable)
            query += '&IsUnavailable=' + PingResultGridController.filters.isUnavailable;

        if (query)
            query = '?' + query;

        window.location = PingResultGridController.additionals.urlForPingResultForCsv + query;
    }
};

var HostDiscoveryResultPopupGridController = {
    api: {},

    filters: {
        hostName: '',
        hostIp: '',
        isNotMatchInDb: false,
        isWindows: false,
        isLinux: false,
        isOSNotDefined: false,
        isOther: false
        
    },

    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);

        HostDiscoveryResultPopupGridController.api = this.api();
    },

    noMatchClick: function (value) {
        HostDiscoveryResultPopupGridController.filters.isNotMatchInDb = value;
        HostDiscoveryResultPopupGridController.api.ajax.reload();
    },

    windowsClick: function (value) {
        HostDiscoveryResultPopupGridController.filters.isWindows = value;
        HostDiscoveryResultPopupGridController.api.ajax.reload();
    },

    linuxClick: function (value) {
        HostDiscoveryResultPopupGridController.filters.isLinux = value;
        HostDiscoveryResultPopupGridController.api.ajax.reload();
    },

    osNotDefinedClick: function (value) {
        HostDiscoveryResultPopupGridController.filters.isOSNotDefined = value;
        HostDiscoveryResultPopupGridController.api.ajax.reload();
    },

    otherClick: function (value) {
        HostDiscoveryResultPopupGridController.filters.isOther = value;
        HostDiscoveryResultPopupGridController.api.ajax.reload();
    }

};

var HostDiscoveryResultGridController = {
    additionals: {
        textTimer: null,
        urlForOverallResult: null,
        urlForCsvResult: null
    },
    api: {},
    filters: {
        hostName: '',
        hostIp: '',
        isMatchInDb: false,
        isNotMatchInDb: false,
        isWindows: false,
        isLinux: false,
        isOSNotDefined: false,
        isOther: false
    },

    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);

        HostDiscoveryResultGridController.api = this.api();
        HostDiscoveryResultGridController.loadStatistics();
    },

    loadStatistics: function () {
        $.ajax({
            url: HostDiscoveryResultGridController.additionals.urlForOverallResult,
            type: 'GET',
            success: function (data) {
                HostDiscoveryResultGridController.fillData(data);
            },
            error: function (error) {
                notifyWarning("Во время выполнения произошла ошибка");
            }
        });
    },

    selectIpSearch: function (e) {
        if (HostDiscoveryResultGridController.additionals.textTimer !== null)
            clearTimeout(HostDiscoveryResultGridController.additionals.textTimer);
        HostDiscoveryResultGridController.additionals.textTimer = setTimeout(function () {
            HostDiscoveryResultGridController.filters.hostIp = e.target.value;
            HostDiscoveryResultGridController.api.ajax.reload();
        }, 500);
    },

    selectNameSearch: function (e) {
        if (HostDiscoveryResultGridController.additionals.textTimer !== null)
            clearTimeout(HostDiscoveryResultGridController.additionals.textTimer);
        HostDiscoveryResultGridController.additionals.textTimer = setTimeout(function () {
            HostDiscoveryResultGridController.filters.hostName = e.target.value;
            HostDiscoveryResultGridController.api.ajax.reload();
        }, 500);
    },

    matchClick: function (value) {
        HostDiscoveryResultGridController.filters.isMatchInDb = value;
        HostDiscoveryResultGridController.api.ajax.reload();
    },

    noMatchClick: function (value) {
        HostDiscoveryResultGridController.filters.isNotMatchInDb = value;
        HostDiscoveryResultGridController.api.ajax.reload();
    },

    windowsClick: function (value) {
        HostDiscoveryResultGridController.filters.isWindows = value;
        HostDiscoveryResultGridController.api.ajax.reload();
    },

    linuxClick: function (value) {
        HostDiscoveryResultGridController.filters.isLinux = value;
        HostDiscoveryResultGridController.api.ajax.reload();
    },

    osNotDefinedClick: function (value) {
        HostDiscoveryResultGridController.filters.isOSNotDefined = value;
        HostDiscoveryResultGridController.api.ajax.reload();
    },

    otherClick: function (value) {
        HostDiscoveryResultGridController.filters.isOther = value;
        HostDiscoveryResultGridController.api.ajax.reload();
    },

    fillData: function (data) {
        if (data != null) {
            let matchHosts = data.MatchHostsCount;
            let noMatchHosts = data.NoMatchInDbHostsCount;

            document.getElementById('macthInDbCount').innerText = matchHosts;
            document.getElementById('noMacthInDbCount').innerText = noMatchHosts;
        }
    },

    exportStatisticsToCsv: function () {
        let query = '';
        if (HostDiscoveryResultGridController.filters.hostIp)
            query += '&hostIp=' + HostDiscoveryResultGridController.filters.hostIp;
        if (HostDiscoveryResultGridController.filters.hostName)
            query += '&hostName=' + HostDiscoveryResultGridController.filters.hostName;
        if (HostDiscoveryResultGridController.filters.isMatchInDb)
            query += '&isMatchInDb=' + HostDiscoveryResultGridController.filters.isMatchInDb;
        if (HostDiscoveryResultGridController.filters.isNotMatchInDb)
            query += '&isNotMatchInDb=' + HostDiscoveryResultGridController.filters.isNotMatchInDb;
        if (HostDiscoveryResultGridController.filters.isWindows)
            query += '&isWindows=' + HostDiscoveryResultGridController.filters.isWindows;
        if (HostDiscoveryResultGridController.filters.isLinux)
            query += '&isLinux=' + HostDiscoveryResultGridController.filters.isLinux;
        if (HostDiscoveryResultGridController.filters.isOSNotDefined)
            query += '&isOSNotDefined=' + HostDiscoveryResultGridController.filters.isOSNotDefined;
        if (HostDiscoveryResultGridController.filters.isOther)
            query += '&isOther=' + HostDiscoveryResultGridController.filters.isOther;

        if (query)
            query = '?' + query;

        window.location = HostDiscoveryResultGridController.additionals.urlForCsvResult + query;
    }
};

var PentestResultGridController = {
    additionals: {
        textTimer: null,
        urlForOverallResult: null,
        urlForCsvResult: null
    },
    api: {},
    filters: {
        ports: '',
        scanResult: null,
        groupId: null,
        isCritical: true,
        isHigh: true,
        isInfo: true,
        isMedium: true,
        isLow: true,
        isUnknown: true,
    },

    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);

        PentestResultGridController.api = this.api();
        $.ajax({
            url: PentestResultGridController.additionals.urlForOverallResult,
            type: 'GET',
            success: function (data) {
                PentestResultGridController.fillData(data);
            },
            error: function (error) {
                notifyWarning("Во время выполнения произошла ошибка");
            }
        });
    },

    reload: function () {
        openPopup();

        PentestResultGridController.filters.isCritical = checkCritical;
        PentestResultGridController.filters.isHigh = checkHigh;
        PentestResultGridController.filters.isInfo = checkInfo;
        PentestResultGridController.filters.isUnknown = checkUnknown;
        PentestResultGridController.filters.isLow = checkLow;
        PentestResultGridController.filters.isMedium = checkMedium;

        PentestResultGridController.api.ajax.reload();
    },

    selectPortSearch: function (e) {
        if (PentestResultGridController.additionals.textTimer !== null)
            clearTimeout(PentestResultGridController.additionals.textTimer);
        PentestResultGridController.additionals.textTimer =
            setTimeout(function () {
                const isValid = PentestResultGridController.isValidFilterForPorts(e.target.value);
                if (!isValid) {
                    notifyWarning('Неверный формат ввода или количество портов превышает 30');
                    return;
                }

                PentestResultGridController.filters.ports = e.target.value;
                PentestResultGridController.api.ajax.reload();
            }, 1000);
    },

    isValidFilterForPorts: function (str) {
        function parsePortFromStr(value) {
            return /^[1-9]\d*$/.test(value.trim()) ? parseInt(value, 10) : NaN;
        }

        const maxCount = 30;
        let ports = [];
        const parts = str.split(',')
            .map(function (value) { return value.trim(); })
            .filter(function (value) { return value.length > 0; });

        for (let i in parts) {
            if (parts[i].indexOf('-') > -1) {
                const nums = parts[i].split('-').map(parsePortFromStr);

                if (nums.length != 2 || isNaN(nums[0]) || isNaN(nums[1])) return false;

                if (nums[0] < nums[1] && nums[0] > 0 && nums[0] <= 65535 && nums[1] > 0 && nums[1] <= 65535) {
                    for (let port = nums[0]; port <= nums[1]; port++) {
                        ports.push(port);
                    }
                } else {
                    return false;
                }
            } else {
                const port = parsePortFromStr(parts[i]);

                if (!isNaN(port) && port > 0 && port <= 65535) {
                    ports.push(port);
                } else {
                    return false;
                }
            }
        }

        const uniquePorts = ports.filter(function (port, index) { return ports.indexOf(port) === index; });
        return uniquePorts.length <= maxCount;
    },

    selectGroups: function (e) {
        PentestResultGridController.filters.groupId = e.target.value;
        PentestResultGridController.api.ajax.reload();
    },

    selectStatus: function (e) {
        PentestResultGridController.filters.scanResult = e.target.value;
        PentestResultGridController.api.ajax.reload();
    },

    fillData: function (data) {
        if (data != null) {
            document.getElementById('hostsCount').innerText = data.HostsCount;
            document.getElementById('availableCount').innerText = data.AvailableHostsCount;
            document.getElementById('openPortsCount').innerText = data.OpenPortsCount;
            document.getElementById('vulnarabilityHostsCount').innerText = data.VulnarabilityHostsCount;
            document.getElementById('hostsWithHighSeverityCount').innerText = data.HostsWithHighSeverityCount;

            let groups = data.Groups;
            if (groups != null)
                for (var i = 0; i < groups.length; i++) {
                    let option = document.createElement('option');
                    option.innerText = groups[i].Name;
                    option.value = groups[i].Id;
                    document.getElementById('filterHosts').appendChild(option);
                }
        }
    },

    exportStatisticsToCsv: function () {
        let query = '';
        if (PentestResultGridController.filters.ports)
            query += '&ports=' + PentestResultGridController.filters.ports;
        if (PentestResultGridController.filters.scanResult)
            query += '&scanResult=' + PentestResultGridController.filters.scanResult;
        if (PentestResultGridController.filters.groupId)
            query += '&groupId=' + PentestResultGridController.filters.groupId;
        if (PentestResultGridController.filters.isCritical)
            query += '&isCritical=' + PentestResultGridController.filters.isCritical;
        if (PentestResultGridController.filters.isHigh)
            query += '&isHigh=' + PentestResultGridController.filters.isHigh;
        if (PentestResultGridController.filters.isInfo)
            query += '&isInfo=' + PentestResultGridController.filters.isInfo;
        if (PentestResultGridController.filters.isUnknown)
            query += '&isUnknown=' + PentestResultGridController.filters.isUnknown;
        if (PentestResultGridController.filters.isLow)
            query += '&isLow=' + PentestResultGridController.filters.isLow;
        if (PentestResultGridController.filters.isMedium)
            query += '&isMedium=' + PentestResultGridController.filters.isMedium;

        if (query)
            query = '?' + query;

        window.location = PentestResultGridController.additionals.urlForCsvResult + query;
    }
};

var DockerVulnerabilityStatisticsResultGridController = {
    additionals: {
        textTimer: null,
        urlForOverallResult: null,
        urlForDockerVulnarabilityResultForCsv: null
    },
    api: {},
    filters: {
        executionId: 0,
        group: null, //all groups
        status: null
    },

    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
        DockerVulnerabilityStatisticsResultGridController.api = this.api();
        $.ajax({
            url: DockerVulnerabilityStatisticsResultGridController.additionals.urlForOverallResult,
            type: 'GET',
            success: function (data) {
                DockerVulnerabilityStatisticsResultGridController.fillData(data);
            },
            error: function (error) {
                notifyWarning("Во время выполнения произошла ошибка");
            }
        });
    },

    onDrawCallback: function (settings) {
        $(settings.nScrollBody).css('overflow-y', 'scroll');
        bindToolTip();
    },

    selectGroups: function (e) {
        DockerVulnerabilityStatisticsResultGridController.filters.group = e.target.value;
        DockerVulnerabilityStatisticsResultGridController.api.ajax.reload();
    },

    selectStatus: function (e) {
        DockerVulnerabilityStatisticsResultGridController.filters.status = e.target.value;
        DockerVulnerabilityStatisticsResultGridController.api.ajax.reload();
    },

    fillData: function (data) {
        if (data != null) {
            document.getElementById('hostsCount').innerText = data.Hosts;
            document.getElementById('availableCount').innerText = data.AvailableHosts;
            document.getElementById('imagesCount').innerText = data.Images;
            document.getElementById('hostsWithImagesCount').innerText = data.HostsWithImages;
            document.getElementById('hostsWithVulnerabilityImagesCount').innerText = data.HostsWithVulnarabilityImages;
            document.getElementById('containersCount').innerText = data.Containers;
            document.getElementById('imagesWithHighSeverity').innerText = data.ImagesWithHighSeverity;

            let groups = data.Groups;
            if (groups != null)
                for (var i = 0; i < groups.length; i++) {
                    let option = document.createElement('option');
                    option.innerText = groups[i].Name;
                    option.value = groups[i].Id;
                    document.getElementById('filterHosts').appendChild(option);
                }
        }
    },

    exportStatisticsToCsvForDockerVulnarability: function () {
        let query = '';
        if (DockerVulnerabilityStatisticsResultGridController.filters.group)
            query += '&GroupId=' + DockerVulnerabilityStatisticsResultGridController.filters.group;
        if (DockerVulnerabilityStatisticsResultGridController.filters.status)
            query += '&Result=' + DockerVulnerabilityStatisticsResultGridController.filters.status;

        if (query)
            query = '?' + query;

        window.location = DockerVulnerabilityStatisticsResultGridController.additionals.urlForDockerVulnarabilityResultForCsv + query;
    }
};

var DockerImagesResultGridController = {
    additionals: {
        textTimer: null
    },
    api: {},
    filters: {
        scanId: 0,
        repositoryText: '', //repository search text
        tagText: '', //tag search text
        onlyCriticalVulnerability: false,
    },
    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
        DockerImagesResultGridController.api = this.api();
    },
    onDrawCallbackForScanResult: function (settings) {
        DockerImagesResultGridController.additionals.isForScanResult = true;
        $(settings.nScrollBody).css('overflow-y', 'scroll');
        bindToolTip();
    },
    criticalVulnerabilityClick: function (value) {
        DockerImagesResultGridController.filters.onlyCriticalVulnerability = value;
        DockerImagesResultGridController.api.ajax.reload();
    },
    selectSearchByRepository: function (e) {
        if (DockerImagesResultGridController.additionals.textTimer !== null)
            clearTimeout(DockerImagesResultGridController.additionals.textTimer);
        DockerImagesResultGridController.additionals.textTimer = setTimeout(function () {
            if (!$.fn.DataTable.isDataTable(DockerImagesResultGridController.api))
                return;

            DockerImagesResultGridController.filters.repositoryText = e.target.value;
            DockerImagesResultGridController.api.ajax.reload();
        }, 500);
    },
    selectSearchByTag: function (e) {
        if (DockerImagesResultGridController.additionals.textTimer !== null)
            clearTimeout(DockerImagesResultGridController.additionals.textTimer);
        DockerImagesResultGridController.additionals.textTimer = setTimeout(function () {
            if (!$.fn.DataTable.isDataTable(DockerImagesResultGridController.api))
                return;

            DockerImagesResultGridController.filters.tagText = e.target.value;
            DockerImagesResultGridController.api.ajax.reload();
        }, 500);
    }
}

var apiDataForAuditResultController = {
    filters: {
        repositoryText: function () {
            if ($('#OvalAuditInventoryGrid').height() > 0)
                return apiDataForAuditResultController.dataForInventoryResult.filter.repositoryText;
            if ($('#OvalAuditGrid').height() > 0)
                return apiDataForAuditResultController.dataForAuditResult.filter.repositoryText;
        },
        tagText: function () {
            if ($('#OvalAuditInventoryGrid').height() > 0)
                return apiDataForAuditResultController.dataForInventoryResult.filter.tagText;
            if ($('#OvalAuditGrid').height() > 0)
                return apiDataForAuditResultController.dataForAuditResult.filter.tagText;
        },
        referenceText: function () {
            if ($('#OvalAuditInventoryGrid').height() > 0)
                return apiDataForAuditResultController.dataForInventoryResult.filter.referenceText;
            if ($('#OvalAuditGrid').height() > 0)
                return apiDataForAuditResultController.dataForAuditResult.filter.referenceText;
        },
        severity: function () {
            if ($('#OvalAuditInventoryGrid').height() > 0)
                return apiDataForAuditResultController.dataForInventoryResult.filter.severity;
            if ($('#OvalAuditGrid').height() > 0)
                return apiDataForAuditResultController.dataForAuditResult.filter.severity;
        },
    },
    dataForAuditResult: {
        api: {},
        filter: {}
    },
    dataForInventoryResult: {
        api: {},
        filter: {}
    }
}

var OvalAuditResultGridController = {
    additionals: {
        textTimer: null
    },
    filters: {
        scanId: 0,
        repositoryText: '', //repository search text
        tagText: '', //tag search text
        referenceText: '', //reference search text
        severity: [] //find by severity
    },
    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
        if (settings.sInstance == "OvalAuditGrid")
            apiDataForAuditResultController.dataForAuditResult.api = api;
        if (settings.sInstance == "OvalAuditInventoryGrid")
            apiDataForAuditResultController.dataForInventoryResult.api = api;
    },
    onDrawCallbackForScanResult: function (settings) {
        const scrollBody = $(this.api().table().node()).parent();
        scrollBody.css('overflow-y', 'scroll');
        bindToolTip();
    },
    onRowGroupDataSrc: function (e, api, value) {
        const columnSeverity = api.column('Severity:name');
        columnSeverity.visible(columnSeverity.dataSrc() !== value);
        bindToolTip();
    },
    selectSearchByRepository: function (e) {
        if (this.additionals.textTimer !== null)
            clearTimeout(this.additionals.textTimer);
        this.additionals.textTimer = setTimeout(function () {
            OvalAuditResultGridController.setFilter({
                name: 'repositoryText',
                value: e.target.value
            });
        }, 500);
    },
    selectSearchByTag: function (e) {
        if (this.additionals.textTimer !== null)
            clearTimeout(this.additionals.textTimer);
        this.additionals.textTimer = setTimeout(function () {
            OvalAuditResultGridController.setFilter({
                name: 'tagText',
                value: e.target.value
            });
        }, 500);
    },
    selectSearchByReferences: function (e) {
        if (this.additionals.textTimer !== null)
            clearTimeout(this.additionals.textTimer);
        this.additionals.textTimer = setTimeout(function () {
            OvalAuditResultGridController.setFilter({
                name: 'referenceText',
                value: e.target.value
            });
        }, 500);
    },

    selectAllSeverity: function (e) {
        checkAllSeverityClick();
        this.checkSeverity();
    },

    checkSeverity: function () {
        let checkedSeverities = [];
        if (document.querySelector('#checkCritical').checked) checkedSeverities.push(Severity.CRITICAL);
        if (document.querySelector('#checkHigh').checked) checkedSeverities.push(Severity.HIGH);
        if (document.querySelector('#checkMedium').checked) checkedSeverities.push(Severity.MEDIUM);
        if (document.querySelector('#checkLow').checked) checkedSeverities.push(Severity.LOW);
        if (document.querySelector('#checkInfo').checked) checkedSeverities.push(Severity.INFO);
        if (document.querySelector('#checkUnknown').checked) checkedSeverities.push(Severity.UNKNOWN);

        OvalAuditResultGridController.setFilter({
            name: 'severity',
            value: checkedSeverities
        });
    },

    severitySelectHandler: function (e) {
        document.querySelectorAll('.js-checkboxSeverity').forEach(checkbox => {
            checkbox.onclick = this.checkSeverity;
        })
    },

    setFilter: function (data) {
        if ($('#OvalAuditInventoryGrid').height() > 0) {
            const api = apiDataForAuditResultController.dataForInventoryResult.api;
            let filter = apiDataForAuditResultController.dataForInventoryResult.filter;

            if ($.fn.DataTable.isDataTable(api)) {
                filter[data.name] = data.value;
                api.remoteGrouping().clear();
                api.ajax.reload();
            }
        }

        if ($('#OvalAuditGrid').height() > 0) {
            const api = apiDataForAuditResultController.dataForAuditResult.api;
            let filter = apiDataForAuditResultController.dataForAuditResult.filter;

            if ($.fn.DataTable.isDataTable(api)) {
                filter[data.name] = data.value;
                api.remoteGrouping().clear();
                api.ajax.reload();
            }
        }
    }
}

var apiDataForYaraResultController = {
    filters: {
        ruleText: function () {
            return apiDataForYaraResultController.dataForResult.filter.ruleText;
        },
        ruleType: function () {
            return apiDataForYaraResultController.dataForResult.filter.ruleType;
        },
    },
    dataForResult: {
        api: {},
        filter: {}
    }
}

var YaraResultGridController = {
    additionals: {
        textTimer: null
    },
    filters: {
        scanId: 0,
        ruleText: '', // Rule search text
        ruleType: 0,
        referenceText: ''
    },
    onInitComplete: function (settings) {
        apiDataForYaraResultController.dataForResult.api = new $.fn.dataTable.Api(settings);
    },
    onDrawCallbackForScanResult: function (settings) {
        const scrollBody = $(this.api().table().node()).parent();
        scrollBody.css('overflow-y', 'scroll');
        bindToolTip();
    },
    selectSearchByRule: function (e) {
        if (this.additionals.textTimer !== null)
            clearTimeout(this.additionals.textTimer);
        this.additionals.textTimer = setTimeout(function () {
            YaraResultGridController.setFilter({
                name: 'ruleText',
                value: e.target.value
            });
        }, 500);
    },
    selectRuleType: function (e) {
        YaraResultGridController.setFilter({
            name: 'ruleType',
            value: e.target.value
        });
    },
    setFilter: function (data) {
        if ($('#YaraGrid').height() > 0) {
            const api = apiDataForYaraResultController.dataForResult.api;
            let filter = apiDataForYaraResultController.dataForResult.filter;

            if ($.fn.DataTable.isDataTable(api)) {
                filter[data.name] = data.value;
                api.remoteGrouping().clear();
                api.ajax.reload();
            }
        }
    }
}

function exportStatisticsToCsv(scanType) {
    switch (scanType) {
        case "Ping":
            PingResultGridController.exportStatisticsToCsvForPing();
            break;
        case "DockerVulnerabilities":
            DockerVulnerabilityStatisticsResultGridController.exportStatisticsToCsvForDockerVulnarability();
            break;
        case "HostDiscovery":
            HostDiscoveryResultGridController.exportStatisticsToCsv();
            break;
        case "Nmap":
            PentestResultGridController.exportStatisticsToCsv();
            break;
        default: notifyInfo("Экспорт не поддерживается");
    }
}

var CredentialsController = {
    credentialsSelectorGridViewisibleIndexes: {},
    SelectionChanged: function (s, e) {
        $('#credentialsSelectorGridView .gridViewSummary .gridViewTotal .totalCount').text(s.GetSelectedRowCount());
        var rowKeyValue = s.GetRowKey(e.visibleIndex);
        if (e.isSelected) {
            CredentialsController.credentialsSelectorGridViewisibleIndexes[rowKeyValue] = e.visibleIndex;
        }
        else
            delete CredentialsController.credentialsSelectorGridViewisibleIndexes[rowKeyValue];
    }
};

var HostController = {
    selectGroups: function () {
        var groupsSelectorGridView = ASPxClientControl.GetControlCollection().GetByName('groupsSelectorGridView');
        var array_values = new Array();
        for (var key in GroupsController.groupsSelectorGridViewisibleIndexes) {
            array_values.push(GroupsController.groupsSelectorGridViewisibleIndexes[key]);
        }
        if (array_values.length === 0) return;
        for (i = 0; i < array_values.length; i++) {
            groupsSelectorGridView.GetRowValues(array_values[i], 'Id;Name;Description', HostController.GroupsSelector_OnGetRowValues);
        }
    },
    GroupsSelector_OnGetRowValues: function (values) {
        if (values[0] === null) {
            closeModal();
            return;
        }
        var val1 = values[1] === null ? '' : values[1];
        var val2 = values[2] === null ? '' : values[2];
        var rowCount = $('#groupsForHostGrid tbody tr').length;
        $('#groupsForHostGrid tr:last').after('<tr class="dxgvDataRow_Office2010Silver">' +
            '<td class="dxgv cell">' +
            '<input data-val="true" id="Groups_' + rowCount + '__Id" name="Groups[' + rowCount + '].Id" type="hidden" value="' + values[0] + '">' +
            '<input class="readonlyInputForModel col-sm-12" id="Groups_' + rowCount + '__Name" name="Groups[' + rowCount + '].Name" readonly="true" type="text" value="' + val1 + '">' +
            '<input data-val="true" id="Groups_' + rowCount + '__ToDelete" name="Groups[' + rowCount + '].ToDelete" type="hidden" value="False">' +
            '</td>' +
            '<td class="dxgv cell"><input class="readonlyInputForModel col-sm-12" id="Groups_' + rowCount + '__Description" name="Groups[' + rowCount + '].Description" readonly="true" type="text" value="' + val2 + '"></td>' +
            '<td class="dxgv cell">' +
            '<a href="#" onclick="deleteGroupFromGrid(' + rowCount + ')" class="col-sm-12"><img src="/Content/rc_icons/basket.png" alt="" title="@RedCheck.Common.Rsx.Resources.CmdDelete"></a>' +
            '</td > ' +
            '</tr>');
        closeModal();
    },

    CredentialsSelector_OnGetRowValues: function (values) {
        if (values[0] === null) {
            closeModal();
            return;
        }

        var rowCount = $('#credentialsForHostGrid tbody tr').length;
        $('#credentialsForHostGrid tr:last').after('<tr class="dxgvDataRow_Office2010Silver">' +
            '<td class="dxgv cell">' +
            '<input data-val="true" id="TargetCredentials_' + rowCount + '__Id" name="TargetCredentials[' + rowCount + '].Id" type="hidden" value="' + values[0] + '">' +
            '<input class="readonlyInputForModel col-sm-12" data-val="true" id="TargetCredentials_' + rowCount + '__Priority" name="TargetCredentials[' + rowCount + '].Priority" readonly="true" type="text" value="' + rowCount + '">' +
            '<input data-val="true" id="TargetCredentials_' + rowCount + '__ToDelete" name="TargetCredentials[' + rowCount + '].ToDelete" type="hidden" value="False">' +
            '</td>' +
            '<td class="dxgv cell">' +
            '<input class="readonlyInputForModel col-sm-12" data-val="true" id="TargetCredentials_' + rowCount + '__Type" name="TargetCredentials[' + rowCount + '].Type" readonly="true" type="text" value="' + values[1] + '">' +
            '</td>' +
            '<td class="dxgv cell">' +
            '<input class="readonlyInputForModel col-sm-12" id="TargetCredentials_' + rowCount + '__Name" name="TargetCredentials[' + rowCount + '].Name" readonly="true" type="text" value="' + values[3] + '">' +
            '</td>' +
            '<td class="dxgv cell">' +
            '</td>' +
            '<td class="dxgv cell">' +
            '<input class="readonlyInputForModel col-sm-12" id="TargetCredentials_' + rowCount + '__CreatedDate" name="TargetCredentials[' + rowCount + '].CreatedDate" readonly="true" type="text" value="' + values[4] + '">' +
            '</td>' +
            '<td class="dxgv cell">' +
            '<a href="#" onclick="deleteCredentialFromGrid(0)" class="col-sm-12"><img src="/Content/rc_icons/basket.png" alt="" title="Удалить"></a>' +
            '</td>' +
            '</tr>');
        closeModal();
    }
};

function submitFormById(formId) {
    var form = $('#' + formId);
    form.submit();
}

var ImportOvalDefinitionsController = {
    processingUploadFiles: function () {
        const form = document.getElementById('ucOvalDefsFileUploader');
        const formData = new FormData(form);
        const xhr = new XMLHttpRequest();

        xhr.responseType = 'json';
        xhr.open(form.method, form.action, true);
        xhr.send(formData);

        xhr.onload = function (event) {
            if (xhr.status == 200 && xhr.response !== null) {
                ImportOvalDefinitionsController.onFileUploadComplete(xhr.response);
            } else {
                notifyWarning(ImportCsvHostsController.errorText);
            }
        };

        xhr.onerror = function () {
            notifyWarning(ImportCsvHostsController.errorText);
        };
    },

    onFileUploadComplete: function (response) {
        document.getElementById('ucOvalDefsFileUploader').reset();
        ImportOvalDefinitionsController.UpdateTasks();
    },
    OnShowImportOvalDefModal: function () {
        const table = document.getElementById('OvalDefTasksGrid');

        if (!$.fn.DataTable.isDataTable(table)) {
            createOvalDefTasksGrid();
        }

        setTimeout(function () {
            $.fn.dataTable.util.columnsAjustSize();
        }, 200);
    },
    OnShownImportOvalDefModal: function () {
        ImportOvalDefinitionsController.UpdateTasks();
    },
    UpdateTasks: function () {
        const table = document.getElementById('OvalDefTasksGrid');

        if ($.fn.DataTable.isDataTable(table)) {
            $(table).dataTable().api().ajax.reload();
            return;
        }
    },
    DeleteTask: function (url, id) {
        $.post(url, { id: id },
            function () {
                const table = document.getElementById('OvalDefTasksGrid');

                if ($.fn.DataTable.isDataTable(table)) {
                    $(table).dataTable().api().ajax.reload();
                    return;
                }
            });
    },
    setElementVisible: function (elementId, element2Id, visible) {
        var el = $("#" + elementId);
        var el2 = $("#" + element2Id);
        if (visible) {
            el.show();
            el2.hide();
        } else {
            el.hide();
            el2.show();
        }
    }
};

var AdUsersController = {
    _table: null,
    CheckValidAdData: function (s, e) {
        var btnSearchUsers = document.getElementById('btnSearchUsers');
        var type = document.getElementById('selectType')

        if (type.selectedIndex === 0) {
            document.getElementById('filterForCredentialsAD').classList.remove('disableContent');
            btnSearchUsers.setAttribute('disabled', true);
        }
        if (type.selectedIndex === 1) {
            document.getElementById('filterForCredentialsAD').classList.add('disableContent');
            btnSearchUsers.removeAttribute('disabled');
        }
        if (type.selectedIndex === 2) {
            document.getElementById('filterForCredentialsAD').classList.remove('disableContent');

            if ($.trim($('input[name="HostName"]').val()) === '' || $.trim($('input[name="CredentialName"]').val()) === '') {
                btnSearchUsers.setAttribute('disabled', true);
            } else {
                btnSearchUsers.removeAttribute('disabled');
            }
        }
    },
    OnSearchUsersComplete: function (response) {
        $('div.main').removeClass('disableContent');
        $('#loader').addClass('hide');
    },
    OnSearchUsersError: function (message) {
        notifyWarning(message.statusText);
        $('div.main').removeClass('disableContent');
        $('#loader').addClass('hide');
    },
    OnBeginGetUsers: function () {
        $('div.main').addClass('disableContent');
        $('#loader').removeClass('hide');
    },
    OnSuccessGetUsersAD: function (data) {
        if (data.err) {
            notifyWarning(data.err);
        }

        AdUsersController.setListUsers(data.users);
        AdUsersController.CheckValidAdData();
    },
    adGettingType_OnSelectedIndexChanged: function (s, e) {
        AdUsersController.CheckValidAdData();
    },

    onInitComplete: function (settings, json) {
        AdUsersController._table = $(settings.nTable).DataTable();
    },

    onDrawCallback: function (settings) {
        bindToolTip();
    },

    setListUsers: function (data) {
        AdUsersController._table
            .clear()
            .rows.add(data)
            .draw();
    }
};

const createFragmentForHostResponse = (newHosts, modifiedHosts, message, updatedHosts = 0, isImport = false, additionalMessage = '') => {
    const fragment = document.createDocumentFragment();

    const pNewHosts = document.createElement('p');
    pNewHosts.innerHTML = !isImport ? `Создано новых хостов: <b>${newHosts}</b>` : `Новых хостов было импортировано: <b>${newHosts}</b>`;
    fragment.appendChild(pNewHosts);

    if (modifiedHosts !== 0) {
        const pModifiedHosts = document.createElement('p');
        pModifiedHosts.innerHTML = `Существующих хостов добавлено в новые группы: <b>${modifiedHosts}</b>`;
        fragment.appendChild(pModifiedHosts);
    }
    if (updatedHosts !== 0) {
        const pUpdatedHosts = document.createElement('p');
        pUpdatedHosts.innerHTML = `Существующим хостам обновлено описание: <b>${updatedHosts}</b>`;
        fragment.appendChild(pUpdatedHosts);
    }
    if (message !== '') {
        const pMessage = document.createElement('p');
        pMessage.innerHTML = `<u>${message}</u>`;
        fragment.appendChild(pMessage);
    }
    if (additionalMessage !== '') {
        const pAdditionalMessage = document.createElement('p');
        pAdditionalMessage.innerHTML = additionalMessage;
        fragment.appendChild(pAdditionalMessage);
    }
    
    return fragment;
}

var AdImportHostsController = {
    GetSelectedIds: function () {
        const table = document.getElementById('SelectAdImportHostsGrid');
        let result = [];

        if ($.fn.dataTable.isDataTable(table)) {
            const selected = $(table).dataTable().api().column('Id:name').checkboxes.selected();
            result = selected !== undefined ? selected.toArray() : [];
        }

        return result;
    },
    OnSubmitClick: function () {
        $('div.main').addClass('disableContent');
        $('#loader').removeClass('hide');

        const selectedItems = AdImportHostsController.GetSelectedIds();

        if (selectedItems.length === 0) {
            $('div.main').removeClass('disableContent');
            $('#loader').addClass('hide');

            notifyWarning(hostImportMessages.needSelecteHosts);
            return;
        }

        $("#selectedIDsHF").val(selectedItems.join(';'));

        $("#Import_ADSearchFilter").val($('#Filter_ADFilter').val());
        $("#Import_CredentialName").val($('#Filter_CredentialName').val());
        $("#Import_GroupName").val($('#Filter_GroupName').val());
        $("#Import_HostName").val($('#Filter_HostName').val());
        $("#Import_ImportHostType").val($("#Filter_ImportHostType").val());
        $("#Import_IsSearchFirst1000Items").val($("#Filter_IsSearchFirst1000Items").val());
        $("#Import_CredentialId").val($("#Filter_CredentialId").val());
        $("#Import_GroupId").val($("#Filter_GroupId").val());
        $("#Import_HostId").val($("#Filter_HostId").val());
        $("#Import_ADSearchPath").val($("#Filter_ADSearchPath").val());
        $("#Import_SelectedDomainProtocolType").val($('#Filter_SelectedDomainProtocolType').val());

        $('#importHostsForm').submit();
    },
    OnImportComplete: function (data) {
        const jsonData = JSON.parse(data.responseText);
        if (jsonData.result === "ok") {
            const { CountOfImportedHosts, CountOfModifiedHosts, ImportMessage } = jsonData.message;

            let div = document.createElement('div');
            const fragment = createFragmentForHostResponse(CountOfImportedHosts, CountOfModifiedHosts, ImportMessage, 0, true);
            div.appendChild(fragment);
            notifySuccess(div.outerHTML);
        } else if (jsonData.message.length > 0) {
            notifyWarning(jsonData.message);
        } else {
            notifyWarning(hostImportMessages.importDefaultError);
        }

        $('div.main').removeClass('disableContent');
        $('#loader').addClass('hide');
    },
    OnImportFailure: function () {
        notifyWarning(hostImportMessages.importDefaultError);

        $('div.main').removeClass('disableContent');
        $('#loader').addClass('hide');
    },

    CheckValidAdData: function () {
        var btnADSearchTree = document.getElementById('btnADSearchTree');
        var btnSearchHosts = document.getElementById('btnSearchHosts');

        if ($.trim($('input[name="Filter.HostName"]').val()) === '' || $.trim($('input[name="Filter.CredentialName"]').val()) === '') {
            btnADSearchTree.title = disabledBtnTooltip;
            btnADSearchTree.disabled = true;
            btnSearchHosts.title = disabledBtnTooltip;
            btnSearchHosts.disabled = true;
        } else {
            btnADSearchTree.title = enabledAdFilterBtnTooltip;
            btnADSearchTree.disabled = false;
            btnSearchHosts.title = '';
            btnSearchHosts.disabled = false;
        }
    },
    SearchHostsClick: function () {
        $('div.main').addClass('disableContent');
        $('#loader').removeClass('hide');

        $.ajax({
            url: '/clientrequest?url=' +
                hostsImportsUrl.checkAdParams +
                encodeURIComponent('?hostName=' + document.getElementById('Filter_HostName').value) +
                encodeURIComponent('&credentialId=' + document.getElementById('Filter_CredentialId').value) +
                encodeURIComponent('&typeDomain=' + document.getElementById('Filter_SelectedDomainProtocolType').value)            ,
            type: 'GET',
            contentType: "application/json; charset=utf-8",
            error: function () {
                AdImportHostsController.ShowSearchHostsError();
            },
            success: function (data) {
                var jsonData = JSON.parse(data);
                if (jsonData.result === "ok") {
                    $('#searchHostsForm').submit();
                    return;
                } else if (jsonData.message.length > 0) {
                    AdImportHostsController.ShowSearchHostsError(jsonData.message);
                } else {
                    AdImportHostsController.ShowSearchHostsError();
                }
            }
        });
    },
    OnFillFilterComplete: function () {
        $('div.main').removeClass('disableContent');
        $('#loader').addClass('hide');

        const table = document.getElementById('SelectAdImportHostsGrid');
        if ($.fn.DataTable.isDataTable(table)) {
            $(table).dataTable().api().column('Id:name').checkboxes.deselectAll();
            $(table).dataTable().api().ajax.reload();
            return;
        }
    },
    OnFillFilterError: function () {
        AdImportHostsController.ShowSearchHostsError();
    },
    ShowSearchHostsError: function (message) {
        if (message === undefined)
            message = hostImportMessages.searchDefaultError + '.';

        notifyWarning(message);
        $('div.main').removeClass('disableContent');
        $('#loader').addClass('hide');
    },

    OnChangeCredentialTypesForSelectLDAPDomainType: function (select) {
        let filter = {};

        switch (select.value) 
        {
            case '0': // ActiveDirectory
                filter.CredentialTypes = [0]; // Windows/LDAP
                break;
            case '1': // FreeIPA
                filter.CredentialTypes = [0]; // Windows/LDAP
                break;
            case '2': // ALD
                filter.CredentialTypes = [0]; // Windows/LDAP
                break;
            case '3': // RedADM
                filter.CredentialTypes = [0]; // Windows/LDAP
                break;
            default:
                break;
        }

        AdImportHostsController.setDefaultAdFilter();

        document.getElementById('Filter_ADSearchPath').value = '';
        CredentialsPopupControler.setFilter(filter);
    },
    
    setDefaultAdFilter: function () {
        const protocolType = document.getElementById('Filter_SelectedDomainProtocolType').value;
        const input = document.getElementById('Filter_ADFilter');

        switch (protocolType)
        {
            case '0': // ActiveDirectory
                input.value = "(&(objectCategory=computer))";
                break;
            case '1': // FreeIPA
                input.value = "(&(objectClass=ipahost))";
                break;
            case '2': // ALD
                input.value = "(&(objectClass=x-ald-host-object))";
                break;
            case '3': // RedADM
                input.value = "(&(objectCategory=computer))";
                break;
            default:
                break;
        }
    }
};

var LdapPathPopupController = {
    errorText: 'Во время выполнения запроса что-то пошло не так',
    ldapObjectsTreeView: null,

    onShow: function (event) {
        LdapPathPopupController.showPreloader();
    },

    onShown: function (event) {
        LdapPathPopupController.ldapObjectsTreeView = new TreeView({
            selector: '#ldapObjectsTreeView',
            initComplete: LdapPathPopupController.onInitCompleteForTreeView
        });

        $('#ldapObjectsTreeView').on('expand.treeview', LdapPathPopupController.onExpandNode);
    },

    onHidden: function (event) {
        LdapPathPopupController.ldapObjectsTreeView.destroy();
        LdapPathPopupController.ldapObjectsTreeView = null;

        LdapPathPopupController.hideErrorMessage();
    },

    selectAdPathButtonClick: function () {
        const node = LdapPathPopupController.ldapObjectsTreeView.getFocusedNode();

        if (node !== null) {
            document.getElementById('Filter_ADSearchPath').value = node.getName();
            $('#ldapPathTreeModal').modal('hide');
        }
    },

    getFilter: function () {
        return {
            ldapServer: document.getElementById('Filter_HostName').value,
            credentialId: document.getElementById('Filter_CredentialId').value,
            domainType: document.getElementById('Filter_SelectedDomainProtocolType').value,
        };
    },

    onInitCompleteForTreeView: function () {
        const filter = LdapPathPopupController.getFilter();

        LdapPathPopupController.loadTreeNodes(filter.domainType, filter.ldapServer, filter.credentialId, null)
            .then((response) => {
                if (response.data === null || response.data.length === 0) {
                    LdapPathPopupController.showErrorMessage(hostImportMessages.objectsNotFound);
                } else {
                    TreeViewClientSideHelper.addNodes(this, response.data);
                }                
            })
            .catch((error) => {
                const message = error != null ? error : '';
                LdapPathPopupController.showErrorMessage(hostImportMessages.failAccess + ' ' + message);
            })
            .finally(() => LdapPathPopupController.hidePreloader());
    },

    onExpandNode: function (event, context, node) {
        const container = node.querySelector(':scope > .treeview__container');
        if (container !== null) return;

        const filter = LdapPathPopupController.getFilter();

        LdapPathPopupController.loadTreeNodes(filter.domainType, filter.ldapServer, filter.credentialId, node.dataset.name)
            .then((response) => TreeViewClientSideHelper.addNodes(context, response.data, node))
            .catch((error) => notifyWarning(LdapPathPopupController.errorText));
    },

    loadTreeNodes: function (domainType, ldapServer, credentialId, nodeId) {
        return new Promise(function (resolve, reject) {
            const formData = new FormData();
            formData.append('domainType', domainType);
            formData.append('ldapServer', ldapServer);
            formData.append('credentialId', credentialId);

            if (nodeId !== null && nodeId !== undefined) {
                formData.append('nodeId', escapeHtml(nodeId));
            }

            const xhr = new XMLHttpRequest();
            xhr.responseType = 'json';
            xhr.open('POST', hostsImportsUrl.getLdapObjectsTreeView, true);
            xhr.send(formData);

            xhr.onload = function (event) {
                if (xhr.status !== 200) {
                    reject();
                } else if (xhr.response !== null && xhr.response.result !== 'error') {
                    resolve(xhr.response);
                } else {
                    reject(xhr.response.message);
                }
            };

            xhr.onerror = function () {
                reject();
            };
        });
    },

    showPreloader: function () {
        document.getElementById('preloaderLdapObjectsTreeView').classList.remove('hide');
    },

    hidePreloader: function () {
        document.getElementById('preloaderLdapObjectsTreeView').classList.add('hide');
    },

    showErrorMessage: function (message) {
        document.getElementById('ldapFailAccessMessage').textContent =
            message == undefined || message == null
                ? hostImportMessages.failAccess
                : message;

        document.getElementById('ldapFailAccessMessage').classList.remove('hide');
    },

    hideErrorMessage: function () {
        document.getElementById('ldapFailAccessMessage').classList.add('hide');
    },
}

var ImportCsvHostsController = {
    errorText: 'Во время выполнения запроса что-то пошло не так',

    processingUploadFiles: function () {
        const form = document.getElementById('csvHostsFileUploader');
        const formData = new FormData(form);
        const xhr = new XMLHttpRequest();

        xhr.responseType = 'json';
        xhr.open(form.method, form.action, true);
        xhr.send(formData);

        xhr.onload = function (event) {
            if (xhr.status == 200 && xhr.response !== null) {
                ImportCsvHostsController.onFileUploadComplete(xhr.response);
            } else {
                notifyWarning(ImportCsvHostsController.errorText);
            }
        };

        xhr.onerror = function () {
            notifyWarning(ImportCsvHostsController.errorText);
        };
    },

    onFileUploadComplete: function (response) {
        document.getElementById('csvHostsFileUploader').reset();

        let result = {
            HostCreated: 0,
            HostNotAdded: 0,
            HostDeleted: 0,
            HostUpdated: 0,
            GroupCreated: 0,
            GroupDeleted: 0,
            GroupUpdated: 0,
        };

        for (let item of response.data) {
            result.HostCreated += item.HostCreated;
            result.HostNotAdded += item.HostNotAdded;
            result.HostDeleted += item.HostDeleted;
            result.HostUpdated += item.HostUpdated;
            result.GroupCreated += item.GroupCreated;
            result.GroupDeleted += item.GroupDeleted;
            result.GroupUpdated += item.GroupUpdated;
        }

        ImportCsvHostsController.updatePopup(result);
        $('#importFromCsvResultModal').modal('show');
    },

    updatePopup: function (data) {
        document.getElementById("hostCreated_Lbl").innerText = data.HostCreated;
        document.getElementById("hostNotCreated_Lbl").innerText = data.HostNotAdded;
        document.getElementById("hostDeleted_Lbl").innerText = data.HostDeleted;
        document.getElementById("hostUpdated_Lbl").innerText = data.HostUpdated;
        document.getElementById("groupCreated_Lbl").innerText = data.GroupCreated;
        document.getElementById("groupDeleted_Lbl").innerText = data.GroupDeleted;
        document.getElementById("groupUpdated_Lbl").innerText = data.GroupUpdated;
    },

    setElementVisible: function (elementId, element2Id, visible) {
        var el = $("#" + elementId);
        var el2 = $("#" + element2Id);
        if (visible) {
            el.show();
            el2.hide();
        } else {
            el.hide();
            el2.show();
        }
    }
};

var ImportAltxmapScriptController = {
    errorText: 'Во время выполнения запроса что-то пошло не так',

    processingUploadFiles: function () {
        const form = document.getElementById('altxmapScriptFileUploader');
        const formData = new FormData(form);
        const xhr = new XMLHttpRequest();

        xhr.responseType = 'json';
        xhr.open(form.method, form.action, true);
        xhr.send(formData);

        xhr.onload = function (event) {
            if (xhr.status == 200 && xhr.response !== null) {
                ImportAltxmapScriptController.onFileUploadComplete(xhr.response);
            } else {
                notifyWarning(ImportAltxmapScriptController.errorText);
            }
        };

        xhr.onerror = function () {
            notifyWarning(ImportAltxmapScriptController.errorText);
        };
    },

    onFileUploadComplete: function (response) {
        document.getElementById('altxmapScriptFileUploader').reset();

        let result = {
            ScriptCreated: "",
        };

        for (let item of response.data) {
            result.ScriptCreated += item;

        }

        ImportAltxmapScriptController.updatePopup(result);
        $('#importAltxmapScriptResultModal').modal('show');
    },

    updatePopup: function (data) {
        document.getElementById("importScriptResult_Lbl").innerText = data.ScriptCreated;

    },

    setElementVisible: function (elementId, element2Id, visible) {
        var el = $("#" + elementId);
        var el2 = $("#" + element2Id);
        if (visible) {
            el.show();
            el2.hide();
        } else {
            el.hide();
            el2.show();
        }
    }
};

var VulnerabilityMismatchController = {
    onRowCallback: function (row, data) {
        switch (data.Status) {
            case 1: // Added
                $(row).css("background-color", "#f2fbf4");
                $(row).css("color", "#00810f");
                break;
            case 2: // Removed
                $(row).css("background-color", "#f7f6ff");
                $(row).css("color", "#12007a");
                break;
            case 3: // Changed
                $(row).css("background-color", "#FCF5F6");
                $(row).css("color", "#DD0009");
                break;
        }
    },
};

var FixationsPageControlController = {
    onActiveTabChanged: function (s, e) {
        $.fn.dataTable.util.columnsAjustSize();
    }
};

var ControlsController = {
    GridViewGroup: function (selectedColumn, columnName, gridName) {
        var grid = ASPxClientControl.GetControlCollection().GetByName(gridName);
        var groupedColumnName = ControlsController.getGroupFieldName(grid.cpGroupedRows);
        if (groupedColumnName === undefined || groupedColumnName === "") {
            grid.GroupBy(columnName);
        } else {
            grid.UnGroup(groupedColumnName);
        }
    },

    getGroupFieldName: function (s) {
        var jsonData = JSON.parse(s);
        if (jsonData.data.length === 0)
            return "";
        else
            return jsonData.data[0].name;
    }
};

var UsersController = {
    _table: null,

    onInitComplete: function (settings, json) {
        UsersController._table = $(settings.nTable).DataTable();

        UsersController.AdjustSize(null, settings);
    },

    onDrawCallback: function (settings) {
        bindToolTip();
    },

    AdjustSize: function (e, settings) {
        const $wraper = $(settings.nTableWrapper);
        let widthWrapper = $(window).innerWidth() - $wraper.innerWidth();

        // set width
        $wraper.css('width', 'calc(100vw - ' + widthWrapper + 'px)');

        const wraperHeight = $wraper.height();
        const maxHeight = settings.oInit.maxHeight || wraperHeight;

        if (wraperHeight > maxHeight) {
            const $scrollBody = $(settings.nScrollBody);

            // set height
            $scrollBody.css('height', $scrollBody.height() - (wraperHeight - maxHeight));
        }
    },

    updateTable: function () {
        UsersController._table.ajax.reload();;
    },

    editUser: function (sender, row) {
        $("#editUserButton").attr("href", sender.href).click();
    },

    deleteUser: function (sender, row) {
        window.deleteUser(row.Id, row.Name );
    },

    saveCreateUserClick: function() {
        document.getElementById('alertPassDoNotMatch').classList.add('hidden');
        document.getElementById('alertUserNameIsEmpty').classList.add('hidden');

        const usernameInput = document.getElementById('Name');
        if (usernameInput !== null && usernameInput.value === '') {
            document.getElementById('alertUserNameIsEmpty').classList.remove('hidden');
            return false;
        }

        const isPasswordFieldsVisible = document.getElementById('passwordFields') !== null
            && !document.getElementById('passwordFields').classList.contains('hide')

        if (isPasswordFieldsVisible) {
            if (document.getElementById('OldPassword').value !== document.getElementById('NewPassword').value) {
                document.getElementById('alertPassDoNotMatch').classList.remove('hidden');
                return false;
            }

            if (document.getElementById('NewPassword').value === '') {
                document.getElementById('alertUserNameIsEmpty').classList.remove('hidden');
                return false;
            }
        }
    },

    cancelCreateUser: function() {
        document.getElementById('addUserButton').classList.remove('disableContent');
        document.getElementById('userView').innerHTML = '';
    },

    togglePasswordFieldsDisplay: function (select) {
         if (select.value === 'Local') {
             document.getElementById('passwordFields').classList.remove('hide');
         } else {
             document.getElementById('passwordFields').classList.add('hide');
         }
     },

     addUserActive: function () {
        document.getElementById('addUserButton').classList.add('disableContent');
        document.getElementById('loading').classList.add('hide');
    },

    beginLoadUserView: function () {
        document.getElementById('loading').classList.remove('hide');
    },
    
    saveUserSuccess: function (data, message) {
        if (typeof data.error === 'string' && data.error.length > 0) {
            notifyWarning(data.error);
            return;
        }

        document.getElementById('addUserButton').classList.remove('disableContent');
        document.getElementById('userView').innerHTML = '';
        notifySuccess(message);

        UsersController.updateTable();
    },

    editUserClick: function () {
        document.getElementById('addUserButton').classList.add('disableContent');
    },

    toggleDisableSegmentsManage: function (select, isGlobalAdminActiveUser) {
        if (isGlobalAdminActiveUser) {
            if (select.value === 'RedCheckAdmins') {
                document.getElementById('IsGlobalAdmin').disabled = false;
                document.getElementById('segmentManage').classList.remove('disableContent')
            } else {
                
                document.getElementById('segmentManage').classList.add('disableContent')
                document.getElementById('IsGlobalAdmin').checked = false;
                document.getElementById('IsGlobalAdmin').disabled = true;
            }
        }
    }
};

var SegmentsController = {
    _table: null,

    onInitComplete: function (settings, json) {
        SegmentsController._table = $(settings.nTable).DataTable();

        SegmentsController.AdjustSize(null, settings);
    },

    onDrawCallback: function (settings) {
        bindToolTip();
    },

    AdjustSize: function (e, settings) {
        const $wraper = $(settings.nTableWrapper);
        let widthWrapper = $(window).innerWidth() - $wraper.innerWidth();

        // set width
        $wraper.css('width', 'calc(100vw - ' + widthWrapper + 'px)');

        const wraperHeight = $wraper.height();
        const maxHeight = settings.oInit.maxHeight || wraperHeight;

        if (wraperHeight > maxHeight) {
            const $scrollBody = $(settings.nScrollBody);

            // set height
            $scrollBody.css('height', $scrollBody.height() - (wraperHeight - maxHeight));
        }
    },

    updateTable: function () {
        SegmentsController._table.ajax.reload();
    },

    editSegment: function (sender, row) {
        $("#editSegmentButton").attr("href", sender.href).click();
    },

    deleteSegment: function (sender, row) {
        window.deleteSegment(row.Id, row.Name);
    },

    saveSegmentSuccess: function (data, message) {
        if (typeof data.error === 'string' && data.error.length > 0) {
            notifyWarning(data.error);
            return;
        }

        document.getElementById('addSegmentButton').classList.remove('disableContent');
        document.getElementById('segmentView').innerHTML = '';
        notifySuccess(message);

        SegmentsController.updateTable();
    },

    saveCreateSegmentClick: function () {
        document.getElementById('alertSegmentNameIsEmpty').classList.add('hidden');
        document.getElementById('alertSegmentNameIsUsed').classList.add('hidden');

        const usernameInput = document.getElementById('Name');
        const nameSegment = usernameInput.value.trim().toLowerCase();
        if (usernameInput !== null && usernameInput.value === '') {
            document.getElementById('alertSegmentNameIsEmpty').classList.remove('hidden');
            return false;
        }
     
        let selectSegmentId = document.getElementById('Id')
        if (selectSegmentId !== null && selectSegmentId.value === '') {
            return false;
        }
    },

    addSegmentActive: function () {
        document.getElementById('addSegmentButton').classList.add('disableContent');
        document.getElementById('loading').classList.add('hide');
    },

    editSegmentClick: function () {
        document.getElementById('addSegmentButton').classList.add('disableContent');
    },

    beginLoadSegmentView: function() {
        document.getElementById('loading').classList.remove('hide');
    },

    cancelCreateSegment: function () {
        document.getElementById('addSegmentButton').classList.remove('disableContent');
        document.getElementById('segmentView').innerHTML = '';
    }
};

var PingsController = {
    OnInit: function (s, e) {
        PingsController.AdjustSize(s.name);
        ASPxClientUtils.AttachEventToElement(window, "resize", function (evt) {
            PingsController.AdjustSize(s.name);
        });
    },
    OnEndCallback: function (s, e) {
        PingsController.AdjustSize(s.name);
    },
    AdjustSize: function (name) {
        var clientHeight = document.documentElement.clientHeight;
        var gridView = ASPxClientControl.GetControlCollection().GetByName(name);
        gridView.SetHeight(clientHeight - 150);
    }
};

var ScanResultPortScanController = {
    onDrawCallbackForScanResult: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
        const scrollBody = api.tables().body().to$().parent('table').parent();
        $(scrollBody).css('overflow-y', 'scroll');
        bindToolTip();
    },

    onRowCallback: function (row, data) {
        if (data.Method !== undefined && data.Method === 1) { // Table
            $(row).css("background-color", "#d3d3d3");
        }
    },

    onContextMenuItemClick: function (node, name) {
        var actionParams = $("form#portScanningForm").attr("action").split("?command=");
        actionParams[1] = name;
        $("form#portScanningForm").attr("action", actionParams.join("?command="));
        $("form#portScanningForm").submit();
        this.close();
    }
};

var NmapHostInfoController = {
    OnInit: function () {
        NmapHostInfoController.AdjustSize();
    },
    AdjustSize: function () {
        var clientHeight = document.documentElement.clientHeight;
        $('#HostInfoGridView').height(clientHeight - 200);
    }
};

var ScanResultBruteforceController = {
    onContextMenuItemClick: function (node, name) {
        var actionParams = $("form#bruteforceForm").attr("action").split("?command=");
        actionParams[1] = name;
        $("form#bruteforceForm").attr("action", actionParams.join("?command="));
        $("form#bruteforceForm").submit();
        this.close();
    }
};

var ScanResultPentestController = {
    getGroupFieldName: function (s) {
        var jsonData = JSON.parse(s);
        if (jsonData.data.length === 0)
            return "";
        else
            return jsonData.data[0].name;
    },

    api: {},
    filters: {
        scanId: 0,
        confidence: '',
    },
    onInitComplete: function (settings) {
        ScanResultPentestController.api = this.api();
    },

    onDrawCallbackForScanResult: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
        const scrollBody = api.tables().body().to$().parent('table').parent();
        $(scrollBody).css('overflow-y', 'scroll');
        bindToolTip();

        // Don't show column after disabling grouping
        const columnCpe = api.column('Cpe:name');
        columnCpe.visible(false);
    },

    OnConfidenceComboboxInit: function (s, e) {
        ASPxClientControl.GetControlCollection().GetByName('PentestConfidenceType').SetValue(ScanResultPentestController.filters.confidence);
    },
    OnConfidenceComboboxSelectionChanged: function (s, e) {
        ScanResultPentestController.filters.confidence = ASPxClientControl.GetControlCollection().GetByName('PentestConfidenceType').GetValue();

        ScanResultPentestController.api.remoteGrouping().clear();
        ScanResultPentestController.api.ajax.reload();
    },

    onContextMenuItemClick: function (node, name) {
        var actionParams = $("form#pentestForm").attr("action").split("?command=");
        actionParams[1] = name;
        $("form#pentestForm").attr("action", actionParams.join("?command="));
        $("form#pentestForm").submit();

        this.close();
    },
};

var ScanResultScadaInventoryController = {
    onInitComplete: function () {
        this.api().table().container().classList.add('hide-search-input');
    },

    onDrawCallbackForScanResult: function (settings) {
        const scrollBody = $(this.api().table().node()).parent();
        scrollBody.css('overflow-y', 'scroll');
        bindToolTip();
    },

    onContextMenuItemClick: function (node, name) {
        var actionParams = $("form#scadaInventoryForm").attr("action").split("?command=");
        actionParams[1] = name;
        $("form#scadaInventoryForm").attr("action", actionParams.join("?command="));
        $("form#scadaInventoryForm").submit();
        this.close();
    },
};
function callbackForDashboard(response, element, callbackForSucceess) {
    element.html(response);

    if (callbackForSucceess != undefined)
        callbackForSucceess();
}

function getEventForDashoard(elementId) {
    switch (elementId) {
        case 'newsContentDiv':
            loadNews();
            break;
        case 'topPatchesContentDiv':
            loadTopPatches();
            break;
        case 'topVulnerabilitiesContentDiv':
            loadTopVuln();
            break;
        case 'vulnSeveritiesChartContentDiv':
            loadVulnSeverity();
            break;
        case 'vulnHostsChartContentDiv':
            loadVulnHosts();
            break;
        case 'patchSeveritiesChartContentDiv':
            loadPatchSeverityes();
            break;
        case 'patchHostsChartContentDiv':
            loadPatchHosts();
            break;
        case 'topHostsVulnerabilityContentDiv':
            loadTopHostsVuln();
            break;
        case 'topHostsNotUpdatedContentDiv':
            loadPatchHostsNotUpdates();
            break;
    }
}

function fillQuery(filterCountName, filterSeverityName) {
    var severity = '';
    var severityValue = document.getElementById(filterSeverityName).value;
    if (severityValue != 'All') {
        severity = '&severity=' + severityValue;
    }
    return '?count=' + document.getElementById(filterCountName).value + severity;
}

function errorCallbackForDashboard(elementId) {
    let parent = document.getElementById(elementId);
    parent.innerHTML = '';
    let div = document.createElement('div');
    div.classList.add('dashboard-load-panel');
    let p = document.createElement('p');
    p.innerHTML = 'Во время выполнения запроса что-то пошло не так';
    let btn = document.createElement('button');
    btn.innerText = 'Обновить';
    btn.classList.add('text-color-black');
    btn.addEventListener('click', function () { getEventForDashoard(elementId); });
    div.appendChild(p);
    div.appendChild(btn);
    parent.appendChild(div);
}

function loadTopPatches() {
    var topPatches = $('#topPatchesContentDiv');
    var url = topPatches.data('url') + fillQuery("CountingSortForDefinitionsPatch", "TypeSortForDefinitionsPatch");
    $.ajax({
        url: url,
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, topPatches, updateDateTopPatches);
        },
        error: function () {
            errorCallbackForDashboard('topPatchesContentDiv');
        }
    });
}

function loadTopVuln() {
    var topVuln = $('#topVulnerabilitiesContentDiv');
    var url = topVuln.data('url') + fillQuery("CountingSortForDefinitionsVulnerability", "TypeSortForDefinitionsVulnerability");
    $.ajax({
        url: url,
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, topVuln, updateDateTopVulnerability);
        },
        error: function () {
            errorCallbackForDashboard('topVulnerabilitiesContentDiv');
        }
    });
}

function loadVulnSeverity() {
    var vulnSeverity = $('#vulnSeveritiesChartContentDiv');
    $.ajax({
        url: vulnSeverity.data('url'),
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, vulnSeverity, updateDateCharts);
        },
        error: function () {
            errorCallbackForDashboard('vulnSeveritiesChartContentDiv');
        }
    });
}

function loadVulnHosts() {
    var vulnHosts = $('#vulnHostsChartContentDiv');
    $.ajax({
        url: vulnHosts.data('url'),
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, vulnHosts, updateDateCharts);
        },
        error: function () {
            errorCallbackForDashboard('vulnHostsChartContentDiv');
        }
    });
}

function loadPatchSeverityes() {
    var patchSeverityes = $('#patchSeveritiesChartContentDiv');
    $.ajax({
        url: patchSeverityes.data('url'),
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, patchSeverityes, updateDateCharts);
        },
        error: function () {
            errorCallbackForDashboard('patchSeveritiesChartContentDiv');
        }
    });
}

function loadPatchHosts() {
    var patchHosts = $('#patchHostsChartContentDiv');
    $.ajax({
        url: patchHosts.data('url'),
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, patchHosts, updateDateCharts);
        },
        error: function () {
            errorCallbackForDashboard('patchHostsChartContentDiv');
        }
    });
}

function loadCharts() {
    loadVulnSeverity();
    loadVulnHosts();
    loadPatchSeverityes();
    loadPatchHosts();
}

function loadTopHostsVuln() {
    var topHostsVuln = $('#topHostsVulnerabilityContentDiv');
    var url = topHostsVuln.data('url') + fillQuery("CountingSortForHostsVulnerability", "TypeSortForHostsVulnerability");
    $.ajax({
        url: url,
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, topHostsVuln, updateDateTopHostVuln);
            bindToolTip();
        },
        error: function () {
            errorCallbackForDashboard('topHostsVulnerabilityContentDiv');
        }
    });
}

function loadPatchHostsNotUpdates() {
    var patchHostsNotUpdates = $('#topHostsNotUpdatedContentDiv');
    var url = patchHostsNotUpdates.data('url') + fillQuery("CountingSortForHostsPatch", "TypeSortForHostsPatch");
    $.ajax({
        url: url,
        cache: true,
        dataType: "html",
        success: function (data) {
            callbackForDashboard(data, patchHostsNotUpdates, updateDateTopHostNotUpdatedPanel);
            bindToolTip();
        },
        error: function () {
            errorCallbackForDashboard('topHostsNotUpdatedContentDiv');
        }
    });
}

function updateDateTopPatches() {
    var currentdate = new Date();
    $("#patchesUpdatedDate").html(currentdate.toLocaleString());
}

function updateDateTopVulnerability() {
    var currentdate = new Date();
    $("#vulnerabilityUpdatedDate").html(currentdate.toLocaleString());
}

function updateDateCharts() {
    var currentdate = new Date();
    $("#chartsUpdatedDate").html(currentdate.toLocaleString());
}

function updateDateTopHostVuln() {
    var currentdate = new Date();
    $("#topHostsVulnUpdatedDate").html(currentdate.toLocaleString());
}

function updateDateTopHostNotUpdatedPanel() {
    var currentdate = new Date();
    $("#topHostsNotUpdatedDate").html(currentdate.toLocaleString());
}

function loadComplianceDashboards() {
    loadBenchmarkInfo();
    loadSuccessfulHostsStatistics();
    loadHostScanStatistics();
}
function loadBenchmarkInfo() {
    var benchmarkInfo = $('#benchmarkInfoDiv');
    $.ajax({
        url: benchmarkInfo.data('url') +'?' + objectToQueryString(ComplianceAnalysisController.filter),
        dataType: "html",
        success: function (data) {
            benchmarkInfo.html(data);
        },
        error: function () {
            errorCallbackForDashboard('benchmarkInfoDiv');
        }
    });
}

function loadSuccessfulHostsStatistics() {
    const successfulHostsStatistics = $('#successfulHostsStatisticsDiv');
    
    $.ajax({
        url: successfulHostsStatistics.data('url') +'?' + objectToQueryString(ComplianceAnalysisController.filter),
        dataType: "html",
        success: function (data) {
            successfulHostsStatistics.html(data);
        },
        error: function () {
            errorCallbackForDashboard('successfulHostsStatisticsDiv');
        }
    });
}

function loadHostScanStatistics() {
    var hostScanStatistics = $('#hostScanStatisticsDiv');
    $.ajax({
        url: hostScanStatistics.data('url') +'?' + objectToQueryString(ComplianceAnalysisController.filter),
        dataType: "html",
        success: function (data) {
            hostScanStatistics.html(data);
        },
        error: function () {
            errorCallbackForDashboard('hostScanStatisticsDiv');
        }
    });
}

function FillProfileTreeViewValue() {
    if (typeof xssdfProfileTreeView2 === "undefined")
        return;

    let profileTreeView = xssdfProfileTreeView2;
    var nodes = [];

    const treeNodes = profileTreeView.getTopNodes();
    treeNodes.forEach(function (node) {
        var profiles = [];

        profileTreeView.getNodesByParent(node)
            .forEach(function (profileNode) {
                let isSelected = false;

                if (profileTreeView.getAllowCheckNodes() && profileNode.getChecked())
                    isSelected = true;

                const focusedNode = profileTreeView.getFocusedNode();

                if (!profileTreeView.getAllowCheckNodes() && focusedNode !== null
                    && profileNode.getName() === focusedNode.getName()
                    && node.getName() === focusedNode.getParent().getName())
                    isSelected = true;

                profiles.push({
                    Id: profileNode.getKey(),
                    Name: profileNode.getText(),
                    ProfileId: profileNode.getName(),
                    IsSelected: isSelected
                });
            });

        nodes.push({
            Id: node.getKey(),
            Filepath: node.getName(),
            Name: node.getNodeText(),
            Profiles: profiles
        });
    });

    FillXccdfProfiles(nodes);
}

function FillTreeViewValue() {
    if (typeof xssdfProfileTreeView === "undefined" || typeof xssdfProfileTreeView.GetNodeCount !== "function")
        return;

    var nodes = [];

    for (var ii = 0; ii < xssdfProfileTreeView.GetNodeCount(); ii++) {
        var innerNodes = [];
        for (var inneri = 0; inneri < xssdfProfileTreeView.GetNode(ii).GetNodeCount(); inneri++) {
            var selected = false;

            try {
                // For multiple selection mode
                if (xssdfProfileTreeView.GetNode(ii).clientEnabled && xssdfProfileTreeView.GetNode(ii).GetNode(inneri).GetChecked() === true
                    // For single selection mode
                    || !xssdfProfileTreeView.GetNode(ii).clientEnabled
                    && xssdfProfileTreeView.GetNode(ii).name === xssdfProfileTreeView.GetSelectedNode().parent.name
                    && xssdfProfileTreeView.GetNode(ii).GetNode(inneri).name === xssdfProfileTreeView.GetSelectedNode().name)
                    selected = true;

                innerNodes[inneri] = {
                    Id: xssdfProfileTreeView.GetNode(ii).GetNode(inneri).target,
                    Name: xssdfProfileTreeView.GetNode(ii).GetNode(inneri).text,
                    ProfileId: xssdfProfileTreeView.GetNode(ii).GetNode(inneri).name,
                    IsSelected: selected
                };
                // TODO: fix the "Cannot read property 'id' of null" error when no items selected (can't find reason)
            } catch (err) {
                console.log(err);
            }
        }
        nodes[ii] = {
            Id: xssdfProfileTreeView.GetNode(ii).target,
            Filepath: xssdfProfileTreeView.GetNode(ii).name,
            Name: xssdfProfileTreeView.GetNode(ii).text,
            Profiles: innerNodes
        };
    }

    FillXccdfProfiles(nodes);
}

function FillXccdfProfiles(nodes) {
    for (var i = 0; i < nodes.length; i++) {
        var inputId = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'XccdfProfiles.XccdfFiles[' + i + '].Id').attr('id', 'XccdfProfiles_XccdfFiles_' + i + '_ID').val(nodes[i].Id);
        var inputFilepath = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'XccdfProfiles.XccdfFiles[' + i + '].Filepath').attr('id', 'XccdfProfiles_XccdfFiles_' + i + '_Filepath').val(nodes[i].Filepath.replace(/\\/g, '\\\\'));
        var inputName = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'XccdfProfiles.XccdfFiles[' + i + '].Name').attr('id', 'XccdfProfiles_XccdfFiles_' + i + '_Name').val(nodes[i].Name.replace(/"/g, '\\"'));
        $('#XccdfProfile').append(inputId);
        $('#XccdfProfile').append(inputFilepath);
        $('#XccdfProfile').append(inputName);
        for (var inner = 0; inner < nodes[i].Profiles.length; inner++) {

            var inputInnerId = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'XccdfProfiles.XccdfFiles[' + i + '].Profiles[' + inner + '].Id').attr('id', 'XccdfProfiles_XccdfFiles_' + i + '_Profiles[' + inner + ']_Id').val(nodes[i].Profiles[inner].Id);
            var inputInnerProfileId = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'XccdfProfiles.XccdfFiles[' + i + '].Profiles[' + inner + '].ProfileId').attr('id', 'XccdfProfiles_XccdfFiles_' + i + '_Profiles[' + inner + ']_ProfileId').val(nodes[i].Profiles[inner].ProfileId);
            var inputInnerName = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'XccdfProfiles.XccdfFiles[' + i + '].Profiles[' + inner + '].Name').attr('id', 'XccdfProfiles_XccdfFiles_' + i + '_Profiles[' + inner + ']_Name').val(nodes[i].Profiles[inner].Name.replace(/"/g, '\\"'));
            var inputInnerSelected = $(document.createElement('input')).attr('type', 'hidden').attr('name', 'XccdfProfiles.XccdfFiles[' + i + '].Profiles[' + inner + '].IsSelected').attr('id', 'XccdfProfiles_XccdfFiles_' + i + '_Profiles[' + inner + ']_IsSelected').val(nodes[i].Profiles[inner].IsSelected);

            $('#XccdfProfile').append(inputInnerId);
            $('#XccdfProfile').append(inputInnerProfileId);
            $('#XccdfProfile').append(inputInnerName);
            $('#XccdfProfile').append(inputInnerSelected);
        }
    }
}

function selectedSchedulerType_OnSelectedIndexChanged(element) {
    var lang = getCookie("lang");
    var label = document.getElementById('schedulerLabel');
    var interval = parseInt(document.getElementById('Scheduler_Interval').value);
    var schedulerDate = new Date(document.getElementById('Scheduler_InitialStartDate').value);
    var schedulerTime = document.getElementById('Scheduler_InitialStartTime').value;
    var time = new Date();
    time.setMinutes(time.getMinutes() + 5);
    var selectedValue = element.value;

    if (selectedValue === SCHEDULE_TYPE_Minutely) {
        document.getElementById('schedulerExpiredBlock').classList.remove('hide');
        if (lang === "ru")
            label.innerText = " (минуты)";
        else label.innerText = " (minutes)";
        hideSchedulerExpiredBlock();
        time.setMinutes(time.getMinutes() + interval);
        document.getElementById('Scheduler_ExpiredTime').value = getFormatTime(time.getHours(), time.getMinutes());
        document.getElementById('Scheduler_ExpiredDate').value = getFormatDate(time);
    }
    if (selectedValue === SCHEDULE_TYPE_Hourly) {
        document.getElementById('schedulerExpiredBlock').classList.remove('hide');
        if (lang === "ru")
            label.innerText = " (часы)";
        else label.innerText = " (hours)";
        hideSchedulerExpiredBlock();
        time.setHours(time.getHours() + interval);
        document.getElementById('Scheduler_ExpiredTime').value = getFormatTime(time.getHours(), time.getMinutes());
        document.getElementById('Scheduler_ExpiredDate').value = getFormatDate(time);
    }
    if (selectedValue === SCHEDULE_TYPE_Daily) {
        document.getElementById('schedulerExpiredBlock').classList.remove('hide');
        if (lang === "ru")
            label.innerText = " (дни)";
        else label.innerText = " (days)";
        hideSchedulerExpiredBlock();
        schedulerDate.setDate(schedulerDate.getDate() + interval);
        document.getElementById('Scheduler_ExpiredDate').value = getFormatDate(schedulerDate);
        document.getElementById('Scheduler_ExpiredTime').value = schedulerTime;
    }
    if (selectedValue === SCHEDULE_TYPE_Weekly) {
        document.getElementById('schedulerExpiredBlock').classList.remove('hide');
        if (lang === "ru")
            label.innerText = " (недели)";
        else label.innerText = " (weeks)";
        hideSchedulerExpiredBlock();
        schedulerDate.setDate(schedulerDate.getDate() + interval * 7);
        document.getElementById('Scheduler_ExpiredDate').value = getFormatDate(schedulerDate);
        document.getElementById('Scheduler_ExpiredTime').value = schedulerTime;
    }
    if (selectedValue === SCHEDULE_TYPE_Monthly) {
        document.getElementById('schedulerExpiredBlock').classList.remove('hide');
        if (lang === "ru")
            label.innerText = " (месяцы)";
        else label.innerText = " (months)";
        hideSchedulerExpiredBlock();
        schedulerDate.setMonth(schedulerDate.getMonth() + interval);
        document.getElementById('Scheduler_ExpiredDate').value = getFormatDate(schedulerDate);
        document.getElementById('Scheduler_ExpiredTime').value = schedulerTime;
    }
    if (selectedValue === SCHEDULE_TYPE_OneTime) {
        document.getElementById('schedulerExpiredBlock').classList.add('hide');
        hideSchedulerExpiredBlock();
    }
}

function getLabelForExpiredDate(selectedValue) {
    var lang = getCookie("lang");
    var label = document.getElementById('schedulerLabel');
    if (selectedValue === SCHEDULE_TYPE_Minutely) {
        if (lang === "ru")
            label.innerText = " (минуты)";
        else label.innerText = " (minutes)";
    }
    if (selectedValue === SCHEDULE_TYPE_Hourly) {
        if (lang === "ru")
            label.innerText = " (часы)";
        else label.innerText = " (hours)";
    }
    if (selectedValue === SCHEDULE_TYPE_Daily) {
        if (lang === "ru")
            label.innerText = " (дни)";
        else label.innerText = " (days)";
    }
    if (selectedValue === SCHEDULE_TYPE_Weekly) {
        if (lang === "ru")
            label.innerText = " (недели)";
        else label.innerText = " (weeks)";
    }
    if (selectedValue === SCHEDULE_TYPE_Monthly) {
        if (lang === "ru")
            label.innerText = " (месяцы)";
        else label.innerText = " (months)";
    }
}

function getFormatDate(date) {
    var day = date.getDate(),
        month = date.getMonth() + 1,
        year = date.getFullYear();

    month = (month < 10 ? "0" : "") + month;
    day = (day < 10 ? "0" : "") + day;

    var currentDate = year + "-" + month + "-" + day;

    return currentDate;
}

function getFormatTime(hours, mins) {
    hours = (hours < 10 ? "0" : "") + hours;
    mins = (mins < 10 ? "0" : "") + mins;

    return hours + ":" + mins;
}

function hideSchedulerExpiredBlock() {
    document.getElementById('Scheduler_IsSetExpired').checked = false;
    document.getElementById('expiredblock').classList.add('disableContent');
}

function isSetExpiredChecked() {
    if ($('#Scheduler_IsSetExpired').prop('checked') === true) {
        document.getElementById('expiredblock').classList.remove('disableContent');
        validateSchedule();
    }
    else {
        document.getElementById('expiredblock').classList.add('disableContent');
        $('#expiredValid').addClass('hide');
    }
}

function addValidateEvent() {
    $('#Scheduler_SelectedSchedulerType, #Scheduler_InitialStartDate, #Scheduler_InitialStartTime, #Scheduler_ExpiredDate, #Scheduler_ExpiredTime, #Scheduler_Interval, #Scheduler_IsRunTimeLimited, #Scheduler_RunTimeLimitHours')
        .change(validateSchedule);
}

function toggleRunTimeLimitSettingsDisabled() {
    const element = document.getElementById('Scheduler_IsRunTimeLimited');
    const settings = document.getElementById('runTimeLimitSettings');
    if (element.checked) {
        settings.classList.remove('disableContent');
        refreshTimeConvertForRunTimeLimitHours();
    } else {
        settings.classList.add('disableContent');
    }
}

function refreshTimeConvertForRunTimeLimitHours() {
    let element = document.getElementById('Scheduler_RunTimeLimitHours');
    let label = document.getElementById('runTimeLimitDesc');
    let str = convertHoursToDuration(element.value);

    if (str.length !== 0) {
        label.textContent = '(' + str + ')';
    } else {
        label.textContent = '';
    }
}

function isSetSuspendedChecked() {
    if (document.getElementById('Scheduler_IsSuspended').checked == true) {
        document.getElementById('suspendedEnabled').classList.remove('disableContent');
    }
    else document.getElementById('suspendedEnabled').classList.add('disableContent');
}

function isSuspendDateValid() {
    if (document.getElementById('Scheduler_IsSuspended').checked == true) {
        return document.getElementById('Scheduler_Monday').checked ||
            document.getElementById('Scheduler_Tuesday').checked ||
            document.getElementById('Scheduler_Wednesday').checked ||
            document.getElementById('Scheduler_Thursday').checked ||
            document.getElementById('Scheduler_Friday').checked ||
            document.getElementById('Scheduler_Saturday').checked ||
            document.getElementById('Scheduler_Sunday').checked;
    }

    return true;
}

function isValidScheduleWithNotify() {
    if (!isSuspendDateValid()) {
        notifyWarning(suspendedDayNotSpecified);
        return false;
    }

    return true;
}

function validateSchedule() {
    var result = true;
    var dateParts, timeParts, startTimestamp;
    
    const schedulerType = document.getElementById('Scheduler_SelectedSchedulerType').value;
    
    try {
        if (!isSuspendDateValid()) {
            notifyWarning(suspendedDayNotSpecified);
            result = false;
        }

        dateParts = $('#Scheduler_InitialStartDate').val().split('-');
        timeParts = $('#Scheduler_InitialStartTime').val().split(':');
        startTimestamp = new Date(dateParts[0], dateParts[1] - 1, dateParts[2], timeParts[0], timeParts[1]).getTime();

        if (isNaN(startTimestamp)) {
            $('#firstStartValid').html(unacceptableDateFormat).removeClass('hide');
            result = false;
        } else if (schedulerType === SCHEDULE_TYPE_OneTime && startTimestamp <= Date.now()) {
            $('#firstStartValid').html(startTimeLessThanNow).removeClass('hide');
            result = false;
        } else {
            $('#firstStartValid').addClass('hide');
        }
    } catch (error) {
        $('#firstStartValid').html(unacceptableDateFormat).removeClass('hide');
        console.log(error);
        result = false;
    }

    if (schedulerType !== SCHEDULE_TYPE_OneTime) {
        var recurEvery = $('#Scheduler_Interval').val();
        if (recurEvery.length === 0 ||
            parseInt(recurEvery) === NaN ||
            parseInt(recurEvery) < 1 ||
            parseInt(recurEvery) > 999) {
            $('#recurEveryValid').html(unacceptableIntervalValue).removeClass('hide');
            result = false;
        } else {
            $('#recurEveryValid').addClass('hide');
        }
    }

    if (document.querySelector('#Scheduler_IsRunTimeLimited').checked) {
        const element = document.querySelector('#Scheduler_RunTimeLimitHours');
        const validator = $(element.closest('form')).data("validator");

        if (!validator.element(element)) {
            result = false;
        } else if (schedulerType !== SCHEDULE_TYPE_OneTime) {
            const interval = moment.duration($('#Scheduler_Interval').val(), scheduleTypeToMomentUnit(schedulerType)).asMinutes();

            if (interval < parseInt(element.value) * 60) {
                validator.showErrors({ [element.name]: cannotGreaterRecurrenceInterval });
                result = false;
            }
        }
    } else {
        $('#Scheduler_RunTimeLimitHours-error').text('');
    }

    if ($('#Scheduler_IsSetExpired').prop('checked') !== true)
        return result;

    try {
        dateParts = $('#Scheduler_ExpiredDate').val().split('-');
        timeParts = $('#Scheduler_ExpiredTime').val().split(':');
        var expiredTimestamp = new Date(dateParts[0], dateParts[1] - 1, dateParts[2], timeParts[0], timeParts[1]).getTime();

        if (isNaN(expiredTimestamp)) {
            $('#expiredValid').html(unacceptableDateFormat).removeClass('hide');
            result = false;
        } else if (expiredTimestamp <= startTimestamp) {
            $('#expiredValid').html(expiredTimeLessThanStart).removeClass('hide');
            result = false;
        } else {
            $('#expiredValid').addClass('hide');
        }
    } catch (error) {
        $('#expiredValid').html(unacceptableDateFormat).removeClass('hide');
        console.log(error);
        result = false;
    }

    return result;
}

function scheduleTypeToMomentUnit(scheduleType) {
    const units = {
        [SCHEDULE_TYPE_Minutely]: 'minutes',
        [SCHEDULE_TYPE_Hourly]: 'hours',
        [SCHEDULE_TYPE_Daily]: 'days',
        [SCHEDULE_TYPE_Weekly]: 'weeks',
        [SCHEDULE_TYPE_Monthly]: 'months',
    };

    const result = units[scheduleType];
    if (!result) {
        throw new Error('Parameter "ScheduleType" cannot be converted to "MomentUnit".');
    }

    return result;
}

function setCurrentDateAndTime() {
    var date = new Date();
    date.setMinutes(date.getMinutes() + 5);

    var day = date.getDate(),
        month = date.getMonth() + 1,
        year = date.getFullYear(),
        hour = date.getHours(),
        min = date.getMinutes();

    month = (month < 10 ? "0" : "") + month;
    day = (day < 10 ? "0" : "") + day;
    hour = (hour < 10 ? "0" : "") + hour;
    min = (min < 10 ? "0" : "") + min;

    var currentDate = year + "-" + month + "-" + day;
    var currentTime = hour + ":" + min;

    document.getElementById('Scheduler_InitialStartDate').value = currentDate;
    document.getElementById("Scheduler_InitialStartTime").value = currentTime;
}



function showParamsBlock() {
    document.getElementById('emptyState').classList.add("hidden");
    document.getElementById('paramsBlock').classList.remove("hidden");
}

function showEmptyState() {
    document.getElementById('emptyState').classList.remove("hidden");
    document.getElementById('paramsBlock').classList.add("hidden");
}

function getDomainAdress(id) {
    $.ajax({
        url: getCurrentDomainUrl(id),
        type: 'GET',
        success: function (innerResponse) {
            document.getElementById('HostName').value = innerResponse;
            AdUsersController.CheckValidAdData();
        },
        error: function () {
        }
    });
}

var SelectedHostsGridController = {
    table: null,
    cpData: [],

    onInitComplete: function (settings, json) {
        SelectedHostsGridController.table = $(settings.nTable).DataTable();

        SelectedHostsGridController.adjustGridSize();
    },

    onDrawCallback: function (settings) {
        SelectedHostsGridController.adjustGridSize();
    },

    reloadSelectedHostsGrid: function () {
        SelectedHostsGridController.table.ajax.reload(null, false);
    },

    addHosts: function (hostIds) {
        SelectedHostsGridController.cpData = unionArray(SelectedHostsGridController.cpData, hostIds);
        SelectedHostsGridController.reloadSelectedHostsGrid();
        SelectedHostsGridController._createEvent();
    },

    handleDeleteHostsClick: function (e, dt, node, config) {
        const hostIds = dt.redcheck.selectedIds();
        const requiresPaginationSync = dt.rows().count() === 1;
        
        dt.redcheck.deselectAll();
        SelectedHostsGridController.cpData = SelectedHostsGridController.cpData.filter((id) => {
            return hostIds.indexOf(id) === -1;
        });

        if (requiresPaginationSync) {
            DataTablesHelper.navigateToLastPage(dt, SelectedHostsGridController.cpData.length);
        } else {
            SelectedHostsGridController.reloadSelectedHostsGrid();
        }

        SelectedHostsGridController._createEvent();
    },

    reset: function () {
        SelectedHostsGridController.cpData.splice(0, SelectedHostsGridController.cpData.length);
        SelectedHostsGridController.reloadSelectedHostsGrid();
        SelectedHostsGridController._createEvent();
    },

    adjustGridSize: function () {
        const api = SelectedHostsGridController.table;
        if (api !== null) {
            adjustGridSizeInSplitter(api.table().node().id);
            api.columns.adjust();
        }
    },

    getCountSelectedHosts: function () {
        return SelectedHostsGridController.cpData.length;
    },

    _createEvent: function () {
        const api = SelectedHostsGridController.table;
        $(api.table().node()).trigger('change-selected-hosts.grid');
    },
};

var FilterHostsGridController = {
    ShowSelectedHost: function (hosts, settings) {
        const hostsId = hosts.map(function (host) {
            return host.id;
        });

        if (SelectedHostsGridController.table !== null) {
            SelectedHostsGridController.addHosts(hostsId);
            return;
        }

        let selectedHost = [hosts[0].id, hosts[0].name];

        // view for import hosts from AD`
        if (document.getElementById('importAdHosts') !== null) {
            AdImportOnGetHostRowValues(selectedHost);
        } else // views with search by host
            OnGetHostRowValues(selectedHost);
    },
};

var SelectedGroupsGridController = {
    table: null,
    cpData: [],

    onInitComplete: function (settings, json) {
        SelectedGroupsGridController.table = $(settings.nTable).DataTable();

        SelectedGroupsGridController.adjustGridSize();
    },

    onDrawCallback: function (settings) {
        SelectedGroupsGridController.adjustGridSize();
    },

    reloadSelectedGroupsGrid: function () {
        SelectedGroupsGridController.table.ajax.reload(null, false);
    },

    addGroups: function (groupIds) {
        SelectedGroupsGridController.cpData = unionArray(SelectedGroupsGridController.cpData, groupIds);
        SelectedGroupsGridController.reloadSelectedGroupsGrid();
        SelectedGroupsGridController._createEvent();
    },

    handleDeleteGroupsClick: function (e, dt, node, config) {
        const groupIds = dt.redcheck.selectedIds();
        const requiresPaginationSync = dt.rows().count() === 1;

        dt.redcheck.deselectAll();
        SelectedGroupsGridController.cpData = SelectedGroupsGridController.cpData.filter((id) => {
            return groupIds.indexOf(id) === -1;
        });

        if (requiresPaginationSync) {
            DataTablesHelper.navigateToLastPage(dt, SelectedGroupsGridController.cpData.length);
        } else {
            SelectedGroupsGridController.reloadSelectedGroupsGrid();
        }

        SelectedGroupsGridController._createEvent();
    },

    handleDeleteGroupClick: function (groupId) {
        const requiresPaginationSync = SelectedGroupsGridController.table.rows().count() === 1;
        const index = SelectedGroupsGridController.cpData.indexOf(groupId);
        SelectedGroupsGridController.cpData.splice(index, 1);

        if (requiresPaginationSync) {
            DataTablesHelper.navigateToLastPage(SelectedGroupsGridController.table, SelectedGroupsGridController.cpData.length);
        } else {
            DataTablesHelper.ajaxReloadAndSaveScroll(SelectedGroupsGridController.table);
        }

        SelectedGroupsGridController._createEvent();
    },

    reset: function () {
        SelectedGroupsGridController.cpData.splice(0, SelectedGroupsGridController.cpData.length);
        SelectedGroupsGridController.reloadSelectedGroupsGrid();
        SelectedGroupsGridController._createEvent();
    },

    adjustGridSize: function () {
        const api = SelectedGroupsGridController.table;
        if (api !== null) {
            adjustGridSizeInSplitter(api.table().node().id);
            api.columns.adjust();
        }
    },

    getCountSelectedGroups: function () {
        return SelectedGroupsGridController.cpData.length;
    },

    _createEvent: function () {
        const api = SelectedGroupsGridController.table;
        $(api.table().node()).trigger('change-selected-groups.grid');
    },
};

var FilterGroupsGridController = {
    ShowSelectedGroup: function (groups, settings) {
        const groupsId = groups.map(function (group) {
            return group.id;
        });

        if (SelectedGroupsGridController.table !== null) {
            SelectedGroupsGridController.addGroups(groupsId);
            return;
        }

        let selectedGroup = [groups[0].id, groups[0].name.trim()];

        // view for import hosts from AD
        if (document.getElementById('importAdHosts') !== null) {
            AdImportOnGetGroupRowValues(selectedGroup);
        } else // views with search by groups
            OnGetGroupRowValues(selectedGroup);
    },
};

var HostsGroupsFunctions = {
    isCreateReport: function () {
        return typeof createReportTabs !== "undefined"
            && typeof hostsTab !== "undefined";
    },
};

var HostsPopupControler = {
    needSelectHostMessage: 'Выберите хост',
    filterHostsGrid: null,
    isUseCheckBox: false,

    TableLoad: function (filter) {
        const checkbox = document.querySelector('[id*=hostsModal] input[id*="IsUseCheckBox"]');
        HostsPopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;

        if (!HostsPopupControler.filterHostsGrid || !HostsPopupControler.filterHostsGrid.isMount()) {
            HostsPopupControler.filterHostsGrid = new FilterHostsGridComponent({
                root: '#FilterHostsGrid',
                ajax: HostsPopupControler.createUrlFiltersHosts(),
                style: HostsPopupControler.isUseCheckBox ? 'multi' : 'single'
            });
        }
    },

    onShown: function () {
        if (HostsPopupControler.filterHostsGrid) {
            if (!HostsPopupControler.filterHostsGrid.isMount()) {
                HostsPopupControler.filterHostsGrid.mount();
            } else {
                HostsPopupControler.filterHostsGrid.$api.selectCustom().deselectAll().draw();
            }
        }
    },

    createUrlFiltersHosts: function () {
        let links = {
            url: '/Hosts/FiltersHostsGridView',
            urlItemsId: '/Hosts/ListHostIds',
        }

        if (HostsGroupsFunctions.isCreateReport()) {
            var previousStep = $('.tabcontent:not(.hide)').prevAll('.tabcontent').first().data('step-name');
            var params = createReportTabs[previousStep].tab.GetParams();

            let reportFilter = [];

            for (let key in params) {
                if (params.hasOwnProperty(key)) {
                    reportFilter.push({ name: key, value: params[key] });
                }
            }

            links = {
                url: links.url + '?' + $.param(reportFilter),
                urlItemsId: links.urlItemsId + '?' + $.param(reportFilter)
            };
        }

        return links;
    },

    SelectHostButtonClick: function (button) {
        const selectedRows = HostsPopupControler.filterHostsGrid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(HostsPopupControler.needSelectHostMessage);
            return;
        }

        FilterHostsGridController.ShowSelectedHost(selectedRows, { isUseCheckBox: HostsPopupControler.isUseCheckBox });
        $('#hostsModal').modal('hide');
    }
};

var GroupsPopupControler = {
    needSelectGroupMessage: 'Выберите группу',
    filterGroupsGrid: null,
    isUseCheckBox: false,

    TableLoad: function () {
        const checkbox = document.querySelector('[id*=groupsModal] input[id*="IsUseCheckBox"]');
        GroupsPopupControler.isUseCheckBox = checkbox.value === 'False' ? false : true;

        if (GroupsPopupControler.filterGroupsGrid == null || !GroupsPopupControler.filterGroupsGrid.isMount()) {
            GroupsPopupControler.filterGroupsGrid = new FilterGroupsGridComponent({
                root: '#FilterGroupsGrid',
                ajax: GroupsPopupControler.createUrlFiltersGroups(),
                style: GroupsPopupControler.isUseCheckBox ? 'multi' : 'single'
            });
        }
    },

    onShown: function () {
        if (GroupsPopupControler.filterGroupsGrid) {
            if (!GroupsPopupControler.filterGroupsGrid.isMount()) {
                GroupsPopupControler.filterGroupsGrid.mount();
            } else {
                GroupsPopupControler.filterGroupsGrid.$api.selectCustom().deselectAll().draw();
            }
        }
    },

    createUrlFiltersGroups: function () {
        let links = {
            url: '/Groups/FiltersGroupsGridView',
            urlItemsId: '/Groups/ListGroupIds'
        }

        if (HostsGroupsFunctions.isCreateReport()) {
            var previousStep = $('.tabcontent:not(.hide)').prevAll('.tabcontent').first().data('step-name');
            var params = createReportTabs[previousStep].tab.GetParams();

            let reportFilter = {};

            for (let key in params) {
                if (params.hasOwnProperty(key)) {
                    reportFilter[key] = params[key];
                }
            }

            links.url = links.url + '?' + $.param(reportFilter);
            links.urlItemsId = links.urlItemsId + '?' + $.param(reportFilter);
        }

        return links;
    },

    SelectGroupButtonClick: function (button) {
        const selectedRows = GroupsPopupControler.filterGroupsGrid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(GroupsPopupControler.needSelectGroupMessage);
            return;
        }

        FilterGroupsGridController.ShowSelectedGroup(selectedRows, { isUseCheckBox: GroupsPopupControler.isUseCheckBox });
        $('#groupsModal').modal('hide');
    }
};

function unionArray(first, second) {
    var concatArr = first.concat(second);
    return concatArr.filter(function (value, pos) { return concatArr.indexOf(value) === pos; });
}

const unionArrayOfObjects = (a, b, predicate) => {
    const result = [...a];
    b.forEach((bItem) => (result.some((rItem) => predicate(bItem, rItem)) ? null : result.push(bItem)));
    return result;
}

function findIndex(arr, predicate) {
    for (var i = 0; i < arr.length; i++) {
        if (predicate(arr[i]))
            return i;
    }
}

function findElement(arr, predicate) {
    for (var i = 0; i < arr.length; i++) {
        if (predicate(arr[i])) {
            return arr[i];
        }
    }
}

function importBenchClick() {
    document.getElementById('directoryDialog').click();
    document.getElementById('directoryDialog').addEventListener('change', selectedFiles);
}

function selectedFiles() {
    var files = document.getElementById('directoryDialog').files;

    if (files.length > 0 && validSelectedFile(files))
        document.getElementById('submitImportClick').click();
}

function validSelectedFile(files) {
    var xccdfFileCount = 0;
    var hasCpeDictFile = false;
    var hasCpeOvalFile = false;
    var hasOvalFile = false;
    for (var i = 0; i < files.length; i++) {
        if (files[i].type != 'text/xml') {
            notifyWarning(complianceMessages.selecrWrongCompliance);
            return false;
        }
        if (files[i].name.indexOf('-oval') !== -1) {
            if (files[i].name.indexOf('-cpe-oval') !== -1)
                hasCpeOvalFile = true;
            else
                hasOvalFile = true;
        }
        
        if (files[i].name.indexOf('-xccdf') !== -1){
            xccdfFileCount++;
        }
        
        hasCpeDictFile = hasCpeDictFile || files[i].name.indexOf('-cpe-dictionary') !== -1;
    }

    var hasXccdfFile = xccdfFileCount > 0;
    if (!hasXccdfFile || !hasCpeDictFile || !hasCpeOvalFile || !hasOvalFile) {
        var errorMessage = !hasXccdfFile ? '<...>-xccdf.xml </br>' : '';
        errorMessage += !hasCpeDictFile ? '<...>-сpe-dictionary.xml </br>' : '';
        errorMessage += !hasCpeOvalFile ? '<...>-cpe-oval.xml </br>' : '';
        errorMessage += !hasOvalFile ? '<...>-oval.xml </br>' : '';

        notifyWarning(complianceMessages.filesNotFound + ':</br>' + errorMessage);
        return false;
    }
    
    if (xccdfFileCount > 1) {
        notifyWarning(complianceMessages.onlyOneXccdfFileAllowed);
        return false;
    }

    return true;
}

function showLoader() {
    document.getElementById('importLoader').classList.remove('hide');
}

function hideLoader() {
    document.getElementById('importLoader').classList.add('hide');
}

function actionAfterImport(data) {
    if (data !== null && data !== undefined) {
        if (data == true) {
            notifySuccess(complianceMessages.complianceImportedSuccessfully);
            actionAfterImport();
        }
        else {
            notifyWarning(complianceMessages.complianceImportedFailed);
        }
    }
}

function hashString(str) {
    var hash = 0, l = str.length, i = 0;
    if (l > 0)
        while (i < l)
            hash = (hash << 5) - hash + str.charCodeAt(i++) | 0;
    return hash;
}

function validateRange(element) {
    if (parseInt(element.value) == NaN) element.value = element.min
    if (element.value != "") {
        if (parseInt(element.value) < parseInt(element.min)) {
            element.value = element.min;
        }
        if (parseInt(element.value) > parseInt(element.max)) {
            element.value = element.max;
        }
    }
}

var FormHelper = {
    trimInput: function (element) {
        element.value = element.value.trim();
    }
};

var ContextMenu = (function () {
    function ContextMenu(options) {
        this._selector = options.selector;
        this._target = options.target || 'body';
        this._callbackRender = options.callbackRender || function () { };

        this._element = document.querySelector(this._selector);

        this._handleClickItem = handleClickItem.bind(this);
        this._handleRightClickTarget = handleRightClickTarget.bind(this);
        this._handleClickWindow = handleClickWindow.bind(this);

        if (this._element) {
            _init(this);
        }
    }

    function _init(context) {
        const target = document.querySelector(context._target);
        target.addEventListener('contextmenu', context._handleRightClickTarget);

        const items = Array.from(context._element.querySelectorAll('a'));
        items.forEach(function (item) {
            item.addEventListener('click', context._handleClickItem);
        });
    }

    function handleClickItem(event) {
        const node = event.currentTarget;
        this._callbackRender(node, node.dataset.name);
    }

    function handleRightClickTarget(event) {
        event.preventDefault();

        this.show(event.clientX, event.clientY);
    }

    function handleClickWindow(event) {
        const contextMenu = $(event.target).closest(this._selector).get(0);
        if (contextMenu != this._element) {
            this.close();
        }
    }

    function show(x, y) {
        this._element.style.top = y + 'px';
        this._element.style.left = x + 'px';
        this._element.classList.add('is-visible');

        document.addEventListener('mousedown', this._handleClickWindow);
    }

    function close() {
        this._element.classList.remove('is-visible');

        document.removeEventListener('mousedown', this._handleClickWindow);
    }

    ContextMenu.prototype.show = show;
    ContextMenu.prototype.close = close;

    return ContextMenu;
}());

var ComplianceController = {
    PlatformFilter: '',
    ComplianceSelectionChanged: function (e, itemsId) {
        ComplianceController.ShowInfo(itemsId[0]);
    },
    DeleteBenchmark: function (id) {
        ajaxRequest('Compliance/CheckBenchmarkForDelete?xccdfId=' + id, 'GET', undefined, null, actionForDelete, id);
    },
    ShowInfo: function (xccdfProfileId) {
        document.getElementById('desciptionBlock').classList.remove("hide");
        showParamsBlock();
        ajaxRequest('Compliance/GetXccdfFileInfo/' + xccdfProfileId, 'GET', undefined, null, setXccdfFileInfo);
    },
    PrepareToOpenCompliance: function () {
        $('#SelectedPlatform').addClass('hide');
        $('#SelectedProduct').addClass('hide');
    }
}

var CreateJobsComplianceController = {
    additionals: {
        isPreviewMode: false,
        isSingleRowSelection: false,
        isComplianceGridInit: false,
    },
    focusedRowKey: -1,
    isTableLoaded: false,

    onInitComplete: function (settings) {
        if (CreateJobsComplianceController.additionals.isSingleRowSelection) {
            this.api().select.style('single');
            this.api().select.selector('tr');
            this.api().select.toggleable(false);
            this.api().column('Id:name').visible(false);
        }

        if (CreateJobsComplianceController.additionals.isPreviewMode) {
            CreateJobsComplianceController.allowFocusedRow(this.api());
            CreateJobsComplianceController.setFocusedRowIndex(0);
        }

        if (typeof xccdfFileIds !== 'undefined') {
            let selectedRows = [];
            this.api().rows().every(function (rowIdx, tableLoop, rowLoop) {
                let data = this.data();

                if (xccdfFileIds.some(function (value) { return value === data.Id })) {
                    selectedRows.push(rowIdx);
                }
            });

            CreateJobsComplianceController.additionals.isComplianceGridInit = true;
            this.api().rows(selectedRows).select();
            CreateJobsComplianceController.additionals.isComplianceGridInit = false;
        }
        
        if (typeof currentJobProperties !== "undefined" && typeof currentJobProperties.selectedCompliances !== "undefined") {
            let selectedComplianceIds = currentJobProperties.selectedCompliances.map(x => x.id);
            this.api().rows().every(function() {
                let data = this.data();
                if (selectedComplianceIds.indexOf(data.Id) > -1) {
                    this.select();
                }
            });
        }

        CreateJobsComplianceController.isTableLoaded = true;
    },

    onDrawCallback: function (settings) {
        if (CreateJobsComplianceController.focusedRowKey !== -1) {
            let rowId = -1;
            this.api().rows().every(function () {
                if (this.data().Id === CreateJobsComplianceController.focusedRowKey)
                    rowId = this.index();
            });

            CreateJobsComplianceController.setFocusedRowIndex(rowId);
        }
    },

    getSelectedIds: function () {
        const table = document.getElementById('CreateJobsComplianceGrid');
        let result = [];

        if ($.fn.dataTable.isDataTable(table)) {
            const selected = $(table).dataTable().api().column('Id:name').checkboxes.selected();
            result = selected !== undefined ? selected.toArray() : [];
        }

        return result;
    },

    allowFocusedRow: function (api) {
        const tableNode = api.table().node();
        tableNode.classList.add('dt-allow-focused');

        $(tableNode).on('click', 'tr.data-table__row', function () {
            if (!$(this).hasClass('focused')) {
                const index = api.row(this).index();
                CreateJobsComplianceController.setFocusedRowIndex(index);
            }
        });
    },

    setFocusedRowIndex: function (index) {
        const api = $('#CreateJobsComplianceGrid').DataTable();
        const rowData = api.row(index).data();

        if (rowData !== undefined) {
            CreateJobsComplianceController.focusedRowKey = rowData.Id;

            const $table = api.tables().body().to$();
            $table.trigger("focused-row-changed", [api, index]);

            const tableNode = api.table().node();
            $(tableNode).find('tr.focused').removeClass('focused');
            $(api.row(index).node()).addClass('focused');
        }
    }
}

function openPopover(popoverId) {
    $('#' + popoverId).removeClass("hidden");
    openPopup();

    const position = $('[data-target="' + popoverId +'"]').position();
    if (position !== undefined) {
        $('#' + popoverId).css("top", position.top + 32);
        $('#' + popoverId).css("left", position.left);
    }

    addClickEventListenerOutside(popoverId, function () {
        if ($('#' + popoverId).is(':visible')) {
            closePopover(popoverId);
        }
    });
}

function closePopover(popoverId) {
    $('#' + popoverId).addClass("hidden");
    closePopup(popoverId);
}

function openResultPopover(popoverId) {
    $('#' + popoverId).removeClass("hidden");
    openResultPopup();

    const position = $('[data-target="' + popoverId + '"]').position();
    if (position !== undefined) {
        $('#' + popoverId).css("top", position.top + 32);
        $('#' + popoverId).css("left", position.left);
    }

    addClickEventListenerOutside(popoverId, function () {
        if ($('#' + popoverId).is(':visible')) {
            closeResultPopup();
        }
    });
}

function addClickEventListenerOutside(elementId, callback) {
    const element = document.getElementById(elementId);

    if (element === null || callback === undefined)
        return;

    function handleClick(e) {
        const withinBorders = e.composedPath().includes(element);

        if (!withinBorders) {
            document.removeEventListener("mousedown", handleClick);
            callback();
        }
    }
    document.addEventListener('mousedown', handleClick);
}

var JobPickerController = {
    setValues: function (entityId, entityName) {
        const jobName = document.getElementById('JobName');
        const jobId = document.getElementById('JobId');

        if (jobName === null || jobId === null) return;

        jobName.value = entityName;
        jobName.readOnly = true;
        jobId.value = entityId;
    },
};

function selectAllComplianceJM() {
    $('#CreateJobsComplianceGrid').DataTable().rows().select();
}

function unSelectAllComplianceJM() {
    $('#CreateJobsComplianceGrid').DataTable().rows().deselect();
}

const CHECK_STATE_UNCHECKED = 'Unchecked';
const CHECK_STATE_CHECKED = 'Checked';
const CHECK_STATE_INDETERMINATE = 'Indeterminate';

var TreeView = (function () {
    const SELECTOR_NODE_LIST = '.treeview__container';
    const SELECTOR_NODE = '.treeview-node';
    const SELECTOR_NODE_CONTENT = '.treeview-node__content';
    const SELECTOR_CONTROL = 'button.detail-button-dt';

    function TreeView(options) {
        this._selector = options.selector;
        this._initComplete = options.initComplete || function () { };
        this._initComplete = this._initComplete.bind(this);

        this._selectionChanged = options.selectionChanged || function () { };

        this._element = document.querySelector(this._selector);
        this._checkNodesRecursive = getCheckNodesRecursive(this._element);

        this._handleClickNode = handleClickNode.bind(this);
        this._handleClickControl = handleClickControl.bind(this);

        if (this._element) {
            _init(this);
        }
    }

    function _init(context) {
        if (context.getAllowCheckNodes()) {
            _enableCheckboxes(context);
        }

        Array.from(context._element.querySelectorAll(SELECTOR_NODE_CONTENT))
            .forEach(function (item) {
                item.addEventListener('click', context._handleClickNode);
            });
        Array.from(context._element.querySelectorAll(SELECTOR_CONTROL))
            .forEach(function (item) {
                item.addEventListener('click', context._handleClickControl);
            });

        context._initComplete();
    }

    function _enableCheckboxes(context) {
        if (context._checkNodesRecursive) {
            Array.from(context._element.querySelectorAll(SELECTOR_NODE + '.parent'))
                .forEach(function (node) {
                    const nodeCheckbox = node.querySelector(':scope > ' + SELECTOR_NODE_CONTENT + '> label > input[type="checkbox"]');
                    const anyChildChecked = node.querySelector(SELECTOR_NODE_LIST + ' input[type="checkbox"]:checked') !== null;

                    if (nodeCheckbox !== null && !nodeCheckbox.checked && anyChildChecked) {
                        nodeCheckbox.indeterminate = true;
                    }
                });
        }

        context._element.addEventListener('change', function (event) {
            const node = event.target.parentElement.parentElement.parentElement;

            if (event.target.type !== 'checkbox' || !node.classList.contains('treeview-node'))
                return;

            $(node).trigger(event.target.checked ? 'check-node.treeview' : 'uncheck-node.treeview');
        });

        if (context._checkNodesRecursive) {
            $(context._element).on('check-node.treeview', onCheckNode.bind(context));
            $(context._element).on('uncheck-node.treeview', onUncheckNode.bind(context));
        }
    }

    function onCheckNode(event) {
        _updateChildCheckbox(event.target, true);

        const parent = event.target.parentNode.parentNode;
        _updateParentCheckbox(this, new TreeViewNode(parent));
    }

    function onUncheckNode(event) {
        _updateChildCheckbox(event.target, false);

        const parent = event.target.parentNode.parentNode;
        _updateParentCheckbox(this, new TreeViewNode(parent));
    }

    function handleClickNode(event) {
        _resetFocus(this);
        const node = event.currentTarget;
        node.parentNode.classList.add('focused');

        this._selectionChanged(node.parentNode);
    }

    function handleClickControl(event) {
        const button = event.currentTarget;
        const li = button.parentNode.parentNode;
        const isExpanded = li.classList.contains('is-open')

        if (!isExpanded) {
            $(this._element).trigger('expand.treeview', [this, li]);
        }
        _renderNode(li, !isExpanded);
    }

    function _updateChildCheckbox(node, flag) {
        let selectorCheckbox = flag
            ? 'input[type="checkbox"]:not(:checked)'
            : 'input[type="checkbox"]';

        Array.from(node.querySelectorAll(SELECTOR_NODE + ' ' + selectorCheckbox))
            .forEach(function (item) {
                item.checked = flag;
                item.indeterminate = false;
            });
    }

    function _updateParentCheckbox(context, node) {
        const list = context.getNodesByParent(node);
        let checkState = CHECK_STATE_CHECKED;
        let anyChecked = false;

        for (let i = 0; i < list.length; i++) {
            const currentCheckState = list[i].getCheckState();

            if (currentCheckState === CHECK_STATE_CHECKED) {
                anyChecked = true;
            } else if (currentCheckState === CHECK_STATE_UNCHECKED) {
                checkState = currentCheckState;
            } else if (currentCheckState === CHECK_STATE_INDETERMINATE) {
                checkState = currentCheckState;
                break;
            }
        }

        if (anyChecked && checkState === CHECK_STATE_UNCHECKED) {
            checkState = CHECK_STATE_INDETERMINATE;
        }

        node.setCheckState(checkState);

        const parent = node.getParent();
        if (parent !== null) {
            _updateParentCheckbox(context, parent);
        }
    }

    function _renderNode(node, isExpanded) {
        const button = node.querySelector(SELECTOR_CONTROL);

        if (!button) return;

        if (isExpanded) {
            node.classList.add('is-open');

            button.classList.remove('icon_expand');
            button.classList.add('icon_collapse');
            button.setAttribute('aria-label', 'Collapse');
        } else {
            node.classList.remove('is-open');

            button.classList.remove('icon_collapse');
            button.classList.add('icon_expand');
            button.setAttribute('aria-label', 'Expand');
        }
    }

    function _getNodes(context, parentNode) {
        let nodes = [];

        const parentElement = parentNode !== undefined ? parentNode._element : context._element;
        const container = parentElement.querySelector(SELECTOR_NODE_LIST);

        if (container !== null && container.hasChildNodes()) {
            Array.from(container.childNodes)
                .forEach(function (innerNode) {
                    nodes.push(new TreeViewNode(innerNode));
                });
        }

        return nodes;
    }

    function _resetFocus(context) {
        Array.from(context._element.querySelectorAll(SELECTOR_NODE + '.focused'))
            .forEach(function (item) {
                item.classList.remove('focused');
            });
    }

    function setFocusedNode(node) {
        _resetFocus(this);

        node.getElement().classList.add('focused');
    }

    function getFocusedNode() {
        const node = this._element.querySelector(SELECTOR_NODE + '.focused');
        return node !== null ? new TreeViewNode(node) : null;
    }

    function getAllowCheckNodes() {
        if (!this._element.hasAttribute('data-checkboxes'))
            return false;

        return this._element.dataset.checkboxes !== 'false';
    }

    function collapseAll() {
        Array.from(this._element.querySelectorAll(SELECTOR_NODE + '.is-open'))
            .forEach(function (item) {
                _renderNode(item, false);
            });
    }

    function expandAll() {
        Array.from(this._element.querySelectorAll(SELECTOR_NODE))
            .forEach(function (item) {
                _renderNode(item, true);
            });
    }

    function getTopNodes() {
        return _getNodes(this);
    }

    function getNodesByParent(parentNode) {
        return _getNodes(this, parentNode);
    }

    function getCheckNodesRecursive(element) {
        if (!element.hasAttribute('data-checkboxes-recursive'))
            return false;

        return element.dataset.checkboxesRecursive !== 'false';
    }

    function destroy() {
        const container = this._element.querySelector(SELECTOR_NODE_LIST);

        if (container !== null) {
            container.innerHTML = '';
        }

        // Remove event handler expand.treeview
        $(this._element).off();
    }

    function addNode(node, parentNode) {
        const content = node.querySelector(SELECTOR_NODE_CONTENT)
        const control = node.querySelector(SELECTOR_CONTROL)

        if (content) {
            content.addEventListener('click', this._handleClickNode);
        }

        if (control) {
            control.addEventListener('click', this._handleClickControl);
        }

        if (parentNode === undefined) {
            const body = this._element.querySelector(SELECTOR_NODE_LIST);
            body.appendChild(node);
        } else {
            let body = parentNode.querySelector(SELECTOR_NODE_LIST);

            if (body === null) {
                body = document.createElement('ul');
                body.classList.add('treeview__container');
                parentNode.appendChild(body);
            }

            body.appendChild(node);
        }
    }

    TreeView.prototype.setFocusedNode = setFocusedNode;
    TreeView.prototype.getFocusedNode = getFocusedNode;
    TreeView.prototype.getAllowCheckNodes = getAllowCheckNodes;
    TreeView.prototype.collapseAll = collapseAll;
    TreeView.prototype.expandAll = expandAll;
    TreeView.prototype.getTopNodes = getTopNodes;
    TreeView.prototype.getNodesByParent = getNodesByParent;
    TreeView.prototype.destroy = destroy;
    TreeView.prototype.addNode = addNode;

    return TreeView;
}());

var TreeViewNode = (function () {
    function TreeViewNode(element) {
        this._element = element;
        this._allowCheck = element.hasAttribute('data-allow-check') && element.dataset.allowCheck !== 'false'
            || !element.hasAttribute('data-allow-check');

        this._checkbox = this._element.querySelector(':scope > div > label > input[type="checkbox"]');
        this._isParent = this._element.classList.contains('parent');
    }

    TreeViewNode.prototype.getKey = function () {
        return this._element.dataset.key;
    };

    TreeViewNode.prototype.getName = function () {
        return this._element.dataset.name;
    };

    TreeViewNode.prototype.getText = function () {
        return this._element.querySelector('.treeview-node__content > label').textContent;
    };
    TreeViewNode.prototype.getNodeText = function () {
        return this._element.querySelector('.treeview-node__content > span').textContent;
    };

    TreeViewNode.prototype.setChecked = function (flag) {
        if (!this._allowCheck || this._checkbox === null) {
            return;
        }

        this._checkbox.checked = flag;
        this._checkbox.indeterminate = false;

        $(this._element).trigger(flag ? 'check-node.treeview' : 'uncheck-node.treeview');
    };

    TreeViewNode.prototype.getChecked = function () {
        return this._allowCheck && this._checkbox !== null
            ? this._checkbox.checked
            : false;
    };

    TreeViewNode.prototype.setCheckState = function (checkState) {
        if (!this._allowCheck || this._checkbox === null) {
            return;
        }

        switch (checkState) {
            case CHECK_STATE_UNCHECKED:
                this._checkbox.checked = false;
                this._checkbox.indeterminate = false;
                break;
            case CHECK_STATE_CHECKED:
                this._checkbox.checked = true;
                this._checkbox.indeterminate = false;
                break;
            case CHECK_STATE_INDETERMINATE:
                this._checkbox.checked = false;
                this._checkbox.indeterminate = true;
                break;
        }
    };

    TreeViewNode.prototype.getCheckState = function () {
        if (this._allowCheck && this._checkbox !== null) {
            return this._checkbox.checked
                ? CHECK_STATE_CHECKED
                : this._checkbox.indeterminate
                    ? CHECK_STATE_INDETERMINATE
                    : CHECK_STATE_UNCHECKED;
        }

        return CHECK_STATE_UNCHECKED;
    };

    TreeViewNode.prototype.getElement = function () {
        return this._element;
    };

    TreeViewNode.prototype.getParent = function () {
        const node = this._element.parentNode.parentNode;
        return node !== null && node.classList.contains('treeview-node')
            ? new TreeViewNode(node)
            : null;
    };

    return TreeViewNode;
}());

var XccdfProfilesController = {
    onInit: function () {
        let profileTreeView = this;
        const benchmarkNodes = profileTreeView.getTopNodes();
        benchmarkNodes.forEach(function (node) {
            let complianceId = parseInt(node.getKey());
            profileTreeView.getNodesByParent(node)
                .forEach(function (profileNode) {
                    let profileId = parseInt(profileNode.getKey());
                    if (Number.isNaN(profileId) === true)
                        profileId = 0;
                    if (currentJobProperties.selectedCompliances.filter(c => c.id === complianceId).length > 0
                        && currentJobProperties.selectedCompliances.filter(c => c.id === complianceId)[0].profiles.indexOf(profileId) > -1)
                        profileNode.setChecked(true);
                    else
                        profileNode.setChecked(false);
                });
        });
    },

    onCheckedChanged: function (node) {
        // TODO: think of replacing by getSelectedBenchmarks()
        let complianceId = $(node).closest('li.treeview-node.parent').data('key');
        let profileId = parseInt(node.dataset.key);
        if (Number.isNaN(profileId) === true)
            profileId = 0;
        let isChecked = $($(node).find('input:checkbox')[0]).prop('checked');
        let addedAtIndex = currentJobProperties.selectedCompliances.filter(c => c.id === complianceId)[0].profiles.indexOf(profileId);
        if (isChecked === true && addedAtIndex === -1)
            currentJobProperties.selectedCompliances.filter(c => c.id === complianceId)[0].profiles.push(profileId);
        else if (isChecked === false && addedAtIndex > -1)
            currentJobProperties.selectedCompliances.filter(c => c.id === complianceId)[0].profiles.splice(addedAtIndex, 1);
    }
};

var JobExecutionsController = {
    additionals: {
        selectTimer: null,
    },

    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
        api.on('deselect select', JobExecutionsController.onSelectCallback);
    },

    onSelectCallback: function (e, api, type, indexes) {
        if (JobExecutionsController.additionals.selectTimer !== null)
            clearTimeout(JobExecutionsController.additionals.selectTimer);
        JobExecutionsController.additionals.selectTimer = setTimeout(function () {
            setJobExecution(api.selectCustom().selectedItemKeys());
        }, 100);
    },

    getRecordsDisplay: function () {
        const table = document.getElementById('JobExecutionsGrid');

        if ($.fn.DataTable.isDataTable(table)) {
            const info = $(table).dataTable().api().page.info();
            return info.recordsDisplay;
        }

        return 0;
    },

    getSelectedItemKeys: function () {
        const table = document.getElementById('JobExecutionsGrid');

        if ($.fn.DataTable.isDataTable(table)) {
            const api = $(table).dataTable().api();
            return api.selectCustom().selectedItemKeys();
        }

        return 0;
    }
};

var JobExecutionsDiffController = {
    additionals: {
        selectTimer: null,
    },

    onInitComplete: function (settings) {
        const api = new $.fn.dataTable.Api(settings);
        api.on('deselect select', JobExecutionsDiffController.onSelectCallback);
    },

    onSelectCallback: function (e, api, type, indexes) {
        if (JobExecutionsDiffController.additionals.selectTimer !== null)
            clearTimeout(JobExecutionsDiffController.additionals.selectTimer);
        JobExecutionsDiffController.additionals.selectTimer = setTimeout(function () {
            setJobExecutionDiff(api.selectCustom().selectedItemKeys());
        }, 100);
    },

    reset: function () {
        const table = document.getElementById('JobExecutionsDiffGrid');

        if ($.fn.DataTable.isDataTable(table)) {
            const api = $(table).dataTable().api();
            api.rows().deselect();
            api.ajax.reload();
        }
    }
};

var ChartsController = {

    drawForDashboard: function () {

        //Remove all event listeners
        d3.select(window).on('resize.vulnSeveritiesChartContentDiv', null);
        d3.select(window).on('resize.vulnHostsChartContentDiv', null);
        d3.select(window).on('resize.patchSeveritiesChartContentDiv', null);
        d3.select(window).on('resize.patchHostsChartContentDiv', null);

        if ($(".vuln-panel").is(":visible")) {
            getDatasetForVulnHostsChart();
            getDatasetForVulnSeveritiesChart();
        }
        else if ($(".patch-panel").is(":visible")) {
            getDatasetForPatchHostsChart();
            getDatasetForPatchSeveritiesChart();
        }
    },

    createBarChart: function (domElementId, dataset) {

        //Margin
        let margin = { top: 30, right: 20, bottom: 40, left: 80 };

        //SVG
        d3.select("#barChart").remove();
        let svg = d3.select(domElementId).append("svg").attr("id", "barChart");

        //Contains all other elements of chart
        let svgMainGroup = svg.append("g").attr("id", "mainBarChartGr")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

        //Add group for X and Y axis
        svgMainGroup.append("g").attr("class", "x-axis");
        svgMainGroup.append("g").attr("class", "y-axis");

        svgMainGroup.append("g").attr("class", "bars");
        svgMainGroup.append("g").attr("class", "bar-value");

        let maxValueLength = Math.max.apply(Math, dataset.map(function (item) { return item.valueLength; }));

        //Add text
        svgMainGroup.append("text")
            .attr("id", "barChartYAxisLegend")
            .attr("transform", "rotate(-90)")
            .attr("y", maxValueLength * (10) < 40 ? -40 : maxValueLength * (-9))
            .attr("dy", "")
            .attr("text-anchor", "end")
            .text("Количество хостов");

        //Construct scales
        let xScale = d3.scaleBand().padding(0.4);
        let yScale = d3.scaleLinear();

        //Compute domains
        xScale.domain(dataset.map(d => d.label));
        yScale.domain([0, d3.max(dataset, d => d.value)]);

        let container = d3.select(svg.node().parentNode);
        d3.select(window).on('resize.' + container.attr('id'), drawBarChart);

        drawBarChart();

        function drawBarChart() {

            let currentParentWidth = parseInt(d3.select(domElementId).style("width"));
            let currentParentHeight = parseInt(d3.select(domElementId).style("height"));

            //Limit width with 600px
            let width = currentParentWidth > 600 ? 600 : currentParentWidth;
            let height = currentParentHeight;

            width = width - margin.left - margin.right;
            //For x-axis legend not to cut
            margin.bottom = width > 350 ? 40 : 60;
            height = height - margin.top - margin.bottom;

            // Set SVG width and height including margin.
            svg
                .attr("width", width + margin.left + margin.right)
                .attr("height", height + margin.top + margin.bottom);

            //Set barChartYAxisLegend's X attribute
            svgMainGroup.select("#barChartYAxisLegend").attr("x", (height < 150) ? -20 : -50);

            //Compute ranges
            xScale.range([0, width]);
            yScale.range([height, 0]);

            //Initialize axes
            let xAxis = d3.axisBottom(xScale);
            let yAxis = d3.axisLeft(yScale).ticks(8);

            // Add the x-axis.
            if (width > 350) {
                d3.select(".x-axis").attr("transform", "translate(0," + height + ")").call(xAxis)
                    .selectAll("text")
                    .style("text-anchor", "middle")
                    .attr("dy", "0.71em")
                    .attr("dx", "0")
                    .attr("y", "9").attr("transform", "rotate(0)");;
            } else {
                d3.select(".x-axis").attr("transform", "translate(0," + height + ")").call(xAxis)
                    .selectAll("text")
                    .style("text-anchor", "end")
                    .attr("dx", "-.8em")
                    .attr("dy", ".15em")
                    .attr("transform", "rotate(-50)");
            }

            // Add the y-axis.
            d3.select(".y-axis").call(yAxis);

            svgMainGroup.select(".bars").selectAll("rect")
                .data(dataset)
                .join("rect")
                .attr("id", d => d.severity)
                .attr("x", d => xScale(d.label))
                .attr("y", d => yScale(d.value))
                .attr("width", xScale.bandwidth())
                .attr("height", d => height - yScale(d.value))
                .attr("fill", d => d.bgColor)
                .on("mouseover", function () {
                    d3.selectAll("rect")
                        .filter((d, i) => d.severity === this.id)
                        .transition()
                        .duration("50")
                        .attr("opacity", ".90");
                })
                .on("mouseout", function (d, i) {
                    d3.selectAll("rect")
                        .filter((d, i) => d.severity === this.id)
                        .transition()
                        .duration("50")
                        .attr("opacity", 1)
                        .attr("fill", d => d.bgColor);
                });

            svgMainGroup.select(".bar-value")
                .selectAll("text")
                .data(dataset)
                .join("text")
                .text(d => d.value)
                .attr("x", d => xScale(d.label) + xScale.bandwidth() / 2)
                .attr("y", d => yScale(d.value) - 3)
                .attr("fomt-family", "sans-serif")
                .attr("font-size", "13px")
                .attr("font-weight", 600)
                .attr("fill", "black")
                .attr("text-anchor", "middle");
        }
    },

    createDonutChart: function (domElementId, dataset, options) {
        const chartOptions = {
            maxWidth: 600,
            valueDisplay: options !== undefined && options.valueDisplay === true,
            totalValueTitle: options !== undefined && !isEmptyString(options.totalValueTitle) ? options.totalValueTitle : null,
        };
        
        // Set SVG
        d3.select("#donutChart").remove();
        let svg = d3.select(domElementId).append("svg").attr("id", "donutChart");

        // Contains all other elements of chart
        let svgMainGroup = svg.append("g").attr("id", "mainDonutChartGr");

        // Add group for slices, dots and labels
        svgMainGroup.append("g").attr("id", "slicesGroup");
        svgMainGroup.append("g").attr("id", "dotsGroup");
        svgMainGroup.append("g").attr("id", "labelsGroup");

        if (chartOptions.valueDisplay) {
            svgMainGroup.append('g').attr('id', 'totalCaption');
            svgMainGroup.append('g').attr('id', 'totalValueLabel');
            svgMainGroup.append('g').attr('id', 'valuesGroup');
        }

        // Construct scales
        let colorScale = d3.scaleOrdinal(dataset.map(d => d.bgColor));

        // Set layout
        let pie = d3.pie().value(d => d.value);
        let pieData = pie(dataset);
        let totalValue = pieData.reduce((acc, current) => acc + current.value, 0);

        let container = d3.select(svg.node().parentNode);
        d3.select(window).on('resize.' + container.attr('id'), drawDonutChart);

        drawDonutChart();

        function drawDonutChart() {

            // Setting properties
            let margin = { top: 20, right: 0, bottom: 0, left: 20 };

            let currentParentWidth = parseInt(d3.select(domElementId).style("width"));
            let currentParentHeight = parseInt(d3.select(domElementId).style("height"));

            // Limit width
            let width = currentParentWidth > chartOptions.maxWidth ? chartOptions.maxWidth : currentParentWidth;
            let height = currentParentHeight;

            width = width - margin.left - margin.right;

            let radius = (Math.min(width - 180, height) / 2) - margin.top;

            // Arc generator
            let arc = d3.arc().innerRadius(radius * 0.6).outerRadius(radius).padAngle(0.02);

            svg
                .attr("width", width + margin.left + margin.right)
                .attr("height", height + margin.top + margin.bottom);

            svgMainGroup.attr("transform", `translate(${radius + margin.left}, ${radius + margin.top})`);

            // Draw slices
            svgMainGroup.select("#slicesGroup").selectAll("path")
                .data(pieData)
                .join("path")
                .attr("d", arc)
                .attr("id", d => d.data.id)
                .attr("fill", d => colorScale(d.data.severity))
                .attr("opacity", ".90")
                .on("mouseover", function (d, i) {
                    d3.select(this).transition()
                        .duration("50")
                        .attr("opacity", "1");
                })
                .on("mouseout", function (d, i) {
                    d3.select(this).transition()
                        .duration("50")
                        .attr("opacity", ".90");
                });

            // Draw dots
            let minDotCY = Math.round(pieData.length / 2) * (-20);
            let dotsCX = 50;

            svgMainGroup.select("#dotsGroup").selectAll("circle")
                .data(pieData)
                .join("circle")
                .attr('transform', `translate(${radius}, ${0})`)
                .attr("cx", dotsCX)
                .attr("cy", function (d, i) {
                    minDotCY = minDotCY + 20;
                    return minDotCY;
                })
                .attr("r", 6)
                .style("fill", d => colorScale(d.data.severity));

            // Draw labels
            let minYText = Math.round(pieData.length / 2) * (-20);
            let xForText = dotsCX + 15;

            svg.select("#labelsGroup").selectAll("text")
                .data(pieData)
                .join("text")
                .text(d => d.data.label)
                .attr('transform', `translate(${radius}, ${0})`)
                .attr("id", d => d.data.severity)
                .attr("text-anchor", "start")
                .attr("alignment-baseline", "central")
                .attr("font-size", 13)
                .attr("x", xForText)
                .attr("y", function (d, i) {
                    minYText = minYText + 20;
                    return minYText;
                })
                .attr("fill", "black");

            if (chartOptions.valueDisplay) {
                svg.select('#totalCaption').selectAll('text')
                    .data([chartOptions.totalValueTitle])
                    .join('text')
                    .text(d => d)
                    .attr('text-anchor', 'middle')
                    .attr('font-size', 12)
                    .attr('y', '1.5em');
                
                svg.select('#totalValueLabel').selectAll('text')
                    .data([totalValue])
                    .join('text')
                    .text(d => d)
                    .attr('text-anchor', 'middle')
                    .attr('font-size', 20);

                let minYValue = Math.round(pieData.length / 2) * (-20);
                
                let xForValue = domElementId === '#hostStatisticsChart' ? dotsCX + 160 : dotsCX + 120;
                
                svg.select('#valuesGroup').selectAll('text')
                    .data(pieData)
                    .join('text')
                    .text(d => d.data.value)
                    .attr('transform', `translate(${radius}, ${0})`)
                    .attr('id', d => d.data.severity)
                    .attr('text-anchor', 'start')
                    .attr('alignment-baseline', 'central')
                    .attr('font-size', 13)
                    .attr('x', xForValue)
                    .attr('y', function (d, i) {
                        minYValue = minYValue + 20;
                        return minYValue;
                    })
                    .attr('fill', 'black');
            }
        }
    }
};

var AjaxContainer = {
    errorText: 'Во время выполнения запроса что-то пошло не так',

    findAndLoadByWrapperId: function (wrapperId) {
        const wrapper = document.getElementById(wrapperId);

        if (wrapper !== null) {
            Array.from(wrapper.querySelectorAll('div[data-action-type="load"]')).forEach(function (element) {
                AjaxContainer.loadContent(element);
            });
        }
    },

    loadContent: function (container) {
        const url = container.dataset.actionUrl;

        if (url === null) {
            return;
        }

        $(container).load(url, function (response, status, xhr) {
            if (status === 'error') {
                AjaxContainer.innerErrorText(container);
                return;
            }
        });
    },

    innerErrorText: function (container) {
        container.innerHTML = '';

        const content = document.createElement('div');
        content.setAttribute('style', 'margin-top: 150px;text-align: center;');

        const message = document.createElement('div');
        message.classList.add('margin-10');
        message.textContent = AjaxContainer.errorText;

        const btn = document.createElement('input');
        btn.type = 'button';
        btn.value = 'Обновить';
        btn.onclick = function () {
            this.disabled = true;
            AjaxContainer.reloadContent(container);
        };

        content.appendChild(message);
        content.appendChild(btn);

        container.appendChild(content);
    },

    reloadContent: function (container) {
        setTimeout(function () {
            AjaxContainer.loadContent(container);
        }, 1500);
    }
};

function objectToQueryString(queryParams) {
    const params = new URLSearchParams();

    for (let key in queryParams) {
        if (Array.isArray(queryParams[key])) {
            queryParams[key].forEach((item) => params.append(key, item));
        } else {
            params.append(key, queryParams[key]);
        }
    }

    return params.toString();
}

function isJobConfigurationAllowed(serviceOsType, jobScanType, credentialType, transportType, nixScanServiceForbiddenJobs) {
    if (serviceOsType !== OS_TYPE_LINUX)
        return true;

    if (nixScanServiceForbiddenJobs.JobScanTypes.includes(jobScanType))
        return false;

    var forbiddenCt = nixScanServiceForbiddenJobs.CredentialTypes
        .filter(ct => { return ct.Type === credentialType });
    if (forbiddenCt.length === 0)
        return true;

    if (credentialType === CREDENTIAL_TYPE_Windows)
        return forbiddenCt[0].TransportTypes.includes(transportType) ? false : true;

    return false;
}

function isJobScanTypeForNixServiceAllowed(serviceOsType, jobScanType, nixScanServiceForbiddenJobs) {
    if (serviceOsType !== OS_TYPE_LINUX)
        return true;

    return !nixScanServiceForbiddenJobs.JobScanTypes.includes(jobScanType);
}

function isCredentialsForNixServiceAllowed(serviceOsType, jobScanType, jobPingType, credentials, nixScanServiceForbiddenJobs) {
    if (serviceOsType !== OS_TYPE_LINUX)
        return { result: true };
    
    let credentialsWithForbiddenTypes = [];
    let credentialsWithForbiddenTransport = [];
    credentials.forEach(function(c) {
        let pingType = jobScanType === SCAN_TYPE_Ping ? jobPingType : jobAgentTypeToPingType(c.AgentType);
        if (!isCredentialTypeForNixServiceAllowed(serviceOsType, c.Type, nixScanServiceForbiddenJobs))
            credentialsWithForbiddenTypes.push(c);
        else if (!isCredentialTypeWithTransportTypeForNixServiceAllowed(serviceOsType, c.Type, pingType, nixScanServiceForbiddenJobs))
            credentialsWithForbiddenTransport.push(c);
    });
    
    let result = credentialsWithForbiddenTypes.length === 0 && credentialsWithForbiddenTransport.length === 0;
    let message = '';
    if (credentialsWithForbiddenTypes.length > 0) {
        message += nixScanServiceInvalidCredentialType + ":\n";
        credentialsWithForbiddenTypes.forEach(function(c) {
            message += c.Name + ' (' + c.Type + ')';
        });
    }
    if (credentialsWithForbiddenTransport.length > 0) {
        if (message.length > 0)
            message += '\n\n';

        message += nixScanServiceInvalidTransport + ":\n";
        credentialsWithForbiddenTransport.forEach(function(c) {
            message += c.Name + ' (' + c.Type + ', ' + AddAgentTypeTextBasedOnCred(jobScanType === SCAN_TYPE_Ping ? jobPingType : c.AgentType, c.Type) + ')';
        });
    }

    return { result: result, message: message };
}

function isCredentialTypeForNixServiceAllowed(serviceOsType, credentialType, nixScanServiceForbiddenJobs) {
    if (serviceOsType !== OS_TYPE_LINUX)
        return true;

    // undefined check is for Ping transport step
    if (credentialType === undefined)
        credentialType = CREDENTIAL_TYPE_Windows;

    let forbiddenCt = nixScanServiceForbiddenJobs.CredentialTypes
        .filter(ct => { return ct.Type === credentialType });
    if (forbiddenCt.length === 0)
        return true;

    // If any transport types are specified - that means only that transport types are forbidden
    // Otherwise the whole credential type is forbidden
    return forbiddenCt[0].TransportTypes.length > 0;
}

function isCredentialTypeWithTransportTypeForNixServiceAllowed(serviceOsType, credentialType, transportType, nixScanServiceForbiddenJobs) {
    if (serviceOsType !== OS_TYPE_LINUX)
        return true;

    // undefined check is for Ping transport step
    if (!credentialType)
        credentialType = CREDENTIAL_TYPE_Windows;

    var forbiddenCt = nixScanServiceForbiddenJobs.CredentialTypes
        .filter(ct => {
            return ct.Type === credentialType
        });
    if (forbiddenCt.length === 0)
        return true;

    return forbiddenCt[0].TransportTypes.length === 0 || !forbiddenCt[0].TransportTypes.includes(transportType);
}

const JOB_PING_TYPE_Wmi = "Wmi";
const JOB_PING_TYPE_Winrm = "Winrm";
const JOB_PING_TYPE_Agent = "Agent";
function jobAgentTypeToPingType(jobAgentType) {
    switch (jobAgentType) {
        case JOB_AGENT_TYPE_Agentless:
            return JOB_PING_TYPE_Wmi;
        case JOB_AGENT_TYPE_TempAgent:
            return JOB_PING_TYPE_Winrm;
        default:
            return JOB_PING_TYPE_Agent;
    }
}

var HostsExportController = {
    exportHosts: function () {
        let fileNameEl = document.getElementById('exportHostsFileName');
        let descCheckedEl = document.getElementById('includeDescription');

        let fileNameValue = fileNameEl.value.trim();
        if (fileNameValue == '')
            return notifyWarning("Не указано имя файла")

        let url = "/hostsexport/downloadhosts?fileName=" + fileNameValue + "&includeDescription=" + descCheckedEl.checked;

        fileNameEl.value = '';
        descCheckedEl.checked = false;

        $('#exportHostsModal').modal('hide');

        window.location = url;
    },

    closeExportHostsModal: function () {
        document.getElementById('exportHostsFileName').value = '';
        document.getElementById('includeDescription').checked = false;
        $('#exportHostsModal').modal('hide');
    }
}

function toggleFailedHostsRetrySettingsVisibility() {
    const element = document.getElementById('enableFailedHostsRetry');
    const settings = document.getElementById('failedHostsRetrySettings');
    
    if (element && settings){
        if (element.checked) {
            settings.classList.remove('hide');
        }
        else {
            settings.classList.add('hide');
        }
    }
}

function convertHoursToDuration(totalHours) {
    let hours = totalHours % 24;
    let totalDays = Math.floor(totalHours / 24);

    let days = totalDays % 7;
    let weeks = Math.floor(totalDays / 7);

    let result = '';

    if (weeks === 0 && days === 0) {
        return result;
    }

    if (weeks > 0) {
        result = weeks + ' нед. ';
    }
    if (days > 0) {
        result += days + ' д. ';
    }
    if (hours > 0) {
        result += hours + ' ч.';
    }

    return result.trim();
}

const GroupEditorController = {
    errorText: 'Во время выполнения запроса что-то пошло не так',
    formElement: null,
    submitCompleteCallback: () => {},

    init: function ({selector, submitComplete}) {
        GroupEditorController.formElement = document.querySelector(selector);
        GroupEditorController.submitCompleteCallback = submitComplete;
        
        // submitHandler is used to avoid repeated requests and additional validation checks
        const validator = $(selector).data('validator');
        validator.settings.submitHandler = function(form) {
            GroupEditorController.submitForm();
            return false;
        };
    },

    submitForm: async function () {
        const url = GroupEditorController.formElement.action;
        const formData = new FormData(GroupEditorController.formElement);

        const jsonData = Object.fromEntries(formData);
        jsonData['Targets'] = SelectedHostsGridController.cpData.map((x) => { return { 'Id': x }});

        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(jsonData)
            });

            if (!response.ok) {
                notifyWarning(GroupEditorController.errorText);
            } else {
                GroupEditorController.submitCompleteCallback();
            }
        } catch (e) {
            console.error(e);
            notifyWarning(GroupEditorController.errorText);
        }
    }
};

const BackgroundTaskState = {
    RUNNING: 0,
    QUEUED: 1,
    COMPLETED: 2,
    PAUSED: 3,
    ERROR: 4,
    NONE: 5,
};

class EventEmitter {
    constructor() {
        this._events = new Map();
    }

    on(event, listener) {
        if (!this._events.has(event)) {
            this._events.set(event, new Set());
        }
        
        this._events.get(event).add(listener);
        return this;
    }

    off(event, listener) {
        if (this._events.has(event)) {
            this._events.get(event).delete(listener);
        }
        return this;
    }

    emit(event, ...args) {
        const listeners = this._events.get(event);
        if (!listeners || listeners.size === 0) {
            return false;
        }

        for (let listener of [...listeners]) {
            try {
                listener(...args);
            } catch (err) {
                setTimeout(() => { throw err; }, 0);
            }
        }
        return true;
    }
}

class BackgroundTasksMonitor extends EventEmitter{
    tasks = [];
    syncCallback = () => {};

    constructor(options) {
        super();
        this.tasks = options.taskKeys.map(key => ({ key: key, state: BackgroundTaskState.NONE }));
        this.syncCallback = options.syncCallback.bind(this);

        this._updateStatuses();
        setInterval(() => this._updateStatuses(), 5000);
    }

    startTrackingTask(key) {
        this.tasks.push({ key: key, state: BackgroundTaskState.NONE });
        this.syncCallback();
    }

    stopTrackingTask(key) {
        this.tasks = this.tasks.filter(t => t.key !== key);
    }

    stopTrackingErrorTask() {
        this.tasks = this.tasks.filter(t => t.state !== BackgroundTaskState.ERROR);
        this.syncCallback();
    }

    _updateTask(key, state) {
        const task = this.tasks.find(t => t.key === key);
        if (task !== undefined) {
            task.state = state;
        }
    }

    async _updateStatuses() {
        const taskKeys = this.tasks.map(t => t.key);
        if (taskKeys.length === 0 || document.visibilityState !== 'visible') {
            return;
        }

        const response = await fetch('/BackgroundTasks/BackgroundTasksGrid');
        if (!response.ok) {
            return;
        }

        const data = (await response.json()).data;
        const tasks = data.map(t => ({ key: t.Key, state: t.State }));

        let hasChanges = false;
        for (let key of taskKeys) {
            const task = tasks.find(t => t.key === key);
            if (task === undefined || task.state === BackgroundTaskState.COMPLETED) {
                this.stopTrackingTask(key);
                hasChanges = true;
                continue;
            }

            this._updateTask(key, task.state);
        }

        this.syncCallback();

        if (hasChanges) {
            this.emit('tasks-stopped');
        }
    }
}

const backgroundTasksMonitor = new BackgroundTasksMonitor({
    taskKeys: JSON.parse(sessionStorage.getItem('background-tasks') ?? '[]'),
    syncCallback: function () {
        const taskKeys = this.tasks.map(t => t.key);
        sessionStorage.setItem('background-tasks', JSON.stringify(taskKeys));

        const isActive = this.tasks.filter(t => t.state !== BackgroundTaskState.ERROR).length > 0;
        const hasUnreadEvents = this.tasks.some(t => t.state === BackgroundTaskState.ERROR);
        updateTasksProgress(isActive, hasUnreadEvents);
    },
});

var ImportYaraRulesController = {
    processingUploadFiles: function () {
        const form = document.getElementById('ucYaraRulesFileUploader');
        const formData = new FormData(form);
        const xhr = new XMLHttpRequest();

        xhr.responseType = 'json';
        xhr.open(form.method, form.action, true);
        xhr.send(formData);

        xhr.onload = function (event) {
            if (xhr.status == 200 && xhr.response !== null) {
                ImportYaraRulesController.onFileUploadComplete(xhr.response);
            } else {
                notifyWarning(xhr.response ?? ImportCsvHostsController.errorText);
            }
        };

        xhr.onerror = function () {
            notifyWarning(ImportCsvHostsController.errorText);
        };
    },

    onFileUploadComplete: function (response) {
        document.getElementById('ucYaraRulesFileUploader').reset();
        document.getElementById('importPreloader').classList.add('hide');
        document.getElementById('importYaraRulesModalBody').classList.remove('disableContent');
        let message = `Всего правил: ${response.totalRulesCount}<br>Правил импортировано: ${response.importedRulesCount}<br>Правил обновлено: ${response.updatedRulesCount}<br>Правил с ошибками: ${response.failedRulesCount}<br>Файлов с ошибками: ${response.failedFilesCount}`
        if (response.failedRulesCount > 0 || response.failedFilesCount > 0) {
            message += "<br>Подробности в логах событий";
            if (response.importedRulesCount === 0 && response.updatedRulesCount === 0)
                notifyWarning(message);
            else
                notifyAttention(message);
        }
        else
            notifySuccess(message);
            
    },
    setElementVisible: function (elementId, element2Id, visible) {
        var el = $("#" + elementId);
        var el2 = $("#" + element2Id);
        if (visible) {
            el.show();
            el2.hide();
        } else {
            el.hide();
            el2.show();
        }
    }
};

var EditUserNotificationSettingsPopupController = {

    onShown: function () {
        var id = $('#userNotificationSettingsModal').attr('data-network-resource-id');
        var email = $('#userNotificationSettingsModal').attr('data-network-resource-email');
        
        const hiddenSubjectValue = NotificationSettingsController.getUserNotificationSubject(id);
        const hiddenTriggersValue = NotificationSettingsController.getUserNotificationTriggers(id);

        $("#editEmailAddress").val(email);
        $("#editEmailSubject").val(hiddenSubjectValue);

        $("#editJobCompletedNotificationTrigger").prop("checked", false);
        $("#editJobFailedNotificationTrigger").prop("checked", false);
        $("#editControlMismatchNotificationTrigger").prop("checked", false);

        if (typeof hiddenTriggersValue !== "undefined" && hiddenTriggersValue.length > 0) {
            var triggers = hiddenTriggersValue.split(',').map(function(item) {
                return parseInt(item.trim(), 10);
            });
            triggers.forEach(function(triggerId) {
                if (triggerId == 1) $("#editJobCompletedNotificationTrigger").prop("checked", true);
                if (triggerId == 2) $("#editJobFailedNotificationTrigger").prop("checked", true);
                if (triggerId == 3) $("#editControlMismatchNotificationTrigger").prop("checked", true);
            });
        }
    },

    saveUserNotificationSettingsButtonClick: function () {
        let id = $('#userNotificationSettingsModal').attr('data-network-resource-id');
        let newSubject = $("#editEmailSubject").val();

        let triggers = [];
        if ($("#editJobCompletedNotificationTrigger").prop("checked")) triggers.push(1);
        if ($("#editJobFailedNotificationTrigger").prop("checked")) triggers.push(2);
        if ($("#editControlMismatchNotificationTrigger").prop("checked")) triggers.push(3);

        NotificationSettingsController.setUserNotificationSubject(id, newSubject);
        NotificationSettingsController.setUserNotificationTriggers(id, triggers.join(','));

        let table = $('#NetworkResourcesGrid').DataTable();

        table.rows().every(function () {
            var data = this.data();
            if (data.Id == id) {
                this.invalidate();
            }
        });

        table.draw(false);

        $('#userNotificationSettingsModal').modal('hide');
    }
};

var NotificationSettingsController = {

    getInputValueBySelector: function (selector){
        const input = document.querySelector(selector);
        return input ? input.value : null;
    },
    
    setInputValueBySelector: function (selector, newValue){
        const input = document.querySelector(selector);
        if (input) input.value = newValue;
    },
    
    getUserNotificationSubject: function (id) {
        const selector = `[id*="NetworkResourcesGrid"] input[id*="UserNotificationSettings_${id}_"][id$="_Subject"]`;
        return this.getInputValueBySelector(selector);
    },

    getUserNotificationTriggers: function (id) {
        const selector = `[id*="NetworkResourcesGrid"] input[id*="UserNotificationSettings_${id}_"][id$="_Triggers"]`;
        return this.getInputValueBySelector(selector);
    },
    
    getMappedUserNotificationTriggers: function (triggers) {
        const map = {
            1: "Задание выполнено",
            2: "Задание завершено с ошибкой",
            3: "Несоответствие контроля"
        };

        return (triggers ?? '')
            .split(',')
            .map(v => v.trim())
            .filter(v => v !== "")
            .map(v => map[v] || v)
            .join(';');
    },

    setUserNotificationSubject: function (id, newValue) {
        const selector = `[id*="NetworkResourcesGrid"] input[id*="UserNotificationSettings_${id}_"][id$="_Subject"]`;
        this.setInputValueBySelector(selector, newValue);
    },
    
    setUserNotificationTriggers: function (id, newValue) {
        const selector = `[id*="NetworkResourcesGrid"] input[id*="UserNotificationSettings_${id}_"][id$="_Triggers"]`;
        this.setInputValueBySelector(selector, newValue);
    }
}