﻿const WIZARD_MODE_Report = "Report";
const WIZARD_MODE_CreateTemplate = "CreateTemplate";
const WIZARD_MODE_EditTemplate = "EditTemplate";

function Tab(name) {
    this.name = name;

    this.WizardMode = $('#Params_WizardMode');
    this.UseReportTemplate = $('#Params_UseReportTemplate');
    this.ReportTemplateId = $('#Params_ReportTemplateId');
    this.SelectedType = $('#Params_SelectedType');
    this.SelectedDataTypeSimple = $('#Params_SelectedDataType');
    this.SelectedDataTypeDiff = $('#Params_SelectedDataTypeDiff');
    this.SelectedDataSelectionMode = $('#Params_SelectedDataSelectionMode');
}

Tab.prototype.open = function () {
    if ($('.tablinks[data-step-name="' + this.data('step-name') + '"]').length === 0)
        this.addTabLink();

    $('.tabcontent').addClass('hide');
    this.removeClass('hide');

    $('.tablinks').removeClass('active');
    $('.tablinks[data-step-name="' + this.data('step-name') + '"]').addClass('active');

    if (getNextStepName() === '' && this.data('step-name') !== 'tmp') {
        $('#nextStep').addClass('hide');
        $('#buttonCreateReport').removeClass('hide');
    } else {
        $('#nextStep').removeClass('hide');
        $('#buttonCreateReport').addClass('hide');
    }

    if (this.data('step-name') === $('.tabcontent').first().data('step-name'))
        $('#prevStep').hide();
    else
        $('#prevStep').show();

    if (this.data('step-name') !== 'tmp')
        $('#stepContainer').trigger('tab-changed', [this.data('step-name')]);
};

Tab.prototype.isValid = function () {
    return $("form").valid();
};

Tab.prototype.GetParams = function (context) {
    var selectedDataType = context.SelectedType.val() === reportTypes.Simple
        ? context.SelectedDataTypeSimple.val()
        : context.SelectedDataTypeDiff.val();

    return {
        WizardMode: context.WizardMode.val(),
        ReportTemplateId: context.ReportTemplateId.val(),
        ReportType: context.SelectedType.val(),
        ReportDataType: selectedDataType,
        ReportSelectionMode: context.SelectedDataSelectionMode !== 'undefined' ? context.SelectedDataSelectionMode.val() : null
    };
};

Tab.prototype.addTabLink = function () {
    var self = this;
    var newTab = document.createElement("button");
    newTab.innerText = this.data('title');
    newTab.classList.add("tablinks");
    newTab.setAttribute('data-step-name', this.data('step-name'));
    newTab.onclick = function () { self.open() };

    $('.tablinks:last-child').after(newTab);
};

// Report Filter Strips

var StripsPopupController = {
    needSelectStripMessage: 'Выберите профиль аудитов',
    filterStripsGrid: null,
    currentPopupElement: null,

    onInit: function () {
        if (StripsPopupController.filterStripsGrid != null) {
            StripsPopupController.filterStripsGrid = null;
        }
    },

    onShow: function (event) {
        StripsPopupController.setCurrentPopupElement(event.relatedTarget);

        setTimeout(function () {
            $.fn.dataTable.util.columnsAjustSize();
        }, 200);
    },

    onShown: function (event) {
        if (StripsPopupController.filterStripsGrid != null) {
            StripsPopupController.filterStripsGrid.deselectAll();
        }
    },

    TableLoad: function (filter) {
        var parsedFilter = JSON.parse(filter);

        StripsPopupController.filterStripsGrid = new FilterStripsPopupGridComponent({
            root: '#FilterStripsGrid',
            ajax: StripsPopupController.createUrlFiltersHosts(),
            style: 'multi',
            filter: JSON.stringify(parsedFilter)
        });

        StripsPopupController.filterStripsGrid.mount();
    },

    selectStripsButtonClick: function () {
        const selectedRows = StripsPopupController.filterStripsGrid.getSelectedItems();

        if (!selectedRows.length) {
            notifyWarning(StripsPopupController.needSelectStripMessage);
            return;
        }
        
        StripsPopupController.showSelectedStrips(selectedRows);
        $('#stripsModal').modal('hide');
    },

    showSelectedStrips: function (newStrips) {
        const newStripIds = newStrips.map(function (resource) {
            return resource.id;
        });

        StripsGridController.AddSelectedStrip(newStripIds);
    },

    setCurrentPopupElement: function (element) {
        StripsPopupController.currentPopupElement = element;
    },

    getCurrentPopupElement: function () {
        return StripsPopupController.currentPopupElement;
    },

    createUrlFiltersHosts: function () {
        let links = {
            url: '/OvalProfiles/FiltersOvalProfilesGrid',
            urlItemsId: '/OvalProfiles/ListOvalProfileIds',
        }

        return links;
    }
};

StripsGridController = {
    includedStripIds: [],
    excludedStripIds: [],

    AddSelectedStrip: function (values) {
        var isExcluded = StripsPopupController.getCurrentPopupElement().id === "btnExcludedStrips";

        var selectedStrips;
        if (isExcluded) {
            StripsGridController.excludedStripIds = unionArray(StripsGridController.excludedStripIds, values);
            selectedStrips = StripsGridController.excludedStripIds;
        } else {
            StripsGridController.includedStripIds = unionArray(StripsGridController.includedStripIds, values);
            selectedStrips = StripsGridController.includedStripIds;
        }

        if (selectedStrips.length === 0) {
            notifyWarning(needSelectStripsMessage);
            return;
        } else {
            ajaxRequest(getStripsByListIdUrl, 'POST',
                {
                    isExclude: isExcluded,
                    selectedStripIds: selectedStrips
                }, function () {
                    document.getElementById('preloader' + (isExcluded ? 'ExcludedStrips' : 'IncludedStrips')).classList.remove('hide');
                    document.getElementById('selected' + (isExcluded ? 'ExcludedStrips' : 'IncludedStrips') + 'ResultGrid').innerHTML = '';
                    document.getElementById('btn' + (isExcluded ? 'ExcludedStrips' : 'IncludedStrips')).setAttribute('disabled', '');
                }, function (html) {
                    document.getElementById('preloader' + (isExcluded ? 'ExcludedStrips' : 'IncludedStrips')).classList.add('hide');
                    document.getElementById(isExcluded ? 'block-excluded-strips-grid' : 'block-included-strips-grid').innerHTML = html;
                    document.getElementById('btn' + (isExcluded ? 'ExcludedStrips' : 'IncludedStrips')).removeAttribute('disabled');    
            });
            //document.getElementById('selectedStrips').innerHTML = StripsGridController.cpData.length;

            // Deleting intersected strips from the opposite list
            var intersectedStrips = $(StripsGridController.includedStripIds).filter(StripsGridController.excludedStripIds);
            for (var i = 0; i < intersectedStrips.length; i++)
                StripsGridController.DeleteSelectedStrip(intersectedStrips[i], !isExcluded);
        }
    },
    DeleteSelectedStrip: function (id, isExclude) {
        var index;
        var stripsType;
        if (isExclude) {
            index = StripsGridController.excludedStripIds.indexOf(id);
            StripsGridController.excludedStripIds.splice(index, 1);
            stripsType = "excluded";
        } else {
            index = StripsGridController.includedStripIds.indexOf(id);
            StripsGridController.includedStripIds.splice(index, 1);
            stripsType = "included";
        }

        $('tr[data-id="strip-' + stripsType + '-row-' + id + '"]').remove();
        $('[data-id="strip-' + stripsType + '-' + id + '"]').remove();

        // Reindexing form elements to eliminate missing elements on server side (if elements are ordered: 1,3,7, etc)
        // TODO: if possible, remove reindexing
        // TODO: or try to reindex only from the deleted index (check correspondence between markup and array elements order after inserting/deleting)
        var stripInputId = isExclude ? "Filters_ExcludedStrips_Strips_" : "Filters_IncludedStrips_Strips_";
        var stripInputName = isExclude ? "Filters.ExcludedStrips.Strips" : "Filters.IncludedStrips.Strips";
        var selectedStrips = isExclude ? StripsGridController.excludedStripIds : StripsGridController.includedStripIds;
        for (var i = 0; i < selectedStrips.length; i++) {
            var iStripElements = Array.from(document.querySelectorAll('input[type=hidden][data-id=strip-' + stripsType + '-' + selectedStrips[i] + ']'));
            for (var j = 0; j < iStripElements.length; j++) {
                var postfix = iStripElements[j].getAttribute('id').substring(iStripElements[j].getAttribute('id').lastIndexOf('_') + 1);
                iStripElements[j].setAttribute('id', stripInputId + i + '_' + postfix);
                iStripElements[j].setAttribute('name', stripInputName + '[' + i + '].' + postfix);
            }
        }

        var cntElement = document.getElementById('selected' + (isExclude ? 'ExcludedStrips' : 'IncludedStrips'))
        cntElement.innerHTML = cntElement.innerHTML - 1;
    }
}

// Miscellaneous Report / Report Template Wizard methods
reportTemplateId_OnSelectedIndexChanged = function (s, e) {
    $.ajax({
        url: getReportTemplateByIdUrl,
        type: 'POST',
        dataType: 'JSON',
        data: { idTxt: startTab.ReportTemplateId.val() },
        beforeSend: function () {
            document.getElementById('nextStep').disabled = true;
        },
        success: function (reportTemplate) {
            if (reportTemplate !== undefined) {
                $('#Params_Name').val(reportTemplate.Name);
                $('#Params_Description').val(reportTemplate.Description);
                $('#Params_SelectedType').prop('selectedIndex', reportTemplate.Type);

                selectedType_OnSelectedIndexChanged();
                if ($('#Params_SelectedType').val() === reportTypes.Simple) {
                    $('#Params_SelectedDataType').val(reportTemplate.DataTypeText);
                } else {
                    $('#Params_SelectedDataTypeDiff').val(reportTemplate.DataTypeText);
                }
                selectedDataType_OnSelectedIndexChanged();


                if (startTab.WizardMode.val() === WIZARD_MODE_Report)
                    $('#Params_SelectedDataSelectionMode').val(reportTemplate.DataSelectionModeText !== ''
                        ? reportTemplate.DataSelectionModeText
                        : dataSelectionModes.ByTargets);
                else {
                    $('#Params_ReportTemplateName').val(reportTemplate.ReportTemplateName);
                    
                    $('input:radio[name="Params.HostsSelectionMode"][value="' 
                        + (reportTemplate.HostsSelectionModeText !== '' 
                            ? reportTemplate.HostsSelectionModeText 
                            : reportTemplateHostsSelectionModes.Selected)
                        + '"]').prop('checked', true);
                    
                    $('input:radio[name="Params.ScansSelectionMode"][value="' 
                        + (reportTemplate.ScansSelectionModeText !== '' 
                            ? reportTemplate.ScansSelectionModeText 
                            : reportTemplateScansSelectionModes.LastScanOnly)
                        + '"]').prop('checked', true);
                    
                    if (reportTemplate.FromDaysAgo !== null)
                        $('#Params_FromDaysAgo').val(reportTemplate.FromDaysAgo);
                    
                    scansSelectionMode_OnSelectedValueChanged();
                }
            }
        },
        complete: function () {
            document.getElementById('nextStep').disabled = false;
        },
    });
}

selectedType_OnSelectedIndexChanged = function () {
    $('#Params_SelectedDataType').toggleClass('hide', $('#Params_SelectedType').val() !== reportTypes.Simple);
    $('#Params_SelectedDataTypeDiff').toggleClass('hide', $('#Params_SelectedType').val() !== reportTypes.Differentiated);
    $('#Params_SelectedDataSelectionMode').prop('disabled', $('#Params_SelectedType').val() === reportTypes.Differentiated);

    if ($('#Params_SelectedType').val() === reportTypes.Differentiated)
        $("#Params_SelectedDataSelectionMode").prop("selectedIndex", 0);

    clearNextSteps(startTab.data('step-name'));
};

selectedDataType_OnSelectedIndexChanged = function (s, e) {
    clearNextSteps(startTab.data('step-name'));

    if ($("#Params_SelectedDataSelectionMode").length === 0)
        return;
    
    $("#Params_SelectedDataSelectionMode").find('option').remove();
    $("#Params_SelectedDataSelectionMode").append('<option value="' + startTab.selectionModes[0].value + '" selected>' + startTab.selectionModes[0].text + '</option>');

    if ($('#Params_SelectedDataType').val() === reportDataTypesSimple.ComplianceIndexAnalytical || $('#Params_SelectedDataType').val() === reportDataTypesSimple.HostDiscovery)
        return;

    $("#Params_SelectedDataSelectionMode").append('<option value="' + startTab.selectionModes[1].value + '">' + startTab.selectionModes[1].text + '</option>');
    $("#Params_SelectedDataSelectionMode").append('<option value="' + startTab.selectionModes[2].value + '">' + startTab.selectionModes[2].text + '</option>');
}

selectedDataSelectionMode_OnSelectedIndexChanged = function (s, e) {
    clearNextSteps(startTab.data('step-name'));
}

hostsSelectionMode_OnSelectedValueChanged = function() {
    clearNextSteps(startTab.data('step-name'));
}

scansSelectionMode_OnSelectedValueChanged = function () {
    $('#FromDaysAgoContainer').toggleClass('hide', $('input:radio[name="Params.ScansSelectionMode"]:checked').val() === reportTemplateScansSelectionModes.LastScanOnly);
    clearNextSteps(startTab.data('step-name'));
}

fromDaysAgo_OnValueChanged = function() {
    clearNextSteps(startTab.data('step-name'));
}

function checkReportName() {
    const currentName = document.getElementById('Params_Name').value.trim();
    if (currentName !== '') {
        restRequestWithParams(checkReportNametUrl(currentName), viewNewReportName);
    } else {
        document.getElementById('Params_Name').value = currentName;
    }
}

function viewNewReportName(data) {
    const parsedData = JSON.parse(data);
    const oldName = document.getElementById('Params_Name').value.trim();
    if (parsedData.reportName !== oldName) {
        document.getElementById('reportNewNameInfoBlock').classList.remove('hide');
        document.getElementById('reportNewNameMessage').innerText = newReportNameMessage(oldName, parsedData.reportName);
        document.getElementById('Params_Name').value = parsedData.reportName;
    } else {
        document.getElementById('reportNewNameInfoBlock').classList.add('margin-top-50');
        document.getElementById('reportNewNameInfoBlock').classList.add('hide');
        document.getElementById('Params_Name').value = oldName;
    }
}

function checkReportTemplateName() {
    const currentName = document.getElementById('Params_ReportTemplateName').value.trim();
    if (currentName !== '') {
        restRequestWithParams(checkReportTemplateNametUrl(currentName), viewNewReportTemplateName);
    } else {
        document.getElementById('Params_ReportTemplateName').value = currentName;
    }
}

function viewNewReportTemplateName(data) {
    const parsedData = JSON.parse(data);
    const oldName = document.getElementById('Params_ReportTemplateName').value.trim();
    if (parsedData.reportTemplateName !== oldName) {
        document.getElementById('reportNewNameInfoBlock').classList.remove('hide');
        document.getElementById('reportNewNameMessage').innerText = newReportTemplateNameMessage(oldName, parsedData.reportTemplateName);
        document.getElementById('Params_ReportTemplateName').value = parsedData.reportTemplateName;
    } else {
        document.getElementById('reportNewNameInfoBlock').classList.remove('margin-top-50');
        document.getElementById('reportNewNameInfoBlock').classList.add('hide');
        document.getElementById('Params_ReportTemplateName').value = oldName;
    }
}