﻿$(document).ready(function () {
    updateBlockForNmapPaths();
    isSetUseMailChecked();
    isSetUseMailAuthChecked();
    isSetProxy();
    isSetUseProxyAuth();
    onChangeProxyServer(document.getElementById('Common_ProxyType_Value'));

    $('#form-settings').on('submit', function(e){
        if (typeof onBeforeSubmitCleanup === 'function')
            onBeforeSubmitCleanup($(this));
        onBeforeSubmitLogging($(this));
    });
});

var firstInitFlags = {
    isSetEmailDeliveryPass: {},
    isSetProxyPassword: {}
}

function updateBlockForNmapPaths() {
    if ($('#Scan_UseNmapDictionaries_Value').prop('checked') === true) 
        document.getElementById('nmapPahLinux').classList.add('disableContent');
    
    if ($('#Scan_UseNmapDictionaries_Value').prop('checked') === false)
        document.getElementById('nmapPahLinux').classList.remove('disableContent');
    
}

function isSetMapPathChecked() {
    updateBlockForNmapPaths();

    if ($('#Scan_UseNmapDictionaries_Value').prop('checked') === true) {
        document.getElementById('Scan_BruteforceUserNamesFilePath_Value').value = '/var/opt/altxmap/nselib/data/usernames.lst';
        document.getElementById('Scan_BruteforcePasswordsFilePath_Value').value = '/var/opt/altxmap/nselib/data/passwords.lst';

        document.getElementById('nmapPahLinux').classList.add('disableContent');
    }
}

function isSetUseMailChecked() {
    if ($('#Delivery_UseEmailDelivery_Value').prop('checked') === true)
        document.getElementById('delivery').classList.remove('disableContent');
    else
        document.getElementById('delivery').classList.add('disableContent');
}

function isSetUseMailAuthChecked() {
    if ($('#Delivery_UseEmailAuth_Value').prop('checked') === true)
        document.getElementById('deliveryEmailAuth').classList.remove('disableContent');
    else
        document.getElementById('deliveryEmailAuth').classList.add('disableContent');
}

function isSetCleanupTnaScanResults() {
    if ($('#Cleanup_DeleteTnaScanResults').prop('checked') === true)
        document.getElementById('Cleanup_DeleteTnaScanResults_Params').classList.remove('hide');
    else
        document.getElementById('Cleanup_DeleteTnaScanResults_Params').classList.add('hide');
}

function isSetCleanupErrorScanResults() {
    if ($('#Cleanup_DeleteErrorScanResults').prop('checked') === true)
        document.getElementById('Cleanup_DeleteErrorScanResults_Params').classList.remove('hide');
    else
        document.getElementById('Cleanup_DeleteErrorScanResults_Params').classList.add('hide');
}

function isSetCleanupCompleteScanResults() {
    if ($('#Cleanup_DeleteCompleteScanResults').prop('checked') === true)
        document.getElementById('Cleanup_DeleteCompleteScanResults_Params').classList.remove('hide');
    else
        document.getElementById('Cleanup_DeleteCompleteScanResults_Params').classList.add('hide');
}

function isSetCleanupTnaOlderThanDays() {
    if ($('#Cleanup_IsDeleteOlderThanDaysTnaScanResultsEnabled').prop('checked') === true)
        document.getElementById('Cleanup_TnaScanResultsOlderThanDays').classList.remove('disableContent');
    else
        document.getElementById('Cleanup_TnaScanResultsOlderThanDays').classList.add('disableContent');
}

function isSetCleanupErrorOlderThanDays() {
    if ($('#Cleanup_IsDeleteOlderThanDaysErrorScanResultsEnabled').prop('checked') === true)
        document.getElementById('Cleanup_ErrorScanResultsOlderThanDays').classList.remove('disableContent');
    else
        document.getElementById('Cleanup_ErrorScanResultsOlderThanDays').classList.add('disableContent');
}

function isSetCleanupCompleteOlderThanDays() {
    if ($('#Cleanup_IsDeleteOlderThanDaysCompleteScanResultsEnabled').prop('checked') === true)
        document.getElementById('Cleanup_CompleteScanResultsOlderThanDays').classList.remove('disableContent');
    else
        document.getElementById('Cleanup_CompleteScanResultsOlderThanDays').classList.add('disableContent');
}

function isSetCleanupReportsOlderThanDays() {
    if ($('#Cleanup_DeleteReports').prop('checked') === true)
        document.getElementById('Cleanup_ReportsOlderThanDays').classList.remove('disableContent');
    else
        document.getElementById('Cleanup_ReportsOlderThanDays').classList.add('disableContent');
}

function isSetCleanupSchedule() {
    if ($('#Cleanup_IsScheduleEnabled').prop('checked') === true)
        document.getElementById('Cleanup_IsScheduleEnabled_Params').classList.remove('disableContent');
    else
        document.getElementById('Cleanup_IsScheduleEnabled_Params').classList.add('disableContent');
}

function isSetCleanupNotify() {
    if ($('#Cleanup_IsNotifyOnDbSizeExcessEnabled').prop('checked') === true) {
        document.getElementById('Cleanup_IsNotifyOnDbSizeExcessEnabled_Params').classList.remove('disableContent');
        document.getElementById('Cleanup_IsNotifyOnDbSizeExcessEnabled_Recipients').classList.remove('disableContent');
    }
    else {
        document.getElementById('Cleanup_IsNotifyOnDbSizeExcessEnabled_Params').classList.add('disableContent');
        document.getElementById('Cleanup_IsNotifyOnDbSizeExcessEnabled_Recipients').classList.add('disableContent');
    }
}

function onChangeProxyServer(s, e) {
    var currentValue = $(s).val();
    if (currentValue === "None") {
        document.getElementById('dontUseProxyInScanService').classList.add('disableContent');
    } else {
        document.getElementById('dontUseProxyInScanService').classList.remove('disableContent');
    }
    if (currentValue === "Http") {
        document.getElementById('http').classList.remove('disableContent');
        document.getElementById('userProxyAuthCheck').classList.remove('disableContent');
        isSetUseProxyAuth();
    }
    else {
        document.getElementById('http').classList.add('disableContent');
        document.getElementById('userProxyAuthCheck').classList.add('disableContent');
        document.getElementById('proxy').classList.add('disableContent');
    }
}

function isSetProxy() {
    if ($('#Common_ProxyType_Value').val() === "Http") {
        document.getElementById('http').classList.remove('disableContent');
        document.getElementById('userProxyAuthCheck').classList.remove('disableContent');
    }
    else {
        document.getElementById('http').classList.add('disableContent');
        document.getElementById('userProxyAuthCheck').classList.add('disableContent');
        document.getElementById('proxy').classList.add('disableContent');
    }
}

function isSetUseProxyAuth() {
    if ($('#Common_UseProxyAuth_Value').prop('checked') === true)
        document.getElementById('proxy').classList.remove('disableContent');
    else
        document.getElementById('proxy').classList.add('disableContent');
}

function isEmptyOrSpaces(str) {
    return str === null || str.match(/^ *$/) !== null;
}

function isInCorrectBounds(str, min, max) {
    var parsed = parseInt(str, 10);
    if (isNaN(parsed))
        return false;
    if (parsed < min || parsed > max)
        return false;
    return true;
}

function isCorrectPort(str) {
    return isInCorrectBounds(str, 1, 65535);
}

function validPathField(field) {
    return field.disabled || !isEmptyOrSpaces(field.value);
}

function validateSettings() {

    // Common

    var dbDataSource = document.getElementById('Common_DbDataSource_Value').value;
    var dbInitialCatalog = document.getElementById('Common_DbInitialCatalog_Value').value;

    var restUrl = document.getElementById('Common_RESTUrl_Value').value;
    var restPort = document.getElementById('Common_RESTPort_Value').value;

    var sessionTimeout = document.getElementById('Common_SessionTimeout_Value').value;

    if (isEmptyOrSpaces(dbDataSource)) {
        notifyWarning("Настройки доступа к БД: Необходимо указать сервер БД");
        return false;
    }

    if (isEmptyOrSpaces(dbInitialCatalog)) {
        notifyWarning("Настройки доступа к БД: Необходимо указать имя БД");
        return false;
    }

    if (isEmptyOrSpaces(restUrl)) {
        notifyWarning("REST настройки: Необходимо указать адрес REST сервера");
        return false;
    }

    if (!isCorrectPort(restPort)) {
        notifyWarning("REST настройки: Необходимо указать корректный REST порт");
        return false;
    }

    if (isNaN(sessionTimeout) || sessionTimeout < 1) {
        notifyWarning("Настройки клиента: Необходимо указать корректный срок действия клиентской сессии");
        return false;
    }

    // Scan

    var maxConcurrentJobs = document.getElementById('Scan_MaxConcurrentJobs_Value').value;
    var degreeOfParallelism = document.getElementById('Scan_DegreeOfParallelism_Value').value;
    var collectedItemMaxLength = document.getElementById('Scan_CollectedItemMaxLength_Value').value;

    if (!isInCorrectBounds(maxConcurrentJobs, 1, 5)) {
        notifyWarning("Параллельность заданий: Необходимо указать корректное число параллельных заданий");
        return false;
    }

    if (!isInCorrectBounds(degreeOfParallelism, 1, 100)) {
        notifyWarning("Параллельность заданий: Необходимо указать корректное число параллельных сканирований в задании");
        return false;
    }

    if (!isInCorrectBounds(collectedItemMaxLength, 0, 2147483647)) {
        notifyWarning("Максимальная длина фактического значения правил конфигурации: Необходимо указать корректное число символов");
        return false;
    }

    var dataPathLinux = document.getElementById('Scan_WorkingDirPath_Value');

    if (!validPathField(dataPathLinux)) {
        notifyWarning("Пути приложения: Необходимо указать пути к папкам с данными и временными файлами");
        return false;
    }

    var useNmapDicts = document.getElementById('Scan_UseNmapDictionaries_Value').checked;

    var bruteforceUserNamesFilePath = document.getElementById('Scan_BruteforceUserNamesFilePath_Value').value;
    var bruteforcePasswordsFilePath = document.getElementById('Scan_BruteforcePasswordsFilePath_Value').value;

    if (!useNmapDicts && (isEmptyOrSpaces(bruteforceUserNamesFilePath) || isEmptyOrSpaces(bruteforcePasswordsFilePath))) {
        notifyWarning("Компонент ALTXMAP: Необходимо указать пути к словарю логинов и паролей");
        return false;
    }

    // Email

    var useEmailDelivery = document.getElementById('Delivery_UseEmailDelivery_Value').checked;
    var emailSvrAddress = document.getElementById('Delivery_EmailServer_Value').value;
    var emailSvrPort = document.getElementById('Delivery_EmailServerPort_Value').value;

    var useEmailAuth = document.getElementById('Delivery_UseEmailAuth_Value').checked;
    var emailLogin = document.getElementById('Delivery_EmailLogin_Value').value;
    var emailPassword = document.getElementById('Delivery_EmailPassword_Value').value;

    var emailSenderMail = document.getElementById('Delivery_EmailSenderMail_Value').value;
    var emailRecipientMail = document.getElementById('NetworkResourcesGrid');

    if (useEmailDelivery) {
        if (isEmptyOrSpaces(emailSvrAddress)) {
            notifyWarning("Доставка на электронную почту: Необходимо указать адрес сервера исходящих сообщений");
            return false;
        }

        if (!isCorrectPort(emailSvrPort)) {
            notifyWarning("Доставка на электронную почту: Необходимо указать корректный порт");
            return false;
        }

        if (useEmailAuth && isEmptyOrSpaces(emailLogin)) {
            notifyWarning("Доставка на электронную почту: Необходимо указать логин");
            return false;
        }

        if (useEmailAuth && isEmptyOrSpaces(emailPassword) && firstInitFlags.isSetEmailDeliveryPass == false) {
            notifyWarning("Доставка на электронную почту: Необходимо указать пароль");
            return false;
        }

        if (isEmptyOrSpaces(emailSenderMail)) {
            notifyWarning("Доставка на электронную почту: Необходимо указать E-mail отправителя");
            return false;
        }

        if (emailRecipientMail.rows.length === 0) {
            notifyWarning("Доставка на электронную почту: Необходимо указать E-mail получателей");
            return false;
        }
    }

    // Cleanup

    const cleanupDeleteTnaScanResults = document.getElementById('Cleanup_DeleteTnaScanResults');
    const cleanupTnaScanResultsOlderThanDays = document.getElementById('Cleanup_TnaScanResultsOlderThanDays');
    const isDeleteAllTnaScanResultsEnabled = document.getElementById('Cleanup_IsDeleteAllTnaScanResultsEnabled');

    const cleanupDeleteErrorScanResults = document.getElementById('Cleanup_DeleteErrorScanResults');
    const cleanupErrorScanResultsOlderThanDays = document.getElementById('Cleanup_ErrorScanResultsOlderThanDays');
    const isDeleteAllErrorScanResultsEnabled = document.getElementById('Cleanup_IsDeleteAllErrorScanResultsEnabled');

    const cleanupDeleteCompleteScanResults = document.getElementById('Cleanup_DeleteCompleteScanResults');
    const cleanupCompleteScanResultsOlderThanDays = document.getElementById('Cleanup_CompleteScanResultsOlderThanDays');
    const isDeleteAllCompleteScanResultsEnabled = document.getElementById('Cleanup_IsDeleteAllCompleteScanResultsEnabled');

    const cleanupDeleteReports = document.getElementById('Cleanup_DeleteReports');
    const cleanupReportsOlderThanDays = document.getElementById('Cleanup_ReportsOlderThanDays');
    const cleanupIsNotifyOnDbSizeExcessEnabled = document.getElementById('Cleanup_IsNotifyOnDbSizeExcessEnabled');
    const cleanupDbSizeExcessGb = document.getElementById('Cleanup_DbSizeExcessGb');

    if (cleanupDeleteTnaScanResults && cleanupTnaScanResultsOlderThanDays && isDeleteAllTnaScanResultsEnabled) {
        if (cleanupDeleteTnaScanResults.checked && !isDeleteAllTnaScanResultsEnabled.checked && !isInCorrectBounds(cleanupTnaScanResultsOlderThanDays.value, 1, 5000)) {
            notifyWarning("Удалять результаты сканирований со статусом \"Хост недоступен\": Необходимо указать корректное число дней.");
            return false;
        }
    }

    if (cleanupDeleteErrorScanResults && cleanupErrorScanResultsOlderThanDays && isDeleteAllErrorScanResultsEnabled) {
        if (cleanupDeleteErrorScanResults.checked && !isDeleteAllErrorScanResultsEnabled.checked && !isInCorrectBounds(cleanupErrorScanResultsOlderThanDays.value, 1, 5000)) {
            notifyWarning("Удалять результаты сканирований со статусом \"Ошибка\": Необходимо указать корректное число дней.");
            return false;
        }
    }

    if (cleanupDeleteCompleteScanResults && cleanupCompleteScanResultsOlderThanDays && isDeleteAllCompleteScanResultsEnabled) {
        if (cleanupDeleteCompleteScanResults.checked && !isDeleteAllCompleteScanResultsEnabled.checked && !isInCorrectBounds(cleanupCompleteScanResultsOlderThanDays.value, 1, 5000)) {
            notifyWarning("Удалять результаты сканирований со статусом \"Завершено\": Необходимо указать корректное число дней.");
            return false;
        }
    }

    if (cleanupDeleteReports && cleanupReportsOlderThanDays) {
        if (cleanupDeleteReports.checked && !isInCorrectBounds(cleanupReportsOlderThanDays.value, 1, 5000)) {
            notifyWarning("Удалять отчёты: Необходимо указать корректное число дней.");
            return false;
        }
    }

    if (cleanupIsNotifyOnDbSizeExcessEnabled && cleanupDbSizeExcessGb) {
        if (cleanupIsNotifyOnDbSizeExcessEnabled.checked && !isInCorrectBounds(cleanupDbSizeExcessGb.value, 1, 99999)) {
            notifyWarning("Уведомлять при превышении размера БД: Необходимо указать корректный размер БД.");
            return false;
        }
    }

    // Proxy

    var useHttpProxy = document.getElementById('Common_ProxyType_Value').value.toLowerCase() === 'http';
    var proxyAddress = document.getElementById('Common_ProxyAddress_Value').value;
    var proxyPort = document.getElementById('Common_ProxyPort_Value').value;

    var useProxyAuth = document.getElementById('Common_UseProxyAuth_Value').checked;
    var proxyLogin = document.getElementById('Common_ProxyLogin_Value').value;
    var proxyPwd = document.getElementById('Common_ProxyPassword_Value').value;

    if (useHttpProxy) {
        if (isEmptyOrSpaces(proxyAddress)) {
            notifyWarning("Прокси-сервер: Необходимо указать адрес прокси");
            return false;
        }

        if (!isCorrectPort(proxyPort)) {
            notifyWarning("Прокси-сервер: Необходимо указать корректный порт");
            return false;
        }

        if (useProxyAuth) {
            if (isEmptyOrSpaces(proxyLogin)) {
                notifyWarning("Прокси-сервер: Необходимо указать имя пользователя");
                return false;
            }
            if (isEmptyOrSpaces(proxyPwd) && firstInitFlags.isSetProxyPassword == false) {
                notifyWarning("Прокси-сервер: Необходимо указать пароль");
                return false;
            }
        }
    }

    // Sync
    
    if (!checkSyncSettings())
        return false;
    
    // Logging
    if (!checkLoggingSettings())
        return false;

    // System

    const timeoutPerObject = document.getElementById('System_TimeoutPerObject_Value').value;
    
    if (!isInCorrectBounds(timeoutPerObject, 1, 2147483647)) {
        notifyWarning("Настройки SCAP сканирования: Необходимо указать корректный таймаут проверки");
        return false;
    }

    const sshExecutionTimeout = document.getElementById('System_SshExecutionTimeout_Value').value;
    const sshWaitingTimeout = document.getElementById('System_SshWaitingTimeout_Value').value;
    const sshKeepAliveDelay = document.getElementById('System_SshKeepAliveDelay_Value').value;
    const sshKeepAliveInterval = document.getElementById('System_SshKeepAliveInterval_Value').value;
    const shellCommandTimeout = document.getElementById('System_ShellCommandTimeout_Value').value;
    const shellResponseTimeout = document.getElementById('System_ShellResponseTimeout_Value').value;
    const shellWaitingDuration = document.getElementById('System_ShellWaitingDuration_Value').value;
    const terminalColumns = document.getElementById('System_TerminalColumns_Value').value;
    
    if (!isInCorrectBounds(sshExecutionTimeout, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректный таймаут SSH сессии");
        return false;
    }

    if (!isInCorrectBounds(sshWaitingTimeout, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректный таймаут ожидания данных");
        return false;
    }

    if (!isInCorrectBounds(sshKeepAliveDelay, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректное значение задержки отправки keep-alive пакета");
        return false;
    }

    if (!isInCorrectBounds(sshKeepAliveInterval, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректный интервал отправки keep-alive пакета");
        return false;
    }

    if (!isInCorrectBounds(shellCommandTimeout, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректный таймаут shell команды");
        return false;
    }

    if (!isInCorrectBounds(shellResponseTimeout, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректный таймаут shell ответа");
        return false;
    }

    if (!isInCorrectBounds(shellWaitingDuration, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректное значение продолжительности ожидания порции данных");
        return false;
    }

    if (!isInCorrectBounds(terminalColumns, 1, 2147483647)) {
        notifyWarning("Настройки протокола SSH: Необходимо указать корректное количество колонок окна виртуального терминала");
        return false;
    }
    
    return true;
}
