﻿var urlList = new urlConfig();
var currentTimerId = null;

var STORAGE_TASKID = 'taskID';

var syncCm = {
    None: 0,
    CheckUpdates: 1,
    Sync: 2,
    CheckSoftwareUpdates: 3
};

checkSyncServiceExists();

function checkSyncServiceExists() {
    $.ajax({
        url: urlList.getSyncService(),
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        success: function (data) {
            if (data === undefined || data === null || (data !== undefined && data !== null && data.Id === 0)) {
                document.getElementById('syncServiceState').innerText = syncStateListResource.SyncNotFound;
                document.getElementById('syncBlock').classList.remove('hide');
                setNotFoundState();
                return;
            }

            checkAccessSyncService(checkSync, data);
        }
    });
}

function checkAccessSyncService(checkSync, svcObj) {
    $.ajax({
        url: urlList.checkAccessService(),
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        success: function (data) {
            if (data === true) {
                document.getElementById('syncConnectedStatus').setAttribute('data-original-title', syncStateListResource.ServiceConnectSuccess);
                document.getElementById('syncConnectedStatus').src = imageStatus.Green;
                document.getElementById('syncBlock').classList.remove('hide');
                checkSync(svcObj);
            } else {
                document.getElementById('syncConnectedStatus').setAttribute('data-original-title', syncStateListResource.InAccess);
                document.getElementById('syncConnectedStatus').src = imageStatus.Red;
                document.getElementById('syncBlock').classList.add('hide');
            }
        }
    });
}

function checkSync(svcObj) {
    if (isStorageEmpty()) {
        if (!isEmptyString(svcObj.SyncCmd)) {
            updateState(getSyncCmd(svcObj.SyncCmd), svcObj.SyncCmdState, svcObj.SyncResult, svcObj.SyncMessage, true);
        } else setCanNoDetectState();
    } else {
        currentTimerId = setInterval(() => {
            getTask(getValueFromStorage(STORAGE_TASKID));
        }, 2000);
    }
}

function setCanNoDetectState() {
    document.getElementById('imageContentStatus').src = "/img/grey.svg";
    document.getElementById('imageContentStatus').setAttribute('data-original-title', syncContentStatus.CanNotDetect);
    document.getElementById('syncServiceState').innerHTML = syncContentStatus.CanNotDetect;
}

function setNotFoundState() {
    document.getElementById('imageContentStatus').src = "/img/red.svg";
    document.getElementById('imageContentStatus').setAttribute('data-original-title', syncContentStatus.CanNotDetect);
    document.getElementById('syncServiceState').classList.add('text-danger');
}

function sendCmd(cmd, param) {
    $.ajax({
        url: urlList.sendCmd(cmd, param),
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        success: function (data) {
            if (data !== undefined && data !== null) {
                saveToStorage(STORAGE_TASKID, data.Id);
                currentTimerId = setInterval(() => {
                    getTask(getValueFromStorage(STORAGE_TASKID));
                }, 2000);
            }
        }
    });
}

function getTask(id) {
    $.ajax({
        url: urlList.getTask(id),
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        success: function (data) {
            if (data !== undefined && data !== null) {
                if (data.ServiceIsAlive === false && data.SyncCmdState === 1) { //InProgress
                    stopTimer();
                    return;
                }

                updateState(data.SyncCmd, data.SyncCmdState, data.SyncResult, data.SyncMessage, false);
            } else {
                clearTimer();
            }
        },
        error: function (data) {
            clearTimer();
        }
    });
}

function updateState(syncCmd, syncCmdState, syncResult, syncMessage, isCheck) {
    var srcImage = null;
    var cmd;

    //Queued or InProgress
    if (syncCmdState === 0 || syncCmdState === 1) {
        document.getElementById('cmd-link-id-sync').classList.add('hide');
    }

    switch (syncCmd) {
        //None
        case 0:
            srcImage = imageStatus.Process;
            document.getElementById('syncServiceState').innerHTML = '';
            break;
        //CheckUpdates
        case 1:
            switch (syncCmdState) {
                //Queued
                case 0:
                    srcImage = imageStatus.Process;
                    if (isEmptyString(syncMessage))
                        document.getElementById('syncServiceState').innerHTML = syncStateListResource.CheckUpdates + '...';
                    else document.getElementById('syncServiceState').innerHTML = syncMessage;
                    break;
                //InProgress
                case 1:
                    srcImage = imageStatus.Process;
                    document.getElementById('syncServiceState').innerHTML = syncMessage;
                    break;
                //Completed
                case 2:
                    if (!isCheck) {
                        clearTimer();

                        if (syncResult === 3) {
                            notifyWarning('Ошибка проверки обновлений контента');
                        } else {
                            notifySuccess('Проверка обновлений выполнена');
                        }
                    }
                    if (syncResult === 1) {
                        srcImage = imageStatus.Yellow;
                    } else if (syncResult === 3) {
                        srcImage = imageStatus.Red;
                    } else {
                        srcImage = imageStatus.Green;
                    }

                    document.getElementById('syncServiceState').innerHTML = syncMessage;
                    setTitleForStatus(syncMessage);
                    document.getElementById('cmd-link-id-sync').classList.remove('hide');
                    break;
            }
            break;
        //Sync
        case 2:
            switch (syncCmdState) {
                //Queued
                case 0:
                    srcImage = imageStatus.Process;
                    if (isEmptyString(syncMessage))
                        document.getElementById('syncServiceState').innerHTML = syncStateListResource.Sync;
                    else document.getElementById('syncServiceState').innerHTML = syncMessage;
                    break;
                //InProgress
                case 1:
                    srcImage = imageStatus.Process;
                    document.getElementById('syncServiceState').innerHTML = syncMessage;
                    break;
                //Completed
                case 2:
                    if (!isCheck) {
                        clearTimer();

                        $.when($.post(urlList.invalidateLicenseCache()))
                            .then(function () {
                                $.get(urlList.refreshLicenseStatusBar(), function (data) {
                                    $('#licenseStatusBar').html(data);
                                });
                                $.get(urlList.refreshHeaderNavigationPartial(), function (data) {
                                    $('#headerNavigationPartial').html(data);
                                });
                            });

                        if (syncResult === 3) {
                            notifyWarning('Ошибка выполнения синхронизации');
                        } else {
                            notifySuccess('Синхронизация завершена');
                        }
                    }

                    if (syncResult === 3) {
                        srcImage = imageStatus.Red;
                    } else {
                        srcImage = imageStatus.Green;
                    }

                    document.getElementById('syncServiceState').innerHTML = syncMessage;
                    setTitleForStatus(syncMessage);
                    document.getElementById('cmd-link-id-sync').classList.remove('hide');

                    break;
            }
            break;
        //CheckSoftwareUpdates
        case 3:
            switch (syncCmdState) {
                //Queued
                case 0:
                    srcImage = imageStatus.Grey;
                    if (isEmptyString(syncMessage))
                        document.getElementById('syncServiceState').innerHTML = syncStateListResource.CheckSoftwareUpdates;
                    else document.getElementById('syncServiceState').innerHTML = syncMessage;
                    break;
                //InProgress
                case 1:
                    srcImage = imageStatus.Process;
                    document.getElementById('syncServiceState').innerHTML = syncMessage;
                    break;
                //Completed
                case 2:
                    if (!isCheck) {
                        clearTimer();
                    }
                    if (syncResult === 1) {
                        document.getElementById('syncServiceState').innerHTML = syncStateListResource.SoftwareUpdateAvailable;
                    } else document.getElementById('syncServiceState').innerHTML = syncMessage;
                    break;
            }
            break;
    }

    if (srcImage !== null) {
        document.getElementById('imageContentStatus').src = srcImage;
    }
}

function setTitleForStatus(message) {
    document.getElementById('imageContentStatus').setAttribute('data-original-title', message);

}

function stopTimer() {
    clearTimeout(currentTimerId);
    currentTimerId = null;
}

function clearTimer() {
    saveToStorage(STORAGE_TASKID, '');
    clearTimeout(currentTimerId);
    currentTimerId = null;
}

function syncExecute(param) {
    document.getElementById('cmd-link-id-sync').classList.add('hide');
    document.getElementById('imageContentStatus').src = imageStatus.Process;
    document.getElementById('syncServiceState').innerHTML = syncStateListResource.Sync;
    document.getElementById('imageContentStatus').setAttribute('data-original-title', '');
    sendCmd(syncCm.Sync, param);
}

function syncUpdateExecute() {
    document.getElementById('cmd-link-id-sync').classList.add('hide');
    document.getElementById('imageContentStatus').src = imageStatus.Process;
    document.getElementById('syncServiceState').innerHTML = syncStateListResource.CheckUpdates + '...';
    document.getElementById('imageContentStatus').setAttribute('data-original-title', '');
    sendCmd(syncCm.CheckUpdates);
}

function saveToStorage(itemName, itemValue) {
    sessionStorage.setItem(itemName, itemValue);
}

function getValueFromStorage(itemName) {
    return sessionStorage.getItem(itemName);
}

function isStorageEmpty() {
    var taskId = sessionStorage.getItem(STORAGE_TASKID);
    return isEmptyString(taskId);
}

function getSyncCmd(cmd) {
    if (cmd.indexOf('CheckUpdates') !== -1) {
        return 1;
    }
    if (cmd.indexOf('Sync') !== -1) {
        return 2;
    }
    if (cmd.indexOf('CheckSoftwareUpdates') !== -1) {
        return 3;
    }
}

// File Upload Handler
class FileUploadHandler {

    static ALLOWED_MIME_TYPES = ['application/zip', 'application/x-zip-compressed'];
    static UPLOAD_ENDPOINT = urlList.uploadContentZip();
    
    static MAX_FILE_SIZE = 1073741824;   // 1Gb in bytes
    static PROGRESS_RESET_DELAY = 1000;  // 1 sec

    constructor() {
        this.initializeElements();
        this.bindEvents();
    }
    
    initializeElements() {
        this.elements = {
            syncControl: document.getElementById('syncControl'),
            fileInput: document.getElementById('fileInput'),
            uploadButton: document.getElementById('uploadButton'),
            errorContainer: document.getElementById('errorContainer'),
            errorText: document.getElementById('errorText'),
            errorContainerCloseButton: document.getElementById('errorContainerCloseButton'),
            progressContainer: document.getElementById('progressContainer'),
            progressText: document.getElementById('progressText')
        };
    }
    
    bindEvents() {
        this.elements.uploadButton.addEventListener('click', () => this.elements.fileInput.click());
        this.elements.fileInput.addEventListener('change', () => this.handleFileSelection());
        this.elements.errorContainerCloseButton.addEventListener('click', () => this.showSyncControl());
    }

    hideSyncControl() {
        this.elements.syncControl.classList.add('hide');
    }

    showSyncControl() {
        this.hideProgress()
        this.elements.errorContainer.classList.add('hide');
        this.elements.errorText.textContent = '';
        this.elements.syncControl.classList.remove('hide');
    }

    hideProgress() {
        this.elements.progressContainer.classList.add('hide');
        this.elements.progressText.textContent = 'Загрузка контента 0%';
    }
    
    showError(message) {
        console.error('Sync content upload error:', message);
        this.elements.errorText.textContent = 'Ошибка загрузки';
        this.elements.errorContainer.classList.remove('hide');
    }
    
    validateFile(file) {
        if (!file) return false;

        if (file.size > FileUploadHandler.MAX_FILE_SIZE) {
            const maxSizeMB = FileUploadHandler.MAX_FILE_SIZE / (1024 * 1024);
            this.showError(`File size exceeds ${maxSizeMB}MB limit`);
            return false;
        }

        if (!FileUploadHandler.ALLOWED_MIME_TYPES.includes(file.type)) {
            this.showError('Only ZIP files are allowed');
            return false;
        }

        return true;
    }
    
    async handleFileSelection() {
        this.hideSyncControl();
        
        const file = this.elements.fileInput.files[0];

        if (!this.validateFile(file)) {
            this.elements.fileInput.value = '';
            return;
        }

        this.elements.progressContainer.classList.remove('hide');

        try {
            const formData = new FormData();
            formData.append('file', file);

            const response = await this.uploadWithProgress(formData);

            if (response.ok) {
                this.handleSuccessfulUpload();
            }
        } catch (error) {
            this.handleFailedUpload(error);
        }
        finally {
            this.elements.fileInput.value = '';
        }
    }
    
    handleSuccessfulUpload() {
        this.elements.progressText.textContent = 'Загрузка завершена';
        setTimeout(() => {
            this.hideProgress()
            this.showSyncControl();
            syncExecute();
        }, FileUploadHandler.PROGRESS_RESET_DELAY);
    }
    
    handleFailedUpload(error) {
        this.hideProgress();
        this.showError(error.message);
    }
    
    uploadWithProgress(formData) {
        return new Promise((resolve, reject) => {
            const xhr = new XMLHttpRequest();

            xhr.upload.addEventListener('progress', this.updateProgress.bind(this));

            xhr.addEventListener('load', () => {
                if (xhr.status >= 400) {
                    reject(new Error(`Server error ${xhr.status} (${xhr.statusText})`));
                    return;
                }
                resolve(new Response(xhr.response, {
                    status: xhr.status,
                    statusText: xhr.statusText
                }));
            });

            // Handle network-level errors
            xhr.addEventListener('error', () => {
                reject(new Error('Network error'));
            });

            // Handle timeout
            xhr.addEventListener('timeout', () => {
                reject(new Error('Upload timeout'));
            });

            xhr.open('POST', FileUploadHandler.UPLOAD_ENDPOINT);
            xhr.setRequestHeader('RequestVerificationToken', document.getElementById('antiForgeryToken').value);
            
            xhr.send(formData);
        });
    }
    
    updateProgress(event) {
        if (event.lengthComputable) {
            const percentComplete = Math.round((event.loaded / event.total) * 100);
            this.elements.progressText.textContent = `Загрузка контента ${percentComplete}%`;
        }
    }
}