#!/bin/bash
#set -o nounset

if [ $EUID -ne 0 ]; then
  echo -e "The script must be run as root user"
  exit 1
fi

cn=`echo $'\n.'`
cn=${cn%.}

# Regular Colors
Red=$'\033[0;31m'		# Red
Green=$'\033[0;32m'		# Green
Yellow=$'\033[0;33m'		# Yellow
Color_Off=$'\033[0m'		# Text Reset

#Include components
REDCHECK_COMMON="redcheck-common"
REDCHECK_API="redcheck-api"
REDCHECK_CLIENT="redcheck-client"
REDCHECK_SCAN_SERVICE="redcheck-scan-service"
REDCHECK_SYNC_SERVICE="redcheck-sync-service"
REDCHECK_CLEANUP_SERVICE="redcheck-cleanup-service"
REDCHECK_REPORTS_SERVICE="redcheck-reports-export-service.service"
CONFIGURE_ACTION="configure"

#Default values
APACHE_SITES_FOLDER="/etc/apache2/sites-available/"
HTTPD_SITES_FOLDER="/etc/httpd/redcheck/"
APACHE_ENABLED_SITES_FOLDER="/etc/apache2/sites-enabled/"
HTTPD_ENABLED_SITES_FOLDER="/etc/httpd/conf.d/"
APACHE_CONF_API_FILE_NAME="${REDCHECK_API}.conf"
APACHE_CONF_API_SSL_FILE_NAME="${REDCHECK_API}-ssl.conf"
APACHE_CONF_CLIENT_FILE_NAME="${REDCHECK_CLIENT}.conf"
APACHE_CONF_CLIENT_SSL_FILE_NAME="${REDCHECK_CLIENT}-ssl.conf"
APACHE_CONF_CLEANUP_FILE_NAME="${REDCHECK_CLEANUP_SERVICE}.conf"
APACHE_CONF_CLEANUP_SSL_FILE_NAME="${REDCHECK_CLEANUP_SERVICE}-ssl.conf"
API_CRT_FILE="${REDCHECK_API}.crt"
API_KEY_FILE="${REDCHECK_API}.key"
API_CONF_FILE_NAME="appsettings.json"
CLIENT_CRT_FILE="${REDCHECK_CLIENT}.crt"
CLIENT_KEY_FILE="${REDCHECK_CLIENT}.key"
CLEANUP_CRT_FILE="${REDCHECK_CLEANUP_SERVICE}.crt"
CLEANUP_KEY_FILE="${REDCHECK_CLEANUP_SERVICE}.key"
REDCHECK_APP_DATA_PATH="/var/opt/"
REDCHECK_LICENSE_DIR_PATH="${REDCHECK_APP_DATA_PATH}${REDCHECK_API}/license/"
REDCHECK_COMMON_SSL_CONF="${REDCHECK_APP_DATA_PATH}${REDCHECK_COMMON}/ssl/openssl.cnf"
CONF_FOLDER_NAME="conf"
APPSETTINGS_FILE_NAME="appsettings.json"
REDCHECK_API_APPSETTINGS_PATH="${REDCHECK_APP_DATA_PATH}${REDCHECK_API}/${CONF_FOLDER_NAME}/${APPSETTINGS_FILE_NAME}"
REDCHECK_CLIENT_APPSETTINGS_PATH="${REDCHECK_APP_DATA_PATH}${REDCHECK_CLIENT}/${CONF_FOLDER_NAME}/${APPSETTINGS_FILE_NAME}"
REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH="${REDCHECK_APP_DATA_PATH}${REDCHECK_SCAN_SERVICE}/${CONF_FOLDER_NAME}/${APPSETTINGS_FILE_NAME}"
REDCHECK_SYNC_SERVICE_APPSETTINGS_PATH="${REDCHECK_APP_DATA_PATH}${REDCHECK_SYNC_SERVICE}/${CONF_FOLDER_NAME}/${APPSETTINGS_FILE_NAME}"
BOOTSTRAP_LOG_FILE="${REDCHECK_APP_DATA_PATH}${REDCHECK_COMMON}/log/configuration.log"


# Common
declare -A PARAMETERS=([help]=false [advanced_setup]=false [secret_save]=false [configure]=false)
COMPONENTS=($REDCHECK_API $REDCHECK_CLIENT $REDCHECK_SCAN_SERVICE $REDCHECK_SYNC_SERVICE $REDCHECK_CLEANUP_SERVICE)
declare -A CONFIGURABLE_COMPONENTS=([$REDCHECK_SCAN_SERVICE]="" [$REDCHECK_SYNC_SERVICE]="")
declare -A COMPONENTS_DESC=([$REDCHECK_API]="Настройка RedCheck-Api" [$REDCHECK_CLIENT]="Настройка RedCheck-Client" [$REDCHECK_SCAN_SERVICE]="Настройка RedCheck-Scan-Service" [$REDCHECK_SYNC_SERVICE]="Настройка RedCheck-Sync-Service" [$REDCHECK_CLEANUP_SERVICE]="Настройка RedCheck-Cleanup-Service")
declare -A COMPONENTS_ACTION=([$REDCHECK_API]=config_module_api [$REDCHECK_CLIENT]=config_module_client [$REDCHECK_SCAN_SERVICE]=config_module_scan [$REDCHECK_SYNC_SERVICE]=config_module_sync [$REDCHECK_CLEANUP_SERVICE]=config_module_cleanup)
display_menu_bottom=("Активация лицензии" "Выход")
actions_menu_bottom=(license_activation close_config)
declare -A DEFAULT_PORTS=([default_${REDCHECK_API}_port]="8081" [default_${REDCHECK_API}_ssl_port]="445" [default_${REDCHECK_CLIENT}_port]="8080" [default_${REDCHECK_CLIENT}_ssl_port]="444" [default_${REDCHECK_CLEANUP_SERVICE}_ssl_port]="446" [default_${REDCHECK_CLEANUP_SERVICE}_port]="8741" [default_sql_port]="5432")
declare -A PROTOCOLS=([http]="http" [https]="https")
declare -A CERT_BASED=([ip]="ip" [dns]="dns")
declare -A INSTALLED=([$REDCHECK_COMMON]=false [$REDCHECK_API]=false [$REDCHECK_CLIENT]=false [$REDCHECK_SCAN_SERVICE]=false [$REDCHECK_SYNC_SERVICE]=false [$REDCHECK_REPORTS_SERVICE]=false [$REDCHECK_CLEANUP_SERVICE]=false)
declare -A PLATFORMS=([RedHat]=false [Debian]=false)
declare -A OS_NAME=([Sber]=false [RED]=false [Astra]=false [Debian]=false)
declare -A CONFIGURED=([sql]=false [license]=false [$REDCHECK_API]=false [$REDCHECK_CLIENT]=false [$REDCHECK_SCAN_SERVICE]=false [$REDCHECK_SYNC_SERVICE]=false [$REDCHECK_CLEANUP_SERVICE]=false )
declare -A ANSWERS=([choise]="" [db_custom_cs]="" [db_sslroot_crt]="" [db_sslclient_crt]="" [db_sslclient_key]="" [db_host]="" [db_port]="" [db_user]="" [db_password]="" [db_database]="" [db_use_default_schema]=true [db_schema]="" [db_use_default_tablespace]=true [db_tablespace]="" [sckd]="" [${REDCHECK_API}-port]="" [${REDCHECK_API}-url]="" [${REDCHECK_API}-ip]="" [${REDCHECK_API}-protocol]="" [rc-admin-login]="" [rc-admin-password]="" [ssl_state]="Moscow" [ssl_city]="Korolev" [ssl_org]="AO ALTX-SOFT" [ssl_dep]="" [ssl_host_type]="" [${REDCHECK_CLIENT}-url]="" [${REDCHECK_CLIENT}-port]="" [${REDCHECK_CLIENT}-protocol]="" [svc_name]="" [${REDCHECK_CLEANUP_SERVICE}-url]="" [${REDCHECK_CLEANUP_SERVICE}-port]="" [${REDCHECK_CLEANUP_SERVICE}-protocol]="")

script_version="v2.0.19"
Welcome="Добро пожаловать в мастер конфигурации RedCheck"
stage_title="Настройка"
common_repeat_enter_params="Повторить ввод? [Y/N]"
expected_answer_yn=${Yellow}"Ожидаемый ответ Y или N"${Color_Off}
empty_answer_error_without_question_msg=${Yellow}"Значение не может быть пустым"${Color_Off}
invalid_value_question_msg=${Yellow}"Введеное значение не прошло проверку фильтра"${Color_Off}
stage_verifying_db="Проверка БД на соответствие требованиям для установки службы"
selected="Выбран"
selected_param="Выбран параметр"
actions="действия"
available_str="Доступные"
eths="интерфейсы"
protocols="протоколы"
pass="Пароль"
# Variables for license block
license_stage_title="Проверка лицензии/активация продукта"
license_stage_enter_key="Введите ключ лицензии: "
license_stage_success_msg="Проверка лицензии прошла успешно"
license_stage_file_check_failure_msg="Произошла ошибка активации лицензии:"
license_stage_key_invalid_format="Неверный формат ключа"
license_stage_file_exists=${Green}"Указанный файл существует"${Color_Off}
license_stage_file_doesnot_exist=${Red}"Не удалось найти файл по указанному пути"${Color_Off}
# Variables for database block
db_stage_title="подключения к БД"
db_stage_sckd_warning=${Yellow}"Внимание! В случае использования пользовательского ключа шифрования - сохраните его и используйте при инсталляции и переустановке всех компонентов программы. Утрата или неправильный ввод ключей при переустановке или обновлении компонентов программы на последующие версии при сохранении БД программы приведет к неработоспособности программы и отсутствии возможности использования сохранённых в БД учетных записей. Вы можете не использовать пользовательский ключ шифрования, при этом учетные данные, использованные программой, будут шифроваться, но с меньшим уровнем криптографической стойкости."${Color_Off}
db_add_param_warn=${Yellow}"Внимание! В случае ввода не корректной записи либо не допустимых параметров для строки подключения к БД, мы не гарантируем работоспособность сканера RedCheck. Прежде чем вводить дополнительные параметры, ознакомьтесь с документацией на БД Postgres.."${Color_Off}
db_stage_enter_sckd="Введите пользовательский ключ шифрования"
db_stage_check_connection="Выполняется проверка ${db_stage_title}"
db_stage_connection_established=${Green}"Подключение к БД установлено"${Color_Off}
db_stage_connection_failed_compatible=${Red}"Службе не удалось подключиться к указанной БД"${Color_Off}
db_stage_opening_conn_error_msg=${Red}"Не удалось подключиться к серверу БД с введенными параметрами"${Color_Off}
# Variables for API
is_db_updated=false
need_configure_license=false
web_stage_enter_rest_url="Выберите интерфейс из списка доступных"
web_stage_enter_rest_port="Введите порт"
web_stage_enter_protocol="Выберите протокол взаимодействия"
enter_custom_db_param="Ведите доп параметры для строки подключения к БД"
web_stage_enter_ssl_host_type="Выберите тип генерации сертификата"
web_stage_enter_dns_host_name="Выберите DNS имя "
web_stage_copying_cert_error=${Red}"Произошла ошибка при копировании сертификата"${Color_Off}
web_stage_copying_cert_key_error=${Red}"Произошла ошибка при копировании ключа сертификата"${Color_Off}
web_stage_enter_admin_login="Логин: "
web_stage_clear_existed_certs="Происходит переконфигурация WEB, ранее сгенерированные сертификаты будут удалены из хранилища"
enter_path="Введите путь к файлу"
# Variables for Scan
scan_stage_winrm_configuring_needed_actions="Для конфигурации WinRM необходимо выполнить следующие действия:"
scan_stage_winrm_configuring_check_python_existence="Проверить наличие файла по пути"
scan_stage_winrm_configuring_step_two="В случае отсутствия файла по указанному пути, необходимо найти фактическое место расположения файла."
scan_stage_winrm_configuring_step_three="Заполнить настройку <PythonDll> актуальным путем в конфигурационном файле <${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH}>."
scan_stage_winrm_configuring_warning=${Yellow}"Во время конфигурации WinRM произошла ошибка. Данный функционал не будет работать."${Color_Off}
update_db="Обновление БД"
# Variables for CleanUP
error_execute_comand_mng="ошибка выполнения команды"
interrupt_config="Прервать конфигурирование?"
_is_config_interrupted=false
continue_configuration=true
sync_id=""
need_ask_sckd=false
NEED_ASK_RECONF_SQL=false

check_params(){
local param
local _str=" "
local _all
local _val
  deny_pattern='s/[@!/^/$/:/*/%/&/?]*//'
  arg_param1='s/-//'
  arg_param2='s/=.*//'
  arg_value='s/.*=//'
  parse_param(){
	param=`echo ${_all[1]} | sed $deny_pattern`
	if [[ " ${!CONFIGURABLE_COMPONENTS[@]} " =~ " ${param} " ]];then
		_str="$_str модуля: ${param} с параметрами: "
		module_name=${param}
		shift
		for j in "${_all[@]}"; do
			param=`echo ${j} | sed $arg_param1 | sed $arg_param2`
			value=`echo ${j} | sed $arg_value`
			if [[ " ${!ANSWERS[@]} " =~ " ${param} " ]];then
				if ${PARAMETERS[secret_save]}; then
					_str="${_str} ${param} = ${value}, "
				else
					if [[ ${param} =~ password ]];then
						_str="${_str} ${param} = ********, "
					else
						_str="${_str} ${param} = ${value}, "
					fi
				fi
				ANSWERS[${param}]=${value}
			fi
		done
	fi
  }

  if [ $# -gt 0 ];then
	for i in "$@"; do
	  _all=($(echo "${@}" | tr ' ' '\n'))
	  param=`echo ${i} | sed $deny_pattern`
	  if [[ " ${!PARAMETERS[@]} " =~ " ${param} " ]];then
		print_message "Активирован параметр запуска $i" 2 0
		PARAMETERS[$i]=true
		if ${PARAMETERS[configure]};then
		  if [[ "${_all[0]}" == "${CONFIGURE_ACTION}" ]];then
			if [[ " ${CONFIGURABLE_COMPONENTS[*]} " =~ " ${_all[1]} " ]];then
			  _str="Командный режим конфигурирования"
			  parse_param
			  _val=0
			else
			  _str=" "
			  _val=1
			fi
		  else
			while true;do
			shift
			_all=($(echo "${@}" | tr ' ' '\n'))
			if [[ "${_all[0]}" == "$CONFIGURE_ACTION" ]];then
			  parse_param
			  break
			fi
		  done
		  fi
		  print_message "${_str}" 2 0
		  break
		fi
	  fi
	done
  fi
  return ${_val}
}

print_menu(){
#$1 - массив
#$2 - тип обработки массива:
		#0-отобразить массив из параметра,
		#1-выполнить команду для получения массива,
		#3-отображение меню действий
#$3 - Сообщение
#$4 - Значение по умолчанию (опционально, задает пункт по умолчанию)
local tmp_arr
local skip=false
local count=1
local _config=false
local _module_name
local _url
local _protocol
local _port
local _msg
	unset cur_arr_list
	if [ $2 -eq 0 ]; then
		tmp_arr=($(echo "${1}" | tr ' ' '\n'))
		for i in ${!tmp_arr[@]};do
			cur_arr_list[$count]=${tmp_arr[$i]}
			(( count++ ))
		done
	elif [ $2 -eq 1 ]; then
		tmp_arr=($(${1} | tr ' ' '\n'))
		for i in ${!tmp_arr[@]};do
			cur_arr_list[$count]=${tmp_arr[$i]}
			(( count++ ))
		done
	elif [ $2 -eq 3 ]; then
		for i in ${!display_menu_tmp[@]};do
			cur_arr_list[$count]=${display_menu_tmp[$i]}
			action_menu[$count]=${actions_menu_tmp[$i]}
			(( count++ ))
		done
	fi
	
	(( cur_start_bound=${#cur_arr_list[@]}-${#cur_arr_list[@]}+1 ))
	(( cur_end_bound=${#cur_arr_list[@]} ))
	if [ $cur_start_bound -eq $cur_end_bound ];then
		cur_bounds_list="[$cur_start_bound]"
		defval=$cur_start_bound
	else
		cur_bounds_list="[$cur_start_bound-$cur_end_bound]"
	fi

	print_message "${3}" 0 0
	for i in ${!cur_arr_list[*]};do
		if [ ${#cur_arr_list[*]} -eq 1 ];then
			defval=$i
			skip=true
		fi
		if [ $# -eq 4 ]; then
			if [[ "${cur_arr_list[$i]}" = "${4}" ]]; then
				defval=$i
				skip=true
			else
				if ! $skip; then
					defval=""
				fi
			fi
		fi
		for j in "${!COMPONENTS_DESC[@]}";do
			if [ "${COMPONENTS_DESC[$j]}" = "${cur_arr_list[$i]}" ]; then
				if ${CONFIGURED[$j]}; then
					_config=true
					_module_name=${j}
				fi
			fi
		done
	
		if ${_config}; then
			_protocol=(${_module_name}-protocol)
			_url=(${_module_name}-url)
			_port=(${_module_name}-port)
			if [[ -n "${ANSWERS[${_protocol}]}" && ! -z ${ANSWERS[${_protocol}]} ]];then
				_msg="${Color_Off} - ${ANSWERS[${_protocol}]}://${ANSWERS[${_url}]}:${ANSWERS[${_port}]}"
			else
				_msg=""
			fi
			print_message ${Green}"[$i] : ${cur_arr_list[$i]}${_msg}"${Color_Off} 0 1
			_config=false
		else
			print_message "[$i] : ${cur_arr_list[$i]}" 0 0
		fi
	done
	${cn}
}

check_choise(){
  local input=$1
  local rule=$2
  local _val=1
  local RULES
  declare -A RULES=(
    [range]="^[0-9]+\$"
    [port]="[0-9]\$"
    [string]="^[а-яА-Яa-z0-9A-Z\.\_\/\-]+\$"
    [en_string]="^[a-z0-9A-Z\.\_\/\-]+\$"
    [ip]="^([0-9]{1,3}\.){3}[0-9]{1,3}\$"
    [key]="^[A-F0-9a-f]{8}-[A-F0-9a-f]{4}-[A-F0-9a-f]{4}-[A-F0-9a-f]{4}-[A-F0-9a-f]{12}\$"
    [en_yn]="^[YyNn]+\$"
    [yn]="^[YyДдNnНн]+\$"
    [en_kf]="^[KkFf]+\$"
    [kf]="^[КкKkФфFf]+\$"
    [onoffline]="^[NnFf]+\$"
    [pwd]="^.*\$"
  ) 
  if [[ " ${!RULES[*]} " =~ " ${rule} " ]]; then
    case $rule in
    "range" )
      if [[ ${input} =~ ${RULES[$rule]} && ${input} -ge $cur_start_bound && ${input} -le $cur_end_bound ]]; then
      _val=0
      fi
    ;;
    "port" )
      if [[ ${input} =~ ${RULES[$rule]} && ${input} -gt 0 && ${input} -lt 65536 ]]; then
      _val=0
      fi
    ;;
    "string" )
      if [[ ${input} =~ ${RULES[$rule]} || ${input} =~ ${RULES["en_string"]} ]]; then
         if [[ ${#input} -le 255 ]]; then
           _val=0
         fi
      fi
    ;;
    "en_string" )
      if [[ ${input} =~ ${RULES[$rule]} ]]; then
         if [[ ${#input} -le 255 ]]; then
           _val=0
         fi
      fi
    ;;
    "yn" )
      if [[ ${input} =~ ${RULES[$rule]} || ${input} =~ ${RULES["en_yn"]} ]]; then
       _val=0
      fi
    ;;
    "kf" )
      if [[ ${input} =~ ${RULES[$rule]} || ${input} =~ ${RULES["en_kf"]} ]]; then
       _val=0         
      fi
    ;;
    * )
      if [[ ${input} =~ ${RULES[$rule]} ]]; then
        _val=0
      fi
    ;;
    esac
  fi
  return ${_val}
}

print_block_delimeter(){
  ${cn}
  for i in $(seq 1 $(stty size | cut -d' ' -f2)); do
	  echo -n "="
  done
  ${cn}
}

echo_header(){
  local Color=$1
  local Text=$2
  local type=$3
  local need_trim=$4
  print_message ${Color}"$Text"${Color_Off} ${type} ${need_trim}
  print_block_delimeter
}

echo_footer(){
  local Color=$1
  local Text=$2
  local type=$3
  local need_trim=$4
  print_message ${Color}"$Text"${Color_Off} ${type} ${need_trim}
  print_block_delimeter
}

print_message(){
local text="$1"
local type=$2
local need_trim=$3
# 0 - both, 1 - console, 2 - file

	if [ ! -n "$1" ]; then
		echo -e "(отсутствует переменная)"
	fi
	
	if [[ $type -eq 0 || $type -eq 1 ]]; then
		echo -e "$text"
	fi
	
	if [[ $type -eq 0 || $type -eq 2 ]]; then
		if [ $need_trim -eq 1 ]; then
			text=$(echo "$text" | sed 's/\x1B\[[0-9;]*[JKmsu]//g')
		fi
		echo "[$(date +"%Y-%m-%d %a %H:%M:%S") LOG] $text" >> ${BOOTSTRAP_LOG_FILE}
	fi
}

check_installed(){
  local required_pckg="$1"
  local pckg_installed
  local locale=$(locale | grep LANG | cut -d= -f2 | cut -d_ -f1)
  if ${PLATFORMS[RedHat]}; then
	if [[ "$locale" == "ru" ]]; then
	  pckg_installed=$(rpm -q $required_pckg 2>/dev/null | grep -c "не установлен")
	else
	  pckg_installed=$(rpm -q $required_pckg 2>/dev/null | grep -c "is not installed")
	fi
	pckg_installed=$(( !pckg_installed ))
  elif ${PLATFORMS[Debian]}; then
	pckg_installed=$(dpkg-query -W -f='${Status}' $required_pckg 2>/dev/null | grep -c "ok installed")
  else
	echo "Unknown system type."
	exit 1
  fi
  if [ $pckg_installed -eq 0 ]; then
	pckg_installed=false
  else
	pckg_installed=true
  fi
  INSTALLED[$required_pckg]=$pckg_installed
}

repeat_simple_question(){
local msg=$1
local defval=" (Y)"
local input
  while true; do
	read -e -p "${msg}$defval: " input
	  input=${input:-Y}
	case $input in
	[YyДд]* )
	  return 0
	  break
	;;
	[NnНн]* )
	  return 1
	  break
	;;
	* )
	  print_message "$expected_answer_yn" 0 1
	esac
  done
}

repeat_config(){
local msg=$1
local param=$2
local rule=$3
local no_empty=$4
local defval=$5
local log
local input
local msg_defval
local msg_end
local exit_code
local ret_val=1

while true; do
  if ${PARAMETERS[configure]};then
	ret_val=0
	break
  else
	if [[ $# = 5 && ! -z "${defval}" ]]; then
	  msg_defval=" ($defval)"
	fi

	if [ "$rule" = "range" ];then
	  msg_end="${msg} $cur_bounds_list$msg_defval: "
	else
	  msg_end="${msg}$msg_defval: "
	fi
	
	read -e -p "${msg_end}" input

	if [ $# -eq 5 ]; then
	  input=${input:-$defval}
	fi

	if $no_empty; then
	  if [ ! -z ${input} ]; then
		check_choise $input $rule
		exit_code=$?
	  else
		print_message "$empty_answer_error_without_question_msg" 0 1
		exit_code=1
	  fi
	else
	  exit_code=0
	fi

	if [ $exit_code -eq 0 ]; then
	  if [ "$rule" = "range" ];then
		ANSWERS[${param}]=${cur_arr_list[$input]}
		log="${selected_param} ${param}: ${cur_arr_list[$input]}"
	  else
		 ANSWERS[${param}]=$input
		 log="${selected_param} ${param}: $input"
	  fi
	  print_message "$log" 2 0
	  ret_val=0
	  break
	else
	  print_message "$invalid_value_question_msg" 1 0
	fi
  fi
done
return $ret_val
}

check_no_empty_value(){
local msg=$1
local param=$2
local rule=$3
#local repeat_secret=$4
local input
local retype_input
local parameters="-e -p "
local ret_val=1

  while true; do
	if ${PARAMETERS[configure]};then
	  ret_val=0
	  break
	else
	  if [[ "$rule" = "pwd" ]]; then
		parameters="-s $parameters"
	  fi
	  read ${parameters?} "${msg} " input
	  if [[ ! -z "${input}" ]]; then
	  if check_choise ${input} $rule; then
		ANSWERS[$param]=${input}
		if [[ "$rule" = "pwd" ]]; then
		  print_message "\r" 1 0
			if [[ -z "$4" ]]; then
			  while true; do
				read ${parameters?} "Повторите ввод: " retype_input
				if [[ ! -z "${retype_input}" ]]; then
				  break
				else
				  print_message "$empty_answer_error_without_question_msg" 0 1
				fi
			  done
			  if [ "$input" = "$retype_input" ];then
				print_message "\r" 1 0
				if ${PARAMETERS[secret_save]}; then
				  print_message ${Yellow}"Введенный пароль сохранен в лог файл!"${Color_Off} 1 0
				  print_message "Введенный пароль: ${ANSWERS[$2]}" 2 0
				fi
				print_message "Ввод пароля подтвержден" 2 0
				ret_val=0
				break
			  else
				print_message "\nВвод паролей не совпадает. Повторите ввод" 1 0
			  fi
			else
			  if ${PARAMETERS[secret_save]}; then
			    print_message ${Yellow}"Введенный пароль сохранен в лог файл!"${Color_Off} 1 0
				print_message "$msg ${ANSWERS[$param]}" 2 0
			  else
				print_message "$msg ********" 2 0
			  fi
			  
			  ret_val=0
			  break
			fi
		  else
		    print_message "$msg ${ANSWERS[$param]}" 2 0
			ret_val=0
			break
		  fi
		else
		  print_message "$invalid_value_question_msg" 1 0
		fi
	  else
		print_message "$empty_answer_error_without_question_msg" 1 0
	  fi
	fi
  done
  return $ret_val
}

check_api_configuration(){
  local enabled_sites=""
  local used_conf=""
  local configured_url=""

  enabled_sites=`ls ${sites_available_folder}`
  if [[ $enabled_sites == *${APACHE_CONF_API_SSL_FILE_NAME}* ]]; then
	used_conf="${APACHE_CONF_API_SSL_FILE_NAME}"
  elif [[ $enabled_sites == *${APACHE_CONF_API_FILE_NAME}* ]]; then
	used_conf="${APACHE_CONF_API_FILE_NAME}"
  else
	echo 0
	return
  fi
  if [[ $used_conf != "" ]]; then
	configured_url=`grep -o 'VirtualHost [^:]*' ${sites_available_folder}${used_conf} | sed 's/^.* //'`
	if [[ $configured_url != "*" ]]; then
	  echo 1
	else
	  echo 0
	fi
  fi
}

check_client_configuration(){
  local _val
  local configured_api_url="$(sudo -u redcheck ${REDCHECK_CLIENT} get-api-hostname)"
  if [ $? -eq 0 ]; then		
    print_message "Получено значение 'ApiConnection.Url'=<${configured_api_url}>" 2 0
  else
    print_message "Ошибка при получении параметра 'ApiConnection.Url'=<${configured_api_url}>" 2 0
  fi
  if [[ "$configured_api_url" == "localhost" ]]; then
    _val=1
  else
    _val=0
  fi
  return $_val
}

check_exist_cs(){
local _val
local _module=$1
local configured_api_cs=`grep -o 'PostgreSQL": "[^"]*' "${REDCHECK_APP_DATA_PATH}${_module}/${CONF_FOLDER_NAME}/${API_CONF_FILE_NAME}" | sed 's/PostgreSQL": "//'`
  if [[ "$configured_api_url" == "localhost" ]]; then
	_val=0
  else
	_val=1
  fi
  return $_val
}

get_config_param(){
local _component=$1
local _config_protocol
local config_file_path=""
local cs
	print_message "Определение параметров конфигурации найденного модуля ${_component}" 2 0
	case $_component in
	"$REDCHECK_API"|"$REDCHECK_CLIENT"|"$REDCHECK_CLEANUP_SERVICE" )
		if [ -f $site_enabled_folder${_component}.conf ];then
			_config_protocol="${PROTOCOLS[http]}"
			config_file_path="${sites_available_folder}${_component}.conf"
		elif [ -f $site_enabled_folder${_component}-ssl.conf ];then
			_config_protocol="${PROTOCOLS[https]}"
			config_file_path="${sites_available_folder}${_component}-ssl.conf"
		else
			print_message "транспорт не определен" 2 0
		fi
	
		if [[ "${_config_protocol}" != "" && "$config_file_path" != "" ]]; then
			ANSWERS[${2}]=${_config_protocol}
			ANSWERS[${3}]=`grep -o '<VirtualHost [^:]*' ${config_file_path} | sed 's/^.* //'`
			ANSWERS[${4}]=`grep -o 'Listen [^"]*' ${config_file_path} | sed 's/^.* //'`
			CONFIGURED[${_component}]=true
			return 0
		fi
	;;
	"$REDCHECK_SCAN_SERVICE" )
		if [ -f "$REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH" ];then
			cs=`cat $REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH | grep Default`
			if [ ! -z "${cs}" ];then
				if ! ${CONFIGURED[sql]} ;then
					NEED_ASK_RECONF_SQL=true
					NEED_ASK_RECONF_SCAN_SQL=true
				fi
				CONFIGURED[${_component}]=true
			fi
		fi
	;;
	"$REDCHECK_SYNC_SERVICE" )
		if [ -f "$REDCHECK_SYNC_SERVICE_APPSETTINGS_PATH" ];then
			sync_id=`sed -n 's/.*"ServiceId": "\([^"]*\)",/\1/p' ${REDCHECK_SYNC_SERVICE_APPSETTINGS_PATH}`
			if [ "$sync_id" = "00000000-0000-0000-0000-000000000000" ];then
				sync_id=${machine_id}
			fi
			cs=`cat $REDCHECK_SYNC_SERVICE_APPSETTINGS_PATH | grep Default`
			if [ ! -z "${cs}" ];then
				if ! ${CONFIGURED[sql]} ;then
					NEED_ASK_RECONF_SQL=true
					NEED_ASK_RECONF_SYNC_SQL=true
				fi
				CONFIGURED[${_component}]=true
			fi
		fi
	;;
	esac
}

get_host_name(){
  hostnames=`hostname -a`
  hostnames+=" "
  hostnames+=`hostname -A`
  hostnames+=" "
  hostnames+=`hostname -d`
  hostnames+=" "
  hostnames+=`hostname -f`
  hostnames+=" "
  hostnames+=`hostname -s`
}

config_site_https(){
	local URL=$1
	local PORT=$2
	local SSL_FILE_NAME=$3
	local FILE_NAME=$4
	local CRT_FILE=$5
	local KEY_FILE=$6
	
	sed -i "s|Listen .*|Listen ${PORT}|" "${sites_available_folder}${SSL_FILE_NAME}"
	print_message "В ${sites_available_folder}${SSL_FILE_NAME} новое значение: Listen ${PORT}" 2 0
	sed -i "s|<VirtualHost .*:.*>|<VirtualHost ${URL}:${PORT}>|" "${sites_available_folder}${SSL_FILE_NAME}"
	print_message "В ${sites_available_folder}${SSL_FILE_NAME} новое значение: <VirtualHost ${URL}:${PORT}>" 2 0
	sed -i "s|ServerName .*|ServerName ${URL}|" "${sites_available_folder}${SSL_FILE_NAME}"
	print_message "В ${sites_available_folder}${SSL_FILE_NAME} новое значение: ServerName ${URL}" 2 0
	if ! ${OS_NAME[Astra]}; then
	sed -i "s|AstraMode off|#AstraMode off|" "${sites_available_folder}${SSL_FILE_NAME}"
	fi
	
	if ${PLATFORMS[RedHat]}; then
		sed -i "s|SSLCertificateFile .*|SSLCertificateFile ${ssl_certs_folder}${CRT_FILE}|" "${sites_available_folder}${SSL_FILE_NAME}"
		print_message "В ${sites_available_folder}${SSL_FILE_NAME} новое значение: SSLCertificateFile ${ssl_certs_folder}${CRT_FILE}" 2 0
		sed -i "s|SSLCertificateKeyFile .*|SSLCertificateKeyFile ${ssl_key_folder}${KEY_FILE}|" "${sites_available_folder}${SSL_FILE_NAME}"
		print_message "В ${sites_available_folder}${SSL_FILE_NAME} новое значение: SSLCertificateKeyFile ${ssl_key_folder}${KEY_FILE}" 2 0
	fi
	if [ -f ${site_enabled_folder}${FILE_NAME} ]; then
		rm "${site_enabled_folder}${FILE_NAME}"
	fi
	if [ ! -f ${site_enabled_folder}${SSL_FILE_NAME} ]; then
		ln -s "${sites_available_folder}${SSL_FILE_NAME}" "${site_enabled_folder}${SSL_FILE_NAME}"
	fi
	
}

config_site_http(){
	local URL=$1
	local PORT=$2
	local SSL_FILE_NAME=$3
	local FILE_NAME=$4
	
	sed -i "s|Listen .*|Listen ${PORT}|" "${sites_available_folder}${FILE_NAME}"
	print_message "В ${sites_available_folder}${FILE_NAME} новое значение: Listen ${PORT}" 2 0
	sed -i "s|<VirtualHost .*:.*>|<VirtualHost ${URL}:${PORT}>|" "${sites_available_folder}${FILE_NAME}"
	print_message "В ${sites_available_folder}${FILE_NAME} новое значение: <VirtualHost ${URL}:${PORT}>" 2 0
	if ! ${OS_NAME[Astra]}; then
		sed -i "s|AstraMode off|#AstraMode off|" "${sites_available_folder}${FILE_NAME}"
	fi

	if [ -f ${site_enabled_folder}${SSL_FILE_NAME} ]; then
		rm ${site_enabled_folder}${SSL_FILE_NAME}
	fi
	if [ ! -f ${site_enabled_folder}${FILE_NAME} ]; then
		ln -s ${sites_available_folder}${FILE_NAME} ${site_enabled_folder}${FILE_NAME}
	fi
}

config_tablespace(){
local _config_file=$1
local default=$2

  if $default;then
	print_message "Будeт использовано табличное пространство по умолчанию" 2 0;
	sudo -u redcheck sed -i "s|TableSpace\": \".*\"|TableSpace\": \"''\"|" "${_config_file}"
	print_message "В конфигурационном файле ${_config_file} изменено значение для параметра <TableSpace>. Новое значение: ''" 2 0
  else
	print_message "Будeт использовано пользовательское табличное пространство" 2 0;
	sudo -u redcheck sed -i "s|TableSpace\": \".*\"|TableSpace\": \"${ANSWERS[db_tablespace]}\"|" "${_config_file}"
	print_message "В конфигурационном файле ${_config_file} изменено значение для параметра <TableSpace>. Новое значение: ${ANSWERS[db_tablespace]}" 2 0
  fi
}

config_schema(){
local _config_file=$1
local default=$2

  if $default;then
	sudo -u redcheck sed -i "s|RedCheckSchema\": \".*\"|RedCheckSchema\": \"\"|" "${_config_file}"
	print_message "В конфигурационном файле ${_config_file} установлено значение по умолчанию для параметра <RedCheckSchema>." 2 0
  else
	sudo -u redcheck sed -i "s|RedCheckSchema\": \".*\"|RedCheckSchema\": \"${ANSWERS[db_schema]}\"|" "${_config_file}"
	print_message "В конфигурационном файле ${_config_file} изменено значение для параметра <RedCheckSchema>. Новое значение: ${ANSWERS[db_schema]}" 2 0
  fi
}

config_web_client(){
  local _url=$1
	local update_settings_cmd=$( sudo -u redcheck ${REDCHECK_CLIENT} configure -a "${ANSWERS[redcheck-api-protocol]}://${_url}:${ANSWERS[redcheck-api-port]}")
	if [ $? -eq 0 ]; then		
		print_message "В <${REDCHECK_CLIENT}> новое значение: 'ApiConnection'=${ANSWERS[redcheck-api-protocol]}://${_url}:${ANSWERS[redcheck-api-port]}" 2 0
	else
		print_message "Ошибка <${update_settings_cmd}> при сохранении параметра 'ApiConnection'=${ANSWERS[redcheck-api-protocol]}://${_url}:${ANSWERS[redcheck-api-port]} в файл <${REDCHECK_CLIENT}>" 2 0
	fi
}

config_semanage(){
local port=$1
if ${PLATFORMS[RedHat]}; then
	semanage_output=$(semanage port -a -t http_port_t -p tcp "${port}" 2>&1)
	if [ $? -ne 0 ]; then
		semanage_output=$(semanage port -m -t http_port_t -p tcp "${port}" 2>&1)
	fi
	if [ -n "$semanage_output" ]; then
		print_message "$semanage_output" 2 0
	fi
fi
}

gencert(){
local _MODULE=$1
local _MODE=$2
local _CN=$3
local _val
local _cn_str
local update_ca_output

	print_message "Генерация сертификата.." 0 0
	ANSWERS[ssl_dep]="$_MODULE"

	case $_MODE in
	${CERT_BASED[ip]} )
		if ! grep -q "#DNS\.1 =" "${REDCHECK_COMMON_SSL_CONF}"; then
			sed -i "s/DNS\.1/#&/g" "${REDCHECK_COMMON_SSL_CONF}"
		fi
		sed -i "s/^#\?IP\.1 = .*/IP.1 = ${_CN}/" "${REDCHECK_COMMON_SSL_CONF}"
		_cn_str=${_CN}
		print_message "В ${REDCHECK_COMMON_SSL_CONF} новое значение: IP.1 = ${_CN}" 2 0
	;;
	${CERT_BASED[dns]} )
		if ! grep -q "#IP\.1 =" ${REDCHECK_COMMON_SSL_CONF}; then
			sed -i "s/IP\.1/#&/g" "${REDCHECK_COMMON_SSL_CONF}"
		fi
		sed -i "s/^#\?DNS\.1 = .*/DNS.1 = ${_CN}/" "${REDCHECK_COMMON_SSL_CONF}"
		_cn_str=${_CN}
		print_message "В ${REDCHECK_COMMON_SSL_CONF} новое значение: DNS.1 = ${_CN}" 2 0
		ANSWERS[${_MODULE}_url]=${_CN}
	;;
	esac

	print_message "gencert: /C=RU/ST=${ANSWERS[ssl_state]}/L=${ANSWERS[ssl_city]}/O=${ANSWERS[ssl_org]}/OU=${ANSWERS[ssl_dep]}/CN=${_cn_str}" 2 0
	sudo -u redcheck openssl req -x509 -newkey rsa:4096 -sha256 -utf8 -days 365 -nodes -subj "/C=RU/ST=${ANSWERS[ssl_state]}/L=${ANSWERS[ssl_city]}/O=${ANSWERS[ssl_org]}/OU=${ANSWERS[ssl_dep]}/CN=${_cn_str}" -keyout /var/opt/${_MODULE}/ssl/${_MODULE}.key -out /var/opt/${_MODULE}/ssl/${_MODULE}.crt -extensions v3_ca -extensions v3_req -config ${REDCHECK_COMMON_SSL_CONF} 1>/dev/null 2>&1
	if [ $? -eq 0 ]; then
		_val=0
		cp /var/opt/${_MODULE}/ssl/${_MODULE}.crt ${ssl_certs_folder}
		if [[ $? -ne 0 ]]; then
			print_message "$web_stage_copying_cert_error" 0 1
			break
		fi
		if ${PLATFORMS[RedHat]}; then
			cp /var/opt/${_MODULE}/ssl/${_MODULE}.key ${ssl_key_folder}
			if [[ $? -ne 0 ]]; then
				print_message "$web_stage_copying_cert_key_error" 0 1
			fi
		fi
	else
		print_message ${Red}"Произошла ошибка при генерации сертификата"${Color_Off} 0 1
		_val=2
	fi

	update_ca_output=`$update_ca`
	if [ $? -eq 0 ]; then
		print_message "Хранилище сертификатов обновлено успешно" 2 0
	else
		_val=1
		print_message "$error_execute_comand_mng \'$update_ca_output\'" 2 0
	fi

	if [[ $# = 3 ]]; then
		sed -i "s|DNS.1 = .*|DNS.1 = |" "${REDCHECK_COMMON_SSL_CONF}"
	fi

	if [ $_val -eq 0 ]; then
		print_message ${Green}"Сертификат сформирован"${Color_Off} 0 1
	else
		print_message "Произошла ошибка при обновлении хранилища сертификатов, ошибка: ${_val}" 2 0
	fi
	return $_val
}

print_registered_services(){
  local result=""
  local service_name=""
  IFS=';' read -r -a array <<< "$registered_scanning_services"
  for index in "${!array[@]}"
  do
	if [[ $index != 0 ]]; then
		result="$result "
	fi
	service_name=`echo ${array[index]} | grep -oP 'Name=\K[^,]+'`
	result="$result${service_name}"
  done
  echo $result
}

check_python_path(){
  local configured_path=`grep -o 'PythonDll": "[^"]*' "/var/opt/${REDCHECK_SCAN_SERVICE}/conf/appsettings.json" | sed 's/PythonDll": "//'`
  if [[ "$configured_path" == "" ]]; then
	echo 1
  else
	echo 0
  fi
}

services(){
local _service_action=$1
local _service_name=$2
local systemctl_cmd

  #if ${INSTALLED[${_service_name}]}; then
	systemctl_cmd=`systemctl ${_service_action} ${_service_name}`
	case $_service_action in
	"enable" )
	  if [ $? -eq 0 ]; then
		status="включена.."
	  else
		status="ошибка включения.."
	  fi
	;;
	"start" )
	  if [ $? -eq 0 ]; then
		status="запущена.."
	  else
		status="ошибка запуска.."
	  fi
	;;
	"stop" )
	  if [ $? -eq 0 ]; then
		status="остановлена.."
	  else
		status="ошибка остановки.."
	  fi
	;;
	"restart" )
	  if [ $? -eq 0 ]; then
		status="перезапущена.."
	  else
		status="ошибка перезапуска.."
	  fi
	;;
	esac

	print_message "Служба ${_service_name} $status.." 2 0
  # else
	# print_message "Служба ${_service_name} не установлена, действие \"${_service_action}\" не применено.." 2 0
  # fi
}

get_os_name(){
  local distr_id=`grep ^NAME= /etc/os-release | cut -d'"' -f2`
  if [[ "${distr_id}" == "SberLinux" ]]; then
	OS_NAME[Sber]=true
  elif [[ "${distr_id}" == "RED OS" ]]; then
	OS_NAME[RED]=true
  elif [[ "${distr_id}" == "Astra" || "${distr_id}" == "AstraLinux" || "${distr_id}" == "Astra Linux" ]]; then
	OS_NAME[Astra]=true
  elif [[ "${distr_id}" == "Debian GNU/Linux" ]]; then
	OS_NAME[Debian]=true
  else
	echo -e "Unknown system type."
	return 1
	exit 1
  fi
}

prepare_defval_protocol(){
local _module=$1
	if [ -z "${ANSWERS[${_module}-protocol]}" ]; then
		ANSWERS[${_module}-protocol]="${PROTOCOLS[https]}"
	fi
}

prepare_defval_port(){
local _module=$1
local _protocol=$2
	if [ -z ${ANSWERS[${_module}-port]} ]; then
		if [ "${ANSWERS[${_module}-protocol]}" = "${PROTOCOLS[http]}" ]; then
			defval=${DEFAULT_PORTS[default_${_module}_port]}
		else
			defval=${DEFAULT_PORTS[default_${_module}_ssl_port]}
		fi
	else
		if [ "${_protocol}" = "${ANSWERS[${_module}-protocol]}" ];then
			defval=${ANSWERS[${_module}-port]}
		else
			if [ "${ANSWERS[${_module}-protocol]}" = "${PROTOCOLS[http]}" ]; then
				defval=${DEFAULT_PORTS[default_${_module}_port]}
			else
				defval=${DEFAULT_PORTS[default_${_module}_ssl_port]}
			fi
		fi
	fi
}

find_update_ca(){
local result
local path
  result=`whereis $1`
  path="${result#*: }"
  path="${path%% *}"
  update_ca="$path"
}

config_module_sql(){
local status
CONFIGURED[sql]=false
_is_config_interrupted=false

echo_header $Green "$stage_title $db_stage_title" 1 0
print_message "$stage_title $db_stage_title" 2 0
while ! ${CONFIGURED[sql]} && ! $_is_config_interrupted; do
	check_no_empty_value "Сервер СУБД [IP]:" db_host ip
	repeat_config "$web_stage_enter_rest_port" db_port port true ${DEFAULT_PORTS[default_sql_port]}
	if [ $? -eq 1 ];then
		_is_config_interrupted=true
		break
	fi
	check_no_empty_value "$web_stage_enter_admin_login" db_user string
	check_no_empty_value "$pass:" db_password pwd no_repeat_pwd
	check_no_empty_value "Введите имя БД:" db_database string

	conn_str="Host=${ANSWERS[db_host]};Database=${ANSWERS[db_database]};User ID=${ANSWERS[db_user]};Port=${ANSWERS[db_port]};Password=${ANSWERS[db_password]}"

	if ${PARAMETERS[advanced_setup]};then
		print_message "$db_add_param_warn" 1 0
		repeat_config "$enter_custom_db_param" db_custom_cs string false
		conn_str="${conn_str};${ANSWERS[db_custom_cs]}"
		if ! ${PARAMETERS[configure]};then
			repeat_simple_question "Использовать схему БД по умолчанию? [Y/N]"
			if [ $? -eq 0 ];then
				print_message "Будeт использована схема по умолчанию" 2 0;
			else
				print_message "Будeт использована пользовательская схема" 2 0;
				ANSWERS[db_use_default_schema]=false
				check_no_empty_value "Введите имя схемы: " db_schema string
				repeat_simple_question "Использовать табличное пространство по умолчанию? [Y/N]"
				if [ $? -eq 0 ];then
					print_message "Будeт использовано табличное пространство по умолчанию" 2 0;
					config_tablespace ${REDCHECK_API_APPSETTINGS_PATH} ${ANSWERS[db_use_default_tablespace]}
				else
					ANSWERS[db_use_default_tablespace]=false
					config_tablespace ${REDCHECK_API_APPSETTINGS_PATH} ${ANSWERS[db_use_default_tablespace]}
					check_no_empty_value "Введите имя табличного пространства: " db_tablespace string
				fi
			fi
		fi
	fi

	CONFIGURED[sql]=true
	is_db_updated=false
	break
done

if ${CONFIGURED[sql]} && ! $_is_config_interrupted; then
	status="успешно"
	Color=$Green
	# Если для конфигурации выбрана новая БД, то лицензия в конфигураторе сбрасывается
	CONFIGURED[license]=false
	REDCHECK_LICENSE_DATA=
	global_license_key=	
else
	status="прервана"
	Color=$Yellow
fi

echo_footer $Color "$stage_title $db_stage_title $status" 0 1
}

set_license_data_from_file(){
	local license_file_path=${1:-""}
	local is_update_data=${2:-0}
	local _is_interrupted=false
	
	if [ ! -z "${REDCHECK_LICENSE_DATA}"  ]; then
		if [ $is_update_data -eq 0 ] ; then
			print_message "Файл лицензии уже был прочитан" 2 0
			return 0;
		else
			print_message "Включён режим перезаписи, запрашиваем путь к файлу лицензии" 2 0
		fi
	fi
	while true; do
		if [ -z "$license_file_path" ]; then
			read -e -p "$enter_path лицензии: " license_file_path
			print_message "Введенный путь к файлу с лицензией: $license_file_path" 2 0
		else
			print_message "Выбран путь к файлу с лицензией: $license_file_path" 2 0
		fi
		if [ ! -z "$license_file_path" ]; then
			if [ -f "$license_file_path" ]; then
				local buffer
				print_message "$license_stage_file_exists" 0 1
				buffer=$(<"$license_file_path")
				if [ $? -eq 0 ]; then
					print_message "Файл лицензии прочитан" 2 0
					if [ ! -z "$buffer" ]; then
						REDCHECK_LICENSE_DATA="$buffer"
						return 0;
					else
						print_message ${Red}"Выбран пустой файл лицензии!"${Color_Off} 0 1
						if ! repeat_simple_question "$common_repeat_enter_params"; then return 1; fi
					fi
				else
					print_message "Произошла ошибка при чтении файла лицензии" 2 0						
					if ! repeat_simple_question "$common_repeat_enter_params"; then return 1; fi
				fi
			else
				print_message "$license_stage_file_doesnot_exist" 0 1					
				if ! repeat_simple_question "$common_repeat_enter_params"; then return 1; fi
			fi
		else
			print_message "$empty_answer_error_without_question_msg" 0 1				
			if ! repeat_simple_question "$common_repeat_enter_params"; then return 1; fi
		fi
		license_file_path="";
	done
}

# Стандартная процедура активации лицензии.
# При активации через ключ, данная процедура отвечает за запрос ОНЛАЙН активации по ключу 
# и при её успехе, файл лицензии будет лежать в службе API. 
# Для того что бы этот файл попал в БД нужно запустить процедуру обновления БД
# При активации через файл, происходит запрос файла лицензии у пользователя.
# Содержимое данного файла, в дальнейшем, должно быть передано в процедуру обновления БД, т.к. на стороне API данного файла либо не будет, либо будет лежать старый файл лицензии.
license_activation(){
local status
local license_file_path
local license_key
local exit_code
local api_activate_cmd
#local mkdir_cmd
_is_config_interrupted=false

print_message "license_activation..." 1 0

if [ -n "$global_license_key" ]; then
	license_key=$global_license_key
	global_license_key=""
fi

echo_header $Green "$license_stage_title" 1 0
print_message "$license_stage_title" 2 0

if ${INSTALLED[${REDCHECK_API}]}; then
	while ! ${_is_config_interrupted} && ! ${CONFIGURED[license]}; do
		repeat_config "Выберите тип работы с лицензией - ключ лицензии или файл лицензии? (К/Ф,F)" choise kf true
		case ${ANSWERS[choise]} in
		[КкKk]* )
			if [ -z "$license_key" ]; then
				print_message "$selected способ конфигурации лицензии с помощью ключа" 2 0
				read -e -p "$license_stage_enter_key" license_key
			fi
			print_message "Введенный ключ: $license_key" 2 0
			print_message "Проверка статуса лицензии.." 2 0
			if check_choise $license_key key; then
				api_activate_cmd=`sudo -u redcheck ${REDCHECK_API} activate -k "$license_key"`
				exit_code=$?
				if [ $exit_code -eq 0 ]; then
					print_message "$license_stage_success_msg" 0 1
					global_license_key=$license_key
					CONFIGURED[license]=true
				else
					print_message ${Red}"$license_stage_file_check_failure_msg $api_activate_cmd"${Color_Off} 0 1
					if ! repeat_simple_question "$common_repeat_enter_params"; then _is_config_interrupted=true; break; fi
					license_key=""
				fi
			else
				print_message $Yellow"$license_stage_key_invalid_format"$Color_Off 0 1
				if ! repeat_simple_question "$common_repeat_enter_params"; then _is_config_interrupted=true; break; fi
				license_key=""
			fi
		;;
		[ФфFf]* )
			print_message "$selected способ конфигурации лицензии с помощью файла" 2 0
			set_license_data_from_file "" 1
			if [ $? -ne 0 ]; then	_is_config_interrupted=true; break;	fi
			api_activate_cmd=`sudo -u redcheck ${REDCHECK_API} activate -fd "$REDCHECK_LICENSE_DATA"`
			exit_code=$?
			if [ $exit_code -eq 0 ]; then
				global_license_key=`echo $api_activate_cmd | grep -oP 'LicenseNumberFromDb=<\K[^>]+'`
				print_message "$license_stage_success_msg" 0 1
				CONFIGURED[license]=true
			else
				REDCHECK_LICENSE_DATA=
				print_message ${Red}"$license_stage_file_check_failure_msg $api_activate_cmd"${Color_Off} 0 1
				if ! repeat_simple_question "$common_repeat_enter_params"; then _is_config_interrupted=true; break; fi
			fi
		;;
		esac
	done
fi
if ! ${_is_config_interrupted}; then
	status="успешна"
	Color=$Green
else
	status="прервана"
	Color=$Yellow
fi

echo_footer $Color "$license_stage_title $status" 0 1
}

# Процедура реактивации лицензии. Данная процедура рассчитана на использовании в сценарии 
# когда происходит перенос REDCHECK-API на другую машину со сбросом кода активации в самой лицензии.
# В этом случаи задача данной процедуры, получить новый файл лицензии, либо через API (процедура активации ОНЛАЙН через ключ), 
# либо напрямую от пользователя (процедура активации ОФФЛАЙН через файл) 
reactivation_license(){
local status
local license_file_path
local license_key
local exit_code
local api_activate_cmd
_is_config_interrupted=false
CONFIGURED[license]=false

print_message "reactivation_license..." 1 0

if [ -n "$global_license_key" ]; then
	license_key=$global_license_key
	global_license_key=""
fi

while ! ${_is_config_interrupted} && ! ${CONFIGURED[license]}; do
	if ! repeat_simple_question "Вы хотите установить RedCheck для лицензии № \"${license_key}\" на текущий сервер? [Y/N]"; then
		_is_config_interrupted=true; break;
	fi
	repeat_config "Выберите тип установки ON-LINE или OFF-LINE [N/F]" choise onoffline true 'N'
	case ${ANSWERS[choise]} in
  [Nn]* )
  	api_activate_cmd=`sudo -u redcheck ${REDCHECK_API} activate -k "$license_key"`
  	exit_code=$?
		if [ $exit_code -eq 0 ]; then
			print_message "$license_stage_success_msg" 0 1
			global_license_key=$license_key
			CONFIGURED[license]=true
		else
			print_message ${Red}"Необходимо произвести сброс активации в личном кабинете, а затем повторить настройку компонента RedCheck-API"${Color_Off} 0 1
			_is_config_interrupted=true;
			global_license_key=""
			license_key=""
		fi
	;;
  [Ff]* )
    set_license_data_from_file "" 1
    if [ $? -ne 0 ]; then	_is_config_interrupted=true; break;	fi
		api_activate_cmd=`sudo -u redcheck ${REDCHECK_API} activate -fd "$REDCHECK_LICENSE_DATA"`
		exit_code=$?
		if [ $exit_code -eq 0 ]; then
			global_license_key=`echo $api_activate_cmd | grep -oP 'LicenseNumberFromDb=<\K[^>]+'`
			print_message "$license_stage_success_msg" 0 1
			CONFIGURED[license]=true
		else
			REDCHECK_LICENSE_DATA=
			print_message ${Red}"$license_stage_file_check_failure_msg $api_activate_cmd"${Color_Off} 0 1
			if ! repeat_simple_question "$common_repeat_enter_params"; then _is_config_interrupted=true; break; fi
		fi
	;;
  esac
done
if ! ${_is_config_interrupted}; then
	status="успешна"
	Color=$Green
else
	status="прервана"
	Color=$Yellow
fi

echo_footer $Color "$license_stage_title $status" 0 1
}

update_db_api(){
local need_conf_lic_loc=$1
local need_pass_admin_creds_loc=$2
local need_reboot_all=$3
local update_db_cmd
local update_db_cmd_text
local continue_update_db=true

while $continue_update_db && ! $is_db_updated; do
	print_message "${update_db} ${REDCHECK_API}.." 0 0	
	if [ ! -z "${REDCHECK_LICENSE_DATA}" ] && $need_pass_admin_creds_loc; then
		print_message "Run update-database -ld -al -ap" 2 0
		update_db_cmd=$(sudo -u redcheck ${REDCHECK_API} update-database -ld "${REDCHECK_LICENSE_DATA}" -al "${ANSWERS[rc-admin-login]}" -ap "${ANSWERS[rc-admin-password]}")
	#?need_conf_lic_loc
	elif [ ! -z "${REDCHECK_LICENSE_DATA}" ]; then
		print_message "Run update-database -ld" 2 0
		update_db_cmd=$(sudo -u redcheck ${REDCHECK_API} update-database -ld "${REDCHECK_LICENSE_DATA}")
	elif $need_pass_admin_creds_loc; then
		print_message "Run update-database -al -ap" 2 0
		update_db_cmd=$(sudo -u redcheck ${REDCHECK_API} update-database -al "${ANSWERS[rc-admin-login]}" -ap "${ANSWERS[rc-admin-password]}")
	else
		print_message "Run update-database" 2 0
		update_db_cmd=$(sudo -u redcheck ${REDCHECK_API} update-database)
	fi
	exit_code=$?
	print_message "$update_db_cmd" 2 0
	if [ $exit_code -eq 0 ]; then
		print_message ${Green}"БД обновлена и готова к работе"${Color_Off} 0 1
		continue_update_db=false
		is_db_updated=true
		if [ -d "$REDCHECK_LICENSE_DIR_PATH" ]; then
			rm -rf "$REDCHECK_LICENSE_DIR_PATH"
		fi
		services enable ${REDCHECK_API}
		services restart ${REDCHECK_API}
		services enable ${REDCHECK_REPORTS_SERVICE}
		services restart ${REDCHECK_REPORTS_SERVICE}
		if $need_reboot_all; then
			services enable ${REDCHECK_CLIENT}
			services restart ${REDCHECK_CLIENT}
			services enable ${REDCHECK_SCAN_SERVICE}
			services restart ${REDCHECK_SCAN_SERVICE}
			services enable ${REDCHECK_SYNC_SERVICE}
			services restart ${REDCHECK_SYNC_SERVICE}
			services enable ${REDCHECK_CLEANUP_SERVICE}
			services restart ${REDCHECK_CLEANUP_SERVICE}
		fi
	else
		print_message ${Red}"Произошла ошибка в процессе обновления базы данных"${Color_Off} 0 1
		print_message ${Red}"$(echo "$update_db_cmd" | awk '
		/^\[/ {
				if (in_block && block) {
						printf "%s", block
						block = ""
				}
				if (/\[.*FAT\]/ || /\[.*ERR\]/) {
						block = $0 "\n"
						in_block = 1
				} else {
						in_block = 0
				}
				next
		}
		in_block {
				block = block $0 "\n"
				next
		}
		END {
				if (in_block && block) {
						printf "%s", block
				}
		}')"${Color_Off} 0 1
		repeat_simple_question "Повторить попытку? [Y/N]"
		if [ $? -eq 0 ]; then
			print_message "Будет проведена повторная попытка обновления БД" 2 0
		else
			print_message "Не будет проведена повторная попытка обновления БД" 2 0
			REDCHECK_LICENSE_DATA=""
			global_license_key=""
			CONFIGURED[license]=false
			continue_update_db=false
		fi
	fi
done
if $need_reboot_all; then
	print_block_delimeter
fi
}

update_db_svc(){
print_message "${update_db} ${REDCHECK_SCAN_SERVICE}.." 0 0
local scan_update_db_cmd=`sudo -u redcheck ${REDCHECK_SCAN_SERVICE} update-database`
exit_code=$?
return $exit_code
}

common_func(){
local _comp_name
local get_id
local module_count=0
local add_update_menu=false
local add_menu_get_code=false
local prior
local prior_api=0
local prior_svc=0
  print_message "Выполнение основных проверок..." 2 0
  print_message "host id:  `cat /etc/machine-id`" 2 0
  #get_id=`cat /etc/machine-id`
  get_id=`openssl rand -hex 16`
  machine_id="${get_id:0:8}-${get_id:8:4}-${get_id:12:4}-${get_id:16:4}-${get_id:20:12}"

  get_os_name
  if [ -e /etc/redhat-release ]; then
	PLATFORMS[RedHat]=true
	distr_id=`grep ^NAME= /etc/os-release | cut -d'"' -f2`
	sites_available_folder=${HTTPD_SITES_FOLDER}
	site_enabled_folder=${HTTPD_ENABLED_SITES_FOLDER}
	web_server="httpd"
	ssl_certs_folder="/etc/pki/tls/certs/"
	ssl_key_folder="/etc/pki/tls/private/"
	find_update_ca "update-ca-trust"
  elif [ -e /etc/debian_version ]; then
	PLATFORMS[Debian]=true
	distr_id=`lsb_release -i | cut -f 2-`
	sites_available_folder=${APACHE_SITES_FOLDER}
	site_enabled_folder=${APACHE_ENABLED_SITES_FOLDER}
	web_server="apache2"
	ssl_certs_folder="/usr/local/share/ca-certificates/"
	find_update_ca "update-ca-certificates"
  else
	  print_message "Не поддерживаемый тип системы" 2 0
  fi

  for i in "${COMPONENTS[@]}"; do
	check_installed "$i"
	if ${INSTALLED[${i}]};then
		get_config_param ${i} ${i}-protocol ${i}-url ${i}-port
		if [ "$i" = "${REDCHECK_API}" ];then
			if  ${CONFIGURED[${REDCHECK_API}]};then
				add_update_menu=true
				prior_api=1
			fi
		  add_menu_get_code=true
		fi
		if [ "$i" = "${REDCHECK_CLIENT}" ];then
		  if  ${CONFIGURED[${REDCHECK_CLIENT}]};then
		    local path2_config="${REDCHECK_APP_DATA_PATH}${REDCHECK_CLIENT}/conf/redcheck-web.dll.config"
		    if [ -f "${path2_config}.rpmsave" ]; then
            local rename_cmd=$( sudo -u redcheck mv "${path2_config}.rpmsave" "${path2_config}" )
            if [ $? -ne 0 ]; then
              print_message "Ошибка при переименовании файла '${path2_config}.rpmsave'." 2 0
            fi
        fi
        if [ -f "${path2_config}" ]; then
          CONFIGURED[${REDCHECK_CLIENT}]=false
        fi 
      fi
    fi 
		if [ "$i" = "${REDCHECK_SCAN_SERVICE}" ];then
		  add_update_menu=true
		  prior_svc=2
		fi
	fi
  done

  if ${add_update_menu};then
	(( prior=prior_api+prior_svc ))
	case $prior in
	"1" )
	  prior=${REDCHECK_API}
	;;
	"2" )
	  prior=${REDCHECK_SCAN_SERVICE}
	;;
	"3" )
	  prior="both"
	;;
	esac
	display_menu_tmp+=( "Обновить структуру БД")
	actions_menu_tmp+=( "update_db ${prior} false false true")
  fi
  
  if ${add_menu_get_code};then
	display_menu_tmp+=("Получение кода активации")
	actions_menu_tmp+=( get_code)
  fi
  
  for i in "${!COMPONENTS[@]}"; do
  _comp_name=${COMPONENTS[$i]}
	if ${INSTALLED[${_comp_name}]}; then
	  display_menu_tmp[${#display_menu_tmp[*]}+1]=${COMPONENTS_DESC[${_comp_name}]}
	  actions_menu_tmp[${#actions_menu_tmp[*]}+1]=${COMPONENTS_ACTION[${_comp_name}]}
	  for j in "${!CONFIGURABLE_COMPONENTS[@]}"; do
		if [ "${j}" = "${_comp_name}" ];then
			CONFIGURABLE_COMPONENTS[${_comp_name}]=${#display_menu_tmp[*]}
		fi
	  done
	  (( module_count++ ))
	fi
  done
  if [ $module_count -ge 2 ];then
	display_menu_tmp+=( "Настроить все сразу" )
	actions_menu_tmp+=( "config_all" )
  fi
  display_menu_tmp+=( "${display_menu_bottom[@]}" )
  actions_menu_tmp+=( "${actions_menu_bottom[@]}" )
}

#Действия для каждого пункта меню

update_db(){
local action_modul=$1
echo_header $Green "${update_db}" 1 0
case $action_modul in
	"${REDCHECK_API}" )
	  update_db_api $2 $3 $4
	;;
	"${REDCHECK_SCAN_SERVICE}" )
	  update_db_svc
	;;
	"both" )
	  update_db_api $2 $3 $4
	  update_db_svc
	;;
esac
echo_footer $Green "${update_db} завершено" 0 1
}

get_code(){
local continue_get_license_activation=true
local is_license_activation_configured=false
local license_key
local get_activation_code_cmd
echo_header $Green "Получение кода активации" 1 0
print_message "Получение кода активации" 2 0

while $continue_get_license_activation && ! $is_license_activation_configured; do
	read -e -p "$license_stage_enter_key" license_key
	if check_choise $license_key key; then
	  get_activation_code_cmd=`sudo -u redcheck ${REDCHECK_API} get-activation-code -l "$license_key" | grep -oP 'GeneratedActivationCode=<\K[^>]+'`
	  if [ $? -eq 0 ]; then
		print_message ${Yellow}"Код активации: ${get_activation_code_cmd}"${Color_Off} 0 1
		is_license_activation_configured=false
		break
	  else
		print_message ${Red}"Произошла ошибка во время генерации кода активации"${Color_Off} 0 1
		repeat_simple_question "$common_repeat_enter_params"
		if [ $? = 1 ]; then continue_get_license_activation=false; fi
	  fi
	else
	  print_message ${Yellow}"$license_stage_key_invalid_format"${Color_Off} 0 1
	  repeat_simple_question "$common_repeat_enter_params"
	  if [ $? = 1 ]; then continue_get_license_activation=false; fi
	fi
  done
echo_footer $Green "Окончание получения кода активации" 0 1
}

config_module_api(){
local defval=""
local ssl_host_type=""
local status
local is_sckd_configured=false
local save_cs_for_api=false
local need_pass_admin_creds=false
local exit_code
local check_activation_code_cmd
local get_activation_code_cmd
local check_db_connect=false
_is_config_interrupted=false
CONFIGURED[sql]=false

	while ! ${CONFIGURED[sql]} && ! $_is_config_interrupted; do
		if ${INSTALLED[${REDCHECK_API}]}; then
			if  ! ${CONFIGURED[sql]}; then
				config_module_sql
			fi
		fi
		echo_header $Green "$stage_title ${REDCHECK_API}" 1 0
		print_message "$stage_title ${REDCHECK_API}" 2 0
		if ${INSTALLED[${REDCHECK_API}]}; then
			while ! ${check_db_connect} ;do
				if  ! ${CONFIGURED[sql]};then
					config_module_sql
				fi
				print_message "Проверяется версия сервера PostgreSQL.." 0 0
				check_pg_cmd=`sudo -u redcheck ${REDCHECK_API} check-postgre -c "$conn_str"`
				exit_code=$?
				print_message "$check_pg_cmd" 2 0
				if [ $exit_code -eq 0 ]; then
					#Если версия соответствует - то проверяем наличие такой БД на сервере
					print_message ${Green}"Версия сервера PostgreSQL соответствует минимально необходимой"${Color_Off} 0 1
					print_message "Проверяется наличие указанной БД на сервере.." 0 0
					NEED_ASK_RECONF_SQL=false
					check_db_cmd=`sudo -u redcheck ${REDCHECK_API} check-database -c "$conn_str"`
					exit_code=$?
					print_message "$check_db_cmd" 2 0
					if [ $exit_code -eq 0 ]; then
						#1.1.1. БД существует - проверяем доступ к указанного пользователя к этой БД
						print_message ${Green}"Указанная БД существует"${Color_Off} 0 1
						print_message "Проверяется наличие прав доступа к БД у указанного пользователя.." 0 0
						check_acccess_cmd=`sudo -u redcheck ${REDCHECK_API} check-access -c "$conn_str"`
						exit_code=$?
						print_message "$check_acccess_cmd" 2 0
						if [ $exit_code -eq 0 ]; then
							#1.1.1.1. Доступ есть - пытаемся считать лицензию, а именно код активации
							print_message ${Green}"Указанный пользователь имеет необходимые права для ${db_stage_title}"${Color_Off} 0 1
							check_activation_code_cmd=`sudo -u redcheck ${REDCHECK_API} check-code -c "$conn_str"`
							exit_code=$?
							get_activation_code_cmd=`echo $check_activation_code_cmd | grep -oP 'GeneratedActivationCode=<\K[^>]+'`
							print_message "Код активации: $get_activation_code_cmd" 2 0
							#1.1.1.1.1.1. Код активации соответствует - лицензию запрашивать не будем, прописываем новую строку подключения в конфиг. УСПЕШНО
							# Если $exit_code == 0, то дополнительных действий делать не нужно, сразу переходим к проверке SCKD							
							if [ $exit_code -eq 1 ]; then
								#1.1.1.1.2. Код активации не соответствует - запрашиваем лицензию, если активация прошла, то прописываем новую строку подключения в конфиг.
								global_license_key=`echo $check_activation_code_cmd | grep -oP 'LicenseNumberFromDb=<\K[^>]+'`
								print_message ${Yellow}"Лицензия уже активирована на другом сервере. Для установки RedCheck для лицензии № \"${Color_Off}${global_license_key}${Yellow}\" необходимо:
1. Произвести сброс активации в личном кабинете. см. раздел документации 4.Сопровождение Системы » 4.2.Сброс активации лицензии.
2. Для OFF-LINE установки дополнительно нужно выполнить активацию в личном кабинете с кодом активации сервера - \"${Color_Off}${get_activation_code_cmd}${Yellow}\" и получить файл активации. см. раздел документации 3.Установка RedCheck Nix » 3.2.Debian » Конфигурация RedCheck.
Документация - ${Color_Off}https://docs.redcheck.ru" 0 1
								save_cs_for_api=true
								need_configure_license=true
								reactivation_license
								if $_is_config_interrupted; then 
									print_message ${Red}"Ошибка активации лицензии. Дальнейшая настройка невозможна. Вы можете изменить код активации в лицензии (см. Документацию)"${Color_Off} 0 1
									print_message "Код активации: ${get_activation_code_cmd}" 1 0
									break;
								fi
							fi
							# Проверка SCKD
							if [ "$exit_code" -ge 0 ] && [ "$exit_code" -le 1 ]; then
								if $is_sckd_configured; then
									print_message "SCKD уже был ранее введён!" 2 0
								fi
								while ! $is_sckd_configured; do
									if [ -z ${ANSWERS[sckd]} ];then
										print_message "$db_stage_sckd_warning" 1 0
										repeat_config "$db_stage_enter_sckd" sckd string false
									fi
									check_sckd_cmd=`sudo -u redcheck ${REDCHECK_API} check-sckd -c "$conn_str" -s "${ANSWERS[sckd]}"`
									exit_code=$?
									print_message "$check_sckd_cmd" 2 0
									if [ $exit_code -eq 0 ]; then
										print_message "Введенный пользовательский ключ шифрования валиден" 2 0
										is_sckd_configured=true
										save_cs_for_api=true
									else
										print_message ${Yellow}"Введенный пользовательский ключ шифрования не валиден"${Color_Off} 0 1
										repeat_simple_question "$common_repeat_enter_params"
										if [ $? -eq 0 ];then
											ANSWERS[sckd]=""
										else
											_is_config_interrupted=true
											break
										fi
									fi
								done
							else
								#1.1.1.1.3. Лицензии в БД нет (пустая БД) - прописываем строку подключения в конфиг, нужно будет выполнить блок лицензии. УСПЕШНО
								_is_config_interrupted=true
								save_cs_for_api=true
								need_configure_license=true
								license_activation
								if $_is_config_interrupted; then break; fi
							fi
						else
							print_message ${Yellow}"У указанного пользователя недостаточно прав для редактирования схемы БД"${Color_Off} 0 1
							repeat_simple_question "$common_repeat_enter_params"
							if [ $? -eq 1 ];then
								_is_config_interrupted=true
								break
							fi
						fi
					elif [ $exit_code -eq 1 ]; then
						#1.1.2. БД не существует - предлагаем создать БД
						print_message "БД с таким именем не найдена" 0 0
						repeat_simple_question "Хотите создать новую БД? [Y/N]"
						if [ $? -eq 0 ];then
							print_message "Создание БД.." 0 0
							create_db_cmd=`sudo -u redcheck ${REDCHECK_API} create-database -c "$conn_str"`
							exit_code=$?
							print_message "$create_db_cmd" 2 0
							if [ $exit_code -eq 0 ]; then
								if [ -z ${ANSWERS[sckd]} ];then
									print_message "$db_stage_sckd_warning" 1 0
									repeat_config "$db_stage_enter_sckd" sckd string false
								fi
							print_message ${Green}"БД успешно создана"${Color_Off} 0 1
							license_activation
							if $_is_config_interrupted; then break; fi
								save_cs_for_api=true
							else
								print_message ${Red}"Произошла ошибка при создании БД"${Color_Off} 0 1
								repeat_simple_question "$common_repeat_enter_params"
								if [ $? -eq 1 ];then
									_is_config_interrupted=true
									break
								fi
							fi
						else
							CONFIGURED[sql]=false
							_is_config_interrupted=true
							break
						fi
					else
						print_message "$db_stage_opening_conn_error_msg" 0 1
						repeat_simple_question "$common_repeat_enter_params"
						if [ $? -eq 1 ];then
							_is_config_interrupted=true
							break
						fi
						CONFIGURED[sql]=false
					fi
				elif [ $exit_code -eq 1 ]; then
					print_message ${Yellow}"Версия сервера PostgreSQL ниже необходимой. Минимальная версия - 12.5"${Color_Off} 0 1
					repeat_simple_question "$common_repeat_enter_params"
					if [ $? -eq 1 ];then
						_is_config_interrupted=true
						break
					fi
				else
					print_message "$db_stage_opening_conn_error_msg" 0 1
					repeat_simple_question "$common_repeat_enter_params"
					if [ $? -eq 1 ];then
						_is_config_interrupted=true
						break
					fi
					CONFIGURED[sql]=false
				fi
				if ${CONFIGURED[sql]};then
					check_db_connect=true
				fi
			done
			if ! ${check_db_connect};then
				break
			fi
			if ${PARAMETERS[advanced_setup]};then
				check_schema_cmd=`sudo -u redcheck ${REDCHECK_API} check-schema -c "$conn_str"`
				exit_code=$?
				print_message "$check_schema_cmd" 2 0
				if [ $exit_code -eq 0 ]; then
					print_message "Структура БД уже сформирована. Дополнительные параметры не будут запрошены" 2 0;
				else
					print_message "Структура БД не сформирована. Будут запрошены дополнительные параметры" 2 0;
					if ${ANSWERS[db_use_default_schema]};then
						print_message "Будeт использована схема по умолчанию" 2 0;
					else
						print_message "Будeт использована пользовательская схема" 2 0;
						config_schema ${REDCHECK_API_APPSETTINGS_PATH} ${ANSWERS[db_use_default_schema]}
						conn_str="${conn_str};Search Path=${ANSWERS[db_schema]}"
					fi
				fi
			fi
			if $save_cs_for_api && ! $_is_config_interrupted; then
				print_message "Конфигурация ${REDCHECK_API} новым подключением.." 0 0
				api_configure_cmd=`sudo -u redcheck ${REDCHECK_API} configure -id "${machine_id}" -c "$conn_str" -s "${ANSWERS[sckd]}"`
				exit_code=$?
				print_message "$api_configure_cmd" 2 0
				if [ $exit_code -eq 0 ]; then
					print_message ${Green}"Новое подключение сохранено в конфигурационный файл ${REDCHECK_API}"${Color_Off} 0 1
				else
					print_message ${Yellow}"Подключение не сохранено в конфигурационный файл ${REDCHECK_API}"${Color_Off} 0 1
				fi
			fi
	
			check_api_cfg=`sudo -u redcheck ${REDCHECK_API} check-configuration`
			exit_code=$?
			print_message "$check_api_cfg" 2 0
			if [ $exit_code -eq 0 ]; then
				print_message "Строка подключения для ${REDCHECK_API} сконфигурирована" 2 0
				check_admin_cmd=`sudo -u redcheck ${REDCHECK_API} check-admin -c "$conn_str"`
				exit_code=$?
				print_message "$check_admin_cmd" 2 0
				if [ $exit_code -eq 1 ]; then
					need_pass_admin_creds=true
					print_message "Создание административной УЗ для работы с консолью.." 0 0
					check_no_empty_value "$web_stage_enter_admin_login" rc-admin-login string
					check_no_empty_value "$pass:" rc-admin-password pwd
				fi
		
				update_db_api ${need_configure_license} ${need_pass_admin_creds} false
		
				if ! $is_db_updated; then
					print_message ${Red}"${REDCHECK_API} не настроен. Не настроена БД"${Color_Off} 0 1
					_is_config_interrupted=true
					break
				fi
			else
				print_message "Строка подключения для ${REDCHECK_API} не сконфигурирована" 2 0
				#config_module_sql
				CONFIGURED[sql]=false
				check_db_connect=false
			fi			
		fi
		
		prepare_defval_protocol ${REDCHECK_API}	
		print_menu "${PROTOCOLS[*]}" 0 "$available_str ${protocols}:" ${ANSWERS[${REDCHECK_API}-protocol]}
		repeat_config "$web_stage_enter_protocol" "${REDCHECK_API}-protocol" range true $defval
		if ${INSTALLED[${REDCHECK_API}]}; then
			print_menu "hostname -I" 1 "${available_str} ${eths}:" ${ANSWERS[${REDCHECK_API}-url]}
			repeat_config "$web_stage_enter_rest_url" "${REDCHECK_API}-ip" range true $defval
		else
			check_no_empty_value "Введите адрес ${REDCHECK_API}:" "${REDCHECK_API}-ip" ip
		fi
		prepare_defval_port ${REDCHECK_API} ${ANSWERS[${REDCHECK_API}-protocol]}
		repeat_config "$web_stage_enter_rest_port" "${REDCHECK_API}-port" port true $defval  
		
		if ! ${INSTALLED[${REDCHECK_API}]}; then
			print_message "Введены основные данные подключения к ${REDCHECK_API}" 2 0
			if ${INSTALLED[$REDCHECK_CLIENT]}; then
				config_web_client ${ANSWERS[${REDCHECK_API}-url]}
			fi
			CONFIGURED[$REDCHECK_API]=true
			break
		fi
		if [[ "${ANSWERS[${REDCHECK_API}-protocol]}" = "${PROTOCOLS[https]}" ]]; then
			print_message "$web_stage_clear_existed_certs" 2 0
			api_cert_file_path="${ssl_certs_folder}${API_CRT_FILE}"
			if [ -f "${api_cert_file_path}" ]; then
				rm "${api_cert_file_path}"
				print_message "Удален файл ${api_cert_file_path}" 2 0
				if ${PLATFORMS[RedHat]}; then
					api_key_file_path="${ssl_key_folder}${API_KEY_FILE}"
					if [ -f "${api_key_file_path}" ]; then
						rm "${api_key_file_path}"
						print_message "Удален файл ${api_key_file_path}" 2 0
					fi
				fi
			fi
	
			print_menu "${CERT_BASED[*]}" 0 "Сформировать сертификат на:"
			repeat_config "$web_stage_enter_ssl_host_type" ssl_host_type range true	
			
			if [[ "${ANSWERS[ssl_host_type]}" = "${CERT_BASED[ip]}" ]]; then
				print_message "Выбрано создание сертификата на IP" 2 0
				ANSWERS[${REDCHECK_API}-url]=${ANSWERS[${REDCHECK_API}-ip]}
			else
				print_message "Выбрано создание сертификата на DNS" 2 0
				get_host_name
				print_menu "$hostnames" 0 "Найдены имена хоста:" ${ANSWERS[${REDCHECK_API}-url]}
				repeat_config "$web_stage_enter_dns_host_name" "${REDCHECK_API}-url" range true $defval
			fi
			gencert $REDCHECK_API ${ANSWERS[ssl_host_type]} ${ANSWERS[${REDCHECK_API}-url]}
			if [ $? -eq 0 ]; then
				print_message "генерация сертификата успешно завершена" 2 0
			else
				_is_config_interrupted=true
				break
			fi
			config_site_https ${ANSWERS[${REDCHECK_API}-url]} ${ANSWERS[${REDCHECK_API}-port]} $APACHE_CONF_API_SSL_FILE_NAME $APACHE_CONF_API_FILE_NAME $API_CRT_FILE $API_KEY_FILE
		else
			ANSWERS[${REDCHECK_API}-url]=${ANSWERS[${REDCHECK_API}-ip]}
			config_site_http ${ANSWERS[${REDCHECK_API}-url]} ${ANSWERS[${REDCHECK_API}-port]} $APACHE_CONF_API_SSL_FILE_NAME $APACHE_CONF_API_FILE_NAME
		fi
	
		config_semanage ${ANSWERS[${REDCHECK_API}-port]}
	
		CONFIGURED[$REDCHECK_API]=true
		if ${PLATFORMS[RedHat]}; then
			audit_allow=$(ausearch -c 'httpd' --raw 2>/dev/null | audit2allow -M my-httpd 2>&1)
			if [ -n "$audit_allow" ];then print_message "$audit_allow" 2 0; fi
      audit_allow=$(sudo semodule -i my-httpd.pp 2>&1)
      if [ -n "$audit_allow" ];then print_message "$audit_allow" 2 0; fi
		fi
	
		if ${INSTALLED[$REDCHECK_CLIENT]}; then
			config_web_client ${ANSWERS[${REDCHECK_API}-url]}
		fi
		services enable ${web_server}
		services restart ${web_server}
		break
	done

	if ${CONFIGURED[${REDCHECK_API}]} && ! $_is_config_interrupted; then
		status="успешна"
		Color=$Green
	else
		status="прервана"
		Color=$Yellow
		_is_config_interrupted=true
		CONFIGURED[sql]=false
    NEED_ASK_RECONF_SQL=true
	fi

	echo_footer $Color "$stage_title ${REDCHECK_API} $status" 0 1
}

config_module_client(){
  local defval=""
  local ssl_host_type=""
  _is_config_interrupted=false
    
  local merge_cmd=$( sudo -u redcheck ${REDCHECK_CLIENT} merge-config )
  if [ $? -ne 0 ]; then		
    print_message "Ошибка <${merge_cmd}> при слиянии конфигураций RedCheck клиента!" 2 0
  fi
  
  while ! $_is_config_interrupted; do
    if ! ${CONFIGURED[${REDCHECK_API}]}; then
      print_message "Настройка зависимого модуля ${REDCHECK_API}" 2 0
      config_module_api
    fi
  
    echo_header $Green "$stage_title ${REDCHECK_CLIENT}" 1 0
    print_message "$stage_title ${REDCHECK_CLIENT}" 2 0
  
  	prepare_defval_protocol ${REDCHECK_CLIENT}	
    print_menu "${PROTOCOLS[*]}" 0 "${available_str} ${protocols}:" ${ANSWERS[${REDCHECK_CLIENT}-protocol]}
    repeat_config "$web_stage_enter_protocol" "${REDCHECK_CLIENT}-protocol" range true $defval
    if [ $? -eq 1 ]; then _is_config_interrupted=true; break; fi
    print_menu "hostname -I" 1 "${available_str} ${eths}:" ${ANSWERS[${REDCHECK_CLIENT}-url]}
    repeat_config "$web_stage_enter_rest_url" "${REDCHECK_CLIENT}-ip" range true $defval
    if [ $? -eq 1 ]; then _is_config_interrupted=true; break; fi
  
    prepare_defval_port ${REDCHECK_CLIENT} ${ANSWERS[${REDCHECK_CLIENT}-protocol]}
    repeat_config "$web_stage_enter_rest_port" "${REDCHECK_CLIENT}-port" port true $defval
    if [ $? -eq 1 ]; then _is_config_interrupted=true; break; fi
  
    if [[ "${ANSWERS[${REDCHECK_CLIENT}-protocol]}" = "${PROTOCOLS[https]}" ]]; then
      print_message "$web_stage_clear_existed_certs" 2 0
      client_cert_file_path="${ssl_certs_folder}${CLIENT_CRT_FILE}"
      if [ -f "${client_cert_file_path}" ]; then
        rm "${client_cert_file_path}"
        if ${PLATFORMS[RedHat]}; then
          client_key_file_path="${ssl_key_folder}${CLIENT_KEY_FILE}"
          if [ -f "${client_key_file_path}" ]; then
            rm "${client_key_file_path}"
            print_message "Удален файл ${api_key_file_path}" 2 0
          fi
        fi
      fi
  
      print_menu "${CERT_BASED[*]}" 0 "Сформировать сертификат на:"
      repeat_config "$web_stage_enter_ssl_host_type" ssl_host_type range true
      if [ $? -eq 1 ]; then _is_config_interrupted=true; break; fi
      if [[ "${ANSWERS[ssl_host_type]}" = "${CERT_BASED[ip]}" ]]; then
        print_message "Выбрано создание сертификата на IP" 2 0
        ANSWERS[${REDCHECK_CLIENT}-url]=${ANSWERS[${REDCHECK_CLIENT}-ip]}
      else
        print_message "Выбрано создание сертификата на DNS" 2 0
        get_host_name
        print_menu "$hostnames" 0 "Найдены имена хоста:"
        repeat_config "$web_stage_enter_dns_host_name" "${REDCHECK_CLIENT}-url" range true
      fi
      gencert $REDCHECK_CLIENT ${ANSWERS[ssl_host_type]} ${ANSWERS[${REDCHECK_CLIENT}-url]}
      if [ $? -eq 0 ]; then
        print_message "генерация сертификата успешно завершена" 2 0
      else
        _is_config_interrupted=true
        break
      fi
      config_site_https ${ANSWERS[${REDCHECK_CLIENT}-url]} ${ANSWERS[${REDCHECK_CLIENT}-port]} $APACHE_CONF_CLIENT_SSL_FILE_NAME $APACHE_CONF_CLIENT_FILE_NAME $CLIENT_CRT_FILE $CLIENT_KEY_FILE
    else
      ANSWERS[${REDCHECK_CLIENT}-url]=${ANSWERS[${REDCHECK_CLIENT}-ip]}
      config_site_http ${ANSWERS[${REDCHECK_CLIENT}-url]} ${ANSWERS[${REDCHECK_CLIENT}-port]} $APACHE_CONF_CLIENT_SSL_FILE_NAME $APACHE_CONF_CLIENT_FILE_NAME
    fi
    
    config_semanage ${ANSWERS[${REDCHECK_CLIENT}-port]}
    
    services enable ${REDCHECK_CLIENT}
    services restart ${REDCHECK_CLIENT}
    services restart ${web_server}
  
    CONFIGURED[$REDCHECK_CLIENT]=true
    break
  done

  if ${CONFIGURED[${REDCHECK_CLIENT}]}; then
    status="успешна"
    Color=$Green
  else
    status="прервана"
    Color=$Yellow
  fi
  
  echo_footer $Color "$stage_title ${REDCHECK_CLIENT} $status" 0 1
}

config_module_scan(){
local scan_verify_sckd_cmd_text
local scan_verify_sckd_cmd
local scan_update_db_cmd
local scan_register_cmd_text
local scan_register_cmd
local registered_services_names
local verify_sckd_exit_code
local pypsrp_cmd
local pypsrp_cmd_text
local status
local get_SVC_id
local svc_id
local exit_code
  _is_config_interrupted=false
  echo_header $Green "$stage_title ${REDCHECK_SCAN_SERVICE}" 1 0
  print_message "$stage_title ${REDCHECK_SCAN_SERVICE}" 2 0
  get_SVC_id=`openssl rand -hex 16`
  svc_id="${get_SVC_id:0:8}-${get_SVC_id:8:4}-${get_SVC_id:12:4}-${get_SVC_id:16:4}-${get_SVC_id:20:12}"

  if ! $_is_config_interrupted; then
		print_message "$stage_verifying_db сканирования.." 0 0
		
		if $NEED_ASK_RECONF_SQL || $NEED_ASK_RECONF_SCAN_SQL;then
    	CONFIGURED[${REDCHECK_SCAN_SERVICE}]=false
    fi
		
		while ! ${CONFIGURED[${REDCHECK_SCAN_SERVICE}]} && ! $_is_config_interrupted; do
			print_message "${Yellow}Конфигурация для ${REDCHECK_SCAN_SERVICE}...${Color_Off}" 0 1
			if  ! ${CONFIGURED[sql]};then
				config_module_sql
			fi
			if ${PARAMETERS[advanced_setup]};then
				config_schema ${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH} ${ANSWERS[db_use_default_schema]}
			fi
			print_message "$db_stage_check_connection для ${REDCHECK_SCAN_SERVICE}" 0 0
			verify_scan_db_cmd=`sudo -u redcheck ${REDCHECK_SCAN_SERVICE} verify-database -c "$conn_str"`
			exit_code=$?
			print_message "$verify_scan_db_cmd" 2 0
			if [ $exit_code -eq 0 ]; then
				print_message "$db_stage_connection_established" 0 1
				print_message "Конфигурация ${REDCHECK_SCAN_SERVICE} новым подключением.." 0 0
				NEED_ASK_RECONF_SQL=false
				NEED_ASK_RECONF_SCAN_SQL=false
				scan_configure_cmd=`sudo -u redcheck ${REDCHECK_SCAN_SERVICE} configure -id "${svc_id}" -c "${conn_str}" -s "${ANSWERS[sckd]}"`
				exit_code=$?
				print_message "$scan_configure_cmd" 2 0
				if [ $exit_code -eq 0 ]; then
					print_message ${Green}"Новое подключение сохранено в конфигурационный файл ${REDCHECK_SCAN_SERVICE}"${Color_Off} 0 1
					CONFIGURED[${REDCHECK_SCAN_SERVICE}]=true
				else
					print_message ${Yellow}"Подключение не сохранено в конфигурационный файл ${REDCHECK_SCAN_SERVICE}"${Color_Off} 0 1
				fi
			else
				print_message "$db_stage_connection_failed_compatible" 0 1
				repeat_simple_question "$common_repeat_enter_params"
				if [ $? -eq 1 ];then
					_is_config_interrupted=true
					break
				else
					 CONFIGURED[sql]=false
					 config_module_sql
				fi
			fi
		done
		if ${CONFIGURED[$REDCHECK_SCAN_SERVICE]};then
			scan_verify_reg_cmd=`sudo -u redcheck ${REDCHECK_SCAN_SERVICE} verify-register`
			exit_code=$?
			print_message "$scan_verify_reg_cmd" 2 0
			need_ask_service_name=`echo $scan_verify_reg_cmd | grep -oP 'NeedAskServiceName=<\K[^>]+'`
			registered_scanning_services=`echo $scan_verify_reg_cmd | grep -oP 'ScanningServices=<\K[^>]+'`
			if [[ $exit_code -eq 0 || $exit_code -eq 1 ]]; then
				if ${INSTALLED[$REDCHECK_API]}; then
					while true; do
						scan_verify_sckd_cmd_text="sudo -u redcheck ${REDCHECK_SCAN_SERVICE} verify-sckd"
						if $need_ask_sckd; then
							scan_verify_sckd_cmd_text="$scan_verify_sckd_cmd_text -s ${ANSWERS[sckd]}"
						fi
						scan_verify_sckd_cmd=`$scan_verify_sckd_cmd_text`
						verify_sckd_exit_code=$?
						print_message "$scan_verify_sckd_cmd" 2 0
						if [ $verify_sckd_exit_code -eq 0 ]; then
							break
						else
							print_message "Не удалось проверить пользовательский ключ шифрования." 0 0
							repeat_simple_question "Повторить ввод ключа? [Y/N]"
							if [ $? -eq 0 ]; then
								need_ask_sckd=true
								repeat_config "$db_stage_enter_sckd" sckd string false
							else
								_is_config_interrupted=true
								break
							fi
						fi
					done
				fi
				if ! $_is_config_interrupted; then
					if [[ $exit_code -eq 0 && $need_ask_service_name -eq 1 ]]; then
						check_no_empty_value "Введите имя службы: " svc_name string
					fi
					if [ $exit_code -eq 1 ]; then
						registered_services_names=$(print_registered_services)
						print_message ${Yellow}"Количество установленных служб превышает лицензионное ограничение, вы можете заменить одну из используемых служб"${Color_Off} 0 1
						print_menu "${registered_services_names[*]}" 0 "${available_str} службы для замены:"
						repeat_config "Укажите номер заменяемой службы" svc_name range true
						if [ $? -eq 1 ]; then
							_is_config_interrupted=true
						fi
					fi
					if ! $_is_config_interrupted; then
						print_message ${Green}"Проверка прошла успешно. Служба сканирования может быть установлена к указанной БД"${Color_Off} 0 1
					fi
				fi
			else
				if [ $exit_code -eq 2 ]; then
					print_message ${Red}"Не настроен REST. Служба сканирования не может быть настроена"${Color_Off} 0 1
				elif [ $exit_code -eq 3 ]; then
					print_message ${Red}"Отсутствует лицензия в БД. Служба сканирования не может быть настроена"${Color_Off} 0 1
				else
					print_message ${Red}"Произошла ошибка во время проверки возможности установить службу сканирования к указанной БД"${Color_Off} 0 1
				fi
				_is_config_interrupted=true
			fi
		fi
  fi

	if $_is_config_interrupted; then
	  print_message "$stage_title ${REDCHECK_SCAN_SERVICE}" 2 0
	else
	  scan_register_cmd_text="sudo -u redcheck ${REDCHECK_SCAN_SERVICE} register"
	  if [ $need_ask_service_name -eq 1 2>/dev/null ]; then
			scan_register_cmd_text="$scan_register_cmd_text -d  ${ANSWERS[svc_name]}"
	  fi
	  scan_register_cmd=`$scan_register_cmd_text`
	  exit_code=$?
	  print_message "$scan_register_cmd" 2 0
	  if [ $exit_code -eq 0 ]; then
			update_db_svc
			exit_code=$?
			if [ $exit_code -eq 0 ]; then
				print_message ${Green}"Служба сканирования обновлена"${Color_Off} 0 1
				is_python_path_configured=$(check_python_path)
				if [ $is_python_path_configured -eq 0 ]; then
					print_message "Настройка <PythonDll> заполнена" 2 0
				else
					print_message "Выполняется установка pypsrp[kerberos]..." 2 0
					if ${PLATFORMS[RedHat]}; then
						python_prepath="/usr/lib64/"
					else
						python_prepath="/usr/lib/x86_64-linux-gnu/"
					fi
					if ${OS_NAME[Sber]}; then
						python3_command=$(command -v python3.8)
					else
						python3_command=$(command -v python3)
					fi
					python_version=`$python3_command --version | grep -oE '[0-9]+\.[0-9]+'` 
					python_path="${python_prepath}libpython${python_version}.so.1.0"
					if [[ ! -f "$python_path" ]]; then
						python_path="${python_prepath}libpython${python_version}m.so.1.0"
						if [[ ! -f "$python_path" ]]; then
							print_message "Не удалось обнаружить библиотеку <$python_path>." 2 0 
							print_message "$scan_stage_winrm_configuring_warning" 0 1
							print_message "${Yellow}$scan_stage_winrm_configuring_needed_actions${cn}1. $scan_stage_winrm_configuring_check_python_existence ${python_path}${cn}2. $scan_stage_winrm_configuring_step_two${cn}3. $scan_stage_winrm_configuring_step_three${Color_Off}" 0 1
							exit_code=1 
						fi
					fi
					if [[ -f "$python_path" ]]; then
						sudo -u redcheck sed -i "s|PythonDll\": \".*\"|PythonDll\": \"${python_path}\"|" "${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH}"          
						print_message "В конфигурационном файле ${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH} изменено значение для настройки <PythonDll>. Новое значение: ${python_path}" 2 0        
						if ${OS_NAME[Debian]} || ${OS_NAME[Astra]} || ${OS_NAME[Sber]}; then
							python_venv="/opt/${REDCHECK_SCAN_SERVICE}/pypackages"
							if [[ -d "$python_venv" ]]; then
								sudo -u redcheck sed -i "s|VirtualEnvDirectory\": \".*\"|VirtualEnvDirectory\": \"${python_venv}\"|" "${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH}"
								print_message "В конфигурационном файле ${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH} изменено значение для настройки <VirtualEnvDirectory>. Новое значение: ${python_venv}" 2 0
							else
								print_message "Не удалось обнаружить директорию <$python_venv>." 2 0 
								print_message "$scan_stage_winrm_configuring_warning" 0 1
								exit_code=1
							fi
							if ${PLATFORMS[RedHat]}; then
								python_home="/usr/lib64/python${python_version}"   
							else
								python_home="/usr/lib/python${python_version}"   
							fi
							if [[ -d "$python_home" ]]; then
								sudo -u redcheck sed -i "s|PythonHome\": \".*\"|PythonHome\": \"${python_home}\"|" "${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH}"
								print_message "В конфигурационном файле ${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH} изменено значение для настройки <PythonHome>. Новое значение: ${python_home}" 2 0
							else
								print_message "Не удалось обнаружить директорию <$python_home>." 2 0 
								print_message "$scan_stage_winrm_configuring_warning" 0 1
								exit_code=1
							fi
						fi
					fi
					exit_code=0
					if ${OS_NAME[RED]}; then
						pypsrp_cmd=`tar -xf /var/opt/${REDCHECK_SCAN_SERVICE}/pypsrp/pypsrp-0.8.1-for-rpm-09.08.24.tar.gz -C /var/opt/${REDCHECK_SCAN_SERVICE}/pypsrp`
						pypsrp_conf_result=$?
						if [ $pypsrp_conf_result -eq 0 ]; then
							pypsrp_cmd=$(pip3.8 install --no-index -f /var/opt/${REDCHECK_SCAN_SERVICE}/pypsrp/ --upgrade pip 2>&1)
							pypsrp_conf_result=$?
							print_message "$pypsrp_cmd" 2 0
						fi
						if [ $pypsrp_conf_result -eq 0 ]; then
							pypsrp_cmd=$(pip3.8 install --no-index -f /var/opt/${REDCHECK_SCAN_SERVICE}/pypsrp/ setuptools wheel Cython 2>&1)
							pypsrp_conf_result=$?
							print_message "$pypsrp_cmd" 2 0
						fi
						if [ $pypsrp_conf_result -eq 0 ]; then
							pypsrp_cmd=$(pip3.8 install --no-index -f /var/opt/${REDCHECK_SCAN_SERVICE}/pypsrp/ pypsrp[kerberos] 2>&1)
							pypsrp_conf_result=$?
							print_message "$pypsrp_cmd" 2 0
						fi
						if rpm -q krb5-devel python3-devel > /dev/null; then
							print_message "Пакеты krb5-devel и python3-devel обнаружены. Устанавливаем pypsrp[kerberos]." 2 0
							pypsrp_cmd=$(pip3.8 install --no-index -f /var/opt/${REDCHECK_SCAN_SERVICE}/pypsrp/ pypsrp[kerberos] 2>&1)
							pypsrp_conf_result=$?
							print_message "$pypsrp_cmd" 2 0              
						else
							print_message "Пакеты krb5-devel и(или) python3-devel не были обнаружены. Устанавливаем pypsrp." 2 0
							pypsrp_cmd=$(pip3.8 install --no-index -f /var/opt/${REDCHECK_SCAN_SERVICE}/pypsrp/ pypsrp 2>&1)
							pypsrp_conf_result=$?
							print_message "$pypsrp_cmd" 2 0    
						fi
						exit_code=$pypsrp_conf_result          
					elif [[ ${OS_NAME[Debian]} && ! -d "/opt/${REDCHECK_SCAN_SERVICE}/pypackages" ]]; then
						python_venv_path="/opt/${REDCHECK_SCAN_SERVICE}/pyvenv"
						if [[ ! -d "${python_venv_path}" ]]; then
							sudo -u redcheck mkdir "$python_venv_path"
							pypsrp_cmd=$(sudo -u redcheck ${python3_command} -m venv "${python_venv_path}")
							exit_code=$?
							if [ $exit_code -eq 0 ]; then
								pypsrp_cmd=$(sudo -u redcheck ${python_venv_path}/bin/pip install --upgrade pip 2>&1)
								exit_code=$?
								print_message "$pypsrp_cmd" 2 0
							fi
							if [ $exit_code -eq 0 ]; then
								pypsrp_cmd=$(sudo -u redcheck ${python_venv_path}/bin/pip install setuptools wheel Cython 2>&1)
								exit_code=$?
								print_message "$pypsrp_cmd" 2 0
							fi
							pypsrp_cmd=$(dpkg-query -W -f='${Status}' libkrb5-dev 2>/dev/null | grep -q "ok installed")
							is_krb5=$?
							if [ $is_krb5 -eq 0 ]; then
								print_message "libkrb5-dev обнаружен. Устанавливаем pypsrp[kerberos]." 2 0
								pypsrp_cmd=$(sudo -u redcheck ${python_venv_path}/bin/pip install pypsrp[kerberos] 2>&1)
								exit_code=$?
								print_message "$pypsrp_cmd" 2 0              
							else
								print_message "libkrb5-dev не обнаружен. Устанавливаем pypsrp." 2 0
								pypsrp_cmd=$(sudo -u redcheck ${python_venv_path}/bin/pip install pypsrp 2>&1)
								exit_code=$?
								print_message "$pypsrp_cmd" 2 0
							fi
							if [ $exit_code -eq 0 ]; then
								python_venv="${python_venv_path}/lib/python${python_version}/site-packages"
								if [[ -d "$python_venv" ]]; then
									sudo -u redcheck sed -i "s|VirtualEnvDirectory\": \".*\"|VirtualEnvDirectory\": \"${python_venv}\"|" "${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH}"
									print_message "В конфигурационном файле ${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH} изменено значение для настройки <VirtualEnvDirectory>. Новое значение: ${python_venv}" 2 0
								else
									print_message "Не удалось обнаружить директорию <$python_venv>." 2 0 
									exit_code=1
								fi
								python_home="/usr/lib/python${python_version}" 
								if [[ -d "$python_home" ]]; then
									sudo -u redcheck sed -i "s|PythonHome\": \".*\"|PythonHome\": \"${python_home}\"|" "${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH}"
									print_message "В конфигурационном файле ${REDCHECK_SCAN_SERVICE_APPSETTINGS_PATH} изменено значение для настройки <PythonHome>. Новое значение: ${python_home}" 2 0
								else
									print_message "Не удалось обнаружить директорию <$python_home>." 2 0 
									exit_code=1
								fi
							fi
							if [ $exit_code -eq 0 ]; then
								print_message "Виртуальная среда успешно настроена!" 2 0
							else
								print_message "Процесс настройки виртуальной среды завершился неудачно!" 2 0
							fi
						else
							print_message "Виртуальная среда Python, для работы winrm, уже существует." 2 0
							exit_code=0
						fi
					fi
					if [ $exit_code -ne 0 ]; then
						print_message "Не удалось установить pypsrp[kerberos]" 2 0
						print_message "$scan_stage_winrm_configuring_warning" 0 1
						print_message "${Yellow}$scan_stage_winrm_configuring_needed_actions${cn}1. $scan_stage_winrm_configuring_check_python_existence ${python_path}${cn}2. $scan_stage_winrm_configuring_step_two${cn}3. $scan_stage_winrm_configuring_step_three${Color_Off}" 0 1
					fi
					print_message "Результат выполнения настройки pypsrp[kerberos]: ${exit_code} (0 - успешно)" 2 0			
				fi
				CONFIGURED[$REDCHECK_SCAN_SERVICE]=true
				services enable ${REDCHECK_SCAN_SERVICE}
				services restart ${REDCHECK_SCAN_SERVICE}
			else
				print_message ${Red}"Служба сканирования не обновлена"${Color_Off} 0 1
				_is_config_interrupted=true
			fi
		else
			print_message ${Red}"Служба сканирования не зарегистрирована"${Color_Off} 0 1
			_is_config_interrupted=true
		fi
	fi

	if ! $_is_config_interrupted; then
		status="успешна"
		Color=$Green
	else
		status="прервана"
		Color=$Yellow
	fi
	echo_footer $Color "$stage_title ${REDCHECK_SCAN_SERVICE} $status" 0 1
}

config_module_sync(){
local sync_verify_sckd_cmd
local sync_verify_sckd_cmd_text
local verify_sckd_exit_code
local sync_register_cmd
local status
local exit_code
_is_config_interrupted=false

  echo_header $Green "$stage_title ${REDCHECK_SYNC_SERVICE}" 1 0
  print_message "$stage_title ${REDCHECK_SYNC_SERVICE}" 2 0
  
	if $NEED_ASK_RECONF_SQL || $NEED_ASK_RECONF_SYNC_SQL;then
		CONFIGURED[${REDCHECK_SYNC_SERVICE}]=false
	fi
  
  while ! ${CONFIGURED[${REDCHECK_SYNC_SERVICE}]} && ! $_is_config_interrupted; do
  	print_message "${Yellow}Конфигурация для ${REDCHECK_SYNC_SERVICE}...${Color_Off}" 0 1
		if  ! ${CONFIGURED[sql]};then
			config_module_sql
		fi
		if ${PARAMETERS[advanced_setup]};then
			config_schema ${REDCHECK_SYNC_SERVICE_APPSETTINGS_PATH} ${ANSWERS[db_use_default_schema]}
		fi
	
		print_message "$db_stage_check_connection для ${REDCHECK_SYNC_SERVICE}" 0 0
		verify_sync_db_cmd=`sudo -u redcheck ${REDCHECK_SYNC_SERVICE} verify-database -c "$conn_str"`
		exit_code=$?
		print_message "$verify_sync_db_cmd" 2 0
		if [ $exit_code -eq 0 ]; then
			print_message "$db_stage_connection_established" 0 1
			print_message "Конфигурация ${REDCHECK_SYNC_SERVICE} новым подключением.." 0 0
			NEED_ASK_RECONF_SQL=false
			NEED_ASK_RECONF_SYNC_SQL=false
			api_configure_cmd=`sudo -u redcheck ${REDCHECK_SYNC_SERVICE} configure -id "${sync_id}" -c "$conn_str" -s "${ANSWERS[sckd]}"`
			exit_code=$?
			print_message "$api_configure_cmd" 2 0
			if [ $exit_code -eq 0 ]; then
				print_message ${Green}"Новое подключение сохранено в конфигурационный файл ${REDCHECK_SYNC_SERVICE}"${Color_Off} 0 1
				CONFIGURED[${REDCHECK_SYNC_SERVICE}]=true
			else
				print_message ${Yellow}"Подключение не сохранено в конфигурационный файл ${REDCHECK_SYNC_SERVICE}"${Color_Off} 0 1
			fi
		else
			print_message "$db_stage_connection_failed_compatible" 0 1
			repeat_simple_question "$common_repeat_enter_params"
			if [ $? -eq 1 ];then
				_is_config_interrupted=true
				break
			else
				CONFIGURED[sql]=false
				config_module_sql
			fi
		fi
  done
  if ! $_is_config_interrupted; then
	  print_message "$stage_verifying_db синхронизации.." 0 0
    sync_verify_reg_cmd=`sudo -u redcheck ${REDCHECK_SYNC_SERVICE} verify-register`
    exit_code=$?
    print_message "$sync_verify_reg_cmd" 2 0
    if [ $exit_code -eq 0 ]; then
      while true; do
        sync_verify_sckd_cmd_text="sudo -u redcheck ${REDCHECK_SYNC_SERVICE} verify-sckd"
        if $need_ask_sckd; then
          sync_verify_sckd_cmd_text="$sync_verify_sckd_cmd_text -s ${ANSWERS[sckd]}"
        fi
        sync_verify_sckd_cmd=`$sync_verify_sckd_cmd_text`
        verify_sckd_exit_code=$?
        print_message "$sync_verify_sckd_cmd" 2 0
        if [ $verify_sckd_exit_code -eq 0 ]; then
          break
        else
          print_message "Не удалось проверить пользовательский ключ шифрования." 0 0
          repeat_simple_question "Повторить ввод ключа? [Y/N]"
          if [ $? -eq 0 ]; then
            need_ask_sckd=true
            repeat_config "$db_stage_enter_sckd" sckd string false
          else
            _is_config_interrupted=true
            break
          fi
        fi
      done
      if ! $_is_config_interrupted; then
        print_message ${Green}"Проверка прошла успешно. Служба синхронизации может быть установлена к указанной БД"${Color_Off} 0 1
      fi
    else
      if [ $exit_code -eq 1 ]; then
        print_message ${Yellow}"Служба синхронизации в БД уже установлена. Производим замену службы в указанной БД"${Color_Off} 0 1
      elif [ $exit_code -eq 2 ]; then
        print_message ${Red}"Не настроен REST. Служба синхронизации не может быть настроена"${Color_Off} 0 1
        _is_config_interrupted=true
      else
        print_message ${Red}"Произошла ошибка во время проверки возможности установить службу синхронизации к указанной БД"${Color_Off} 0 1
        _is_config_interrupted=true
      fi
    fi
  fi

  if ! $_is_config_interrupted; then	
	sync_register_cmd=`sudo -u redcheck ${REDCHECK_SYNC_SERVICE} register`
	exit_code=$?
	print_message "$sync_register_cmd" 2 0
	if [ $exit_code -eq 0 ]; then
	  print_message ${Green}"Служба синхронизации обновлена"${Color_Off} 0 1
	  CONFIGURED[$REDCHECK_SYNC_SERVICE]=true
	  services enable ${REDCHECK_SYNC_SERVICE}
	  services restart ${REDCHECK_SYNC_SERVICE}
	else
	  print_message ${Red}"Служба синхронизации не обновлена"${Color_Off} 0 1
	fi
  fi

	if ! $_is_config_interrupted; then
    status="успешно"
    Color=$Green
	else
    status="прервана"
    Color=$Yellow
	fi
	echo_footer $Color "$stage_title ${REDCHECK_SYNC_SERVICE} $status" 0 1
}

config_module_cleanup(){
local ssl_host_type="ip"
local _defval
local status
local _CN
local _mode
_is_config_interrupted=false
CONFIGURED[${REDCHECK_CLEANUP_SERVICE}]=false

	echo_header $Green "$stage_title ${REDCHECK_CLEANUP_SERVICE}" 1 0
	print_message "$stage_title ${REDCHECK_CLEANUP_SERVICE}" 2 0

	while ! ${CONFIGURED[${REDCHECK_CLEANUP_SERVICE}]} && ! $_is_config_interrupted; do
		if ${INSTALLED[$REDCHECK_CLEANUP_SERVICE]}; then
			if ${INSTALLED[${REDCHECK_API}]}; then
				if ${CONFIGURED[${REDCHECK_API}]}; then
					if check_choise ${ANSWERS[${REDCHECK_API}-url]} ip; then
						ANSWERS[${REDCHECK_CLEANUP_SERVICE}-ip]=${ANSWERS[${REDCHECK_API}-url]}
						ANSWERS[${REDCHECK_CLEANUP_SERVICE}-url]=${ANSWERS[${REDCHECK_API}-url]}
					else
						ANSWERS[${REDCHECK_CLEANUP_SERVICE}-url]=${ANSWERS[${REDCHECK_API}-url]}
						ssl_host_type="dns"
					fi
				fi
			fi
			if [[ "${ssl_host_type}" = "${CERT_BASED[dns]}" ]]; then
				print_message "Выберите имя хоста для web службы ${REDCHECK_CLEANUP_SERVICE}" 0 0
				get_host_name
				print_menu "$hostnames" 0 "Найдены имена хоста:"
				repeat_config "$web_stage_enter_dns_host_name" "${REDCHECK_CLEANUP_SERVICE}-url" range true
				_mode="dns"
				_CN=${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-url]}
			else
				print_menu "hostname -I" 1 "${available_str} ${eths}:" ${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-ip]}
				repeat_config "$web_stage_enter_rest_url" "${REDCHECK_CLEANUP_SERVICE}-ip" range true $defval				
				if [ $? -eq 1 ]; then
					_is_config_interrupted=true
					break
				fi
				_mode="ip"
				_CN=${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-ip]}
				ANSWERS[${REDCHECK_CLEANUP_SERVICE}-url]=${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-ip]}
			fi
	
			if [ -z ${ANSWERS[rc-admin-login]} ];then
				print_message "Укажите существующую учетную запись с правами Администратора:" 0 0
				check_no_empty_value "$web_stage_enter_admin_login" rc-admin-login string
				check_no_empty_value "$pass:" rc-admin-password pwd
			fi
				cert_file_path="${ssl_certs_folder}"
			if [ -f "${cert_file_path}${CLEANUP_CRT_FILE}" ]; then
				rm "${cert_file_path}${CLEANUP_CRT_FILE}"
				if ${PLATFORMS[RedHat]}; then
					key_file_path="${ssl_key_folder}"
					if [ -f "${key_file_path}${CLEANUP_KEY_FILE}" ]; then
						rm "${key_file_path}${CLEANUP_KEY_FILE}"
					fi
				fi
			fi
			gencert $REDCHECK_CLEANUP_SERVICE ${CERT_BASED[${_mode}]} ${_CN}
			if [ $? -eq 0 ]; then
				ANSWERS[${REDCHECK_CLEANUP_SERVICE}-protocol]=${PROTOCOLS[https]}
			else
				ANSWERS[${REDCHECK_CLEANUP_SERVICE}-protocol]=${PROTOCOLS[http]}
			fi
	
			if [ -n "${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]}" ]; then
				_defval=${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]}
			else
				if [[ "${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-protocol]}" = "${PROTOCOLS[http]}" ]]; then
					_defval=${DEFAULT_PORTS[default_${REDCHECK_CLEANUP_SERVICE}_port]}
				else
					_defval=${DEFAULT_PORTS[default_${REDCHECK_CLEANUP_SERVICE}_ssl_port]}
				fi
			fi
			repeat_config "$web_stage_enter_rest_port" "${REDCHECK_CLEANUP_SERVICE}-port" port true $_defval
			if [ $? -eq 1 ]; then _is_config_interrupted=true; break; fi
	
			if [[ "${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-protocol]}" = "${PROTOCOLS[https]}" ]]; then
				config_site_https ${_CN} ${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]} $APACHE_CONF_CLEANUP_SSL_FILE_NAME $APACHE_CONF_CLEANUP_FILE_NAME $CLEANUP_CRT_FILE $CLEANUP_KEY_FILE
			else
				config_site_http ${_CN} ${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]} $APACHE_CONF_CLEANUP_SSL_FILE_NAME $APACHE_CONF_CLEANUP_FILE_NAME
			fi
			config_semanage ${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]}
			cleanup_configure_cmd=`sudo DOTNET_BUNDLE_EXTRACT_BASE_DIR=/var/opt/${REDCHECK_CLEANUP_SERVICE}/.net -u redcheck ${REDCHECK_CLEANUP_SERVICE} api -a "${ANSWERS[${REDCHECK_API}-protocol]}://${_CN}:${ANSWERS[${REDCHECK_API}-port]}" -u "${ANSWERS[rc-admin-login]}" -p "${ANSWERS[rc-admin-password]}"`
			if [ $? -eq 0 ]; then
				print_message "Строка подключения службы очистки сохранена в конфигурационном файле" 0 1
			else
				print_message ${Red}"Произошла ошибка при конфигурации подключения службы очистки к ${REDCHECK_API}"${Color_Off} 0 1
			fi
		fi
	
		if ${INSTALLED[$REDCHECK_CLIENT]}; then
			local update_settings_cmd=$( sudo -u redcheck ${REDCHECK_CLIENT} configure -c "${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-protocol]}://${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-url]}:${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]}")
			if [ $? -eq 0 ]; then		
				print_message "В <${REDCHECK_CLIENT}> новое значение: 'CleanupService.Url'=${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-protocol]}://${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-url]}:${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]}" 2 0
			else
				print_message "Ошибка <${update_settings_cmd}> при сохранении параметра 'CleanupService.Url'=${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-protocol]}://${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-url]}:${ANSWERS[${REDCHECK_CLEANUP_SERVICE}-port]} в файл <${REDCHECK_CLIENT}>" 2 0
			fi
		fi
	
		CONFIGURED[$REDCHECK_CLEANUP_SERVICE]=true
	done

	if ! $_is_config_interrupted; then
		services enable ${REDCHECK_CLEANUP_SERVICE}
		services restart ${REDCHECK_CLEANUP_SERVICE}
		services restart ${REDCHECK_API}
		services restart ${REDCHECK_CLIENT}
		services restart ${web_server}
		status="успешно"
		Color=$Green
	else
		status="прервана"
		Color=$Yellow
	fi
	echo_footer $Color "$stage_title ${REDCHECK_CLEANUP_SERVICE} $status" 0 1
}

config_all(){
local _comp_name
  for i in "${!COMPONENTS[@]}"; do
	_comp_name=${COMPONENTS[$i]}
	if ${INSTALLED[${_comp_name}]}; then
	  CONFIGURED[${_comp_name}]=false
	  _is_config_interrupted=false
	  while ! ${CONFIGURED[${_comp_name}]} && ! $_is_config_interrupted; do
			if ${INSTALLED[${_comp_name}]}; then
		  	${COMPONENTS_ACTION[${_comp_name}]}
	    fi
	  done
	  if ! $is_db_updated; then
			print_message "Конфигурация остановлена из-за ошибки обновления БД." 2 0
			break
	  fi
	fi
  done
}

close_config(){
  echo_header $Green "Выход из режима конфигурирования" 1 0
  print_message "Выход из режима конфигурирования" 2 0
  continue_configuration=false
  exit 1
}

#Start user dialog
check_params $@
cp_ec=$?
clear
if ${PARAMETERS[help]};then
  echo_header $Green "$Welcome" 0 1
  print_message "Конфигуратор компонентов RedCheck\nВозможны следующие параметры:\n" 1 0
  print_message " ${Green}advanced_setup${Color_Off}\t - (параметр не обязателен), активирует дополнительные параметры конфигурирования ${db_stage_title}." 1 0
  print_message " ${Green}secret_save${Color_Off}\t - (параметр не обязателен), при вводе пароля, оный сохраняется в лог файл" 1 0
  print_message " ${Green}${CONFIGURE_ACTION}${Color_Off}\t - (параметр не обязателен), активируется командный режим конфигурирования с помощью параметров.\n\t\t	Командный режим доступен для модулей: ${REDCHECK_SCAN_SERVICE} и ${REDCHECK_SYNC_SERVICE}\n\t\t	Синтаксис:\n\t\t	configure ${REDCHECK_SCAN_SERVICE} db_user=ИМЯ_ПОЛЬЗОВАТЕЛЯ db_password=ПАРОЛЬ_БД db_host=IP_БД db_port=ПОРТ db_database=ИМЯ_БД *sckd=КЛЮЧ_ШИФРОВАНИЯ svc_name=ИМЯ_СЛУЖБЫ\n\t\t	configure ${REDCHECK_SYNC_SERVICE} db_user=ИМЯ_ПОЛЬЗОВАТЕЛЯ db_password=ПАРОЛЬ_БД db_host=IP_БД db_port=ПОРТ db_database=ИМЯ_БД *sckd=КЛЮЧ_ШИФРОВАНИЯ\n\t\t	${Yellow}* - опциональный параметр. все значения параметров регистрозависимы.${Color_Off}\n" 1 0
  print_message " ${Green}help${Color_Off}\t\t - показывает данное сообщение.\n" 1 0
  echo_footer "" " Версия файла: ${script_version}\n\n" 1 0
elif ${PARAMETERS[configure]};then
  if [ $cp_ec -eq 0 ];then
	print_message "Выполняем конфигурацию в командном режиме" 2 0
	common_func
	print_menu "" 3 "${available_str} ${actions}:"
	${action_menu[${CONFIGURABLE_COMPONENTS[$module_name]}]}
	print_message "Выполнена конфигурация в командном режиме" 2 0
  else
	print_message "Командный режим конфигурирования не поддерживается для указанного модуля" 1 0
  fi
else
  print_message "${cn}" 2 0
  echo_header $Green "$Welcome" 0 1
  print_message ${Red}" красный ${Color_Off} - критичное сообщение либо ошибка выполнения команды" 1 0
  print_message ${Yellow}" желтый${Color_Off}   - важное замечание требующее действия от пользователя" 1 0
  print_message ${Green}" зеленый${Color_Off}  - успешное выполнение команды либо статус выполнения конфигурации" 1 0
  echo_footer "" " [*] - диапазон допустимых значений${cn} (*) - значение по умолчанию" 1 0
  ${cn}
  
  common_func
  print_menu "" 3 "${available_str} ${actions}:"
  
  while $continue_configuration; do
  check_no_empty_value "Выберите действие $cur_bounds_list:" choise range
  print_block_delimeter
  if [ $? -eq 0 ];then
	${action_menu[${ANSWERS[choise]}]}
	print_menu "" 3 "${available_str} ${actions}:"
  else
	print_message "Ошибка ввода" 1 0
  fi
  done
fi
