description = [[ Checking Netcheck agent is using specific port. ]]

---
-- @usage
-- nmap --script NetcheckAgent -p8731 <host>
--
-- @output
-- | NetcheckAgent: true
----------------------------------------------------------

author = "Alexandr Ruchkin"
license = "Same as Nmap--See https://nmap.org/book/man-legal.html"
categories = {"discovery", "safe", "version"}

local shortport = require "shortport"
local stdnse = require "stdnse"

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = function (host, port) 
		if nmap.version_intensity() < 7 or nmap.port_is_excluded(port.number, port.protocol) then
		  return false
		end
		  return port.number == 8731
		end  
else portrule = function(host,port) return true end
end



action = function(host, port)

local socket = nmap.new_socket()
socket:set_timeout(1000)

local status, err = socket:connect(host, port)

--    
if status == nil then
  socket:close()
  return "Connection Error"
end

if not status then
  socket:close()
  return false
end

local endPoint = "net.tcp://" .. host.ip .. ":" .. port.number .. "/NetCheckBuffered"

local status, err = socket:sendto(host.ip, port.number,  "  " .. string.char(string.len(endPoint)) .. endPoint .. "" )

if not status then
  socket:close()
  return false
end 

local status, err = socket:sendto(host.ip, port.number,   "\tapplication/negotiate")

if not status then
  socket:close()
  return false
end 

status, data = socket:receive()

if not status then
  socket:close()
  return false
end

socket:close()

result = data=="\n"

if result then
   port.version.product = "Netcheck agent"
   port.version.name = "NetcheckAgentWCF"
   nmap.set_port_version(host, port, "hardmatched")
end

return result
end