description = [[ Queries Redcheck web client /account/loginview page to extract the product version. ]]

---
-- @usage
-- nmap --script RedcheckWebClient -p8080 <host>
--
-- @output
-- | RedcheckWebClient:
-- |   Redcheck web client version: 2.6.7.0
----------------------------------------------------------

author = "Alexandr Ruchkin"
license = "Same as Nmap--See https://nmap.org/book/man-legal.html"
categories = {"discovery", "safe", "version"}

local http = require "http"
local nmap = require "nmap"
local shortport = require "shortport"
local stdnse = require "stdnse"

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
portrule = shortport.http 
else portrule = function(host,port) return true end
end

action = function(host, port)

  local loginPage = http.get(host, port, "/account/loginview")

  if loginPage.status ~= 200 then
    return "ERROR: wrong status '" .. tostring(loginPage.status) .. "' for /account/loginview page"
  end

  local clientVersion = string.match(loginPage.body, 'Консоль: ([%d%.]*)')

  if clientVersion ~= nil then
    return "Redcheck web client version: " .. clientVersion
  else 
    return "ERROR: No Redcheck web client version found"
  end

end