local http = require "http";
local shortport = require "shortport";
local stdnse = require "stdnse";
local string = require "string";

description = [[    
At a specific address (/server-status/), 
if the server responds collects the necessary information
]]

--@output
--altx-soft_http-ApacheInformation: 

--|   Server Version : Apache/2.4.18 (Ubuntu)

--|   Server Built   : 2020-08-12T21:35:50

--|   Restart Time   : Friday, 17-Dec-2021 12:01:58 MSK

categories = {"default", "discovery", "safe"}

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

--local headRegex = {
   -- "[Ss][Ee][Rr][Vv][Ee][Rr]%s*[Vv][Ee][Rr][Ss][Ii][Oo][Nn]%s*",
   -- "[Ss][Ee][Rr][Vv][Ee][Rr]%s*[Bb][Uu][Ii][Ll][Tt]%s*",
   -- "[Rr][Ee][Ss][Tt][Aa][Rr][Tt]%s*[Tt][Ii][Mm][Ee]%s*",
   -- "[Ss][Ee][Rr][Vv][Ee][Rr]%s*[Uu][Pp][Tt][Ii][Mm][Ee]%s*"
--}

action = function(host, port)
    stdnse.debug1("Scaning url 'server-status'");
    local output_tab = stdnse.output_table();
    local response = http.get(host, port, "/server-status/");

    if not(response.body) then 
        stdnse.debug1("Response body is empty");
        return nil;
    end
        --server version
        local  row1,data1 = string.match(response.body, "<dt>([Ss][Ee][Rr][Vv][Ee][Rr]%s*[Vv][Ee][Rr][Ss][Ii][Oo][Nn])%s*:%s*(.-)%s*</dt");
        
        if not(row1 == nil) and not(data1 == nil) then
            local formatData1 = string.format( "%s : %s",row1, data1);
            output_tab[#output_tab+1] = formatData1;
        end
       
        --server built
        local  row2,data2 = string.match(response.body, "<dt>([Ss][Ee][Rr][Vv][Ee][Rr]%s*[Bb][Uu][Ii][Ll][Tt])%s*:%s*(.-)%s*</dt");
        
        if not(row2 == nil) and not(data2 == nil) then
            local formatData2 = string.format( "%s : %s",row2, data2);
            output_tab[#output_tab+1] = formatData2;
        end
        --restart time
        local  row3,data3 = string.match(response.body, "<dt>([Rr][Ee][Ss][Tt][Aa][Rr][Tt]%s*[Tt][Ii][Mm][Ee])%s*:%s*(.-)%s*</dt");

        if not(row3 == nil) and not(data3 == nil) then
            local formatData3 = string.format( "%s : %s",row3, data3);
            output_tab[#output_tab+1] = formatData3;
        end
        
       return output_tab;
end
