description = [[ Queries MS exchange owa page to extract the version information. ]]

---
-- @usage
-- nmap --script exchange-version -p443 <host>
--
-- @output
-- | exchange-version:
-- |   Exchange version: 15.0.1496
----------------------------------------------------------

author = "Alexandr Ruchkin"
license = "Same as Nmap--See https://nmap.org/book/man-legal.html"
categories = {"discovery", "safe", "version"}

local http = require "http"
local nmap = require "nmap"
local shortport = require "shortport"
local stdnse = require "stdnse"

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

action = function(host, port)

  local owaPage = http.get(host, port, "/owa", { timeout = 5000 })

  if owaPage.status ~= 200 then
    return "ERROR: wrong status '" .. tostring(owaPage.status) .. "' for /owa page"
  end

  local exchangeVersion = string.match(owaPage.body, '/owa[/auth]+(%d+%.%d+%.%d+)')

  if exchangeVersion ~= nil then
    return "Exchange version: " .. exchangeVersion
  else 
    return "ERROR: No exchange version found"
  end

end