local http = require "http"
local nmap = require "nmap"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"

description = [[
Скрипт для получения версий cms
]]

---
-- @usage
-- nmap -p80,443 --script http-cms-versions <host/ip>
---

author = "Olga Platova"
categories = {"discovery"}

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port)	return true end
end

local lowercase = function (p)
  return (p or ''):lower()
end
local safe_string = function (p)
  return p or ''
end

function response_body_contains(response, pattern, case_sensitive)
  local m
  -- If they're searching for the empty string or nil, it's true
  if(pattern == '' or pattern == nil) then
    return true
  end
  -- Create a function that either lowercases everything or doesn't, depending on case sensitivity
  local case = case_sensitive and safe_string or lowercase

  -- Set the case of the pattern
  pattern = case(pattern)
  
  m = {string.match(case(response['body']), pattern)}
  if(m and #m > 0) then
    return true, m
  end

  return false
end

action = function(host, port)

	local output_tab = stdnse.output_table()
	   
	local response = http.get(host, port, "/", {redirect_ok=true})
	
	-- Drupal
	if http.response_contains(response, "drupal") and  http.get(host, port, "/user", {redirect_ok=false}).status == 200 then
		response = http.get(host, port, "/CHANGELOG.txt", {redirect_ok=false})
		regexp = "Drupal ([%d%.]+)%p [%d%-]+"
		if response.status == 200 then 
			result, version =  response_body_contains(response, regexp, false)
			if result then
				output_tab["Drupal version"] = version[1]:gsub("%s+", "")
			end
		end
	end   
	
	--Joomla
		if http.response_contains(response, "joomla") then
		response = http.get(host, port, "/language/en-GB/en-GB.xml")
		regexp = "<version>([%d%.]+)</version>"
		if response.status == 200 then 
			result, version =  response_body_contains(response, regexp)
			if result then
				output_tab["Joomla version"] = version[1]:gsub("%s+", "")
			end
		end
	end 
	
	-- UMI cms
	if http.response_contains(response, "images/cms") and  http.get(host, port, "/autoupdate", {redirect_ok=false}).status ~= 404 then
		response = http.get(host, port, "/autoupdate/service/version", {redirect_ok=true})
		if response.status == 200 then 
			--result, version =  response_body_contains(response, regexp)
			version = response.body
			if version then
				output_tab["UMI cms version"] = version:gsub("\n", " ")
			end
		end
	end 
	
	  return output_tab
  end
 