description = [[
This script is rebound in the request header with the host field by the generated domain.
 And if the server responds with 200 status code, then it is vulnerable
]]

-- @output
--PORT   STATE SERVICE
--80/tcp open  http
--| http-dns-rebinding: 
--|_  DNS_rebinding: The server is vulnerable (domain rebinding nlndqctt.com)

author = "Alex Petrov"

local os = require "os"
local http = require "http"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"
local string = require "string"


local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

local function GenerHost()
    math.randomseed(os.time())
    local tabChar = {}

    for i = 1 , 8 do  
        local char = string.char( math.random(97, 122))
        tabChar[i] = char
    end

    if(#tabChar ~= 0) then
        local nameHost = table.concat( tabChar, "")
        local rebindingHost = nameHost .. ".com"
        return rebindingHost
    end
    return " "
end

action = function(host, port)
    local output_tab = stdnse.output_table()
    local hostName = GenerHost()

    local resp = http.get(host, port, "/", {header = {Host = hostName}})

    if(resp.status and resp.status == 200) then
        output_tab["DNS_rebinding"] = string.format( "The server is vulnerable (domain rebinding %s)", hostName)
        return output_tab
    end
    return nil
end