local http = require "http";
local shortport = require "shortport";
local stdnse = require "stdnse";
local string = require "string";

categories = {"default", "discovery", "safe"};

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

local Urls = {
    "/apex/f?p=4950",
    "/i/"
}

local Regexs = {
    "alt%s*=%s*\".*\"/>(.-)</span",
    "[Aa][Pp][Pp][Ll][Ii][Cc][Aa][Tt][Ii][Oo][Nn]%s*[Ee][Xx][Pp][Rr][Ee][Ss][Ss]%s*[Vv][Ee][Rr][Ss][Ii][Oo][Nn]:%s*(.*)"
}
  
action = function(host, port)
    local output_tab = stdnse.output_table();
    stdnse.debug1("Scaning");

    for _,url in ipairs(Urls) do
        local response = http.get(host, port, url)

        if not(response.body) then 
            stdnse.debug1("Missing response body");  
            break;         
        end

        for k,regex in ipairs(Regexs) do 
            local version = string.match( response.body, regex);
            if version == nil or version == "" then
                stdnse.debug1("Missing version or does not fit the regular expression");               
            end

            if not(version == nil) and not(version == "") and k ==1  then
                output_tab[#output_tab+1] = version;
            end

            if not(version == nil) and not(version == "") and k == 2 then
                version = string.format( "Oracle Application Express %s", version )
                output_tab[#output_tab+1] = version;
            end       
        end
    end

    return  output_tab;
end