description = [[
    
    Determining the version of phpmyadmin using the web interface.
]]

-- @output
--PORT   STATE SERVICE REASON
--80/tcp open  http    syn-ack ttl 60
--| altx-soft_webVersion-phpmyadmin: 
--|_  VERSION: phpMyAdmin 2.11.3deb1ubuntu1

author = "Alex Petrov"

local http = require "http"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"
local string = require "string"


local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

local paths  = {
    "/phpmyadmin/",
    "/myadmin/"
}

local regxs = {
    "<[Hh]1>%s*.*>(.-)%s*</%s*[Bb][Dd][Oo]%s*>"
}

action = function(host, port)
    local output_tab = stdnse.output_table()

    for _, path in ipairs(paths) do
        local response = http.get(host, port, path)
        if(response.status == 200 and response.body) then       
            for _, regx in ipairs(regxs) do
                local version = string.match(response.body, regx)
                if(version ~= nil and version ~= '') then output_tab['VERSION'] = version return output_tab end 
            end
        end
    end
    return nil 
end