description = [[
    
Determining the version of Apache Tomcat from a non-existent page.
]]

-- @output
--PORT     STATE SERVICE VERSION
--8080/tcp open  http    Apache Tomcat
--| altx-sof_http-versionApacheTomcat404: 
--|_  version: Apache Tomcat/8.5.54 (Debian)

author = "Alex Petrov"

local os = require "os"
local http = require "http"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"
local string = require "string"

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

action = function(host, port)
    local output_tab = stdnse.output_table();
    local URL_404_1 = '/nmaplowercheck' .. os.time(os.date('*t'))

    local response = http.get(host, port, URL_404_1)

    if(response.status == 404 and response.body) then
        local result = string.match( response.body, "<[Hh]3>%s*(.-)%s*</" ) 

        if(result) then
            output_tab["version"] = result
            return output_tab
        else
            stdnse.debug2("Title tag is missing Apache Tomcat version")
        end
    else
        stdnse.debug2( string.format( "The status code for the given path %s is not 404", URL_404_1 ))
    end
    return nil
end

