description = [[
    
    Determining the version of Gitea
]]

-- @output
--PORT    STATE SERVICE
--443/tcp open  https
--| altx-soft_http_versionGitea: 
--|_  product_version: Gitea Version: 1.16.2

author = "Alex Petrov"

local http = require "http"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"
local string = require "string"

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.port_or_service( {80, 443, 3000}, {"http", "https"}, "tcp", "open")
else portrule = function(host,port) return true end
end

local _regex_version = { 
    "[Pp][Oo][Ww][Ee][Rr][Ee][Dd]%s*[Bb][Yy]%s*([Gg][Ii][Tt][Ee][Aa]%s*.-)%s*[Pp][Aa][Gg][Ee]"
    
}

local _regex_lang = {
    "<span%s*class=%s*\"%s*version%s*\"%s*>%s*(.-)%s*<%s*/span%s*>"
}

action = function(host, port)
    local output_tab = stdnse.output_table();
    local response = http.get(host, port, "/")

    if(response.status ~= 200 ) then 
        stdnse.debug2( "The status code for the given path  is not 200")
        return nil
    end

    for _, reg in ipairs(_regex_version) do
        local result = string.match( response.body, reg) 
        
        if(result) then
            local string_out  
            for _, lang in ipairs(_regex_lang) do
                local res_lang = string.match(response.body, lang)

                if(res_lang) then 
                    string_out = result .. string.format( " (%s)", res_lang ) 
                else
                    string_out = result
                end               
            end
            output_tab["product_version"] = string_out
            return output_tab
        else
            stdnse.debug2("Title tag is missing Gitea version")            
        end
    end
    return nil
end		