local http = require "http"
local url = require "url"
local nmap = require "nmap"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"
local httpspider = require "httpspider"

description = [[
Скрипт предназначен для получения версий библиотеки JQuery и других библиотек и плагинов Javascript
]]

---
-- @usage
-- nmap -p80,443 --script http-jquery-version <host/ip>
---
author = "Olga Platova"
categories = {"discovery"}

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port)	return true end
end

-- Функция для получения версии из ссылки. Пока решили не использовать, так как инфа не 100%
 -- function get_version_from_url (response, regexp, version_pattern)
	-- local version
		-- result, matches =  response_body_contains(response, regexp)
		-- if result then
			-- for a, b in pairs(matches) do
				-- for k, v in pairs(version_pattern) do	
					-- version = string.match(b, v) 
					-- if version then
						-- return version
					-- end	
				-- end	
			-- end
		-- end	
 -- end

 function get_version(host, port, response, regexp, version_pattern)
		
   local result, matches
	 local script_res
	 local versions  = {}
	 local version
	 result, matches =  response_body_contains(response, regexp, true, false)
     if result then
			for i, b in ipairs(matches) do
				-- For internal relative links
					if  not string.match(b, "https?") and not string.starts(b, "/") then
						b = "/".. b
					end	
					script_res = http.get(host, port, b)
					if(script_res.status == 301) then
						if(host.name or host == get_host(script_res.header.location)) then
							resp = http.get_url(script_res.header.location)
							if(resp.status == 200) then
								result, version = response_body_contains(resp, version_pattern, false, true)
							end
						end	
					end	
					if(script_res.status == 200) then
						result, version = response_body_contains(script_res, version_pattern,  false, true)	
					end
					
				-- For links like "//ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js"
				if string.starts(b, "//")  and not string.match(b, "https?") then
					b = "https:" .. b
					script_res = http.get_url(b)
					if(script_res.status == 200) then
						result, version = response_body_contains(script_res, version_pattern, false, true)
					end
				end
				
				-- For external links starting with http(s)
				if string.match(b, "http[s]?") then
					script_res = http.get_url(b)
					if(script_res.status == 301) then
						if(get_host(b) == get_host(script_res.header.location)) then
							resp = http.get_url(script_res.header.location)
							if(resp.status == 200) then
								result, version = response_body_contains(resp, version_pattern, false, true)
							end
						end	
					end	
					if(script_res.status == 200) then
						result, version = response_body_contains(script_res, version_pattern, false, true)
					end		
				end
			table.insert(versions, version)	
			end
			if  #versions > 0 then	
				return versions	
			end	
		end	
	end

function string.starts(String,Start)
   return string.sub(String,1,string.len(Start))==Start
end

local lowercase = function (p)
  return (p or ''):lower()
end
local safe_string = function (p)
  return p or ''
end


function response_body_contains(response, pattern, getallmatches, lowercase)
  local m = {}
	
	if(getallmatches == '' or getallmatches == nil) then
		getallmatches = false
	end
  -- If they're searching for the empty string or nil, it's true
	if(pattern == '' or pattern == nil) then
		return true
	end
  -- Create a function that either lowercases everything or doesn't, depending on case sensitivity
    --local case = case_sensitive and safe_string or lowercase

  local body = response.body
  body = string.gsub(body, "<!%-%-.-%-%->", " ")
  
  if (lowercase == true) then
	pattern = pattern:lower()
	body = body:sub(1, 200):lower()
  end
	
	body = string.gsub(body, "&#x2f;", "/")
	
	if(getallmatches) then
		for w in string.gmatch(body, pattern) do 
			table.insert(m, w)                         
		end	
	else
		m = {string.match(body, pattern)}
	end
   -- m = {string.gmatch(body, pattern)}

	if(m and #m > 0) then
		return true, m
	end
  return false, nil
end

 function plugin_version(host, port, response, version_pattern, regexp)
	local versions ={}
	for _, pattern in pairs (version_pattern) do
		versions = get_version(host, port, response, regexp,  pattern)

	-- if not version then
		-- version = get_version_from_url(response, pattern, version_pattern)
	-- end
		if (versions and #versions > 0) then	
			for i,v in ipairs (versions) do
				 if type(v) == "table" then
					 versions[i] = v[1]:gsub("%s+", "")
				 end
			end	
			return versions	
		end
	end
end

  
	removewww = function(url) return string.gsub(url, "www%.", "") end
	removehttp = function(url) return string.gsub(url, "^https?:%/%/", "") end
	
    function get_host (h)
		if (h:match("^https?:%/%/")) then
			h = removehttp(h)
		end	
		if (h:match("www%.")) then
			h = removewww(h)
		end	
		return (h:match("[^/]+") or h):lower()
	end
	
	function check_version_exist(tab, arg )
		for k, v in pairs(tab) do
			if v:match(arg) then
				return true
			end
		end
		return false
	end
	
	function recurse_redirect (current_url, path, port, regexps, version_patterns, output_tab,i)
		if(get_host(current_url) == get_host(path)) then -- проверяем, что редирект не послыает нас на другой хост
			local resp = http.get_url(path)
			-- Если body слишком большое, то берем обрезанное body из response.incomplete, и вручную присваиваем статус 200, так как при ошибке он будет nil
			if (resp.incomplete) then
				resp.body = resp.incomplete.body
				resp.status = 200
			end	
			local parsed = url.parse(path)
			if (resp.status == 200 and resp.body ~= nil)then
				for key, value in pairs(regexps) do	
					for k, v in pairs(value) do
						local versions = plugin_version(parsed.host, parsed.port or port, resp,  version_patterns[key], v)
						 if (versions and #versions > 0) then
							for _,v in pairs (versions) do
								if not check_version_exist(output_tab, key.." "..v) then
									table.insert(output_tab, key.." "..v)
								end
							end
						 end
					end 
				end	
				return true
			end	
			
			if(resp.status == nil) then
				stdnse.debug1("Error: Response status is nil")	
				return true
			end
			while (resp.status == 301 or resp.status == 302) do
				stdnse.debug1("Calling recurse_redirect ... %d time", i)
				i = i+1
				if (i > 3) then
					stdnse.debug1('Too many redirects!')
					break
				end
				local result = recurse_redirect (path, resp.header.location, port, regexps, version_patterns, output_tab,i)
				if result then break end
			end
			return true
		end
	end

action = function(host, port)

	local output_tab = {}
	--output_tab["Host"] = stdnse.get_hostname(host)
	local prefix = "[%w%.%/%-:_@]*"
	local postfix = "%.js[%w=%-%?%.]*"
	local ver = "_?%-?[%d%.]+"
	local regexps = {
						jquery = {prefix.."jquery[%.slim]*[%.min]*"..postfix,
										 prefix.."jquery[%-?_?lates]*[%.min]*"..postfix,
										 prefix.."jquery"..ver.."[%.min]*"..postfix,
										 prefix.."main[%.min]*"..postfix,
										 prefix.."jquery[%.min]*"..ver..postfix},
						jquery_ui = {prefix.."jquery.?ui[%-%.mincore]*"..postfix, prefix.."jquery.?ui"..ver.."[%.custom]*[%-%.mincore]*"..postfix},										 
						jquery_cookie = {prefix.."jquery.?cookie[%-%.%a]*"..postfix, prefix.."js.?cookie[%-%.%a]*"..postfix},																	
						angular = {prefix.."angular[%-%.%a]*"..postfix},
						bootstrap = {prefix.."bootstrap[%.bundle]*[%.min]*"..postfix, prefix.."bootstrap[%.min]*"..ver..postfix},
						lodash = {prefix.."lodash[%-%.%a]*"..postfix},
						mootools = {prefix.."mootools[%-%.%a]*"..postfix},
						file_upload = {prefix.."jquery.file.?upload[%-%.%a]*"..postfix},
						jquery_validate	= {prefix.."jquery.validate[%-%.%a]*"..postfix, prefix.."validation[%-%.%a%d]*"..postfix},
						tinymce	= {prefix.."tinymce[%-%.%a]*"..postfix}	
 }
		
	  local version_regexp = "(%d%.%d%d?%.?%d?%d?)"
	  local version_patterns = {
								  jquery = {"jquery:?[%sjvascptlibry]*%-?%s*[\"v]?"..version_regexp},
								  jquery_ui = {"jquery.?ui%s*%-?%s*[\"v]?"..version_regexp},
								  jquery_cookie = {"j%a+[%.%-_]cookie%s*%a*%s*[\"v]?"..version_regexp},
								  angular = {"angular.?[js]?%s*[\"v]?"..version_regexp},
								  bootstrap = {"bootstrap%s*[\"v]?"..version_regexp},
								  lodash = {"lodash%s*[\"v]?"..version_regexp},
								  mootools = {"mootools=?{?%a*:?%s?[\"v]?"..version_regexp},
								  file_upload = {"file.?upload%s*[\"v]?"..version_regexp},
								  jquery_validate = {"jquery.?validat%a-%s*%a*%-?%a*%s*%-?%s*[\"v]?"..version_regexp},
								  tinymce = {"[version:]*%s*"..version_regexp}
	  }
	 
	  local crawler = httpspider.Crawler:new(host, port, '/', { redirect_ok = true, scriptname = SCRIPT_NAME,
	  withinhost = true, 
      maxpagecount = stdnse.get_script_args('httpspider.maxpagecount') or 20,
      maxdepth = stdnse.get_script_args('httpspider.maxdepth') or 3,
    })
  
    crawler.options.withinhost = function(url)
    if crawler:iswithinhost(url)
      and not crawler:isresource(url, "js")
      and not crawler:isresource(url, "css") then
      return true
    end
  end

  if (not(crawler)) then
    return
  end
  
    crawler:set_timeout(10000)
	
	while (true) do
		local status, r = crawler:crawl()
		-- if the crawler fails it can be due to a number of different reasons
		-- most of them are "legitimate" and should not be reason to abort
		if (not(status)) then
		  if (r.err) then
			return stdnse.format_output(false, r.reason)
		  else
			break
		  end
		end

		if(r.url.host ~= stdnse.get_hostname(host) and r.url.host ~= host.ip) then goto continue end
		local response = r.response
		local current_url = r.url.host .. r.url.path
		if (response.incomplete) then
				response.body = response.incomplete.body
				response.status = 200
			end	
		 if(response.status == 200) then	
			for key, values in pairs(regexps) do		
				for k, v in pairs(values) do
					local versions = plugin_version(host, port, response,  version_patterns[key], v)
					if (versions and #versions > 0) then
						for _,v in pairs (versions) do
							if not check_version_exist(output_tab, key.." "..v) then
								table.insert(output_tab, key.." "..v)
							end
						end	
					end
				end
			end
		  end	 
		  if(response.status == 404) then
			  stdnse.debug1("Error 404: Page not found")	
		  end		  
	   if(response.status == 301 or response.status == 302) then		
			recurse_redirect(current_url, response.header.location, port, regexps, version_patterns, output_tab,1)
	   end
		::continue::	
	end 
	return output_tab  
  end
