var HostsRemediationController = {
    filter: {
        hostNameSearchText: '',

        showHostsWithNewVulnerabilities: true,
        showHostsWithoutNewVulnerabilities: true,
        showHostsWithRemediatedVulnerabilities: true,
        showHostsWithoutRemediatedVulnerabilities: true
    },

    statistics: {
        hostsWithNewVulnerabilitiesCount: true,
        hostsWithoutNewVulnerabilitiesCount: true,
        hostsWithRemediatedVulnerabilitiesCount: true,
        hostsWithoutRemediatedVulnerabilitiesCount: true
    },

    reloadHostsGrid: function () {
        HostsRemediationController.cleanStatistics();
        const table = document.getElementById('hostsGrid');
        if ($.fn.DataTable.isDataTable(table)) {
            $(table).dataTable().api().ajax.reload();
        }
    },

    onHostNameFilterChanged: debounce(function (input) {
        HostsRemediationController.filter.hostNameSearchText = input.value;
        HostsRemediationController.reloadHostsGrid();
    }, 500),

    onShowHostsWithNewVulnerabilitiesFilterChanged: debounce(function (value) {
        HostsRemediationController.filter.showHostsWithNewVulnerabilities = value;
        HostsRemediationController.reloadHostsGrid();
    }, 500),

    onShowHostsWithoutNewVulnerabilitiesFilterChanged: debounce(function (value) {
        HostsRemediationController.filter.showHostsWithoutNewVulnerabilities = value;
        HostsRemediationController.reloadHostsGrid();
    }, 500),

    onShowHostsWithRemediatedVulnerabilitiesFilterChanged: debounce(function (value) {
        HostsRemediationController.filter.showHostsWithRemediatedVulnerabilities = value;
        HostsRemediationController.reloadHostsGrid();
    }, 500),

    onShowHostsWithoutRemediatedVulnerabilitiesFilterChanged: debounce(function (value) {
        HostsRemediationController.filter.showHostsWithoutRemediatedVulnerabilities = value;
        HostsRemediationController.reloadHostsGrid();
    }, 500),

    openVulnerabilitiesByHost: function () {
        let $this = $(this);
        let hostName = $this.attr('data-host-name');

        HostVulnerabilityController.cleanAdditionalInfoOnPage();

        let secondNavTab = document.getElementById('hostsNavTab');
        secondNavTab.classList.remove('active');
        let thirdNavTab = document.getElementById('hostVulnerabilityNavTab');
        thirdNavTab.classList.add('active');

        let secondTab = document.getElementById('hostsTab');
        secondTab.classList.remove('active');
        let thirdTab = document.getElementById('hostVulnerabilityTab');
        thirdTab.classList.add('active');

        let hostVulnerabilityHostNameFilter = document.getElementById('hostVulnerabilityHostNameFilter');
        hostVulnerabilityHostNameFilter.value = hostName;
        HostVulnerabilityController.onHostNameFilterChanged(hostVulnerabilityHostNameFilter);
    },

    updateStatistics: function (json) {
        if (!Array.isArray(json.data)) {
            $('#hostWithoutRemediatedVulnerabilitiesCount').html(json.data.HostWithoutRemediatedVulnerabilitiesCount);
            $('#hostWithoutNewVulnerabilitiesCount').html(json.data.HostWithoutNewVulnerabilitiesCount);
            $('#hostWithRemediatedVulnerabilitiesCount').html(json.data.HostWithRemediatedVulnerabilitiesCount);
            $('#hostWithNewVulnerabilitiesCount').html(json.data.HostWithNewVulnerabilitiesCount);

            if (json.data.UnsuccessfulScanIdsCount > 0) {
                $('#unsuccessfulScanIdsCount').html(json.data.UnsuccessfulScanIdsCount);
                $('#unsuccessfulScanIdsMessage').html(json.data.UnsuccessfulScanIdsMessage);
                let link = '/analyticsforms/unavailabilityreasons';
                let query = '';
                json.data.UnsuccessfulScanIds.forEach((scanId)=>
                    query+='&ScanIds='+scanId.toString()
                );
                query = query.substring(1);
                link = link + '?' + query;
                var a = document.getElementById('unsuccessfulScanIdsMessage');
                a.setAttribute("href", link);
                document.getElementById('warningBoxBlock').classList.remove('hide');
            }
        }
        else {
            HostsRemediationController.cleanStatistics();
        }
    },

    cleanStatistics: function () {
        $('#hostWithoutRemediatedVulnerabilitiesCount').html(0);
        $('#hostWithoutNewVulnerabilitiesCount').html(0);
        $('#hostWithRemediatedVulnerabilitiesCount').html(0);
        $('#hostWithNewVulnerabilitiesCount').html(0);

        $('#unsuccessfulScanIdsCount').html(null);
        $('#unsuccessfulScanIdsMessage').html(null);

        document.getElementById('warningBoxBlock').classList.add('hide');
    },

    exportDataToCsv: function () {
        let query = '';

        if (VulnerabilityRemediationControlController.filter.newJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать задание, сканирования и применить фильтр');
            return;
        }

        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId === true && jobExecutionPicker.oldJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать задание, сканирования и применить фильтр');
            return;
        }

        if (VulnerabilityRemediationControlController.filter.newJobExecutionId)
            query+='&NewJobExecutionId='+VulnerabilityRemediationControlController.filter.newJobExecutionId;
        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId)
            query+='&ChooseExactOldExecutionId='+VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId;
        if (VulnerabilityRemediationControlController.filter.oldJobExecutionId)
            query+='&OldJobExecutionId='+VulnerabilityRemediationControlController.filter.oldJobExecutionId;
        if (VulnerabilityRemediationControlController.filter.useOnlyLastDaysCount)
            query+='&UseOnlyLastDaysCount='+VulnerabilityRemediationControlController.filter.useOnlyLastDaysCount;
        if (VulnerabilityRemediationControlController.filter.hostIds)
            VulnerabilityRemediationControlController.filter.hostIds.forEach((hostId)=>
                query+='&HostIds='+hostId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.groupIds)
            VulnerabilityRemediationControlController.filter.groupIds.forEach((groupId)=>
                query+='&GroupIds='+groupId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.severityTypeIds)
            VulnerabilityRemediationControlController.filter.severityTypeIds.forEach((severityTypeId)=>
                query+='&Severities='+severityTypeId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.cvssScoreMin)
            query+='&CvssScoreMin='+VulnerabilityRemediationControlController.filter.cvssScoreMin;
        if (VulnerabilityRemediationControlController.filter.cvssScoreMax)
            query+='&CvssScoreMax='+VulnerabilityRemediationControlController.filter.cvssScoreMax;
        if (VulnerabilityRemediationControlController.filter.hasExploit)
            query+='&HasExploit='+VulnerabilityRemediationControlController.filter.hasExploit;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInCveDb)
            query+='&IsInCveDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInCveDb;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInBduDb)
            query+='&IsInBduDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInBduDb;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInNkckiDb)
            query+='&IsInNkckiDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInNkckiDb;

        if (VulnerabilityRemediationControlController.filter.dateFrom)
            query+='&PublishedFrom='+VulnerabilityRemediationControlController.filter.dateFrom;
        if (VulnerabilityRemediationControlController.filter.dateTo)
            query+='&PublishedTo='+VulnerabilityRemediationControlController.filter.dateTo;

        if (HostsRemediationController.filter.hostNameSearchText)
            query+='&HostNameSearchText='+HostsRemediationController.filter.hostNameSearchText;

        if (HostsRemediationController.filter.showHostsWithNewVulnerabilities)
            query+='&ShowHostsWithNewVulnerabilities='+HostsRemediationController.filter.showHostsWithNewVulnerabilities;
        if (HostsRemediationController.filter.showHostsWithoutNewVulnerabilities)
            query+='&ShowHostsWithoutNewVulnerabilities='+HostsRemediationController.filter.showHostsWithoutNewVulnerabilities;
        if (HostsRemediationController.filter.showHostsWithRemediatedVulnerabilities)
            query+='&ShowHostsWithRemediatedVulnerabilities='+HostsRemediationController.filter.showHostsWithRemediatedVulnerabilities;
        if (HostsRemediationController.filter.showHostsWithoutRemediatedVulnerabilities)
            query+='&ShowHostsWithoutRemediatedVulnerabilities='+HostsRemediationController.filter.showHostsWithoutRemediatedVulnerabilities;

        if (query)
        {
            query = query.substring(1);
            query = '?' + query;
        }
        window.location = VulnerabilityRemediationControlController.urlForHostsForCsv + query;
    }
}