﻿var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};

var FilterGridViewBase = (function () {
    const SelectMode = {
        Single: 'SINGLE',
        Multi: 'MULTI'
    };

    function FilterGridViewBase(config) {
        this.root = config.root;
        this.defaultOrder = [[1, 'asc']];
        this.url = config.ajax.url;
        this.urlItemsId = config.ajax.urlItemsId;
        this.selectMode = config.style === 'multi' ? SelectMode.Multi : SelectMode.Single;
        this.resetSelectionAfterSearch = config.resetSelectionAfterSearch === false ? false : true;
        this.lastSelectedItem = null;
        this.paging = config.paging === false ? false : true;
        this.data = config.data;
        this.initComplete = config.initComplete !== undefined ? config.initComplete : null;
    }

    FilterGridViewBase.prototype.mount = function (columns) {
        this.$api = $(this.root).DataTable({
            processing: true,
            serverSide: true,
            paging: this.paging,
            pageLength: 20,
            lengthChange: true,
            lengthMenu: [[10, 20, 50, 100, 500], [10, 20, 50, 100, 500]],
            searching: true,
            ajax: {
                url: this.url,
                type: 'POST',
                datatype: 'json',
                dataSrc: 'data'
            },
            select: {
                style: this.selectMode !== SelectMode.Single
                    ? 'multi+shift'
                    : 'single',
                info: false
            },
            selectCustom: {
                urlItemsId: this.urlItemsId,
                onSelectionChanged: onSelectionChanged.bind(this),
                resetSelectionAfterSearch: this.resetSelectionAfterSearch,
            },
            order: this.defaultOrder,
            columns: columns || [],
            data: this.data,
            initComplete: this.initComplete
        });

        if (this.selectMode === SelectMode.Single) {
            this.$api.column(0).visible(false);
        }

        this.$api.table().container().classList.add('hide-search-input');
    };

    FilterGridViewBase.prototype.reload = function () {
        return this.$api.ajax.reload();
    };

    FilterGridViewBase.prototype.deselectAll = function () {
        this.lastSelectedItem = null;
        this.$api.selectCustom().deselectAll();
    };

    FilterGridViewBase.prototype.selectByKeys = function (keys) {
        this.lastSelectedItem = null;

        if (this.selectMode === SelectMode.Multi) {
            this.$api.selectCustom().selectByKeys(keys);
        }
    };

    function onSelectionChanged(e, itemsId) {
        if (this.selectMode === SelectMode.Single) {
            const rows = this.$api.rows({ selected: true }).data().toArray();

            if (rows.length) {
                this.lastSelectedItem = rows[0];
            }
        }
    }

    FilterGridViewBase.prototype.getSelectedItems = function () {
        const selectedItemKeys = this.$api.selectCustom().selectedItemKeys();

        if (!selectedItemKeys.length)
            return [];

        if (this.selectMode === SelectMode.Single) {
            const item = {
                id: this.lastSelectedItem.Id,
                name: this.lastSelectedItem.Name
            };

            return [item];
        }

        return selectedItemKeys.map(function (itemId) {
            return { id: itemId };
        });
    };

    FilterGridViewBase.prototype.search = $.fn.dataTable.util.throttle(function () {
        this.$api.ajax.reload();
    }, 1000);

    FilterGridViewBase.prototype.isMount = function () {
        return this.$api !== null && $.fn.DataTable.isDataTable(this.root);
    };
    
    return FilterGridViewBase;
}());

var ScanningServicesJobsFilterGridComponent = (function (_super) {
    const columns = [
        { data: 'Id', name: 'Id' },
        { data: 'Name', name: 'Name' }
    ];

    __extends(ScanningServicesJobsFilterGridComponent, _super);

    function ScanningServicesJobsFilterGridComponent(config) {
        _super.call(this, config);

        this.defaultOrder = [[0, 'desc']];
    }

    ScanningServicesJobsFilterGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);

        this.$api.column(0).visible(true);
    };

    return ScanningServicesJobsFilterGridComponent;
}(FilterGridViewBase));

var ScanningServicesStatusGridComponent = (function (_super) {
    const columns = [
        { data: 'Id', name: 'Id' },
        { data: 'IsActive', name: 'IsActive', render: templateStatus },
        { data: 'Name', name: 'Name' },
        { data: 'HostOsType', name: 'HostOsType' },
        { data: 'LastPollDate', name: 'LastPollDate', render: $.fn.dataTable.render.date() }
    ];

    function templateStatus(name, type, full, meta) {
        const img = document.createElement('img');
        img.src = full.IsActive === true ? imageStatus.Green : img.src = imageStatus.Red ;
        img.style = 'height: 16px; width: 100%; margin: 0 auto; object-fit: none;';
        return img.outerHTML;
    }

    var imageStatus = {
        Green: '/img/green.svg',
        Red: '/img/red.svg',
    }

    __extends(ScanningServicesStatusGridComponent, _super);

    function ScanningServicesStatusGridComponent(config) {
        _super.call(this, config);
        this.defaultOrder = [[0, 'desc']];
    }

    ScanningServicesStatusGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);
        this.$api.column(0).visible(true);
    };

    ScanningServicesStatusGridComponent.prototype.getSelectedItems = function () {
        const selectedItemKeys = this.$api.selectCustom().selectedItemKeys();

        if (!selectedItemKeys.length)
            return [];

        const item = {
            id: this.lastSelectedItem.Id,
            name: this.lastSelectedItem.Name,
            hostOsType: this.lastSelectedItem.HostOsType != null ? this.lastSelectedItem.HostOsType : null
        };

        return [item];
    };

    return ScanningServicesStatusGridComponent;
}(FilterGridViewBase));

var FilterHostsGridComponent = (function (_super) {
    const columns = [
        { data: null, defaultContent: '<span></span>' },
        { data: 'Id', name: 'Id' },
        { data: 'Name', name: 'ConnectionAddress' },
        { data: 'Description', name: 'Description' },
        { data: 'Cpe', name: 'Cpe' },
        { data: 'OsName', name: 'OsName' },
        { data: 'OsVersion', name: 'OsVersion' },
        { data: 'ModificationDate', name: 'ModificationDate', render: $.fn.dataTable.render.date() }
    ];

    // fix events work in IE
    let filters = { ip: '', description: '', cpe: '' };

    __extends(FilterHostsGridComponent, _super);

    function FilterHostsGridComponent(config) {
        _super.call(this, config);

        this.inputFilterIP = document.querySelector('[id*=hostsModal] input[id*="HostFilterIP"]');
        this.inputFilterDescription = document.querySelector('[id*=hostsModal] input[id*="HostFilterDescription"]');
        this.inputFilterCpe = document.querySelector('[id*=hostsModal] input[id*="HostFilterCpe"]');
    }

    FilterHostsGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);

        this.inputFilterIP.addEventListener('input', onChangeFilterIP.bind(this));
        this.inputFilterDescription.addEventListener('input', onChangeFilterDescription.bind(this));
        this.inputFilterCpe.addEventListener('input', onChangeFilterCpe.bind(this));
    };

    function onChangeFilterIP(e) {
        if (e.target.value === filters.ip) return;

        this.$api.column('ConnectionAddress:name').search(e.target.value);
        filters.ip = e.target.value;
        this.search();
    }

    function onChangeFilterDescription(e) {
        if (e.target.value === filters.description) return;

        this.$api.column('Description:name').search(e.target.value);
        filters.description = e.target.value;
        this.search();
    }

    function onChangeFilterCpe(e) {
        if (e.target.value === filters.cpe) return;

        this.$api.column('Cpe:name').search(e.target.value);
        filters.cpe = e.target.value;
        this.search();
    }

    return FilterHostsGridComponent;
}(FilterGridViewBase));

var FilterGroupsGridComponent = (function (_super) {
    const columns = [
        { data: null, defaultContent: '<span></span>' },
        { data: 'Id', name: 'Id' },
        { data: 'Name', name: 'Name' },
        { data: 'Description', name: 'Description' },
        { data: 'CountOfHosts', name: 'CountOfHosts', render: (data) => parseInt(data) === 0 ? '' : data },
    ];

    __extends(FilterGroupsGridComponent, _super);

    function FilterGroupsGridComponent(config) {
        _super.call(this, config);

        this.inputFilterName = document.querySelector('[id*=groupsModal] input[id*="GroupFilterName"]');
    }

    FilterGroupsGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);

        this.inputFilterName.addEventListener('input', onChangeFilterName.bind(this));
    };

    function onChangeFilterName(e) {
        this.$api.column('Name:name').search(e.target.value);
        this.search();
    }

    return FilterGroupsGridComponent;
}(FilterGridViewBase));

var FilterCredentialsGridComponent = (function (_super) {
    const columns = [
        { data: null, defaultContent: '<span></span>' },
        { data: 'Id', name: 'Id' },
        { data: 'TypeText', name: 'Kind' },
        { data: 'SubType', name: 'SubType' },
        { data: 'Name', name: 'Name' },
        { data: 'CreationDate', name: 'CreationDate', render: $.fn.dataTable.render.date() },
        { data: 'ModificationDate', name: 'ModificationDate', render: $.fn.dataTable.render.date() }
    ];

    __extends(FilterCredentialsGridComponent, _super);

    function FilterCredentialsGridComponent(config) {
        _super.call(this, config);
        
        
        this.defaultOrder = [[1, 'asc']];
        this.credentialFilter = config.filter;
        this.showCheckBox = config.showCheckBox;
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    FilterCredentialsGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);

        this.$api.column(0).visible(this.showCheckBox === true);
    };

    FilterCredentialsGridComponent.prototype.getLastSelectedItem = function() {
        return this.lastSelectedItem;
    };

    FilterCredentialsGridComponent.prototype.applyFilter = function (filter) {
        this.credentialFilter = filter;
    };

    function onBeginCallback(e, settings, data) {
        data['credentialFilter'] = this.credentialFilter;
    }

    return FilterCredentialsGridComponent;
}(FilterGridViewBase));

var FilterJobsGridComponent = (function (_super) {
    const columns = [
        { data: null, defaultContent: '<span></span>' },
        { data: 'Id', name: 'Id' },
        { data: 'Name', name: 'Name' },
        { data: 'ScanType', name: 'ScanType', render: templateScanType },
        { data: 'StartType', name: 'HasSchedule', render: templateStartType },
        { data: 'StopDate', render: $.fn.dataTable.render.date() },
        { data: 'JobExecutionCount', name: 'JobExecutionCount' },
        { data: 'JobExecutionSuccessfulCount', name: 'JobExecutionSuccessfulCount' }
    ];

    __extends(FilterJobsGridComponent, _super);

    function FilterJobsGridComponent(config) {
        _super.call(this, config);

        this.defaultOrder = [[1, 'desc']];
        this.inputFilterName = document.querySelector('[id*=jobsModal] input[id*="JobFilterName"]');
        this.jobFilter = config.filter;
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    FilterJobsGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);

        this.inputFilterName.addEventListener('input', onChangeFilterName.bind(this));
    };

    FilterJobsGridComponent.prototype.applyFilter = function (filter) {
        this.jobFilter = filter;
    };

    function onBeginCallback(e, settings, data) {
        data['jobFilter'] = this.jobFilter;
    }

    function onChangeFilterName(e) {
        this.$api.column('Name:name').search(e.target.value);
        this.search();
    }

    function templateScanType(key, type, full, meta) {
        return getValueFromResourceByKey(listTitlesForJobScanType, key);
    }

    function templateStartType(key, type, full, meta) {
        return getValueFromResourceByKey(listTitlesForJobStartType, key);
    }

    return FilterJobsGridComponent;
}(FilterGridViewBase));

var FilterBenchmarksGridComponent = (function (_super) {
    const columns = [
        { data: null, defaultContent: '<span></span>' },
        { data: 'Id', name: 'Id', visible: false },
        { data: 'Name', name: 'Name' },
        { data: 'ProfileName', name: 'ProfileName' },
        { data: 'ProfileId', name: 'ProfileId', visible: false },
        { data: 'IsProfileDefault', name: 'IsProfileDefault', visible: false },
        { data: 'IsProfileOutOfBox', name: 'IsProfileOutOfBox', visible: false },
        { data: 'IsProfileSingle', name: 'IsProfileSingle', visible: false },
    ];

    __extends(FilterBenchmarksGridComponent, _super);

    function translateBoolToRussian(data) {
        let result;
        if (data === true)
            result = "Да";
        else 
            result = "Нет";
        const span = document.createElement('span');
        span.textContent = result;
        return span.outerHTML;
    }
    function FilterBenchmarksGridComponent(config) {
        _super.call(this, config);

        this.defaultOrder = [[1, 'desc']];
        this.inputFilterName = document.querySelector('[id*=benchmarksModal] input[id*="FilterName"]');
        
        this.benchmarkFilter = config.filter;
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    FilterBenchmarksGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);
        this.inputFilterName.addEventListener('input', onChangeFilterName.bind(this));
    };

    function onChangeFilterName(e) {
        this.$api.column('Name:name').search(e.target.value);
        this.search();
    }
    
    FilterBenchmarksGridComponent.prototype.applyFilter = function (filter) {
        this.benchmarkFilter = filter;
    };

    FilterBenchmarksGridComponent.prototype.getSelectedItemsForBenchmarks = function () {
        const selectedItemKeys = this.$api.selectCustom().selectedItemKeys();

        if (!selectedItemKeys.length)
            return [];

        if (this.selectMode === 'SINGLE') {
            const item = {
                id: this.lastSelectedItem.Id,
                benchmarkId: this.lastSelectedItem.BenchmarkId,
                benchmarkName: this.lastSelectedItem.Name,
                profileId: this.lastSelectedItem.ProfileId,
                profileTextId: this.lastSelectedItem.ProfileTextId,
                isProfileDefault: this.lastSelectedItem.IsProfileDefault,
                isProfileOutOfBox: this.lastSelectedItem.IsProfileOutOfBox,
                isProfileSingle: this.lastSelectedItem.IsProfileSingle
            };

            return [item];
        }

        //?
        return selectedItemKeys.map(function (itemId) {
            return { id: itemId };
        });
    };
    
    function onBeginCallback(e, settings, data) {
        data['benchmarkFilter'] = this.benchmarkFilter;
    }

    return FilterBenchmarksGridComponent;
}(FilterGridViewBase));

var FilterJobExecutionsGridComponent = (function (_super) {
    const columns = [
        { data: null, defaultContent: '<span></span>' },
        { data: 'Id', name: 'Id' },
        { data: 'JobName', name: 'Name' }, //these exact names are made to match names while sorting on server side
        { data: 'Start', name: 'StartedAt', render: $.fn.dataTable.render.date() }, //the same
        { data: 'Stop', name: 'StoppedAt', render: $.fn.dataTable.render.date() }, //the same
        { data: 'TotalHosts', name: 'TotalHostsCount' }, //the same
        { data: 'SuccessfullHosts', name: 'SuccessfullHostsCount' } //the same
    ];

    __extends(FilterJobExecutionsGridComponent, _super);

    function FilterJobExecutionsGridComponent(config) {
        _super.call(this, config);

        this.defaultOrder = [[4, 'desc']];
        this.jobExecutionFilter = config.filter;
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    FilterJobExecutionsGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);
    };

    FilterJobExecutionsGridComponent.prototype.applyFilter = function (filter) {
        this.jobExecutionFilter = filter;
    };

    FilterJobExecutionsGridComponent.prototype.getSelectedItemsForJobExecutions = function () {
        const selectedItemKeys = this.$api.selectCustom().selectedItemKeys();

        if (!selectedItemKeys.length)
            return [];

        if (this.selectMode === 'SINGLE') {
            const item = {
                id: this.lastSelectedItem.Id,
                start: this.lastSelectedItem.Start,
                stop: this.lastSelectedItem.Stop
            };

            return [item];
        }

        //?
        return selectedItemKeys.map(function (itemId) {
            return { id: itemId };
        });
    };
    
    function onBeginCallback(e, settings, data) {
        data['JobExecutionFilter'] = this.jobExecutionFilter;
    }

    return FilterJobExecutionsGridComponent;
}(FilterGridViewBase));

var FilterRulesGridComponent = (function (_super) {
    const columns = [
        { data: 'Id', name: 'Id' },
        { data: 'RuleNumber', name: 'RuleNumber' },
        { data: 'RuleTitle', name: 'RuleTitle' },
        { data: 'RuleId', name: 'RuleId', visible: false}
    ];

    __extends(FilterRulesGridComponent, _super);
    function FilterRulesGridComponent(config) {
        _super.call(this, config);
        
        this.defaultOrder = [[0, 'asc']];
        this.inputFilterName = document.querySelector('[id*=complianceRulesSelectedCheckedModal] input[id*="FilterName"]');

        this.BenchmarkFilter = config.filter;
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    FilterRulesGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);
        this.inputFilterName.addEventListener('input', onChangeFilterName.bind(this));
    };

    function onChangeFilterName(e) {
        this.$api.column('RuleTitle:name').search(e.target.value);
        this.search();
    }

    FilterRulesGridComponent.prototype.applyFilter = function (filter) {
        this.BenchmarkFilter = filter;
    };

    FilterRulesGridComponent.prototype.getSelectedItemsForRules = function () {
        const selectedItemKeys = this.$api.selectCustom().selectedItemKeys();

        if (!selectedItemKeys.length)
            return [];

        if (this.selectMode === 'SINGLE') {
            const item = {
                ruleId: this.lastSelectedItem.RuleId,
                ruleTitle: this.lastSelectedItem.RuleTitle
            };

            return [item];
        }

        //?
        return selectedItemKeys.map(function (itemId) {
            return { id: itemId };
        });
    };
    
    function onBeginCallback(e, settings, data) {
        data['BenchmarkFilterFromPopup'] = this.BenchmarkFilter;
    }

    return FilterRulesGridComponent;
}(FilterGridViewBase));

var FilterHostsWithNoResultGridComponent = (function (_super) {
    const columns = [
        { data: null, defaultContent: '<span></span>' },
        { data: 'Id', name: 'Id' },
        { data: 'HostName', name: 'HostName' },
        { data: 'ScanId', name: 'ScanId' }
    ];
    var showScanIds = false;

    __extends(FilterHostsWithNoResultGridComponent, _super);
    function FilterHostsWithNoResultGridComponent(config) {
        _super.call(this, config);

        this.defaultOrder = [[1, 'asc']];

        this.HostsFilter = config.filter;
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
        $(config.root).on('xhr.dt', function (e, settings, json, xhr) {
            if (json){
                if (json.BadResultOfScanCount > 0) {
                    document.getElementById('hostCountStatistics').classList.remove('hide');
                    $('#badScanHostCount').html(json.BadResultOfScanCount);
                }
                else {
                    document.getElementById('hostCountStatistics').classList.add('hide');
                }
            }
            
        });
    }

    FilterHostsWithNoResultGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, columns);
    };

    FilterHostsWithNoResultGridComponent.prototype.applyFilter = function (filter) {
        this.HostsFilter = filter;
    };

    function onBeginCallback(e, settings, data) {
        data['HostsFilter'] = this.HostsFilter;
    }

    return FilterHostsWithNoResultGridComponent;
}(FilterGridViewBase));

var FilterNetworkResourcesBaseGridComponent = (function (_super) {

    __extends(FilterNetworkResourcesBaseGridComponent, _super);

    const needHideExtraColumns = false;

    function FilterNetworkResourcesBaseGridComponent(config) {
        _super.call(this, config);
        
        this.networkResourceFilter = networkResourceFilter = config.filter;
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    FilterNetworkResourcesBaseGridComponent.prototype.applyFilter = function(filter) {
        this.networkResourceFilter = filter;
    }

    FilterNetworkResourcesBaseGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, this.Columns);

        this.$api.column(0).visible(true);
    };

    FilterNetworkResourcesBaseGridComponent.prototype.getAllItems = function () {
        return this.$api.rows().data();
    };

    FilterNetworkResourcesBaseGridComponent.prototype.reload = function() {
        return this.$api.ajax.reload();
    };

    FilterNetworkResourcesBaseGridComponent.prototype.applyTablePropertiesForSync = function(needHideExtraColumns) {
        this.needHideExtraColumns = needHideExtraColumns;

        if (this.needHideExtraColumns === true) {
            this.$api.column(2).visible(false);
            this.$api.column(3).visible(false);
        } else {
            this.$api.column(2).visible(true);
            this.$api.column(3).visible(true);
        }
    };

    function onBeginCallback(e, settings, data) {
        var parsedFilter = JSON.parse(this.networkResourceFilter);
        if (parsedFilter === undefined || parsedFilter === null)
            return;

        data['networkResourceFilter'] = JSON.stringify({
            IsDefault: parsedFilter.IsDefault,
            ProviderType: parsedFilter.ProviderType,
            Resources: parsedFilter.hasOwnProperty("resources") ? parsedFilter.resources.map(r => r.id)
                : parsedFilter.hasOwnProperty("Resources")
                    ? parsedFilter.Resources
                    : null
        });
    }

    return FilterNetworkResourcesBaseGridComponent;
}(FilterGridViewBase));

var FilterNetworkResourcesGridComponent = (function(_super) {
    __extends(FilterNetworkResourcesGridComponent, _super);
    function FilterNetworkResourcesGridComponent(config) {
        _super.call(this, config);
        this.Columns = [
            { data: 'Id', name: 'Id' },
            { data: 'Path', name: 'Path' },
            { data: 'Subject', name: 'Subject', render: function (data, type, row, meta) {
                    let subjectValue = NotificationSettingsController.getUserNotificationSubject(row.Id);
                    if (type === 'display') {
                        return subjectValue ? subjectValue : '—';
                    }
                    return subjectValue || '';
                }
            },
            { data: 'Triggers', name: 'Triggers', render: function (data, type, row, meta) {
                    let triggers = NotificationSettingsController.getUserNotificationTriggers(row.Id);
                    let mappedTriggers = NotificationSettingsController.getMappedUserNotificationTriggers(triggers);
                    if (type === 'display') {
                        return mappedTriggers ? mappedTriggers : '—';
                    }
                    return mappedTriggers || '';
                }
            },
            { data: 'Commands', render: $.fn.dataTable.render.commandButtons() }
        ];
        
        this.needHideExtraColumns = config.needHideExtraColumns;

        $(config.root).on('preInit.dt', onPreInit.bind(this));
        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    function onPreInit(e, settings, data) {
        var api = new $.fn.dataTable.Api(settings);
        api.table().container().classList.add('hide-length-menu');
    }

    function onBeginCallback(e, settings, data) {
        if(this.needHideExtraColumns === true) {
            data['needHideExtraCommandsForSync'] = JSON.stringify(
                this.needHideExtraColumns
            );
        }
    }

    return FilterNetworkResourcesGridComponent;
}(FilterNetworkResourcesBaseGridComponent));

var FilterNetworkResourcesPopupGridComponent = (function (_super) {
    __extends(FilterNetworkResourcesPopupGridComponent, _super);

    function FilterNetworkResourcesPopupGridComponent(config) {
        _super.call(this, config);
        
        this.Columns = [
            { data: null, defaultContent: '<span></span>' },
            { data: 'Id', name: 'Id' },
            { data: 'ProviderType', name: 'ProviderType' },
            { data: 'Path', name: 'Path' },
        ];
    }

    return FilterNetworkResourcesPopupGridComponent;
}(FilterNetworkResourcesBaseGridComponent));

var FilterReportTemplateNetworkResourcesPopupGridComponent = (function (_super) {
    __extends(FilterReportTemplateNetworkResourcesPopupGridComponent, _super);

    function FilterReportTemplateNetworkResourcesPopupGridComponent(config) {
        _super.call(this, config);

        this.Columns = [
            { data: null, defaultContent: '<span></span>' },
            { data: 'Id', name: 'Id' },
            { data: 'ProviderType', name: 'ProviderType' },
            { data: 'Path', name: 'Path' },
            { data: 'CredentialName', name: 'CredentialName' },
        ];
    }

    return FilterReportTemplateNetworkResourcesPopupGridComponent;
}(FilterNetworkResourcesBaseGridComponent));

var FilterNetworkResourcesSettingsGridComponent = (function (_super) {

    __extends(FilterNetworkResourcesSettingsGridComponent, _super);
    var onResourceIsDefaultChangedFunctionName;

    function FilterNetworkResourcesSettingsGridComponent(config) {
        _super.call(this, config);
        onResourceIsDefaultChangedFunctionName = config.onResourceIsDefaultChangedFunctionName;

        this.Columns = [
            { data: 'Id', name: 'Id' },
            { data: 'ProviderType', name: 'ProviderType' },
            { data: 'Path', name: 'Path' },
            { data: 'CredentialName', name: 'CredentialName' },
            { data: 'CreateDate', name: 'CreateDate', render: $.fn.dataTable.render.date() },
            { data: 'ModificationDate', name: 'ModificationDate', render: $.fn.dataTable.render.date() },
            {
                data: 'IsDefault', name: 'IsDefault', render: function (data, type, row) {
                    if (data === true) {
                        return '<input type="checkbox" data-id="' + row.Id + '" class="editor-active is-default-checkbox" onclick="' + onResourceIsDefaultChangedFunctionName + '" checked>';
                    } else {
                        return '<input type="checkbox" data-id="' + row.Id + '" class="editor-active is-default-checkbox" onclick="' + onResourceIsDefaultChangedFunctionName + '">';
                    }
                }
            },
            { data: 'Commands', render: $.fn.dataTable.render.commandButtons() }
        ];
    }

    return FilterNetworkResourcesSettingsGridComponent;
}(FilterNetworkResourcesBaseGridComponent));

var FilterReportTemplatesGridComponent = (function (_super) {

    __extends(FilterReportTemplatesGridComponent, _super);

    function FilterReportTemplatesGridComponent(config) {
        _super.call(this, config);

        this.reportTemplateFilter = config.filter;
        this.showCheckBox = config.showCheckBox;
        this.showCommands = config.showCommands;

        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));
    }

    FilterReportTemplatesGridComponent.prototype.mount = function () {
        const columns = [
            { data: 'Id', name: 'Id' },
            { data: 'TypeText', name: 'Type' },
            { data: 'ReportTemplateName', name: 'ReportTemplateName' },
            { data: 'DataTypeText', name: 'DataType' },
        ];

        if (this.showCheckBox === true) {
            columns.unshift({ data: null, defaultContent: '<span></span>' });
        }

        if (this.showCommands === true) {
            columns.push({ data: 'Commands', render: $.fn.dataTable.render.commandButtons() });
        }

        _super.prototype.mount.call(this, columns);
    };

    FilterReportTemplatesGridComponent.prototype.getAllItems = function () {
        return this.$api.rows().data();
    };

    FilterReportTemplatesGridComponent.prototype.reload = function () {
        return this.$api.ajax.reload();
    };

    FilterReportTemplatesGridComponent.prototype.selectRowByIndex = function (indexRow) {
        if (indexRow >= 0) {
            this.$api.row(indexRow).select();
        }
    };

    function onBeginCallback(e, settings, data) {
        data['reportTemplateFilter'] = this.reportTemplateFilter;
    }

    return FilterReportTemplatesGridComponent;
}(FilterGridViewBase));

var FilterReportTemplateNetworkResourcesGridComponent = (function(_super) {
    __extends(FilterReportTemplateNetworkResourcesGridComponent, _super);

    // Extra variable to provide access to filters from DataTable row render()
    var networkResourceFilter;

    function FilterReportTemplateNetworkResourcesGridComponent(config) {
        _super.call(this, config);
        this.networkResourceFilter = networkResourceFilter = config.filter;

        this.Columns = [
            { data: 'Id', name: 'Id' },
            { data: 'ProviderType', name: 'ProviderType' },
            { data: 'Path', name: 'Path' },
            { data: 'CredentialName', name: 'CredentialName' },
            {
                render: function (data, type, row) {
                    var parsedFilter = networkResourceFilter !== undefined ? JSON.parse(networkResourceFilter) : null;
                    var selectedExtension = '';
                    if (parsedFilter !== null && parsedFilter.resources.filter(r => r.id === row.Id).length > 0) {
                        var resourceSettings = parsedFilter.resources.filter(r => r.id === row.Id)[0];
                        if (resourceSettings.hasOwnProperty('extension')) {
                            selectedExtension = resourceSettings.extension;
                        }
                    }
                    var comboboxOptions = '';
                    for (var i = 0; i < reportExtensions.length; i++) {
                        comboboxOptions += '<option value="' + reportExtensions[i].ReportExtensionString + '"'
                            + (reportExtensions[i].ReportExtensionString === selectedExtension ? ' selected' : '') + '>'
                            + reportExtensions[i].ReportExtensionString + '</option>';
                    }

                    return '<select class="network-resource-extensions" data-id="' + row.Id + '" onchange="ReportTemplatesController.OnNetworkResourceExtensionChanged(' + row.Id + ', this.value)">' + comboboxOptions + '</select>';
                }
            },
            { data: 'Commands', render: $.fn.dataTable.render.commandButtons() }
        ];
    }

    FilterReportTemplateNetworkResourcesGridComponent.prototype.applyFilter = function (filter) {
        this.networkResourceFilter = networkResourceFilter = filter;
    }

    return FilterReportTemplateNetworkResourcesGridComponent;
}(FilterNetworkResourcesBaseGridComponent));

var FilterStripsPopupGridComponent = (function (_super) {
    __extends(FilterStripsPopupGridComponent, _super);

    function FilterStripsPopupGridComponent(config) {
        _super.call(this, config);

        this.stripsFilter = config.filter;
        this.inputFilterName = document.getElementById('StripsFilterName');

        $(config.root).on('preXhr.dt', onBeginCallback.bind(this));

        this.Columns = [
            { data: null, defaultContent: '<span></span>' },
            { data: 'Id', name: 'Id' },
            { data: 'Name', name: 'Name' },
            { data: 'TypeText', name: 'Type' },
            { data: 'FamilyText', name: 'Family' },
        ];
    }

    FilterStripsPopupGridComponent.prototype.mount = function () {
        _super.prototype.mount.call(this, this.Columns);

        this.inputFilterName.addEventListener('input', onChangeFilterName.bind(this));
        this.$api.column(0).visible(true);
    };

    FilterStripsPopupGridComponent.prototype.deselectAll = function () {
        this.$api.selectCustom().deselectAll().draw();
    };

    function onChangeFilterName(e) {
        this.$api.column('Name:name').search(e.target.value);
        this.search();
    }

    function onBeginCallback(e, settings, data) {
        var parsedFilter = JSON.parse(this.stripsFilter);
        if (parsedFilter === undefined || parsedFilter === null)
            return;

        data.Class = parsedFilter.Class;
        data.OvalProfileType = parsedFilter.OvalProfileType;
    }

    return FilterStripsPopupGridComponent;
}(FilterGridViewBase));