﻿function QuickReport(buttonId) {
    this.ButtonId = buttonId;
    this.sharpModalId = $('#' + this.ButtonId).data('target');
    this.ReportExt = '';
    this.CreateReportUrl = '';
    this.OpenReportText = '';
    this.OpenReportTitle = '';
    this.OpenReportBody = '';
    this.ExportReportUrl = '';
    this.CheckCreateReportTaskUrl = '';
    this.CheckExportReportStatusUrl = '';
    this.DownloadReportUrl = '';
    this.SessionToken = '';
    this.PleaseWait = '';
    this.Exported = false;

    var self = this;
    $('#' + buttonId).click(function (){
        self.ReportId === undefined ? self.CreateReport() : self.ExportReport();
    });
}

QuickReport.prototype.OnReportCreated = function (response) {
    $('#createReportTaskID').val(response.taskId);
    checkCreateReportTasks(this.CheckCreateReportTaskUrl, this.SessionToken);
};

QuickReport.prototype.CreateReport = function () {
    $.ajax({
        url: this.CreateReportUrl,
        dataType: "json",
        success: this.OnReportCreated.bind(this)
    });
};

QuickReport.prototype.ExportReport = function () {
    /*if (this.Exported) {
        window.location.href = downloadUrl;
        $(this.sharpModalId).modal('hide');
        return;
    }*/

    var self = this;
    $.ajax({
        url: this.ExportReportUrl,
        type: 'GET',
        data: {
            id: this.ReportId,
            ext: this.ReportExt,
            clientOffsetMinutes: - new Date().getTimezoneOffset()
        },
        success: function (response) {
            var downloadUrl = self.DownloadReportUrl + '?id=' + self.ReportId + '&ext=' + self.ReportExt + '&exportGuid=' + response.ExportGuid;
            checkExportReportStatus(self.CheckExportReportStatusUrl + '?id=' + self.ReportId + '&ext=' + self.ReportExt + '&exportGuid=' + response.ExportGuid, downloadUrl);
        }
    });
};

function checkCreateReportTasks(url, sessionToken) {
    var id = document.getElementById('createReportTaskID').value;
    setTimeout(restRequestWithParams.bind(null, url.replace('10001', id) + '?' + new Date().getTime(), checkCreateReportResult, null, [url, sessionToken]), 2000);
}

function checkCreateReportResult(xhr, params) {
    var url = params[0];
    var sessionToken = params[1];
    var task = JSON.parse(xhr);
    if (task !== null && task !== undefined) {
        //if finished?
        if (task.state !== 3) {
            checkCreateReportTasks(url, sessionToken);
        }
        if (task.state === 3) {
            if (task.result === 1)
                createReportUpdateViewSuccess(task);
            if (task.result === 2)
                createReportUpdateViewFail(task.summary);
        }
    }
}

function createReportUpdateViewSuccess(task) {
    // TODO: use object properties
    quickReportUtils.ReportId = task.reportId;
    
    $('#' + quickReportUtils.ButtonId).val(quickReportUtils.OpenReportText);
    $('#loading').hide();
    $(quickReportUtils.sharpModalId).modal('hide');
}

function createReportUpdateViewFail(summary) {
    var p = document.createElement('p');
    p.classList.add('text-danger', 'strong');
    p.innerHTML = reportErrorMessage;
    $('#loading').hide();
    document.getElementById('createReportResult').appendChild(p);

    if (summary !== undefined && summary !== '') {
        var summaryElem = document.createElement('p');
        summaryElem.innerHTML = summary;
        summaryElem.classList.add('text-danger');
        document.getElementById('createReportResult').appendChild(summaryElem);
    }
}

function checkExportReportStatus(url, downloadUrl) {
    setTimeout(getExportReportStatus.bind(null, url, downloadUrl), 2000);
}

function getExportReportStatus(url, downloadUrl) {
    $.ajax({
        url: url,
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        success: function (data, status, xhr) {
            var ct = xhr.getResponseHeader("content-type") || "";
            // Wrong content type
            if (ct.indexOf('json') === -1) {
                showMessage(true, 'text-danger', wrongResponseFormat, data.message);
                return;
            }

            if (data !== null && data !== undefined) {
                // InProgress
                if (data.status === 0) {
                    checkExportReportStatus(url, downloadUrl);
                // Connection Error
                } else if (data.status === 3) {
                    if (data.message !== undefined && data.message !== '') {
                        showMessage(false, 'text-warning', data.message, tryingToReconnect);
                    }
                    checkExportReportStatus(url, downloadUrl);
                // Success
                } else if (data.status === 1) {
                    // TODO: use object properties
                    quickReportUtils.Exported = true;
                    $(quickReportUtils.sharpModalId).modal('hide');
                    window.location.href = downloadUrl;
                // Error
                } else if (data.status === 2) {
                    showMessage(true, 'text-danger', reportExportFailHtml, data.message);
                }
            }
        },
        error: function (xhr, textStatus, errorThrown) {
            showMessage(true, 'text-danger', requestError);
            console.log(xhr, textStatus, errorThrown);
        }
    });
}

function showMessage(hideLoader, cssClass, messageHeader, message) {
    document.getElementById('createReportResult').innerHTML = "";
    if (hideLoader === true)
        $('#loading').hide();

    var p = document.createElement('p');
    p.classList.add(cssClass, 'strong');
    p.innerHTML = messageHeader;
    document.getElementById('createReportResult').appendChild(p);

    if (message !== undefined && message !== '') {
        var summaryElem = document.createElement('p');
        summaryElem.innerHTML = message;
        summaryElem.classList.add(cssClass);
        document.getElementById('createReportResult').appendChild(summaryElem);
    }
}