﻿
function restRequest(url, actionAfterRequest, actionOnError) {
    $.ajax({
        url: '/clientrequest?url=' + url,
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        error: function (error) {
            if (actionOnError !== null && actionOnError !== undefined)
                actionOnError();

            console.log('Ошибка ' + error);
        },
        success: function (data) {
            if (actionAfterRequest !== null && actionAfterRequest !== undefined)
                actionAfterRequest(data);
        }
    });
}

function restRequestWithParams(url, actionAfterRequest, actionOnError, params) {
    $.ajax({
        url: '/clientrequest?url=' + url,
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        error: function (error) {
            if (actionOnError !== null && actionOnError !== undefined)
                actionOnError();

            console.log('Ошибка ' + error);
        },
        success: function (data) {
            if (actionAfterRequest !== null && actionAfterRequest !== undefined)
                actionAfterRequest(data, params);
        }
    });
}

function restRequestCORS(url, authInfo, actionAfterRequest, actionOnError) {
    var XHR = "onload" in new XMLHttpRequest() ? XMLHttpRequest : XDomainRequest;
    var xhr = new XHR();

    xhr.open('GET', url, true);

    setAuthHeader(xhr, authInfo);

    xhr.onload = function () {
        if (actionAfterRequest !== undefined && actionAfterRequest !== null)
            actionAfterRequest(xhr);
    };

    xhr.onerror = function () {
        if (actionOnError !== undefined && actionOnError !== null)
            actionOnError(xhr);

        console.log('Ошибка ' + this.status);
    };

    xhr.send();
}

function restRequestWithParamsCORS(url, authInfo, actionAfterRequest, actionOnError, params) {
    var XHR = "onload" in new XMLHttpRequest() ? XMLHttpRequest : XDomainRequest;
    var xhr = new XHR();

    xhr.open('GET', url, true);
    setAuthHeader(xhr, authInfo);

    xhr.onload = function () {
        if (actionAfterRequest !== undefined && actionAfterRequest !== null)
            actionAfterRequest(xhr, params);
    };

    xhr.onerror = function () {
        if (actionOnError !== undefined && actionOnError !== null)
            actionOnError(xhr);

        console.log('Ошибка ' + this.status);
    };

    xhr.send();
}

function ajaxRequest(url, methodType, data, beforeSend, success, params) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: methodType,
        contentType: "application/json; charset=utf-8",
        beforeSend: function () {
            if (beforeSend !== undefined && beforeSend !== null)
                beforeSend();
        },
        success: function (html) {
            if (success !== undefined && success !== null)
                if (params != undefined && params != null)
                    success(html, params);
                else success(html);
        }
    });
}

function setAuthHeader(xhr, authInfo) {
    var headerValue = authInfo.type + ' ' + authInfo.token;
    xhr.setRequestHeader('Authorization', headerValue);
}