function showDeleteYaraRulesDialog(ids, callback) {
    const body = '<p class="dialog-body-title margin-top-5">Удалить выбранные правила YARA?</p>' +
        '<p class="normalText margin-top-5">Удаление правил YARA приведет к удалению связанных с ними результатов сканирования.</p>';

    const dialogOptions = {
        height: 'auto',
        width: 500,
        my: 'top',
        at: 'center',
        of: window,
        minHeight: 0,
        resizable: false,
        closeOnEscape: true,
        modal: true,
        open: function (event, ui) {
            $('.ui-dialog-titlebar-close', ui.dialog | ui).addClass('btn-cross');
        },
    };
    
    $('<div></div>')
        .addClass('dialog')
        .appendTo('body')
        .dialog($.extend({}, dialogOptions,{
            title: 'Удаление',
            buttons: [
                {
                    text: 'Удалить',
                    'class': 'btn btn-info btn-wide',
                    click: function () {
                        $(this).dialog('close');
                        callback();
                    }
                },
                {
                    text: 'Отмена',
                    'class': 'btn btn-default btn-wide margin-left-10',
                    click: function () {
                        $(this).dialog('close');
                    }
                }
            ],
        })).html(body);
}

function onDeleteYaraRulesClick(e, dt) {
    const errorText = 'Во время выполнения запроса что-то пошло не так';

    const selectedIds = dt.redcheck.selectedIds().length > 0
        ? dt.redcheck.selectedIds()
        : [dt.redcheck.focusedId()];
    
    async function deleteYaraRules() {
        try {
            $('#yaraRulesGrid').addClass('disableContent');
            const response = await fetch('/YaraRules/DeleteYaraRules', {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(selectedIds),
            });

            if (response.ok) {
                notifySuccess('Выбранные правила успешно удалены');
                yaraRulesDataTable.redcheck.deselectAll().draw(false);
            } else {
                let errorData = await response.json();
                notifyWarning(errorData.message);
            }
        } catch (e) {
            console.error(e);
            notifyWarning('При удалении правил произошла ошибка: ' + e);
        } finally {
            $('#yaraRulesGrid').removeClass('disableContent');
        }
    }

    window.showDeleteYaraRulesDialog(selectedIds, deleteYaraRules);
}

function onImportYaraRulesClick(e, dt) {
    $('#importYaraRulesModal').modal('show')
}