var VulnerabilitiesController = {
    filter: {
        altxId: '',
        vulnerabilityTitle: '',
        referenceSearchText: '',

        showNewVulnerabilities: true,
        showRemainingVulnerabilities: true,
        showRemediatedVulnerabilities: true
    },

    statistics: {
        totalNewVulnerabilitiesCount: '',
        totalRemainingVulnerabilitiesCount: '',
        totalRemediatedVulnerabilitiesCount: ''
    },

    reloadVulnerabilitiesGrid: function () {
        VulnerabilitiesController.cleanStatistics();
        const table = document.getElementById('vulnerabilitiesGrid');
        if ($.fn.DataTable.isDataTable(table)) {
            $(table).dataTable().api().ajax.reload();
        }
    },

    onAltxIdFilterChanged: debounce(function (input) {
        VulnerabilitiesController.filter.altxId = input.value;
        VulnerabilitiesController.reloadVulnerabilitiesGrid();
    }, 500),

    onVulnerabilityTitleFilterChanged: debounce(function (input) {
        VulnerabilitiesController.filter.vulnerabilityTitle = input.value;
        VulnerabilitiesController.reloadVulnerabilitiesGrid();
    }, 500),

    onReferenceFilterChanged: debounce(function (input) {
        VulnerabilitiesController.filter.referenceSearchText = input.value;
        VulnerabilitiesController.reloadVulnerabilitiesGrid();
    }, 500),

    onShowNewVulnsFilterChanged: debounce(function (value) {
        VulnerabilitiesController.filter.showNewVulnerabilities = value;
        VulnerabilitiesController.reloadVulnerabilitiesGrid();
    }, 500),

    onShowRemainingVulnsFilterChanged: debounce(function (value) {
        VulnerabilitiesController.filter.showRemainingVulnerabilities = value;
        VulnerabilitiesController.reloadVulnerabilitiesGrid();
    }, 500),

    onShowRemediatedVulnsFilterChanged: debounce(function (value) {
        VulnerabilitiesController.filter.showRemediatedVulnerabilities = value;
        VulnerabilitiesController.reloadVulnerabilitiesGrid();
    }, 500),

    updateStatistics: function (json) {
        if (!Array.isArray(json.data)) {
            VulnerabilitiesController.statistics.totalNewVulnerabilitiesCount = json.data.TotalNewVulnerabilitiesCount;
            VulnerabilitiesController.statistics.totalRemainingVulnerabilitiesCount = json.data.TotalRemainingVulnerabilitiesCount;
            VulnerabilitiesController.statistics.totalRemediatedVulnerabilitiesCount = json.data.TotalRemediatedVulnerabilitiesCount;
            $('#totalNewVulnerabilitiesCount').html(json.data.TotalNewVulnerabilitiesCount);
            $('#totalRemainingVulnerabilitiesCount').html(json.data.TotalRemainingVulnerabilitiesCount);
            $('#totalRemediatedVulnerabilitiesCount').html(json.data.TotalRemediatedVulnerabilitiesCount);

            document.getElementById('newVulnStatisticsVulnGrid').classList.remove('hide');
            document.getElementById('remainingVulnStatisticsVulnGrid').classList.remove('hide');
            document.getElementById('remediatedVulnStatisticsVulnGrid').classList.remove('hide');

            let htmlNewVulns = HostVulnerabilityController.createSeverityBlocks(json.data.NewVulnSeverities);
            if (htmlNewVulns) {
                $('#newVulnStatisticsSpanVulnGrid').html(htmlNewVulns);
            }

            let htmlRemainingVulns = HostVulnerabilityController.createSeverityBlocks(json.data.RemainingVulnSeverities);
            if (htmlRemainingVulns) {
                $('#remainingVulnStatisticsSpanVulnGrid').html(htmlRemainingVulns);
            }

            let htmlRemediatedVulns = HostVulnerabilityController.createSeverityBlocks(json.data.RemediatedVulnSeverities);
            if (htmlRemediatedVulns) {
                $('#remediatedVulnStatisticsSpanVulnGrid').html(htmlRemediatedVulns);
            }
        }
    },

    openHostsForAltxId: function () {
        let $this = $(this);
        let altxId = $this.attr('data-altx-id');

        HostVulnerabilityController.cleanAdditionalInfoOnPage();

        let firstNavTab = document.getElementById('vulnerabilitiesNavTab');
        firstNavTab.classList.remove('active');
        let thirdNavTab = document.getElementById('hostVulnerabilityNavTab');
        thirdNavTab.classList.add('active');

        let firstTab = document.getElementById('vulnerabilitiesTab');
        firstTab.classList.remove('active');
        let thirdTab = document.getElementById('hostVulnerabilityTab');
        thirdTab.classList.add('active');

        let hostVulnerabilityAltxIdFilter = document.getElementById('hostVulnerabilityAltxIdFilter');
        hostVulnerabilityAltxIdFilter.value = altxId;
        HostVulnerabilityController.onAltxIdFilterChanged(hostVulnerabilityAltxIdFilter);
    },

    cleanStatistics: function () {
        $('#totalNewVulnerabilitiesCount').html(null);
        $('#totalRemainingVulnerabilitiesCount').html(null);
        $('#totalRemediatedVulnerabilitiesCount').html(null);

        $('#newVulnStatisticsSpanVulnGrid').html(null);
        $('#remainingVulnStatisticsSpanVulnGrid').html(null);
        $('#remediatedVulnStatisticsSpanVulnGrid').html(null);

        document.getElementById('newVulnStatisticsVulnGrid').classList.add('hide');
        document.getElementById('remainingVulnStatisticsVulnGrid').classList.add('hide');
        document.getElementById('remediatedVulnStatisticsVulnGrid').classList.add('hide');
    },

    exportDataToCsv: function () {
        let query = '';

        if (VulnerabilityRemediationControlController.filter.newJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать задание, сканирования и применить фильтр');
            return;
        }

        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId === true && jobExecutionPicker.oldJobExecutionId === 0) {
            notifyWarning('Необходимо выбрать задание, сканирования и применить фильтр');
            return;
        }

        if (VulnerabilityRemediationControlController.filter.newJobExecutionId)
            query+='&NewJobExecutionId='+VulnerabilityRemediationControlController.filter.newJobExecutionId;
        if (VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId)
            query+='&ChooseExactOldExecutionId='+VulnerabilityRemediationControlController.filter.chooseExactOldExecutionId;
        if (VulnerabilityRemediationControlController.filter.oldJobExecutionId)
            query+='&OldJobExecutionId='+VulnerabilityRemediationControlController.filter.oldJobExecutionId;
        if (VulnerabilityRemediationControlController.filter.useOnlyLastDaysCount)
            query+='&UseOnlyLastDaysCount='+VulnerabilityRemediationControlController.filter.useOnlyLastDaysCount;
        if (VulnerabilityRemediationControlController.filter.hostIds)
            VulnerabilityRemediationControlController.filter.hostIds.forEach((hostId)=>
                query+='&HostIds='+hostId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.groupIds)
            VulnerabilityRemediationControlController.filter.groupIds.forEach((groupId)=>
                query+='&GroupIds='+groupId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.severityTypeIds)
            VulnerabilityRemediationControlController.filter.severityTypeIds.forEach((severityTypeId)=>
                query+='&Severities='+severityTypeId.toString()
            );
        if (VulnerabilityRemediationControlController.filter.cvssScoreMin)
            query+='&CvssScoreMin='+VulnerabilityRemediationControlController.filter.cvssScoreMin;
        if (VulnerabilityRemediationControlController.filter.cvssScoreMax)
            query+='&CvssScoreMax='+VulnerabilityRemediationControlController.filter.cvssScoreMax;
        if (VulnerabilityRemediationControlController.filter.hasExploit)
            query+='&HasExploit='+VulnerabilityRemediationControlController.filter.hasExploit;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInCveDb)
            query+='&IsInCveDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInCveDb;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInBduDb)
            query+='&IsInBduDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInBduDb;
        if (VulnerabilityRemediationControlController.filter.referenceDatabases.isInNkckiDb)
            query+='&IsInNkckiDb='+VulnerabilityRemediationControlController.filter.referenceDatabases.isInNkckiDb;

        if (VulnerabilityRemediationControlController.filter.dateFrom)
            query+='&PublishedFrom='+VulnerabilityRemediationControlController.filter.dateFrom;
        if (VulnerabilityRemediationControlController.filter.dateTo)
            query+='&PublishedTo='+VulnerabilityRemediationControlController.filter.dateTo;

        if (VulnerabilitiesController.filter.altxId)
            query+='&AltxId='+VulnerabilitiesController.filter.altxId;
        if (VulnerabilitiesController.filter.vulnerabilityTitle)
            query+='&VulnerabilityTitle='+VulnerabilitiesController.filter.vulnerabilityTitle;
        if (VulnerabilitiesController.filter.referenceSearchText)
            query+='&ReferenceSearchText='+VulnerabilitiesController.filter.referenceSearchText;


        if (VulnerabilitiesController.filter.showNewVulnerabilities)
            query+='&ShowNewVulnerabilities='+VulnerabilitiesController.filter.showNewVulnerabilities;
        if (VulnerabilitiesController.filter.showRemainingVulnerabilities)
            query+='&ShowRemainingVulnerabilities='+VulnerabilitiesController.filter.showRemainingVulnerabilities;
        if (VulnerabilitiesController.filter.showRemediatedVulnerabilities)
            query+='&ShowRemediatedVulnerabilities='+VulnerabilitiesController.filter.showRemediatedVulnerabilities;

        if (query)
        {
            query = query.substring(1);
            query = '?' + query;
        }
        window.location = VulnerabilityRemediationControlController.urlForVulnerabilitiesForCsv + query;
    }
};