﻿var CollapsibleGroup = (function () {
    let _api;
    let _expandedGroups = {};

    function CollapsibleGroup(settings) {
        _api = new $.fn.dataTable.Api(settings);

        _api.on('draw', onDrawComplete);
        _api.on('rowgroup-datasrc', onRowGroupDataSrc);
        $(_api.table().body()).on('click', 'tr.dtrg-group', onClickControl);
    }

    function onDrawComplete(e, settings) {
        const isGrouping = _api.rowGroup().enabled();
        _api.column('GroupSpaceColumn:name').visible(isGrouping);

        if (!isGrouping) {
            _api.rows().every(function () {
                this.node().style.display = '';
            });
        }
    }

    function onRowGroupDataSrc(e, api, value) {
        _expandedGroups = {};
        api.rows().deselect();
    }

    function onClickControl(e) {
        if (e.target.tagName !== 'BUTTON') return;

        const groupName = $(this).data('name');
        _expandedGroups[groupName] = !_expandedGroups[groupName];

        _api.draw(false);

        // the group is now closed
        if (!_expandedGroups[groupName]) {
            _createEventClose(groupName);
        }
    }

    function _createEventClose(groupName) {
        const dataSrc = _api.rowGroup().dataSrc();
        let indexes = _api.rows().indexes();

        indexes = indexes.filter(function (value, index) {
            const rowData = _api.row(value).data();

            return rowData.hasOwnProperty(dataSrc) && groupName === rowData[dataSrc];
        });

        const $table = _api.tables().body().to$();
        $table.trigger("collapsible-group-close", [_api.rows(indexes), groupName]);
    }

    CollapsibleGroup.prototype.isGroupExpanded = isGroupExpanded;

    function isGroupExpanded(groupName) {
        let isExpanded = _expandedGroups[groupName];

        return isExpanded === undefined || isExpanded === false ? false : true;
    }

    return CollapsibleGroup;
}());

(function () {
    $.fn.dataTable.Api.register('collapsibleGroup()', function (groupName) {
        const ctx = this.context[0];

        if (!ctx._collapsibleGroup) {
            return this;
        }

        return new $.fn.dataTable.Api(this, [{
            name: groupName,
            expanded: ctx._collapsibleGroup.isGroupExpanded(groupName)
        }]);;
    });

    $.fn.dataTable.Api.register('collapsibleGroup().expanded()', function (groupName) {
        return this.shift().expanded;
    });

    function _init(settings) {
        settings._collapsibleGroup = new CollapsibleGroup(settings);
    }

    // Entry point for initializing the extension
    $(document).on('preInit.dt', function (e, settings, json) {
        if (e.namespace !== 'dt') {
            return;
        }

        if (settings.oInit.collapsibleGroup) {
            if (!settings._collapsibleGroup) {
                _init(settings);
            }
        }
    });
}());

function createCollapsibleGroupTemplate(callback) {
    return function (rows, groupName, level) {
        const isGrouping = rows.rowGroup().enabled();

        if (!isGrouping || level !== 0) {
            return null;
        }

        var isExpanded = rows.collapsibleGroup(groupName).expanded();
        rows.every(function () {
            this.node().style.display = isExpanded ? '' : 'none';
        });

        const button = DataTablesCustomElement.createDetailButton(isExpanded);
        const content = callback(rows, groupName);
        
        const controlCell = document.createElement('td');
        controlCell.setAttribute('colspan', '1');
        controlCell.classList.add('group-cell');
        controlCell.appendChild(button);
        
        const descCell = document.createElement('td');
        descCell.setAttribute('colspan', '12');
        if (typeof content === 'string') {
            descCell.textContent = content;
        } else {
            descCell.appendChild(content);
        }

        const row = document.createElement('tr');
        row.classList.add('grouping-row');
        row.setAttribute('data-name', groupName);
        row.setAttribute('aria-expanded', isExpanded);
        row.appendChild(controlCell);
        row.appendChild(descCell);

        return row;
    };
}