﻿var DataTablesButtonHelper = {
    toggleGroup: function (columnName) {
        function handler(e, api, node, conf) {
            const btnSelector = conf.name + ':name';
            const columnSelector = columnName + ':name';

            if (api.button(node).active()) {
                api.buttons(btnSelector).active(false);
                disableGrouping(api);
            } else {
                api.buttons(btnSelector).active(false);
                api.button(node).active(true);
                enableGrouping(api, api.column(columnSelector));
            }

            api.draw();
        }

        function disableGrouping(api) {
            api.remoteGrouping().dataSrc('');
            api.remoteGrouping().enable(false);
        }

        function enableGrouping(api, column) {
            api.remoteGrouping().dataSrc(column.dataSrc());
            api.remoteGrouping().enable();
        }

        return handler;
    },
    handleSelectGroup: function (columnName) {
        function handler(e, api, node, conf) {
            const btnSelector = conf.name + ':name';
            const columnSelector = columnName + ':name';

            if (api.button(node).active()) {
                api.buttons(btnSelector).active(false);
                disableGrouping(api);
            } else {
                api.buttons(btnSelector).active(false);
                api.button(node).active(true);
                enableGrouping(api, api.column(columnSelector));
            }

            api.draw();
        }

        function disableGrouping(api) {
            api.order.fixed({});
            api.rowGroup().dataSrc('');
            api.rowGroup().disable();
        }

        function enableGrouping(api, column) {
            api.order.fixed({ pre: [column.index(), 'asc'] });
            api.rowGroup().dataSrc(column.dataSrc());
            api.rowGroup().enable();
        }

        return handler;
    },
};

var DataTablesDetailsHelper = {
    createDefaultContainer: function (node) {
        let masterDetail = document.createElement('div');
        masterDetail.classList.add('data-table-master-detail');
        masterDetail.setAttribute('style', 'margin: 8px 24px;');

        let body = document.createElement('div');
        body.classList.add('data-table-master-detail__body');
        body.appendChild(node);

        masterDetail.appendChild(body);

        return masterDetail;
    },

    getBodyByRequest: function (url, data, isFormData = true) {
        const deferred = $.Deferred();

        $.ajax({
            type: 'POST',
            url: url,
            data: isFormData ? data : JSON.stringify(data),
            contentType: isFormData ? undefined : 'application/json',
            cache: true
        }).then(function (response) {
            if (isRedirectToAuth(response)) {
                return $.Deferred().reject('');
            }
            return response;
        }).catch(function () {
            return 'Во время выполнения запроса что-то пошло не так';
        }).always(function (html) {
            const body = document.createElement('div');
            body.innerHTML = html;

            deferred.resolve(DataTablesDetailsHelper.createDefaultContainer(body));
        });

        return deferred;
    },

    createTable: function (rows) {
        const table = document.createElement('table');
        table.classList.add('details');
        const tbody = document.createElement('tbody');

        rows.forEach(function (value, key) {
            const row = document.createElement('tr');
            const name = document.createElement('td');
            name.classList.add('name');
            name.textContent = key;

            const data = document.createElement('td');
            if (typeof value === 'string') {
                data.textContent = value;
            } else if (value instanceof HTMLElement) {
                data.appendChild(value);
            }

            row.appendChild(name);
            row.appendChild(data);
            tbody.appendChild(row);
        });

        table.appendChild(tbody);

        return table;
    }
};

var DataTablesOptionsHelper = {
    setRowGroupCollapsingOptions: function (options, rowGroupOptions) {
        options.rowGroup = {};

        options.rowGroup.enable = rowGroupOptions.enable;
        options.rowGroup.startRender = createCollapsibleGroupTemplate(rowGroupOptions.startRender);
        options.collapsibleGroup = true;
    }
};

var DataTablesToolbarHelper = {
    createActionGroup: function (commands, maxVisibleButtons = 99) {
        function addToolbarAction(array, command) {
            array.push(command);
        }

        function addToolbarSpacer(array) {
            array.push({ extend: 'toolbarSpacer' });
        }

        function addToolbarMenu(array, commands) {
            const buttons = [];
            for (let i = 0; i < commands.length; i++) {
                addToolbarAction(buttons, commands[i]);
            }

            if (buttons.length > 0) {
                array.push({ extend: 'toolbarMenu', buttons: buttons });
            }
        }

        const limitIndex = maxVisibleButtons < commands.length ? maxVisibleButtons : commands.length;
        const buttons = [];

        for (let i = 0; i < limitIndex; i++) {
            addToolbarAction(buttons, commands[i]);

            if (i + 1 < commands.length) {
                addToolbarSpacer(buttons)
            }
        }

        addToolbarMenu(buttons, commands.slice(limitIndex));

        return buttons;
    },

    getDataByActiveRow: async function (dt, url) {
        let selectedRow = dt.redcheck.selectedIds()[0] ?? dt.redcheck.focusedId();

        let dataRow = dt.rows().data().toArray().find(x => x.Id === selectedRow);
        if (!dataRow) {
            const response = await fetch(`${url}?id=${selectedRow}`);
            dataRow = response.ok ? await response.json() : null;
        }

        return dataRow ? dataRow: null;
    },

    parseCommands: function (commands) {
        return commands.map((c) => ({
            extend: 'toolbarAction',
            iconClass: c.IconClass,
            text: c.Title,
            action: c.OnClick
                ? DataTablesHelper.getFunctionByName(c.OnClick)
                : () => window.location.href = c.Url,
            enabled: c.IsActive,
        }));
    },
};

var DataTablesHelper = {
    navigateToLastPage: function (tableApi, rowCount) {
        const limit = tableApi.page.len();
        const lastPageNumber = Math.ceil(rowCount / limit);

        if (lastPageNumber > 0) {
            tableApi.page(lastPageNumber - 1).draw(false);
        } else {
            tableApi.page(0).draw(false);
        }
    },

    ajaxReloadAndSaveScroll: function (tableApi) {
        const tableNode = tableApi.table().node();
        tableNode.style.height = `${tableNode.offsetHeight}px`;

        const scrollBodyNode = tableNode.parentNode;
        const scrollTop = scrollBodyNode.scrollTop;

        tableApi.ajax.reload(() => {
            scrollBodyNode.scrollTop = scrollTop;
            setTimeout(() => {
                tableNode.style.height = '';
            }, 1);
        }, false); // resetPaging
    },
    
    getFunctionByName: function (path) {
        const parts = path.split('.');
        return parts.reduce(function (acc, functionName) {
            if (typeof acc[functionName] === 'function' || typeof acc[functionName] === 'object') {
                return acc[functionName];
            } else {
                throw 'Failed to get event handler for ' + path + '. ' + functionName + ' not found';
            }
        }, window);
    }
};

var TreeViewClientSideHelper = {
    addNodes: function (context, data, parentNode) {
        for (let item of data) {
            const li = document.createElement('li');
            li.classList.add('treeview__item', 'treeview-node');
            li.dataset.name = item.Name;

            if (item.IsExpandable) {
                const button = TreeViewClientSideHelper.createControl();

                li.appendChild(button);
                li.classList.add('parent');
            }

            const content = TreeViewClientSideHelper.createContent(item.Text, item.PathToIcon);
            li.appendChild(content);

            context.addNode(li, parentNode);
        }
    },

    createContent: function (title, pathToIcon) {
        const content = document.createElement('div');
        content.classList.add('treeview-node__content');

        if (pathToIcon !== undefined) {
            const img = document.createElement('img');
            img.src = pathToIcon;
            img.setAttribute('width', '16px;');
            img.setAttribute('style', 'margin-left:4px;margin-right:10px;');
            content.appendChild(img);
        }

        const span = document.createElement('span');
        span.textContent = title;
        content.appendChild(span);

        return content;
    },

    createControl: function () {
        const wrapper = document.createElement('div');
        wrapper.classList.add('treeview-node__button');

        const button = document.createElement('button');
        button.classList.add('detail-button-dt', 'icon', 'icon_expand');
        button.setAttribute('aria-label', 'Expand');
        button.setAttribute('type', 'button');
        wrapper.appendChild(button);

        return wrapper;
    }
};