﻿// Unable to use object instances due to dataTables element static event handlers (like "onclick" and "data-handler" that are set in markup)
// TODO: search for ability to use object handlers

const JobCredentialsGridComponent = {
    LoadTable: function(config) {
        this.Data = config.data;
        this.JobScanType = config.jobScanType;
        this.JobScanTypeText = config.jobScanTypeText;
        this.CmdDeleteText = config.cmdDeleteText;
        this.CredentialsInfoForJobTypeUrl = config.credentialsInfoForJobTypeUrl;
        this.FormNamePrefix = config.formNamePrefix;
        this.IsMultipleCredentialsAllowed = config.isMultipleCredentialsAllowed;
        let self = this;
        CredentialsPopupControler.selectCredentialButtonClick = function () { self.selectCredentialButtonClickCallback() }

        if (!this.IsMultipleCredentialsAllowed && this.Data.length > 0) {
            $('#btnCredential')
                .prop('disabled', true)
                .prop('title', 'Для задания типа \"' + this.JobScanTypeText + '\" можно выбрать только одну учетную запись');
        }

        this.mount();
    },

    mount: function () {
        const toolbarOptions = {
            contentLeft: [
                { extend: 'toolbarCaption', text: 'Выбранные учётные записи' },
            ],
            batchActions: [
                { extend: 'toolbarCaption', text: 'Выбранные учётные записи' },
                { extend: 'toolbarSpacer' },
                { extend: 'toolbarAction', iconClass: 'rc-icon--trash', text: 'Удалить', action: deleteJobCredentials },
            ],
            contentRight: [
                { extend: 'toolbarColumnVisibility' },
            ],
        };

        this.$api = $('#CredentialsGrid').DataTable({
            paging: false,
            
            select: {
                style: 'multi+shift',
                selector: 'tr'
            },
            useTableIdForRows: true,
            columns: [
                { data: 'Order', name: 'Order', defaultContent: '', className: 'reorder', render: this.renderOrderColumn() },
                { data: null, render: DataTable.render.select() },
                { data: 'Id', name: 'Id' },
                { data: 'TypeText', name: 'Type' },
                { data: 'SubType', name: 'SubType' },
                { data: 'Name', name: 'Name' },
                { data: 'AgentType', name: 'AgentType', render: this.renderAgentTypeColumn() },
            ],
            columnDefs: [{ "targets": [0,1,2,3,4,5,6], "orderable": false }],
            rowReorder: {
                dataSrc: 'Order'
            },
            ordering: false,
            data: this.Data,
            initComplete: function() {
                $('.agent-type-radio').click(function () { self.onAgentTypeRadioClick(this) });
            },
            toolbar: toolbarOptions,
        });

        this.showSelectedCredentials();
        let self = this;
        self.$api.on('row-reordered', () => { self.showSelectedCredentials() });
        self.$api.on('draw', function () { $('.agent-type-radio').click(function() { self.onAgentTypeRadioClick(this) }); });
    },

    showSelectedCredentials: function () {
        let oldCredentialElements = document.querySelectorAll('input[id*="SelectedCredentials_"]');
        for (let i = 0; i < oldCredentialElements.length; i++) {
            oldCredentialElements[i].parentNode.removeChild(oldCredentialElements[i]);
        }

        this.Data.sort((a, b) => a.Order - b.Order);
        for (let i = 0; i < this.Data.length; i++) {
            let inputCredentialId = $(document.createElement('input'))
                .attr('type', 'hidden')
                .attr('name', this.FormNamePrefix + '[' + i + '].Id').attr('id', 'SelectedCredentials_' + this.Data[i].Id + '_Id')
                .val(this.Data[i].Id);
            $('#CredentialsGrid').append(inputCredentialId);

            let inputCredentialName = $(document.createElement('input'))
                .attr('type', 'hidden').attr('name',  this.FormNamePrefix + '[' + i + '].Name').attr('id', 'SelectedCredentials_' + this.Data[i].Id + '_Name')
                .val(this.Data[i].Name);
            $('#CredentialsGrid').append(inputCredentialName);

            let inputCredentialType = $(document.createElement('input'))
                .attr('type', 'hidden').attr('name', this.FormNamePrefix + '[' + i + '].Type').attr('id', 'SelectedCredentials_' + this.Data[i].Id + '_Type')
                .val(this.Data[i].Type);
            $('#CredentialsGrid').append(inputCredentialType);

            if (this.Data[i].Type === CREDENTIAL_TYPE_VMware) {
                let inputCredentialVimType = $(document.createElement('input'))
                    .attr('type', 'hidden').attr('name', this.FormNamePrefix + '[' + i + '].VimType').attr('id', 'SelectedCredentials_' + this.Data[i].Id + '_VimType')
                    .val(this.Data[i].SubType);
                $('#CredentialsGrid').append(inputCredentialVimType);
            } else if (this.Data[i].Type === CREDENTIAL_TYPE_Cisco) {
                let inputCredentialCiscoOsType = $(document.createElement('input'))
                    .attr('type', 'hidden').attr('name', this.FormNamePrefix + '[' + i + '].CiscoOsType').attr('id', 'SelectedCredentials_' + this.Data[i].Id + '_CiscoOsType')
                    .val(this.Data[i].SubType);
                $('#CredentialsGrid').append(inputCredentialCiscoOsType);
            } else if (this.Data[i].Type === CREDENTIAL_TYPE_Sql) {
                let inputCredentialDbType = $(document.createElement('input')).attr('type', 'hidden').attr('name', this.FormNamePrefix + '[' + i + '].DbType').attr('id', 'SelectedCredentials_' + this.Data[i].Id + '_DbType').val(this.Data[i].SubType);
                $('#CredentialsGrid').append(inputCredentialDbType);
            }

            this.Data[i].Order = i + 1;
            let inputCredentialOrder = $(document.createElement('input'))
                .attr('type', 'hidden').attr('name', this.FormNamePrefix + '[' + i + '].Order').attr('id', 'SelectedCredentials_' + this.Data[i].Id + '_Order')
                .val(this.Data[i].Order ?? null);
            $('#CredentialsGrid').append(inputCredentialOrder);
        }

        this.$api.clear();
        this.$api.rows.add(this.Data);
        this.$api.draw();
    },

    renderOrderColumn: function() {
        return function (data, type, row) {
            return '<span class="glyphicon glyphicon-sort"></span>';
        }
    },

    renderAgentTypeColumn: function () {
        const self = this;
        if(self.JobScanType === "Ping")
            return '';

        return function (data, type, row) {
            let result = '';

            const availableAgentTypes = row["Type"] === CREDENTIAL_TYPE_Sql
                ? [JOB_AGENT_TYPE_Agentless]
                : GetAvailableJobAgentScTypes(self.JobScanType, row["Type"]);
            if (availableAgentTypes === undefined || availableAgentTypes.length === 0)
                return result;

            let credential = self.Data.find(c => c.Id === parseInt(row["Id"]));
            availableAgentTypes.forEach((agentType, index) => {
                let labelStyle = '';
                if (index === 0) {
                    if (row["AgentType"] === '') {
                        credential.AgentType = agentType;
                        row["AgentType"] = agentType;
                    }
                } else
                    labelStyle = 'margin-left: 20px';

                let isChecked = row["AgentType"] === agentType ? ' checked="checked"' : '';
                result += '<label class="rc-input-label" style="' + labelStyle + '"><input type="radio" class="agent-type-radio rc-input" name="' + self.FormNamePrefix + '[' + (row["Order"] - 1) + '].AgentType"' +
                    ' id="SelectedCredentials_' + row["Id"] + '_AgentType_' + agentType + '" data-id="' + row["Id"] + '" value="' + agentType + '"' + isChecked +'> ' +
                    AddAgentTypeTextBasedOnCred(agentType, row["Type"]) + '</label>';
            });

            return result;
        }
    },

    onAgentTypeRadioClick: function (sender) {
        const $sender = $(sender);
        const id = parseInt($sender.attr('data-id'), 10);
        const newAgentType = $sender.val();
        const objectsWithId = this.Data.filter(item => item.Id === id);

        if (objectsWithId.length === 1) {
            const credential = this.Data.find(c => c.Id === id);
            credential.AgentType = newAgentType;
            return;
        }
        const oppositeValue = newAgentType === "Agent" ? "TempAgent" : "Agent";
        const $row = $sender.closest('tr');
        const rowIndex = $row.index();
        const credential = this.Data[rowIndex];

        $sender.prop('checked', false);
        if (credential.AgentType === newAgentType) {

            const $prevRadio = $row.find(`input[data-id="${id}"][value="${newAgentType}"]`);
            $prevRadio.prop('checked', true);
            return;
        }

        const $prevRadio = $row.find(`input[data-id="${id}"][value="${oppositeValue}"]`);
        $prevRadio.prop('checked', true);
        return;
      
    },

    deleteJobCredentials: function (e, data, node, config) {
        if (!data || !data.redcheck || typeof data.redcheck.selectedIds !== 'function')
            return;

        const groupIds = data.redcheck.selectedIds();
        const idsToDelete = new Set(groupIds);

        data.redcheck.deselectAll();
        this.Data = this.Data.filter(value => !idsToDelete.has(value.Id));

        // For Job Wizard
        if (typeof setCurrentCredentialTypes !== 'undefined')
            setCurrentCredentialTypes(new CredentialTypes(this.Data), this.JobScanType);
        // For Job Properties
        else
            credentialTypes = new CredentialTypes(this.Data).map(t => t.subType ? t.type + '-' + t.subType : t.type).join(',');
        this.showSelectedCredentials();
        $('#btnCredential').prop('disabled', false).removeAttr('title');
    },

    selectCredentialButtonClickCallback: function () {
        let selectedIds = CredentialsPopupControler.filterCredentialsGrid.getSelectedItems();

        if (!selectedIds.length) {
            notifyWarning(CredentialsPopupControler.needSelectCredentialMessage);
            return;
        }

        let selectButton = document.getElementById('selectCredentialButton');
        selectButton.disabled = true;

        credentialsGridClear();

        $.ajax({
            url: this.CredentialsInfoForJobTypeUrl + "?jobScanType=" + this.JobScanType  + "&credentialIdsStr=" + selectedIds.map((e) => { return e.id }).join(","),
            method: "GET",
            dataType: "json",
            success: (result) => {
                let failedCredentialIds = result.filter((c) => c.CanUse === false);
                if (!failedCredentialIds.length) {
                    result = result.map((item) => {
                        return {
                            Id: item.Id,
                            Type: item.Type,
                            TypeText: item.TypeText,
                            ContentFamilyTypeText: item.ContentFamilyTypeText,
                            SubType: item.SubType,
                            Name: item.Name,
                            AgentType: ''
                        }
                    }, this);

                    this.Data = filterAndMergeNewCredentials(this.Data, result);
                    this.showSelectedCredentials();
                    $('#credentialsModal').modal('hide');
                    selectButton.disabled = false;
                    // For Job Wizard
                    if (typeof setCurrentCredentialTypes !== 'undefined')
                        setCurrentCredentialTypes(new CredentialTypes(this.Data), this.JobScanType);
                    // For Job Properties
                    else
                        credentialTypes = new CredentialTypes(this.Data).map(t => t.subType ? t.type + '-' + t.subType : t.type).join(',');
                    if (!this.IsMultipleCredentialsAllowed) {
                        $('#btnCredential')
                            .prop('disabled', true)
                            .prop('title', 'Для задания типа \"' + this.JobScanTypeText + '\" можно выбрать только одну учетную запись');
                    }

                    return;
                }

                const failedCredentials = result.filter(c => failedCredentialIds.some(ids => ids.Id === c.Id));
                const failedCredentialsSet = [];

                failedCredentials.filter(fc => {
                    if(failedCredentialsSet.find(c => c.Type === fc.Type && c.SubType === fc.SubType)) {
                        return true
                    }
                    failedCredentialsSet.push(fc)
                    return false;
                });

                notifyWarning('Выполните синхронизацию контента для семейств:' + '<br>'
                    + failedCredentialsSet.map((c) => c.ContentFamilyTypeText).join('<br>') +
                '<br>(Настройки->Синхронизация)');
                selectButton.disabled = false;
            }
        });
    }
};

function credentialsGridClear() {
    const table = document.getElementById('CredentialsGrid');
    const api = $(table).dataTable().api();
    api.redcheck.deselectAll();
}

function filterAndMergeNewCredentials(oldCredentials, newCredentials) {
    if (oldCredentials.length === 0) {
        return newCredentials;
    }

    const filteredNewCredentials = [];

    for (const newCredential of newCredentials) {
        const existingWithSameId = oldCredentials.filter(
            item => item.Id === newCredential.Id
        );

        if (existingWithSameId.length === 0) {
            filteredNewCredentials.push(newCredential);
            continue;
        }

        if (newCredential.Type !== CREDENTIAL_TYPE_Windows) {
            continue;
        }

        const hasAgent = existingWithSameId.some(item => item.AgentType === "Agent");
        const hasTempAgent = existingWithSameId.some(item => item.AgentType === "TempAgent");

        if (hasAgent && hasTempAgent) {
            continue;
        }

        if (hasAgent) {
            newCredential.AgentType = "TempAgent";
        } else if (hasTempAgent) {
            newCredential.AgentType = "Agent";
        }

        

        filteredNewCredentials.push(newCredential);
    }

    return [...oldCredentials, ...filteredNewCredentials];
}


// Loosing "this" when trying to call JobCredentialsGridComponent.deleteJobCredentials in batchActions
// So wrapper created
function deleteJobCredentials(sender, data) { $.proxy(JobCredentialsGridComponent.deleteJobCredentials(sender, data), JobCredentialsGridComponent); }

const CredentialTypes = (function() {
    function CredentialTypes(data) {
        this.values = [];
        if (!(data && data.length > 0))
            return;

        for (let i = 0; i < data.length; i++) {
            let credentialType = new CredentialType(data[i]);
            if (!this.hasElement(credentialType))
                this.push(credentialType);
        }
    }
    CredentialTypes.prototype.getByIndex = function(index) {
        return this.values[index];
    }
    CredentialTypes.prototype.push = function(credentialType) {
        if (!credentialType instanceof CredentialType)
            throw new Error("Parameter \"credentialType\" is not an instance of type CredentialType.");

        this.values.push(credentialType);
    }
    CredentialTypes.prototype.map = function(func) {
        return this.values.map(x => func(x));
    }
    CredentialTypes.prototype.hasElement = function(element) {
        if (!element instanceof CredentialType)
            return false;

        for (let i = 0; i < this.values.length; i++)
            if (element.isEqualTo(this.values[i]))
                return true;

        return false;
    }
    CredentialTypes.prototype.isEqualTo = function(other) {
        if (!other instanceof CredentialTypes || this.values.length !== other.values.length)
            return false;

        for (let i = 0; i < other.values.length; i++)
            if (!this.hasElement(other.values[i]))
                return false;

        return true;
    }

    return CredentialTypes;
})();

const CredentialType = (function(type, subType = null) {
    function CredentialType(data) {
        if (!data instanceof Object)
            throw new Error("Parameter \"data\" is not an instance of type Object.");

        this.type = data.Type;
        this.subType = data.SubType;
    }
    CredentialType.prototype.type = type;
    CredentialType.prototype.subType = subType;
    CredentialType.prototype.isEqualTo = function(other) {
        return other instanceof CredentialType && this.type === other.type && this.subType === other.subType
    }

    return CredentialType;
})();

