document.addEventListener('DOMContentLoaded', function () {
    const formSettings = document.getElementById('form-settings');
    const selectAllContentTargets = document.getElementById('selectAllContentTargets');
    const snapshotTargetCheckboxes = document.querySelectorAll('.snapshot-target-checkbox');
    const syncModeRadios = document.querySelectorAll('input[name="Sync.SyncMode.Value"]');
    const syncScheduleEnabled = document.getElementById('syncScheduleEnabled');
    const emailAfterSyncEnabled = document.getElementById('emailAfterSyncEnabled');

    const networkResourcesContainer = document.getElementById('networkResourcesContainer');
    const dataTableUtil = window.$ && window.$.fn && window.$.fn.dataTable && window.$.fn.dataTable.util;

    // Handle form submission
    formSettings.addEventListener('submit', transformContentTargetsToString);

    // Handle select all functionality
    selectAllContentTargets.addEventListener('click', handleSelectAllFunctionality);

    // Event listeners for sync mode radios
    syncModeRadios.forEach(function (radio) {
        radio.addEventListener('change', toggleOfflineSyncPath);
    });

    // Event listener for sync schedule
    syncScheduleEnabled.addEventListener('change', toggleScheduleTime);

    // Event listener for email recipients
    emailAfterSyncEnabled.addEventListener('change', toggleEmailRecipients);

    // Initial state setup
    toggleOfflineSyncPath();
    toggleScheduleTime();
    toggleEmailRecipients();
    offlineSyncPathOnInput();

    //

    function toggleOfflineSyncPath() {
        const offlineSyncPath = document.getElementById('offlineSyncPath');
        const syncTypeOffline = document.getElementById('syncTypeOffline');

        if (syncTypeOffline.checked) {
            offlineSyncPath.classList.remove('hide');
        }
        else {
            offlineSyncPath.classList.add('hide');
        }
    }

    function toggleScheduleTime() {
        const timeSync = document.getElementById('timeSync');
        if (syncScheduleEnabled.checked) {
            timeSync.classList.remove('hide');
        }
        else {
            timeSync.classList.add('hide');
        }
    }

    function toggleEmailRecipients() {
        if (!emailAfterSyncEnabled.checked) {
            networkResourcesContainer.classList.add('hide');
        } else {
            networkResourcesContainer.classList.remove('hide');
            if (dataTableUtil && typeof dataTableUtil.columnsAdjustSize === 'function') {
                dataTableUtil.columnsAdjustSize();
            }
        }
    }

    function transformContentTargetsToString(e) {
        const selected = Array.from(snapshotTargetCheckboxes)
            .filter(cb => cb.checked)
            .map(cb => cb.value);
        document.getElementById('Sync_SelectedContentTargets_Value').value = selected.join(',');
    }

    function handleSelectAllFunctionality(e) {
        e.preventDefault();

        const allChecked = Array.from(snapshotTargetCheckboxes).every(checkbox => checkbox.checked);
        const newState = !allChecked;

        snapshotTargetCheckboxes.forEach(function (checkbox) {
            checkbox.checked = newState;
        });
    }
});

//

function offlineSyncPathOnInput() {
    if (isSyncPathUnc())
        document.getElementById('credentialsForSync').classList.remove('hide');
    else document.getElementById('credentialsForSync').classList.add('hide');
}

function isSyncPathUnc() {
    return document.getElementById('Sync_OfflineSyncPath_Value').value.startsWith('\\\\');
}

function withoutCredentialsClick() {
    if (document.getElementById('syncTab').classList.contains("active")) {
        document.getElementById('Sync_OfflineSyncPathCredentialName').value = '';
        document.getElementById('Sync_OfflineSyncPathCredentialId_Value').value = '';
    }
}

function checkSyncSettings(){
    const useOfflineSync = document.getElementById('syncTypeOffline').checked;
    const offlineSyncPath = document.getElementById('Sync_OfflineSyncPath_Value').value;

    if (useOfflineSync && isEmptyOrSpaces(offlineSyncPath)) {
        notifyWarning("Синхронизация: Необходимо указать путь к папке офлайн-синхронизации");
        return false;
    }
    
    return true;
}