description = [[ Queries Redcheck web Rest /account/loginview page to extract the product version. ]]

---
-- @usage
-- nmap --script RedcheckWebRest -p8081 -sV <host>
--
-- @output
-- | RedcheckWebRest:
-- |   Redcheck web rest version: 0.3
----------------------------------------------------------

author = "Alexandr Ruchkin"
license = "Same as Nmap--See https://nmap.org/book/man-legal.html"
categories = {"discovery", "safe", "version"}

local http = require "http"
local shortport = require "shortport"
local stdnse = require "stdnse"

local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port)	return true end
end

action = function(host, port)

  local tokensPage = http.get(host, port, "/api/v0.3/tokens")

  if tokensPage.status == 400 and string.find(tokensPage.body, "UnsupportedApiVersion") then
    return "Redcheck web rest version: 0.3"
  end

end