description = [[
    
Determining the version of Apache from a non-existent page.
]]

-- @output
--PORT    STATE SERVICE
--443/tcp open  https
--| altx-soft_http_versionApache_404: 
--|_  product_version: Apache/2.4.54 (Unix) PHP/8.0.23 OpenSSL/1.1.1q

author = "Alex Petrov"

local os = require "os"
local http = require "http"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"
local string = require "string"


local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

local _regex = { 
    "<[Ss][Pp][Aa][Nn]>%s*(.-)%s*</%s*[Ss][Pp][Aa][Nn]>",
    "<[Aa][Dd][Dd][Rr][Ee][Ss][Ss]>%s*(.-)%s*[Ss][Ee][Rr][Vv][Ee][Rr]"  
}

action = function(host, port)
    local output_tab = stdnse.output_table();
    local URL_404_1 = '/nmaplowercheck' .. os.time(os.date('*t'))

    local response = http.get(host, port, URL_404_1)

    if(response.status == 404 and response.body) then
        for _, reg in ipairs(_regex) do
            local result = string.match( response.body, reg)            
            if(result) then
                output_tab["product_version"] = result
                return output_tab
            else
                stdnse.debug2("Title tag is missing Apache http server version")            
            end
        end
    else
        stdnse.debug2( string.format( "The status code for the given path %s is not 404", URL_404_1 ))
        return nil
    end
    return nil
end