description = [[
    
    Determining the SquirrelMail version.
]]

-- @output
--PORT   STATE SERVICE REASON
--80/tcp open  http    syn-ack ttl 52
--| altx-soft_version-SquirrelMail: 
--|_  VERSION: SquirrelMail version 1.4.23 [SVN]

author = "Alex Petrov"

local http = require "http"
local shortport = require "shortport"
local stdnse = require "stdnse"
local table = require "table"
local string = require "string"


local use_portrule = stdnse.get_script_args("stdnse.use_portrule") or false

if (use_portrule == "true") then
	portrule = shortport.http 
else portrule = function(host,port) return true end
end

local paths  = {
    "/squirrelmail/"
}

local regxs = {
    "<[Ss][Mm][Aa][Ll][Ll]>%s*(.-)%s*<%s*br%s*/>"
}

action = function(host, port)
    local output_tab = stdnse.output_table()

    for _, path in ipairs(paths) do
        local response = http.get(host, port, path)
        if(response.status == 200 and response.body) then       
            for _, regx in ipairs(regxs) do
                local version = string.match(response.body, regx)
                if(version ~= nil and version ~= '') then output_tab['VERSION'] = version return output_tab end 
            end
        end
    end
    return nil 
end